/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TruecolorAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Init utility for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TruecolorAttributes::Init()
{
    opacity = 1;
    lightingFlag = true;

    TruecolorAttributes::SelectAll();
}

// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Copy utility for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TruecolorAttributes::Copy(const TruecolorAttributes &obj)
{
    opacity = obj.opacity;
    lightingFlag = obj.lightingFlag;

    TruecolorAttributes::SelectAll();
}

// Type map format string
const char *TruecolorAttributes::TypeMapFormatString = TRUECOLORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t TruecolorAttributes::TmfsStruct = {TRUECOLORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Default constructor for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes::TruecolorAttributes() : 
    AttributeSubject(TruecolorAttributes::TypeMapFormatString)
{
    TruecolorAttributes::Init();
}

// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Constructor for the derived classes of TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes::TruecolorAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TruecolorAttributes::Init();
}

// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Copy constructor for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes::TruecolorAttributes(const TruecolorAttributes &obj) : 
    AttributeSubject(TruecolorAttributes::TypeMapFormatString)
{
    TruecolorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TruecolorAttributes::TruecolorAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes::TruecolorAttributes(const TruecolorAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TruecolorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TruecolorAttributes::~TruecolorAttributes
//
// Purpose: 
//   Destructor for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes::~TruecolorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TruecolorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TruecolorAttributes& 
TruecolorAttributes::operator = (const TruecolorAttributes &obj)
{
    if (this == &obj) return *this;

    TruecolorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TruecolorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorAttributes::operator == (const TruecolorAttributes &obj) const
{
    // Create the return value
    return ((opacity == obj.opacity) &&
            (lightingFlag == obj.lightingFlag));
}

// ****************************************************************************
// Method: TruecolorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorAttributes::operator != (const TruecolorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TruecolorAttributes::TypeName
//
// Purpose: 
//   Type name method for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TruecolorAttributes::TypeName() const
{
    return "TruecolorAttributes";
}

// ****************************************************************************
// Method: TruecolorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TruecolorAttributes *tmp = (const TruecolorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TruecolorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TruecolorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TruecolorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TruecolorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TruecolorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TruecolorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TruecolorAttributes(*this);
    else
        retval = new TruecolorAttributes;

    return retval;
}

// ****************************************************************************
// Method: TruecolorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TruecolorAttributes::SelectAll()
{
    Select(ID_opacity,      (void *)&opacity);
    Select(ID_lightingFlag, (void *)&lightingFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TruecolorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TruecolorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TruecolorAttributes.
    DataNode *node = new DataNode("TruecolorAttributes");

    if(completeSave || !FieldsEqual(ID_opacity, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("opacity", opacity));
    }

    if(completeSave || !FieldsEqual(ID_lightingFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lightingFlag", lightingFlag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TruecolorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TruecolorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TruecolorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("opacity")) != 0)
        SetOpacity(node->AsDouble());
    if((node = searchNode->GetNode("lightingFlag")) != 0)
        SetLightingFlag(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TruecolorAttributes::SetOpacity(double opacity_)
{
    opacity = opacity_;
    Select(ID_opacity, (void *)&opacity);
}

void
TruecolorAttributes::SetLightingFlag(bool lightingFlag_)
{
    lightingFlag = lightingFlag_;
    Select(ID_lightingFlag, (void *)&lightingFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
TruecolorAttributes::GetOpacity() const
{
    return opacity;
}

bool
TruecolorAttributes::GetLightingFlag() const
{
    return lightingFlag;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TruecolorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TruecolorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_opacity:      return "opacity";
    case ID_lightingFlag: return "lightingFlag";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TruecolorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TruecolorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_opacity:      return FieldType_opacity;
    case ID_lightingFlag: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TruecolorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TruecolorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_opacity:      return "opacity";
    case ID_lightingFlag: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TruecolorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TruecolorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TruecolorAttributes &obj = *((const TruecolorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_opacity:
        {  // new scope
        retval = (opacity == obj.opacity);
        }
        break;
    case ID_lightingFlag:
        {  // new scope
        retval = (lightingFlag == obj.lightingFlag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
TruecolorAttributes::ChangesRequireRecalculation(const TruecolorAttributes &obj)
{
    return false;
}

