/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTopologyAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorAttributeList.h>

// ****************************************************************************
// Module: PyTopologyAttributes
//
// Purpose: 
//   This class contains the plot attributes for the topology plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TopologyAttributes.
//
struct TopologyAttributesObject
{
    PyObject_HEAD
    TopologyAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTopologyAttributes(int);

std::string
PyTopologyAttributes_ToString(const TopologyAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    SNPRINTF(tmpStr, 1000, "%sminOpacity = %g\n", prefix, atts->GetMinOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminPlateauOpacity = %g\n", prefix, atts->GetMinPlateauOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxPlateauOpacity = %g\n", prefix, atts->GetMaxPlateauOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxOpacity = %g\n", prefix, atts->GetMaxOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stolerance = %g\n", prefix, atts->GetTolerance());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shitpercent = %g\n", prefix, atts->GetHitpercent());
    str += tmpStr;
    return str;
}

static PyObject *
TopologyAttributes_Notify(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetMinOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minOpacity in the object.
    obj->data->SetMinOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetMinOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinOpacity());
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetMinPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minPlateauOpacity in the object.
    obj->data->SetMinPlateauOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetMinPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinPlateauOpacity());
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetMaxPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxPlateauOpacity in the object.
    obj->data->SetMaxPlateauOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetMaxPlateauOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxPlateauOpacity());
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetMaxOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxOpacity in the object.
    obj->data->SetMaxOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetMaxOpacity(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxOpacity());
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetTolerance(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tolerance in the object.
    obj->data->SetTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetTolerance(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTolerance());
    return retval;
}

/*static*/ PyObject *
TopologyAttributes_SetHitpercent(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hitpercent in the object.
    obj->data->SetHitpercent(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TopologyAttributes_GetHitpercent(PyObject *self, PyObject *args)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHitpercent());
    return retval;
}



PyMethodDef PyTopologyAttributes_methods[TOPOLOGYATTRIBUTES_NMETH] = {
    {"Notify", TopologyAttributes_Notify, METH_VARARGS},
    {"SetLineWidth", TopologyAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", TopologyAttributes_GetLineWidth, METH_VARARGS},
    {"SetMultiColor", TopologyAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", TopologyAttributes_GetMultiColor, METH_VARARGS},
    {"SetMinOpacity", TopologyAttributes_SetMinOpacity, METH_VARARGS},
    {"GetMinOpacity", TopologyAttributes_GetMinOpacity, METH_VARARGS},
    {"SetMinPlateauOpacity", TopologyAttributes_SetMinPlateauOpacity, METH_VARARGS},
    {"GetMinPlateauOpacity", TopologyAttributes_GetMinPlateauOpacity, METH_VARARGS},
    {"SetMaxPlateauOpacity", TopologyAttributes_SetMaxPlateauOpacity, METH_VARARGS},
    {"GetMaxPlateauOpacity", TopologyAttributes_GetMaxPlateauOpacity, METH_VARARGS},
    {"SetMaxOpacity", TopologyAttributes_SetMaxOpacity, METH_VARARGS},
    {"GetMaxOpacity", TopologyAttributes_GetMaxOpacity, METH_VARARGS},
    {"SetTolerance", TopologyAttributes_SetTolerance, METH_VARARGS},
    {"GetTolerance", TopologyAttributes_GetTolerance, METH_VARARGS},
    {"SetHitpercent", TopologyAttributes_SetHitpercent, METH_VARARGS},
    {"GetHitpercent", TopologyAttributes_GetHitpercent, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TopologyAttributes_dealloc(PyObject *v)
{
   TopologyAttributesObject *obj = (TopologyAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TopologyAttributes_compare(PyObject *v, PyObject *w)
{
    TopologyAttributes *a = ((TopologyAttributesObject *)v)->data;
    TopologyAttributes *b = ((TopologyAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTopologyAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "lineWidth") == 0)
        return TopologyAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return TopologyAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "minOpacity") == 0)
        return TopologyAttributes_GetMinOpacity(self, NULL);
    if(strcmp(name, "minPlateauOpacity") == 0)
        return TopologyAttributes_GetMinPlateauOpacity(self, NULL);
    if(strcmp(name, "maxPlateauOpacity") == 0)
        return TopologyAttributes_GetMaxPlateauOpacity(self, NULL);
    if(strcmp(name, "maxOpacity") == 0)
        return TopologyAttributes_GetMaxOpacity(self, NULL);
    if(strcmp(name, "tolerance") == 0)
        return TopologyAttributes_GetTolerance(self, NULL);
    if(strcmp(name, "hitpercent") == 0)
        return TopologyAttributes_GetHitpercent(self, NULL);

    // Try and handle legacy fields

    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (lineStyleFound)
    {
        fprintf(stdout, "lineStyle is no longer a valid Topology "
                       "attribute.\nIt's value is being ignored, please remove "
                       "it from your script.\n");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyTopologyAttributes_methods, self, name);
}

int
PyTopologyAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "lineWidth") == 0)
        obj = TopologyAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = TopologyAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "minOpacity") == 0)
        obj = TopologyAttributes_SetMinOpacity(self, tuple);
    else if(strcmp(name, "minPlateauOpacity") == 0)
        obj = TopologyAttributes_SetMinPlateauOpacity(self, tuple);
    else if(strcmp(name, "maxPlateauOpacity") == 0)
        obj = TopologyAttributes_SetMaxPlateauOpacity(self, tuple);
    else if(strcmp(name, "maxOpacity") == 0)
        obj = TopologyAttributes_SetMaxOpacity(self, tuple);
    else if(strcmp(name, "tolerance") == 0)
        obj = TopologyAttributes_SetTolerance(self, tuple);
    else if(strcmp(name, "hitpercent") == 0)
        obj = TopologyAttributes_SetHitpercent(self, tuple);

    // Try and handle legacy fields
    if(obj == NULL)
    {
        if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TopologyAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)v;
    fprintf(fp, "%s", PyTopologyAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TopologyAttributes_str(PyObject *v)
{
    TopologyAttributesObject *obj = (TopologyAttributesObject *)v;
    return PyString_FromString(PyTopologyAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TopologyAttributes_Purpose = "This class contains the plot attributes for the topology plot";
#else
static char *TopologyAttributes_Purpose = "This class contains the plot attributes for the topology plot";
#endif

//
// The type description structure
//
static PyTypeObject TopologyAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TopologyAttributes",                    // tp_name
    sizeof(TopologyAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TopologyAttributes_dealloc,  // tp_dealloc
    (printfunc)TopologyAttributes_print,     // tp_print
    (getattrfunc)PyTopologyAttributes_getattr, // tp_getattr
    (setattrfunc)PyTopologyAttributes_setattr, // tp_setattr
    (cmpfunc)TopologyAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TopologyAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TopologyAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TopologyAttributes *defaultAtts = 0;
static TopologyAttributes *currentAtts = 0;

static PyObject *
NewTopologyAttributes(int useCurrent)
{
    TopologyAttributesObject *newObject;
    newObject = PyObject_NEW(TopologyAttributesObject, &TopologyAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TopologyAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TopologyAttributes(*defaultAtts);
    else
        newObject->data = new TopologyAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTopologyAttributes(const TopologyAttributes *attr)
{
    TopologyAttributesObject *newObject;
    newObject = PyObject_NEW(TopologyAttributesObject, &TopologyAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TopologyAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TopologyAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTopologyAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TopologyAttributesMethods[] = {
    {"TopologyAttributes", TopologyAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TopologyAttributesObserver = 0;

std::string
PyTopologyAttributes_GetLogString()
{
    std::string s("TopologyAtts = TopologyAttributes()\n");
    if(currentAtts != 0)
        s += PyTopologyAttributes_ToString(currentAtts, "TopologyAtts.");
    return s;
}

static void
PyTopologyAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TopologyAtts = TopologyAttributes()\n");
        s += PyTopologyAttributes_ToString(currentAtts, "TopologyAtts.");
        cb(s);
    }
}

void
PyTopologyAttributes_StartUp(TopologyAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTopologyAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TopologyAttributesObserver == 0)
    {
        TopologyAttributesObserver = new ObserverToCallback(subj,
            PyTopologyAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTopologyAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TopologyAttributesObserver;
    TopologyAttributesObserver = 0;
}

PyMethodDef *
PyTopologyAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TopologyAttributesMethods;
}

bool
PyTopologyAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TopologyAttributesType);
}

TopologyAttributes *
PyTopologyAttributes_FromPyObject(PyObject *obj)
{
    TopologyAttributesObject *obj2 = (TopologyAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTopologyAttributes_New()
{
    return NewTopologyAttributes(0);
}

PyObject *
PyTopologyAttributes_Wrap(const TopologyAttributes *attr)
{
    return WrapTopologyAttributes(attr);
}

void
PyTopologyAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TopologyAttributesObject *obj2 = (TopologyAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTopologyAttributes_SetDefaults(const TopologyAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TopologyAttributes(*atts);
}

