/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyConeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyConeAttributes
//
// Purpose: 
//   This class contains attributes for the cone operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConeAttributes.
//
struct ConeAttributesObject
{
    PyObject_HEAD
    ConeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewConeAttributes(int);

std::string
PyConeAttributes_ToString(const ConeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sangle = %g\n", prefix, atts->GetAngle());
    str += tmpStr;
    {   const double *origin = atts->GetOrigin();
        SNPRINTF(tmpStr, 1000, "%sorigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", origin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *normal = atts->GetNormal();
        SNPRINTF(tmpStr, 1000, "%snormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *representation_names = "ThreeD, Flattened, R_Theta";
    switch (atts->GetRepresentation())
    {
      case ConeAttributes::ThreeD:
          SNPRINTF(tmpStr, 1000, "%srepresentation = %sThreeD  # %s\n", prefix, prefix, representation_names);
          str += tmpStr;
          break;
      case ConeAttributes::Flattened:
          SNPRINTF(tmpStr, 1000, "%srepresentation = %sFlattened  # %s\n", prefix, prefix, representation_names);
          str += tmpStr;
          break;
      case ConeAttributes::R_Theta:
          SNPRINTF(tmpStr, 1000, "%srepresentation = %sR_Theta  # %s\n", prefix, prefix, representation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *upAxis = atts->GetUpAxis();
        SNPRINTF(tmpStr, 1000, "%supAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", upAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetCutByLength())
        SNPRINTF(tmpStr, 1000, "%scutByLength = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scutByLength = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slength = %g\n", prefix, atts->GetLength());
    str += tmpStr;
    return str;
}

static PyObject *
ConeAttributes_Notify(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_SetAngle(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the angle in the object.
    obj->data->SetAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetAngle(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAngle());
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetOrigin(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the origin in the object as modified.
    obj->data->SelectOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetOrigin(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the origin.
    PyObject *retval = PyTuple_New(3);
    const double *origin = obj->data->GetOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(origin[i]));
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetNormal(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the normal in the object as modified.
    obj->data->SelectNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetNormal(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the normal.
    PyObject *retval = PyTuple_New(3);
    const double *normal = obj->data->GetNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(normal[i]));
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetRepresentation(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the representation in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetRepresentation(ConeAttributes::Representation(ival));
    else
    {
        fprintf(stderr, "An invalid representation value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ThreeD, Flattened, R_Theta.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetRepresentation(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRepresentation()));
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetUpAxis(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double *dvals = obj->data->GetUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the upAxis in the object as modified.
    obj->data->SelectUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetUpAxis(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upAxis.
    PyObject *retval = PyTuple_New(3);
    const double *upAxis = obj->data->GetUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upAxis[i]));
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetCutByLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cutByLength in the object.
    obj->data->SetCutByLength(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetCutByLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCutByLength()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ConeAttributes_SetLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the length in the object.
    obj->data->SetLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConeAttributes_GetLength(PyObject *self, PyObject *args)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLength());
    return retval;
}



PyMethodDef PyConeAttributes_methods[CONEATTRIBUTES_NMETH] = {
    {"Notify", ConeAttributes_Notify, METH_VARARGS},
    {"SetAngle", ConeAttributes_SetAngle, METH_VARARGS},
    {"GetAngle", ConeAttributes_GetAngle, METH_VARARGS},
    {"SetOrigin", ConeAttributes_SetOrigin, METH_VARARGS},
    {"GetOrigin", ConeAttributes_GetOrigin, METH_VARARGS},
    {"SetNormal", ConeAttributes_SetNormal, METH_VARARGS},
    {"GetNormal", ConeAttributes_GetNormal, METH_VARARGS},
    {"SetRepresentation", ConeAttributes_SetRepresentation, METH_VARARGS},
    {"GetRepresentation", ConeAttributes_GetRepresentation, METH_VARARGS},
    {"SetUpAxis", ConeAttributes_SetUpAxis, METH_VARARGS},
    {"GetUpAxis", ConeAttributes_GetUpAxis, METH_VARARGS},
    {"SetCutByLength", ConeAttributes_SetCutByLength, METH_VARARGS},
    {"GetCutByLength", ConeAttributes_GetCutByLength, METH_VARARGS},
    {"SetLength", ConeAttributes_SetLength, METH_VARARGS},
    {"GetLength", ConeAttributes_GetLength, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConeAttributes_dealloc(PyObject *v)
{
   ConeAttributesObject *obj = (ConeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ConeAttributes_compare(PyObject *v, PyObject *w)
{
    ConeAttributes *a = ((ConeAttributesObject *)v)->data;
    ConeAttributes *b = ((ConeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyConeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "angle") == 0)
        return ConeAttributes_GetAngle(self, NULL);
    if(strcmp(name, "origin") == 0)
        return ConeAttributes_GetOrigin(self, NULL);
    if(strcmp(name, "normal") == 0)
        return ConeAttributes_GetNormal(self, NULL);
    if(strcmp(name, "representation") == 0)
        return ConeAttributes_GetRepresentation(self, NULL);
    if(strcmp(name, "ThreeD") == 0)
        return PyInt_FromLong(long(ConeAttributes::ThreeD));
    if(strcmp(name, "Flattened") == 0)
        return PyInt_FromLong(long(ConeAttributes::Flattened));
    if(strcmp(name, "R_Theta") == 0)
        return PyInt_FromLong(long(ConeAttributes::R_Theta));

    if(strcmp(name, "upAxis") == 0)
        return ConeAttributes_GetUpAxis(self, NULL);
    if(strcmp(name, "cutByLength") == 0)
        return ConeAttributes_GetCutByLength(self, NULL);
    if(strcmp(name, "length") == 0)
        return ConeAttributes_GetLength(self, NULL);

    return Py_FindMethod(PyConeAttributes_methods, self, name);
}

int
PyConeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "angle") == 0)
        obj = ConeAttributes_SetAngle(self, tuple);
    else if(strcmp(name, "origin") == 0)
        obj = ConeAttributes_SetOrigin(self, tuple);
    else if(strcmp(name, "normal") == 0)
        obj = ConeAttributes_SetNormal(self, tuple);
    else if(strcmp(name, "representation") == 0)
        obj = ConeAttributes_SetRepresentation(self, tuple);
    else if(strcmp(name, "upAxis") == 0)
        obj = ConeAttributes_SetUpAxis(self, tuple);
    else if(strcmp(name, "cutByLength") == 0)
        obj = ConeAttributes_SetCutByLength(self, tuple);
    else if(strcmp(name, "length") == 0)
        obj = ConeAttributes_SetLength(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ConeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)v;
    fprintf(fp, "%s", PyConeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ConeAttributes_str(PyObject *v)
{
    ConeAttributesObject *obj = (ConeAttributesObject *)v;
    return PyString_FromString(PyConeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ConeAttributes_Purpose = "This class contains attributes for the cone operator.";
#else
static char *ConeAttributes_Purpose = "This class contains attributes for the cone operator.";
#endif

//
// The type description structure
//
static PyTypeObject ConeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConeAttributes",                    // tp_name
    sizeof(ConeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConeAttributes_dealloc,  // tp_dealloc
    (printfunc)ConeAttributes_print,     // tp_print
    (getattrfunc)PyConeAttributes_getattr, // tp_getattr
    (setattrfunc)PyConeAttributes_setattr, // tp_setattr
    (cmpfunc)ConeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ConeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConeAttributes *defaultAtts = 0;
static ConeAttributes *currentAtts = 0;

static PyObject *
NewConeAttributes(int useCurrent)
{
    ConeAttributesObject *newObject;
    newObject = PyObject_NEW(ConeAttributesObject, &ConeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ConeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ConeAttributes(*defaultAtts);
    else
        newObject->data = new ConeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapConeAttributes(const ConeAttributes *attr)
{
    ConeAttributesObject *newObject;
    newObject = PyObject_NEW(ConeAttributesObject, &ConeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewConeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConeAttributesMethods[] = {
    {"ConeAttributes", ConeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConeAttributesObserver = 0;

std::string
PyConeAttributes_GetLogString()
{
    std::string s("ConeAtts = ConeAttributes()\n");
    if(currentAtts != 0)
        s += PyConeAttributes_ToString(currentAtts, "ConeAtts.");
    return s;
}

static void
PyConeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ConeAtts = ConeAttributes()\n");
        s += PyConeAttributes_ToString(currentAtts, "ConeAtts.");
        cb(s);
    }
}

void
PyConeAttributes_StartUp(ConeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyConeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConeAttributesObserver == 0)
    {
        ConeAttributesObserver = new ObserverToCallback(subj,
            PyConeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyConeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConeAttributesObserver;
    ConeAttributesObserver = 0;
}

PyMethodDef *
PyConeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConeAttributesMethods;
}

bool
PyConeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConeAttributesType);
}

ConeAttributes *
PyConeAttributes_FromPyObject(PyObject *obj)
{
    ConeAttributesObject *obj2 = (ConeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConeAttributes_New()
{
    return NewConeAttributes(0);
}

PyObject *
PyConeAttributes_Wrap(const ConeAttributes *attr)
{
    return WrapConeAttributes(attr);
}

void
PyConeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ConeAttributesObject *obj2 = (ConeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyConeAttributes_SetDefaults(const ConeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConeAttributes(*atts);
}

