/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "ExportDatabaseRPC.h"
#include <DebugStream.h>


// ****************************************************************************
//  Constructor: ExportDatabaseRPC::ExportDatabaseRPC
//
//  Purpose: 
//    This is the constructor.
//
//  Arguments:
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
// ****************************************************************************

ExportDatabaseRPC::ExportDatabaseRPC() : BlockingRPC("i*as"), ids(), exportDBAtts(),
    timeSuffix()
{
}

// ****************************************************************************
//  Destructor: ExportDatabaseRPC::~ExportDatabaseRPC
//
//  Purpose: 
//    This is the destructor.
//
//  Arguments:
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
// ****************************************************************************

ExportDatabaseRPC::~ExportDatabaseRPC()
{
}

// ****************************************************************************
//  Method: ExportDatabaseRPC::operator()
//
//  Purpose: 
//    This is the RPC's invocation method.
//
//  Arguments:
//    id        the network id
//    origData  the type of input 
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
//  Modifications:
//    Brad Whitlock, Fri Jan 24 16:40:22 PST 2014
//    Allow more than one network.
//    Work partially supported by DOE Grant SC0007548.
//
//    Brad Whitlock, Thu Jul 24 22:16:34 EDT 2014
//    Pass time suffix.
//
// ****************************************************************************

void
ExportDatabaseRPC::operator()(const intVector &ids_, const ExportDBAttributes &atts, 
    const std::string &s)
{
    SetIDs(ids_);
    SetExportDBAtts(atts);
    SetTimeSuffix(s);

    Execute();
}

// ****************************************************************************
//  Method: ExportDatabaseRPC::SelectAll
//
//  Purpose: 
//    This selects all variables for sending.
//
//  Arguments:
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
// ****************************************************************************

void
ExportDatabaseRPC::SelectAll()
{
    Select(0, (void*)&ids);
    Select(1, (void*)&exportDBAtts);
    Select(2, (void*)&timeSuffix);
}


// ****************************************************************************
//  Method: ExportDatabaseRPC::SetIDs
//
//  Purpose: 
//    This sets the id parameter.
//
//  Arguments:
//    id_         the id
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
// ****************************************************************************

void
ExportDatabaseRPC::SetIDs(const intVector &ids_)
{
    ids = ids_;
    Select(0, (void*)&ids);
}


// ****************************************************************************
//  Method: ExportDatabaseRPC::GetID
//
//  Purpose: 
//    This returns network ids.
//
//  Arguments:
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005
//
// ****************************************************************************

const intVector &
ExportDatabaseRPC::GetIDs() const
{
    return ids;
}

// ****************************************************************************
//  Method: ExportDatabaseRPC::SetExportDBAtts 
//
//  Purpose:
//    This sets the exportDB atts.
//
//  Arguments:
//    atts      the exportDB atts
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005 
//
// ****************************************************************************
 
void
ExportDatabaseRPC::SetExportDBAtts(const ExportDBAttributes &atts)
{
    exportDBAtts = atts;
    Select(1, (void*)&exportDBAtts);
}


// ****************************************************************************
//  Method: ExportDatabaseRPC::GetExportDBAtts 
//
//  Purpose:
//    This returns the exportDB atts.
//
//  Programmer: Hank Childs
//  Creation:   May 26, 2005 
//
// ****************************************************************************
 
const ExportDBAttributes &
ExportDatabaseRPC::GetExportDBAtts() const
{
    return exportDBAtts;
}

void
ExportDatabaseRPC::SetTimeSuffix(const std::string &s)
{
    timeSuffix = s;
    Select(2, (void*)&timeSuffix);
}

const std::string &
ExportDatabaseRPC::GetTimeSuffix() const
{
    return timeSuffix;
}
