/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtSubsetsMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyNameschemeAttributes.h>

// ****************************************************************************
// Module: PyavtSubsetsMetaData
//
// Purpose: 
//   Information about a particular category of subsets of a mesh (even for material subsets)
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtSubsetsMetaData.
//
struct avtSubsetsMetaDataObject
{
    PyObject_HEAD
    avtSubsetsMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtSubsetsMetaData(int);

std::string
PyavtSubsetsMetaData_ToString(const avtSubsetsMetaData *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    str = PyavtVarMetaData_ToString(atts, prefix);

    SNPRINTF(tmpStr, 1000, "%scatName = \"%s\"\n", prefix, atts->GetCatName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scatCount = %d\n", prefix, atts->GetCatCount());
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "nameScheme.";
        str += PyNameschemeAttributes_ToString(&atts->GetNameScheme(), objPrefix.c_str());
    }
    {   const stringVector &colorScheme = atts->colorScheme;
        SNPRINTF(tmpStr, 1000, "%scolorScheme = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < colorScheme.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", colorScheme[i].c_str());
            str += tmpStr;
            if(i < colorScheme.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &setsToChunksMaps = atts->GetSetsToChunksMaps();
        SNPRINTF(tmpStr, 1000, "%ssetsToChunksMaps = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < setsToChunksMaps.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", setsToChunksMaps[i]);
            str += tmpStr;
            if(i < setsToChunksMaps.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &graphEdges = atts->GetGraphEdges();
        SNPRINTF(tmpStr, 1000, "%sgraphEdges = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < graphEdges.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", graphEdges[i]);
            str += tmpStr;
            if(i < graphEdges.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->isChunkCat)
        SNPRINTF(tmpStr, 1000, "%sisChunkCat = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisChunkCat = 0\n", prefix);
    str += tmpStr;
    if(atts->isMaterialCat)
        SNPRINTF(tmpStr, 1000, "%sisMaterialCat = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisMaterialCat = 0\n", prefix);
    str += tmpStr;
    if(atts->isUnionOfChunks)
        SNPRINTF(tmpStr, 1000, "%sisUnionOfChunks = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisUnionOfChunks = 0\n", prefix);
    str += tmpStr;
    if(atts->hasPartialCells)
        SNPRINTF(tmpStr, 1000, "%shasPartialCells = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shasPartialCells = 0\n", prefix);
    str += tmpStr;
    const char *decompMode_names = "None, Cover, Partition";
    switch (atts->decompMode)
    {
      case avtSubsetsMetaData::None:
          SNPRINTF(tmpStr, 1000, "%sdecompMode = %sNone  # %s\n", prefix, prefix, decompMode_names);
          str += tmpStr;
          break;
      case avtSubsetsMetaData::Cover:
          SNPRINTF(tmpStr, 1000, "%sdecompMode = %sCover  # %s\n", prefix, prefix, decompMode_names);
          str += tmpStr;
          break;
      case avtSubsetsMetaData::Partition:
          SNPRINTF(tmpStr, 1000, "%sdecompMode = %sPartition  # %s\n", prefix, prefix, decompMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxTopoDim = %d\n", prefix, atts->maxTopoDim);
    str += tmpStr;
    return str;
}

static PyObject *
avtSubsetsMetaData_Notify(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetCatName(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the catName in the object.
    obj->data->SetCatName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetCatName(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCatName().c_str());
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetCatCount(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the catCount in the object.
    obj->data->SetCatCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetCatCount(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCatCount()));
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetNameScheme(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyNameschemeAttributes_Check(newValue))
    {
        fprintf(stderr, "The nameScheme field can only be set with NameschemeAttributes objects.\n");
        return NULL;
    }

    obj->data->SetNameScheme(*PyNameschemeAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetNameScheme(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyNameschemeAttributes_Wrap(&obj->data->GetNameScheme());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyNameschemeAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetColorScheme(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    stringVector  &vec = obj->data->colorScheme;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the colorScheme in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetColorScheme(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the colorScheme.
    const stringVector &colorScheme = obj->data->colorScheme;
    PyObject *retval = PyTuple_New(colorScheme.size());
    for(size_t i = 0; i < colorScheme.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(colorScheme[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetSetsToChunksMaps(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    intVector  &vec = obj->data->GetSetsToChunksMaps();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the setsToChunksMaps in the object as modified.
    obj->data->SelectSetsToChunksMaps();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetSetsToChunksMaps(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the setsToChunksMaps.
    const intVector &setsToChunksMaps = obj->data->GetSetsToChunksMaps();
    PyObject *retval = PyTuple_New(setsToChunksMaps.size());
    for(size_t i = 0; i < setsToChunksMaps.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(setsToChunksMaps[i])));
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetGraphEdges(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    intVector  &vec = obj->data->GetGraphEdges();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the graphEdges in the object as modified.
    obj->data->SelectGraphEdges();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetGraphEdges(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the graphEdges.
    const intVector &graphEdges = obj->data->GetGraphEdges();
    PyObject *retval = PyTuple_New(graphEdges.size());
    for(size_t i = 0; i < graphEdges.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(graphEdges[i])));
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetIsChunkCat(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isChunkCat in the object.
    obj->data->isChunkCat = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetIsChunkCat(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->isChunkCat?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetIsMaterialCat(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isMaterialCat in the object.
    obj->data->isMaterialCat = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetIsMaterialCat(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->isMaterialCat?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetIsUnionOfChunks(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isUnionOfChunks in the object.
    obj->data->isUnionOfChunks = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetIsUnionOfChunks(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->isUnionOfChunks?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetHasPartialCells(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasPartialCells in the object.
    obj->data->hasPartialCells = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetHasPartialCells(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasPartialCells?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetDecompMode(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the decompMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->decompMode = avtSubsetsMetaData::DecompMode(ival);
    else
    {
        fprintf(stderr, "An invalid decompMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Cover, Partition.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetDecompMode(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->decompMode));
    return retval;
}

/*static*/ PyObject *
avtSubsetsMetaData_SetMaxTopoDim(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxTopoDim in the object.
    obj->data->maxTopoDim = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSubsetsMetaData_GetMaxTopoDim(PyObject *self, PyObject *args)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->maxTopoDim));
    return retval;
}



PyMethodDef PyavtSubsetsMetaData_methods[AVTSUBSETSMETADATA_NMETH] = {
    {"Notify", avtSubsetsMetaData_Notify, METH_VARARGS},
    {"SetCatName", avtSubsetsMetaData_SetCatName, METH_VARARGS},
    {"GetCatName", avtSubsetsMetaData_GetCatName, METH_VARARGS},
    {"SetCatCount", avtSubsetsMetaData_SetCatCount, METH_VARARGS},
    {"GetCatCount", avtSubsetsMetaData_GetCatCount, METH_VARARGS},
    {"SetNameScheme", avtSubsetsMetaData_SetNameScheme, METH_VARARGS},
    {"GetNameScheme", avtSubsetsMetaData_GetNameScheme, METH_VARARGS},
    {"SetColorScheme", avtSubsetsMetaData_SetColorScheme, METH_VARARGS},
    {"GetColorScheme", avtSubsetsMetaData_GetColorScheme, METH_VARARGS},
    {"SetSetsToChunksMaps", avtSubsetsMetaData_SetSetsToChunksMaps, METH_VARARGS},
    {"GetSetsToChunksMaps", avtSubsetsMetaData_GetSetsToChunksMaps, METH_VARARGS},
    {"SetGraphEdges", avtSubsetsMetaData_SetGraphEdges, METH_VARARGS},
    {"GetGraphEdges", avtSubsetsMetaData_GetGraphEdges, METH_VARARGS},
    {"SetIsChunkCat", avtSubsetsMetaData_SetIsChunkCat, METH_VARARGS},
    {"GetIsChunkCat", avtSubsetsMetaData_GetIsChunkCat, METH_VARARGS},
    {"SetIsMaterialCat", avtSubsetsMetaData_SetIsMaterialCat, METH_VARARGS},
    {"GetIsMaterialCat", avtSubsetsMetaData_GetIsMaterialCat, METH_VARARGS},
    {"SetIsUnionOfChunks", avtSubsetsMetaData_SetIsUnionOfChunks, METH_VARARGS},
    {"GetIsUnionOfChunks", avtSubsetsMetaData_GetIsUnionOfChunks, METH_VARARGS},
    {"SetHasPartialCells", avtSubsetsMetaData_SetHasPartialCells, METH_VARARGS},
    {"GetHasPartialCells", avtSubsetsMetaData_GetHasPartialCells, METH_VARARGS},
    {"SetDecompMode", avtSubsetsMetaData_SetDecompMode, METH_VARARGS},
    {"GetDecompMode", avtSubsetsMetaData_GetDecompMode, METH_VARARGS},
    {"SetMaxTopoDim", avtSubsetsMetaData_SetMaxTopoDim, METH_VARARGS},
    {"GetMaxTopoDim", avtSubsetsMetaData_GetMaxTopoDim, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtSubsetsMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtSubsetsMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtSubsetsMetaData_methods[i] = PyavtVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtSubsetsMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtSubsetsMetaData_dealloc(PyObject *v)
{
   avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtSubsetsMetaData_compare(PyObject *v, PyObject *w)
{
    avtSubsetsMetaData *a = ((avtSubsetsMetaDataObject *)v)->data;
    avtSubsetsMetaData *b = ((avtSubsetsMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtSubsetsMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "catName") == 0)
        return avtSubsetsMetaData_GetCatName(self, NULL);
    if(strcmp(name, "catCount") == 0)
        return avtSubsetsMetaData_GetCatCount(self, NULL);
    if(strcmp(name, "nameScheme") == 0)
        return avtSubsetsMetaData_GetNameScheme(self, NULL);
    if(strcmp(name, "colorScheme") == 0)
        return avtSubsetsMetaData_GetColorScheme(self, NULL);
    if(strcmp(name, "setsToChunksMaps") == 0)
        return avtSubsetsMetaData_GetSetsToChunksMaps(self, NULL);
    if(strcmp(name, "graphEdges") == 0)
        return avtSubsetsMetaData_GetGraphEdges(self, NULL);
    if(strcmp(name, "isChunkCat") == 0)
        return avtSubsetsMetaData_GetIsChunkCat(self, NULL);
    if(strcmp(name, "isMaterialCat") == 0)
        return avtSubsetsMetaData_GetIsMaterialCat(self, NULL);
    if(strcmp(name, "isUnionOfChunks") == 0)
        return avtSubsetsMetaData_GetIsUnionOfChunks(self, NULL);
    if(strcmp(name, "hasPartialCells") == 0)
        return avtSubsetsMetaData_GetHasPartialCells(self, NULL);
    if(strcmp(name, "decompMode") == 0)
        return avtSubsetsMetaData_GetDecompMode(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(avtSubsetsMetaData::None));
    if(strcmp(name, "Cover") == 0)
        return PyInt_FromLong(long(avtSubsetsMetaData::Cover));
    if(strcmp(name, "Partition") == 0)
        return PyInt_FromLong(long(avtSubsetsMetaData::Partition));

    if(strcmp(name, "maxTopoDim") == 0)
        return avtSubsetsMetaData_GetMaxTopoDim(self, NULL);


    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtSubsetsMetaData_ExtendSetGetMethodTable();
    return Py_FindMethod(PyavtSubsetsMetaData_methods, self, name);
}

int
PyavtSubsetsMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtVarMetaData_setattr(self, name, args) != -1)
        return 0;

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "catName") == 0)
        obj = avtSubsetsMetaData_SetCatName(self, tuple);
    else if(strcmp(name, "catCount") == 0)
        obj = avtSubsetsMetaData_SetCatCount(self, tuple);
    else if(strcmp(name, "nameScheme") == 0)
        obj = avtSubsetsMetaData_SetNameScheme(self, tuple);
    else if(strcmp(name, "colorScheme") == 0)
        obj = avtSubsetsMetaData_SetColorScheme(self, tuple);
    else if(strcmp(name, "setsToChunksMaps") == 0)
        obj = avtSubsetsMetaData_SetSetsToChunksMaps(self, tuple);
    else if(strcmp(name, "graphEdges") == 0)
        obj = avtSubsetsMetaData_SetGraphEdges(self, tuple);
    else if(strcmp(name, "isChunkCat") == 0)
        obj = avtSubsetsMetaData_SetIsChunkCat(self, tuple);
    else if(strcmp(name, "isMaterialCat") == 0)
        obj = avtSubsetsMetaData_SetIsMaterialCat(self, tuple);
    else if(strcmp(name, "isUnionOfChunks") == 0)
        obj = avtSubsetsMetaData_SetIsUnionOfChunks(self, tuple);
    else if(strcmp(name, "hasPartialCells") == 0)
        obj = avtSubsetsMetaData_SetHasPartialCells(self, tuple);
    else if(strcmp(name, "decompMode") == 0)
        obj = avtSubsetsMetaData_SetDecompMode(self, tuple);
    else if(strcmp(name, "maxTopoDim") == 0)
        obj = avtSubsetsMetaData_SetMaxTopoDim(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
avtSubsetsMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)v;
    fprintf(fp, "%s", PyavtSubsetsMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtSubsetsMetaData_str(PyObject *v)
{
    avtSubsetsMetaDataObject *obj = (avtSubsetsMetaDataObject *)v;
    return PyString_FromString(PyavtSubsetsMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtSubsetsMetaData_Purpose = "Information about a particular category of subsets of a mesh (even for material subsets)";
#else
static char *avtSubsetsMetaData_Purpose = "Information about a particular category of subsets of a mesh (even for material subsets)";
#endif

//
// The type description structure
//
static PyTypeObject avtSubsetsMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtSubsetsMetaData",                    // tp_name
    sizeof(avtSubsetsMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtSubsetsMetaData_dealloc,  // tp_dealloc
    (printfunc)avtSubsetsMetaData_print,     // tp_print
    (getattrfunc)PyavtSubsetsMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtSubsetsMetaData_setattr, // tp_setattr
    (cmpfunc)avtSubsetsMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtSubsetsMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtSubsetsMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtSubsetsMetaData *defaultAtts = 0;
static avtSubsetsMetaData *currentAtts = 0;

static PyObject *
NewavtSubsetsMetaData(int useCurrent)
{
    avtSubsetsMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSubsetsMetaDataObject, &avtSubsetsMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtSubsetsMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtSubsetsMetaData(*defaultAtts);
    else
        newObject->data = new avtSubsetsMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtSubsetsMetaData(const avtSubsetsMetaData *attr)
{
    avtSubsetsMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSubsetsMetaDataObject, &avtSubsetsMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtSubsetsMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtSubsetsMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtSubsetsMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtSubsetsMetaDataMethods[] = {
    {"avtSubsetsMetaData", avtSubsetsMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtSubsetsMetaDataObserver = 0;

std::string
PyavtSubsetsMetaData_GetLogString()
{
    std::string s("avtSubsetsMetaData = avtSubsetsMetaData()\n");
    if(currentAtts != 0)
        s += PyavtSubsetsMetaData_ToString(currentAtts, "avtSubsetsMetaData.");
    return s;
}

static void
PyavtSubsetsMetaData_CallLogRoutine(Subject *subj, void *data)
{
    avtSubsetsMetaData *atts = (avtSubsetsMetaData *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtSubsetsMetaData = avtSubsetsMetaData()\n");
        s += PyavtSubsetsMetaData_ToString(currentAtts, "avtSubsetsMetaData.");
        cb(s);
    }
}

void
PyavtSubsetsMetaData_StartUp(avtSubsetsMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtSubsetsMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtSubsetsMetaDataObserver == 0)
    {
        avtSubsetsMetaDataObserver = new ObserverToCallback(subj,
            PyavtSubsetsMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtSubsetsMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtSubsetsMetaDataObserver;
    avtSubsetsMetaDataObserver = 0;
}

PyMethodDef *
PyavtSubsetsMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtSubsetsMetaDataMethods;
}

bool
PyavtSubsetsMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtSubsetsMetaDataType);
}

avtSubsetsMetaData *
PyavtSubsetsMetaData_FromPyObject(PyObject *obj)
{
    avtSubsetsMetaDataObject *obj2 = (avtSubsetsMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtSubsetsMetaData_New()
{
    return NewavtSubsetsMetaData(0);
}

PyObject *
PyavtSubsetsMetaData_Wrap(const avtSubsetsMetaData *attr)
{
    return WrapavtSubsetsMetaData(attr);
}

void
PyavtSubsetsMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtSubsetsMetaDataObject *obj2 = (avtSubsetsMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtSubsetsMetaData_SetDefaults(const avtSubsetsMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtSubsetsMetaData(*atts);
}

