/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtSpeciesMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyavtMatSpeciesMetaData.h>

// ****************************************************************************
// Module: PyavtSpeciesMetaData
//
// Purpose: 
//   Contains species metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtSpeciesMetaData.
//
struct avtSpeciesMetaDataObject
{
    PyObject_HEAD
    avtSpeciesMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtSpeciesMetaData(int);

std::string
PyavtSpeciesMetaData_ToString(const avtSpeciesMetaData *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->name.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginalName = \"%s\"\n", prefix, atts->originalName.c_str());
    str += tmpStr;
    if(atts->validVariable)
        SNPRINTF(tmpStr, 1000, "%svalidVariable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svalidVariable = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smeshName = \"%s\"\n", prefix, atts->meshName.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaterialName = \"%s\"\n", prefix, atts->materialName.c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumMaterials = %d\n", prefix, atts->numMaterials);
    str += tmpStr;
    { // new scope
        int index = 0;
        // Create string representation of species from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetSpecies().begin(); pos != atts->GetSpecies().end(); ++pos, ++index)
        {
            const avtMatSpeciesMetaData *current = (const avtMatSpeciesMetaData *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetSpecies(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtMatSpeciesMetaData_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#species does not contain any avtMatSpeciesMetaData objects.\n";
    }
    return str;
}

static PyObject *
avtSpeciesMetaData_Notify(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->name = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->name.c_str());
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetOriginalName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the originalName in the object.
    obj->data->originalName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetOriginalName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->originalName.c_str());
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetValidVariable(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the validVariable in the object.
    obj->data->validVariable = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetValidVariable(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->validVariable?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetMeshName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the meshName in the object.
    obj->data->meshName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetMeshName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->meshName.c_str());
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetMaterialName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the materialName in the object.
    obj->data->materialName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetMaterialName(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->materialName.c_str());
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_SetNumMaterials(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numMaterials in the object.
    obj->data->numMaterials = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetNumMaterials(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->numMaterials));
    return retval;
}

/*static*/ PyObject *
avtSpeciesMetaData_GetSpecies(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || index >= obj->data->GetSpecies().size())
    {
        char msg[200];
        if(obj->data->GetSpecies().size() == 0)
            SNPRINTF(msg, 200, "The index is invalid because species is empty.");
        else
            SNPRINTF(msg, 200, "The index is invalid. Use index values in: [0, %ld).", obj->data->GetSpecies().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtMatSpeciesMetaData_Wrap(&obj->data->GetSpecies(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtMatSpeciesMetaData_SetParent(retval, self);

    return retval;
}

PyObject *
avtSpeciesMetaData_GetNumSpecies(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    return PyInt_FromLong((long)obj->data->GetSpecies().size());
}

PyObject *
avtSpeciesMetaData_AddSpecies(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtMatSpeciesMetaData_Check(element))
    {
        char msg[400];
        SNPRINTF(msg, 400, "The AddSpecies method only accepts avtMatSpeciesMetaData objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtMatSpeciesMetaData *newData = PyavtMatSpeciesMetaData_FromPyObject(element);
    obj->data->AddSpecies(*newData);
    obj->data->SelectSpecies();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtSpeciesMetaData_Remove_One_Species(PyObject *self, int index)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveSpecies() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetSpecies();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectSpecies();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtSpeciesMetaData_RemoveSpecies(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    if(index < 0 || index >= obj->data->GetNumSpecies())
    {
        PyErr_SetString(PyExc_IndexError, "Index out of range");
        return NULL;
    }

    return avtSpeciesMetaData_Remove_One_Species(self, index);
}

PyObject *
avtSpeciesMetaData_ClearSpecies(PyObject *self, PyObject *args)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)self;
    int n = obj->data->GetNumSpecies();
    for(int i = 0; i < n; ++i)
    {
        avtSpeciesMetaData_Remove_One_Species(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}



PyMethodDef PyavtSpeciesMetaData_methods[AVTSPECIESMETADATA_NMETH] = {
    {"Notify", avtSpeciesMetaData_Notify, METH_VARARGS},
    {"SetName", avtSpeciesMetaData_SetName, METH_VARARGS},
    {"GetName", avtSpeciesMetaData_GetName, METH_VARARGS},
    {"SetOriginalName", avtSpeciesMetaData_SetOriginalName, METH_VARARGS},
    {"GetOriginalName", avtSpeciesMetaData_GetOriginalName, METH_VARARGS},
    {"SetValidVariable", avtSpeciesMetaData_SetValidVariable, METH_VARARGS},
    {"GetValidVariable", avtSpeciesMetaData_GetValidVariable, METH_VARARGS},
    {"SetMeshName", avtSpeciesMetaData_SetMeshName, METH_VARARGS},
    {"GetMeshName", avtSpeciesMetaData_GetMeshName, METH_VARARGS},
    {"SetMaterialName", avtSpeciesMetaData_SetMaterialName, METH_VARARGS},
    {"GetMaterialName", avtSpeciesMetaData_GetMaterialName, METH_VARARGS},
    {"SetNumMaterials", avtSpeciesMetaData_SetNumMaterials, METH_VARARGS},
    {"GetNumMaterials", avtSpeciesMetaData_GetNumMaterials, METH_VARARGS},
    {"GetSpecies", avtSpeciesMetaData_GetSpecies, METH_VARARGS},
    {"GetNumSpecies", avtSpeciesMetaData_GetNumSpecies, METH_VARARGS},
    {"AddSpecies", avtSpeciesMetaData_AddSpecies, METH_VARARGS},
    {"RemoveSpecies", avtSpeciesMetaData_RemoveSpecies, METH_VARARGS},
    {"ClearSpecies", avtSpeciesMetaData_ClearSpecies, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtSpeciesMetaData_dealloc(PyObject *v)
{
   avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtSpeciesMetaData_compare(PyObject *v, PyObject *w)
{
    avtSpeciesMetaData *a = ((avtSpeciesMetaDataObject *)v)->data;
    avtSpeciesMetaData *b = ((avtSpeciesMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtSpeciesMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return avtSpeciesMetaData_GetName(self, NULL);
    if(strcmp(name, "originalName") == 0)
        return avtSpeciesMetaData_GetOriginalName(self, NULL);
    if(strcmp(name, "validVariable") == 0)
        return avtSpeciesMetaData_GetValidVariable(self, NULL);
    if(strcmp(name, "meshName") == 0)
        return avtSpeciesMetaData_GetMeshName(self, NULL);
    if(strcmp(name, "materialName") == 0)
        return avtSpeciesMetaData_GetMaterialName(self, NULL);
    if(strcmp(name, "numMaterials") == 0)
        return avtSpeciesMetaData_GetNumMaterials(self, NULL);
    if(strcmp(name, "species") == 0)
        return avtSpeciesMetaData_GetSpecies(self, NULL);

    return Py_FindMethod(PyavtSpeciesMetaData_methods, self, name);
}

int
PyavtSpeciesMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = avtSpeciesMetaData_SetName(self, tuple);
    else if(strcmp(name, "originalName") == 0)
        obj = avtSpeciesMetaData_SetOriginalName(self, tuple);
    else if(strcmp(name, "validVariable") == 0)
        obj = avtSpeciesMetaData_SetValidVariable(self, tuple);
    else if(strcmp(name, "meshName") == 0)
        obj = avtSpeciesMetaData_SetMeshName(self, tuple);
    else if(strcmp(name, "materialName") == 0)
        obj = avtSpeciesMetaData_SetMaterialName(self, tuple);
    else if(strcmp(name, "numMaterials") == 0)
        obj = avtSpeciesMetaData_SetNumMaterials(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
avtSpeciesMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)v;
    fprintf(fp, "%s", PyavtSpeciesMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtSpeciesMetaData_str(PyObject *v)
{
    avtSpeciesMetaDataObject *obj = (avtSpeciesMetaDataObject *)v;
    return PyString_FromString(PyavtSpeciesMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtSpeciesMetaData_Purpose = "Contains species metadata attributes";
#else
static char *avtSpeciesMetaData_Purpose = "Contains species metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtSpeciesMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtSpeciesMetaData",                    // tp_name
    sizeof(avtSpeciesMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtSpeciesMetaData_dealloc,  // tp_dealloc
    (printfunc)avtSpeciesMetaData_print,     // tp_print
    (getattrfunc)PyavtSpeciesMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtSpeciesMetaData_setattr, // tp_setattr
    (cmpfunc)avtSpeciesMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtSpeciesMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtSpeciesMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtSpeciesMetaData *defaultAtts = 0;
static avtSpeciesMetaData *currentAtts = 0;

static PyObject *
NewavtSpeciesMetaData(int useCurrent)
{
    avtSpeciesMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSpeciesMetaDataObject, &avtSpeciesMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtSpeciesMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtSpeciesMetaData(*defaultAtts);
    else
        newObject->data = new avtSpeciesMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtSpeciesMetaData(const avtSpeciesMetaData *attr)
{
    avtSpeciesMetaDataObject *newObject;
    newObject = PyObject_NEW(avtSpeciesMetaDataObject, &avtSpeciesMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtSpeciesMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtSpeciesMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtSpeciesMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtSpeciesMetaDataMethods[] = {
    {"avtSpeciesMetaData", avtSpeciesMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtSpeciesMetaDataObserver = 0;

std::string
PyavtSpeciesMetaData_GetLogString()
{
    std::string s("avtSpeciesMetaData = avtSpeciesMetaData()\n");
    if(currentAtts != 0)
        s += PyavtSpeciesMetaData_ToString(currentAtts, "avtSpeciesMetaData.");
    return s;
}

static void
PyavtSpeciesMetaData_CallLogRoutine(Subject *subj, void *data)
{
    avtSpeciesMetaData *atts = (avtSpeciesMetaData *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtSpeciesMetaData = avtSpeciesMetaData()\n");
        s += PyavtSpeciesMetaData_ToString(currentAtts, "avtSpeciesMetaData.");
        cb(s);
    }
}

void
PyavtSpeciesMetaData_StartUp(avtSpeciesMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtSpeciesMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtSpeciesMetaDataObserver == 0)
    {
        avtSpeciesMetaDataObserver = new ObserverToCallback(subj,
            PyavtSpeciesMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtSpeciesMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtSpeciesMetaDataObserver;
    avtSpeciesMetaDataObserver = 0;
}

PyMethodDef *
PyavtSpeciesMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtSpeciesMetaDataMethods;
}

bool
PyavtSpeciesMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtSpeciesMetaDataType);
}

avtSpeciesMetaData *
PyavtSpeciesMetaData_FromPyObject(PyObject *obj)
{
    avtSpeciesMetaDataObject *obj2 = (avtSpeciesMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtSpeciesMetaData_New()
{
    return NewavtSpeciesMetaData(0);
}

PyObject *
PyavtSpeciesMetaData_Wrap(const avtSpeciesMetaData *attr)
{
    return WrapavtSpeciesMetaData(attr);
}

void
PyavtSpeciesMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtSpeciesMetaDataObject *obj2 = (avtSpeciesMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtSpeciesMetaData_SetDefaults(const avtSpeciesMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtSpeciesMetaData(*atts);
}

