/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtSimulationCommandSpecification.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyavtSimulationCommandSpecification
//
// Purpose: 
//   Contains the specification for one command
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtSimulationCommandSpecification.
//
struct avtSimulationCommandSpecificationObject
{
    PyObject_HEAD
    avtSimulationCommandSpecification *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtSimulationCommandSpecification(int);

std::string
PyavtSimulationCommandSpecification_ToString(const avtSimulationCommandSpecification *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    const char *argumentType_names = "CmdArgNone, CmdArgInt, CmdArgFloat, CmdArgString";
    switch (atts->GetArgumentType())
    {
      case avtSimulationCommandSpecification::CmdArgNone:
          SNPRINTF(tmpStr, 1000, "%sargumentType = %sCmdArgNone  # %s\n", prefix, prefix, argumentType_names);
          str += tmpStr;
          break;
      case avtSimulationCommandSpecification::CmdArgInt:
          SNPRINTF(tmpStr, 1000, "%sargumentType = %sCmdArgInt  # %s\n", prefix, prefix, argumentType_names);
          str += tmpStr;
          break;
      case avtSimulationCommandSpecification::CmdArgFloat:
          SNPRINTF(tmpStr, 1000, "%sargumentType = %sCmdArgFloat  # %s\n", prefix, prefix, argumentType_names);
          str += tmpStr;
          break;
      case avtSimulationCommandSpecification::CmdArgString:
          SNPRINTF(tmpStr, 1000, "%sargumentType = %sCmdArgString  # %s\n", prefix, prefix, argumentType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sclassName = \"%s\"\n", prefix, atts->GetClassName().c_str());
    str += tmpStr;
    if(atts->GetEnabled())
        SNPRINTF(tmpStr, 1000, "%senabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%senabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sparent = \"%s\"\n", prefix, atts->GetParent().c_str());
    str += tmpStr;
    if(atts->GetIsOn())
        SNPRINTF(tmpStr, 1000, "%sisOn = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisOn = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssignal = \"%s\"\n", prefix, atts->GetSignal().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stext = \"%s\"\n", prefix, atts->GetText().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%suiType = \"%s\"\n", prefix, atts->GetUiType().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svalue = \"%s\"\n", prefix, atts->GetValue().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
avtSimulationCommandSpecification_Notify(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetName(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetName(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetArgumentType(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the argumentType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetArgumentType(avtSimulationCommandSpecification::CommandArgumentType(ival));
    else
    {
        fprintf(stderr, "An invalid argumentType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "CmdArgNone, CmdArgInt, CmdArgFloat, CmdArgString.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetArgumentType(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetArgumentType()));
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetClassName(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the className in the object.
    obj->data->SetClassName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetClassName(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetClassName().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetEnabled(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enabled in the object.
    obj->data->SetEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetEnabled(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetParent(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the parent in the object.
    obj->data->SetParent(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetParent(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetParent().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetIsOn(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isOn in the object.
    obj->data->SetIsOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetIsOn(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsOn()?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetSignal(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the signal in the object.
    obj->data->SetSignal(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetSignal(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSignal().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetText(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the text in the object.
    obj->data->SetText(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetText(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetText().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetUiType(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the uiType in the object.
    obj->data->SetUiType(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetUiType(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetUiType().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_SetValue(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the value in the object.
    obj->data->SetValue(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationCommandSpecification_GetValue(PyObject *self, PyObject *args)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetValue().c_str());
    return retval;
}



PyMethodDef PyavtSimulationCommandSpecification_methods[AVTSIMULATIONCOMMANDSPECIFICATION_NMETH] = {
    {"Notify", avtSimulationCommandSpecification_Notify, METH_VARARGS},
    {"SetName", avtSimulationCommandSpecification_SetName, METH_VARARGS},
    {"GetName", avtSimulationCommandSpecification_GetName, METH_VARARGS},
    {"SetArgumentType", avtSimulationCommandSpecification_SetArgumentType, METH_VARARGS},
    {"GetArgumentType", avtSimulationCommandSpecification_GetArgumentType, METH_VARARGS},
    {"SetClassName", avtSimulationCommandSpecification_SetClassName, METH_VARARGS},
    {"GetClassName", avtSimulationCommandSpecification_GetClassName, METH_VARARGS},
    {"SetEnabled", avtSimulationCommandSpecification_SetEnabled, METH_VARARGS},
    {"GetEnabled", avtSimulationCommandSpecification_GetEnabled, METH_VARARGS},
    {"SetParent", avtSimulationCommandSpecification_SetParent, METH_VARARGS},
    {"GetParent", avtSimulationCommandSpecification_GetParent, METH_VARARGS},
    {"SetIsOn", avtSimulationCommandSpecification_SetIsOn, METH_VARARGS},
    {"GetIsOn", avtSimulationCommandSpecification_GetIsOn, METH_VARARGS},
    {"SetSignal", avtSimulationCommandSpecification_SetSignal, METH_VARARGS},
    {"GetSignal", avtSimulationCommandSpecification_GetSignal, METH_VARARGS},
    {"SetText", avtSimulationCommandSpecification_SetText, METH_VARARGS},
    {"GetText", avtSimulationCommandSpecification_GetText, METH_VARARGS},
    {"SetUiType", avtSimulationCommandSpecification_SetUiType, METH_VARARGS},
    {"GetUiType", avtSimulationCommandSpecification_GetUiType, METH_VARARGS},
    {"SetValue", avtSimulationCommandSpecification_SetValue, METH_VARARGS},
    {"GetValue", avtSimulationCommandSpecification_GetValue, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtSimulationCommandSpecification_dealloc(PyObject *v)
{
   avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtSimulationCommandSpecification_compare(PyObject *v, PyObject *w)
{
    avtSimulationCommandSpecification *a = ((avtSimulationCommandSpecificationObject *)v)->data;
    avtSimulationCommandSpecification *b = ((avtSimulationCommandSpecificationObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtSimulationCommandSpecification_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return avtSimulationCommandSpecification_GetName(self, NULL);
    if(strcmp(name, "argumentType") == 0)
        return avtSimulationCommandSpecification_GetArgumentType(self, NULL);
    if(strcmp(name, "CmdArgNone") == 0)
        return PyInt_FromLong(long(avtSimulationCommandSpecification::CmdArgNone));
    if(strcmp(name, "CmdArgInt") == 0)
        return PyInt_FromLong(long(avtSimulationCommandSpecification::CmdArgInt));
    if(strcmp(name, "CmdArgFloat") == 0)
        return PyInt_FromLong(long(avtSimulationCommandSpecification::CmdArgFloat));
    if(strcmp(name, "CmdArgString") == 0)
        return PyInt_FromLong(long(avtSimulationCommandSpecification::CmdArgString));

    if(strcmp(name, "className") == 0)
        return avtSimulationCommandSpecification_GetClassName(self, NULL);
    if(strcmp(name, "enabled") == 0)
        return avtSimulationCommandSpecification_GetEnabled(self, NULL);
    if(strcmp(name, "parent") == 0)
        return avtSimulationCommandSpecification_GetParent(self, NULL);
    if(strcmp(name, "isOn") == 0)
        return avtSimulationCommandSpecification_GetIsOn(self, NULL);
    if(strcmp(name, "signal") == 0)
        return avtSimulationCommandSpecification_GetSignal(self, NULL);
    if(strcmp(name, "text") == 0)
        return avtSimulationCommandSpecification_GetText(self, NULL);
    if(strcmp(name, "uiType") == 0)
        return avtSimulationCommandSpecification_GetUiType(self, NULL);
    if(strcmp(name, "value") == 0)
        return avtSimulationCommandSpecification_GetValue(self, NULL);

    return Py_FindMethod(PyavtSimulationCommandSpecification_methods, self, name);
}

int
PyavtSimulationCommandSpecification_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = avtSimulationCommandSpecification_SetName(self, tuple);
    else if(strcmp(name, "argumentType") == 0)
        obj = avtSimulationCommandSpecification_SetArgumentType(self, tuple);
    else if(strcmp(name, "className") == 0)
        obj = avtSimulationCommandSpecification_SetClassName(self, tuple);
    else if(strcmp(name, "enabled") == 0)
        obj = avtSimulationCommandSpecification_SetEnabled(self, tuple);
    else if(strcmp(name, "parent") == 0)
        obj = avtSimulationCommandSpecification_SetParent(self, tuple);
    else if(strcmp(name, "isOn") == 0)
        obj = avtSimulationCommandSpecification_SetIsOn(self, tuple);
    else if(strcmp(name, "signal") == 0)
        obj = avtSimulationCommandSpecification_SetSignal(self, tuple);
    else if(strcmp(name, "text") == 0)
        obj = avtSimulationCommandSpecification_SetText(self, tuple);
    else if(strcmp(name, "uiType") == 0)
        obj = avtSimulationCommandSpecification_SetUiType(self, tuple);
    else if(strcmp(name, "value") == 0)
        obj = avtSimulationCommandSpecification_SetValue(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
avtSimulationCommandSpecification_print(PyObject *v, FILE *fp, int flags)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)v;
    fprintf(fp, "%s", PyavtSimulationCommandSpecification_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtSimulationCommandSpecification_str(PyObject *v)
{
    avtSimulationCommandSpecificationObject *obj = (avtSimulationCommandSpecificationObject *)v;
    return PyString_FromString(PyavtSimulationCommandSpecification_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtSimulationCommandSpecification_Purpose = "Contains the specification for one command";
#else
static char *avtSimulationCommandSpecification_Purpose = "Contains the specification for one command";
#endif

//
// The type description structure
//
static PyTypeObject avtSimulationCommandSpecificationType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtSimulationCommandSpecification",                    // tp_name
    sizeof(avtSimulationCommandSpecificationObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtSimulationCommandSpecification_dealloc,  // tp_dealloc
    (printfunc)avtSimulationCommandSpecification_print,     // tp_print
    (getattrfunc)PyavtSimulationCommandSpecification_getattr, // tp_getattr
    (setattrfunc)PyavtSimulationCommandSpecification_setattr, // tp_setattr
    (cmpfunc)avtSimulationCommandSpecification_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtSimulationCommandSpecification_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtSimulationCommandSpecification_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtSimulationCommandSpecification *defaultAtts = 0;
static avtSimulationCommandSpecification *currentAtts = 0;

static PyObject *
NewavtSimulationCommandSpecification(int useCurrent)
{
    avtSimulationCommandSpecificationObject *newObject;
    newObject = PyObject_NEW(avtSimulationCommandSpecificationObject, &avtSimulationCommandSpecificationType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtSimulationCommandSpecification(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtSimulationCommandSpecification(*defaultAtts);
    else
        newObject->data = new avtSimulationCommandSpecification;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtSimulationCommandSpecification(const avtSimulationCommandSpecification *attr)
{
    avtSimulationCommandSpecificationObject *newObject;
    newObject = PyObject_NEW(avtSimulationCommandSpecificationObject, &avtSimulationCommandSpecificationType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtSimulationCommandSpecification *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtSimulationCommandSpecification_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtSimulationCommandSpecification(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtSimulationCommandSpecificationMethods[] = {
    {"avtSimulationCommandSpecification", avtSimulationCommandSpecification_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtSimulationCommandSpecificationObserver = 0;

std::string
PyavtSimulationCommandSpecification_GetLogString()
{
    std::string s("avtSimulationCommandSpecification = avtSimulationCommandSpecification()\n");
    if(currentAtts != 0)
        s += PyavtSimulationCommandSpecification_ToString(currentAtts, "avtSimulationCommandSpecification.");
    return s;
}

static void
PyavtSimulationCommandSpecification_CallLogRoutine(Subject *subj, void *data)
{
    avtSimulationCommandSpecification *atts = (avtSimulationCommandSpecification *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtSimulationCommandSpecification = avtSimulationCommandSpecification()\n");
        s += PyavtSimulationCommandSpecification_ToString(currentAtts, "avtSimulationCommandSpecification.");
        cb(s);
    }
}

void
PyavtSimulationCommandSpecification_StartUp(avtSimulationCommandSpecification *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtSimulationCommandSpecification_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtSimulationCommandSpecificationObserver == 0)
    {
        avtSimulationCommandSpecificationObserver = new ObserverToCallback(subj,
            PyavtSimulationCommandSpecification_CallLogRoutine, (void *)data);
    }

}

void
PyavtSimulationCommandSpecification_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtSimulationCommandSpecificationObserver;
    avtSimulationCommandSpecificationObserver = 0;
}

PyMethodDef *
PyavtSimulationCommandSpecification_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtSimulationCommandSpecificationMethods;
}

bool
PyavtSimulationCommandSpecification_Check(PyObject *obj)
{
    return (obj->ob_type == &avtSimulationCommandSpecificationType);
}

avtSimulationCommandSpecification *
PyavtSimulationCommandSpecification_FromPyObject(PyObject *obj)
{
    avtSimulationCommandSpecificationObject *obj2 = (avtSimulationCommandSpecificationObject *)obj;
    return obj2->data;
}

PyObject *
PyavtSimulationCommandSpecification_New()
{
    return NewavtSimulationCommandSpecification(0);
}

PyObject *
PyavtSimulationCommandSpecification_Wrap(const avtSimulationCommandSpecification *attr)
{
    return WrapavtSimulationCommandSpecification(attr);
}

void
PyavtSimulationCommandSpecification_SetParent(PyObject *obj, PyObject *parent)
{
    avtSimulationCommandSpecificationObject *obj2 = (avtSimulationCommandSpecificationObject *)obj;
    obj2->parent = parent;
}

void
PyavtSimulationCommandSpecification_SetDefaults(const avtSimulationCommandSpecification *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtSimulationCommandSpecification(*atts);
}

