/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyQueryOverTimeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyQueryAttributes.h>
#include <PyPickAttributes.h>

// ****************************************************************************
// Module: PyQueryOverTimeAttributes
//
// Purpose: 
//   Attributes for queries over time.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:04:04 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a QueryOverTimeAttributes.
//
struct QueryOverTimeAttributesObject
{
    PyObject_HEAD
    QueryOverTimeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewQueryOverTimeAttributes(int);

std::string
PyQueryOverTimeAttributes_ToString(const QueryOverTimeAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *timeType_names = "Cycle, DTime, Timestep";
    switch (atts->GetTimeType())
    {
      case QueryOverTimeAttributes::Cycle:
          SNPRINTF(tmpStr, 1000, "%stimeType = %sCycle  # %s\n", prefix, prefix, timeType_names);
          str += tmpStr;
          break;
      case QueryOverTimeAttributes::DTime:
          SNPRINTF(tmpStr, 1000, "%stimeType = %sDTime  # %s\n", prefix, prefix, timeType_names);
          str += tmpStr;
          break;
      case QueryOverTimeAttributes::Timestep:
          SNPRINTF(tmpStr, 1000, "%stimeType = %sTimestep  # %s\n", prefix, prefix, timeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetStartTimeFlag())
        SNPRINTF(tmpStr, 1000, "%sstartTimeFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sstartTimeFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstartTime = %d\n", prefix, atts->GetStartTime());
    str += tmpStr;
    if(atts->GetEndTimeFlag())
        SNPRINTF(tmpStr, 1000, "%sendTimeFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sendTimeFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sendTime = %d\n", prefix, atts->GetEndTime());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    if(atts->GetCreateWindow())
        SNPRINTF(tmpStr, 1000, "%screateWindow = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateWindow = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swindowId = %d\n", prefix, atts->GetWindowId());
    str += tmpStr;
    return str;
}

static PyObject *
QueryOverTimeAttributes_Notify(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetTimeType(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTimeType(QueryOverTimeAttributes::TimeType(ival));
    else
    {
        fprintf(stderr, "An invalid timeType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cycle, DTime, Timestep.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetTimeType(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeType()));
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetStartTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTimeFlag in the object.
    obj->data->SetStartTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetStartTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStartTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetStartTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startTime in the object.
    obj->data->SetStartTime((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetStartTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartTime()));
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetEndTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endTimeFlag in the object.
    obj->data->SetEndTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetEndTimeFlag(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEndTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetEndTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endTime in the object.
    obj->data->SetEndTime((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetEndTime(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetEndTime()));
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetStride(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetStride(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetCreateWindow(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createWindow in the object.
    obj->data->SetCreateWindow(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetCreateWindow(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateWindow()?1L:0L);
    return retval;
}

/*static*/ PyObject *
QueryOverTimeAttributes_SetWindowId(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowId in the object.
    obj->data->SetWindowId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryOverTimeAttributes_GetWindowId(PyObject *self, PyObject *args)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWindowId()));
    return retval;
}



static struct PyMethodDef QueryOverTimeAttributes_methods[] = {
    {"Notify", QueryOverTimeAttributes_Notify, METH_VARARGS},
    {"SetTimeType", QueryOverTimeAttributes_SetTimeType, METH_VARARGS},
    {"GetTimeType", QueryOverTimeAttributes_GetTimeType, METH_VARARGS},
    {"SetStartTimeFlag", QueryOverTimeAttributes_SetStartTimeFlag, METH_VARARGS},
    {"GetStartTimeFlag", QueryOverTimeAttributes_GetStartTimeFlag, METH_VARARGS},
    {"SetStartTime", QueryOverTimeAttributes_SetStartTime, METH_VARARGS},
    {"GetStartTime", QueryOverTimeAttributes_GetStartTime, METH_VARARGS},
    {"SetEndTimeFlag", QueryOverTimeAttributes_SetEndTimeFlag, METH_VARARGS},
    {"GetEndTimeFlag", QueryOverTimeAttributes_GetEndTimeFlag, METH_VARARGS},
    {"SetEndTime", QueryOverTimeAttributes_SetEndTime, METH_VARARGS},
    {"GetEndTime", QueryOverTimeAttributes_GetEndTime, METH_VARARGS},
    {"SetStride", QueryOverTimeAttributes_SetStride, METH_VARARGS},
    {"GetStride", QueryOverTimeAttributes_GetStride, METH_VARARGS},
    {"SetCreateWindow", QueryOverTimeAttributes_SetCreateWindow, METH_VARARGS},
    {"GetCreateWindow", QueryOverTimeAttributes_GetCreateWindow, METH_VARARGS},
    {"SetWindowId", QueryOverTimeAttributes_SetWindowId, METH_VARARGS},
    {"GetWindowId", QueryOverTimeAttributes_GetWindowId, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
QueryOverTimeAttributes_dealloc(PyObject *v)
{
   QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
QueryOverTimeAttributes_compare(PyObject *v, PyObject *w)
{
    QueryOverTimeAttributes *a = ((QueryOverTimeAttributesObject *)v)->data;
    QueryOverTimeAttributes *b = ((QueryOverTimeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
QueryOverTimeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "timeType") == 0)
        return QueryOverTimeAttributes_GetTimeType(self, NULL);
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::Cycle));
    if(strcmp(name, "DTime") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::DTime));
    if(strcmp(name, "Timestep") == 0)
        return PyInt_FromLong(long(QueryOverTimeAttributes::Timestep));

    if(strcmp(name, "startTimeFlag") == 0)
        return QueryOverTimeAttributes_GetStartTimeFlag(self, NULL);
    if(strcmp(name, "startTime") == 0)
        return QueryOverTimeAttributes_GetStartTime(self, NULL);
    if(strcmp(name, "endTimeFlag") == 0)
        return QueryOverTimeAttributes_GetEndTimeFlag(self, NULL);
    if(strcmp(name, "endTime") == 0)
        return QueryOverTimeAttributes_GetEndTime(self, NULL);
    if(strcmp(name, "stride") == 0)
        return QueryOverTimeAttributes_GetStride(self, NULL);
    if(strcmp(name, "createWindow") == 0)
        return QueryOverTimeAttributes_GetCreateWindow(self, NULL);
    if(strcmp(name, "windowId") == 0)
        return QueryOverTimeAttributes_GetWindowId(self, NULL);

    return Py_FindMethod(QueryOverTimeAttributes_methods, self, name);
}

static int
QueryOverTimeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "timeType") == 0)
        obj = QueryOverTimeAttributes_SetTimeType(self, tuple);
    else if(strcmp(name, "startTimeFlag") == 0)
        obj = QueryOverTimeAttributes_SetStartTimeFlag(self, tuple);
    else if(strcmp(name, "startTime") == 0)
        obj = QueryOverTimeAttributes_SetStartTime(self, tuple);
    else if(strcmp(name, "endTimeFlag") == 0)
        obj = QueryOverTimeAttributes_SetEndTimeFlag(self, tuple);
    else if(strcmp(name, "endTime") == 0)
        obj = QueryOverTimeAttributes_SetEndTime(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = QueryOverTimeAttributes_SetStride(self, tuple);
    else if(strcmp(name, "createWindow") == 0)
        obj = QueryOverTimeAttributes_SetCreateWindow(self, tuple);
    else if(strcmp(name, "windowId") == 0)
        obj = QueryOverTimeAttributes_SetWindowId(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
QueryOverTimeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;
    fprintf(fp, "%s", PyQueryOverTimeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
QueryOverTimeAttributes_str(PyObject *v)
{
    QueryOverTimeAttributesObject *obj = (QueryOverTimeAttributesObject *)v;
    return PyString_FromString(PyQueryOverTimeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *QueryOverTimeAttributes_Purpose = "Attributes for queries over time.";
#else
static char *QueryOverTimeAttributes_Purpose = "Attributes for queries over time.";
#endif

//
// The type description structure
//
static PyTypeObject QueryOverTimeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "QueryOverTimeAttributes",                    // tp_name
    sizeof(QueryOverTimeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)QueryOverTimeAttributes_dealloc,  // tp_dealloc
    (printfunc)QueryOverTimeAttributes_print,     // tp_print
    (getattrfunc)QueryOverTimeAttributes_getattr, // tp_getattr
    (setattrfunc)QueryOverTimeAttributes_setattr, // tp_setattr
    (cmpfunc)QueryOverTimeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)QueryOverTimeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    QueryOverTimeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static QueryOverTimeAttributes *defaultAtts = 0;
static QueryOverTimeAttributes *currentAtts = 0;

static PyObject *
NewQueryOverTimeAttributes(int useCurrent)
{
    QueryOverTimeAttributesObject *newObject;
    newObject = PyObject_NEW(QueryOverTimeAttributesObject, &QueryOverTimeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new QueryOverTimeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new QueryOverTimeAttributes(*defaultAtts);
    else
        newObject->data = new QueryOverTimeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapQueryOverTimeAttributes(const QueryOverTimeAttributes *attr)
{
    QueryOverTimeAttributesObject *newObject;
    newObject = PyObject_NEW(QueryOverTimeAttributesObject, &QueryOverTimeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (QueryOverTimeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
QueryOverTimeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewQueryOverTimeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef QueryOverTimeAttributesMethods[] = {
    {"QueryOverTimeAttributes", QueryOverTimeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *QueryOverTimeAttributesObserver = 0;

std::string
PyQueryOverTimeAttributes_GetLogString()
{
    std::string s("QueryOverTimeAtts = QueryOverTimeAttributes()\n");
    if(currentAtts != 0)
        s += PyQueryOverTimeAttributes_ToString(currentAtts, "QueryOverTimeAtts.");
    return s;
}

static void
PyQueryOverTimeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    QueryOverTimeAttributes *atts = (QueryOverTimeAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("QueryOverTimeAtts = QueryOverTimeAttributes()\n");
        s += PyQueryOverTimeAttributes_ToString(currentAtts, "QueryOverTimeAtts.");
        cb(s);
    }
}

void
PyQueryOverTimeAttributes_StartUp(QueryOverTimeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyQueryOverTimeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(QueryOverTimeAttributesObserver == 0)
    {
        QueryOverTimeAttributesObserver = new ObserverToCallback(subj,
            PyQueryOverTimeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyQueryOverTimeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete QueryOverTimeAttributesObserver;
    QueryOverTimeAttributesObserver = 0;
}

PyMethodDef *
PyQueryOverTimeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return QueryOverTimeAttributesMethods;
}

bool
PyQueryOverTimeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &QueryOverTimeAttributesType);
}

QueryOverTimeAttributes *
PyQueryOverTimeAttributes_FromPyObject(PyObject *obj)
{
    QueryOverTimeAttributesObject *obj2 = (QueryOverTimeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyQueryOverTimeAttributes_New()
{
    return NewQueryOverTimeAttributes(0);
}

PyObject *
PyQueryOverTimeAttributes_Wrap(const QueryOverTimeAttributes *attr)
{
    return WrapQueryOverTimeAttributes(attr);
}

void
PyQueryOverTimeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    QueryOverTimeAttributesObject *obj2 = (QueryOverTimeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyQueryOverTimeAttributes_SetDefaults(const QueryOverTimeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new QueryOverTimeAttributes(*atts);
}

