/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyQueryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyQueryAttributes
//
// Purpose: 
//   This class contains attributes used for query.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:04:06 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a QueryAttributes.
//
struct QueryAttributesObject
{
    PyObject_HEAD
    QueryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewQueryAttributes(int);

std::string
PyQueryAttributes_ToString(const QueryAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    {   const stringVector &variables = atts->GetVariables();
        SNPRINTF(tmpStr, 1000, "%svariables = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < variables.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", variables[i].c_str());
            str += tmpStr;
            if(i < variables.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sresultsMessage = \"%s\"\n", prefix, atts->GetResultsMessage().c_str());
    str += tmpStr;
    {   const double *worldPoint = atts->GetWorldPoint();
        SNPRINTF(tmpStr, 1000, "%sworldPoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", worldPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sdomain = %d\n", prefix, atts->GetDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%selement = %d\n", prefix, atts->GetElement());
    str += tmpStr;
    {   const doubleVector &resultsValue = atts->GetResultsValue();
        SNPRINTF(tmpStr, 1000, "%sresultsValue = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < resultsValue.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", resultsValue[i]);
            str += tmpStr;
            if(i < resultsValue.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *elementType_names = "Zone, Node";
    switch (atts->GetElementType())
    {
      case QueryAttributes::Zone:
          SNPRINTF(tmpStr, 1000, "%selementType = %sZone  # %s\n", prefix, prefix, elementType_names);
          str += tmpStr;
          break;
      case QueryAttributes::Node:
          SNPRINTF(tmpStr, 1000, "%selementType = %sNode  # %s\n", prefix, prefix, elementType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%stimeStep = %d\n", prefix, atts->GetTimeStep());
    str += tmpStr;
    if(atts->GetUseGlobalId())
        SNPRINTF(tmpStr, 1000, "%suseGlobalId = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseGlobalId = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxUnits = \"%s\"\n", prefix, atts->GetXUnits().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syUnits = \"%s\"\n", prefix, atts->GetYUnits().c_str());
    str += tmpStr;
    {   const doubleVector &darg1 = atts->GetDarg1();
        SNPRINTF(tmpStr, 1000, "%sdarg1 = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < darg1.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", darg1[i]);
            str += tmpStr;
            if(i < darg1.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &darg2 = atts->GetDarg2();
        SNPRINTF(tmpStr, 1000, "%sdarg2 = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < darg2.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", darg2[i]);
            str += tmpStr;
            if(i < darg2.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sfloatFormat = \"%s\"\n", prefix, atts->GetFloatFormat().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxmlResult = \"%s\"\n", prefix, atts->GetXmlResult().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
QueryAttributes_Notify(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_SetName(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetName(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetVariables(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    stringVector  &vec = obj->data->GetVariables();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the variables in the object as modified.
    obj->data->SelectVariables();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetVariables(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the variables.
    const stringVector &variables = obj->data->GetVariables();
    PyObject *retval = PyTuple_New(variables.size());
    for(size_t i = 0; i < variables.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(variables[i].c_str()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetResultsMessage(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the resultsMessage in the object.
    obj->data->SetResultsMessage(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetResultsMessage(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetResultsMessage().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetWorldPoint(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    double *dvals = obj->data->GetWorldPoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the worldPoint in the object as modified.
    obj->data->SelectWorldPoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetWorldPoint(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the worldPoint.
    PyObject *retval = PyTuple_New(3);
    const double *worldPoint = obj->data->GetWorldPoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(worldPoint[i]));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetDomain(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the domain in the object.
    obj->data->SetDomain((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetDomain(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDomain()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetElement(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the element in the object.
    obj->data->SetElement((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetElement(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetElement()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetResultsValue(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    doubleVector  &vec = obj->data->GetResultsValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the resultsValue in the object as modified.
    obj->data->SelectResultsValue();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetResultsValue(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the resultsValue.
    const doubleVector &resultsValue = obj->data->GetResultsValue();
    PyObject *retval = PyTuple_New(resultsValue.size());
    for(size_t i = 0; i < resultsValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(resultsValue[i]));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetElementType(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the elementType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetElementType(QueryAttributes::ElementType(ival));
    else
    {
        fprintf(stderr, "An invalid elementType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Zone, Node.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetElementType(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetElementType()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetTimeStep(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStep in the object.
    obj->data->SetTimeStep((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetTimeStep(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStep()));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetUseGlobalId(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useGlobalId in the object.
    obj->data->SetUseGlobalId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetUseGlobalId(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseGlobalId()?1L:0L);
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetXUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xUnits in the object.
    obj->data->SetXUnits(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetXUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXUnits().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetYUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yUnits in the object.
    obj->data->SetYUnits(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetYUnits(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetYUnits().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetDarg1(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDarg1();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the darg1 in the object as modified.
    obj->data->SelectDarg1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetDarg1(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the darg1.
    const doubleVector &darg1 = obj->data->GetDarg1();
    PyObject *retval = PyTuple_New(darg1.size());
    for(size_t i = 0; i < darg1.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(darg1[i]));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetDarg2(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    doubleVector  &vec = obj->data->GetDarg2();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the darg2 in the object as modified.
    obj->data->SelectDarg2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetDarg2(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the darg2.
    const doubleVector &darg2 = obj->data->GetDarg2();
    PyObject *retval = PyTuple_New(darg2.size());
    for(size_t i = 0; i < darg2.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(darg2[i]));
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetFloatFormat(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the floatFormat in the object.
    obj->data->SetFloatFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetFloatFormat(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFloatFormat().c_str());
    return retval;
}

/*static*/ PyObject *
QueryAttributes_SetXmlResult(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the xmlResult in the object.
    obj->data->SetXmlResult(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
QueryAttributes_GetXmlResult(PyObject *self, PyObject *args)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetXmlResult().c_str());
    return retval;
}



static struct PyMethodDef QueryAttributes_methods[] = {
    {"Notify", QueryAttributes_Notify, METH_VARARGS},
    {"SetName", QueryAttributes_SetName, METH_VARARGS},
    {"GetName", QueryAttributes_GetName, METH_VARARGS},
    {"SetVariables", QueryAttributes_SetVariables, METH_VARARGS},
    {"GetVariables", QueryAttributes_GetVariables, METH_VARARGS},
    {"SetResultsMessage", QueryAttributes_SetResultsMessage, METH_VARARGS},
    {"GetResultsMessage", QueryAttributes_GetResultsMessage, METH_VARARGS},
    {"SetWorldPoint", QueryAttributes_SetWorldPoint, METH_VARARGS},
    {"GetWorldPoint", QueryAttributes_GetWorldPoint, METH_VARARGS},
    {"SetDomain", QueryAttributes_SetDomain, METH_VARARGS},
    {"GetDomain", QueryAttributes_GetDomain, METH_VARARGS},
    {"SetElement", QueryAttributes_SetElement, METH_VARARGS},
    {"GetElement", QueryAttributes_GetElement, METH_VARARGS},
    {"SetResultsValue", QueryAttributes_SetResultsValue, METH_VARARGS},
    {"GetResultsValue", QueryAttributes_GetResultsValue, METH_VARARGS},
    {"SetElementType", QueryAttributes_SetElementType, METH_VARARGS},
    {"GetElementType", QueryAttributes_GetElementType, METH_VARARGS},
    {"SetTimeStep", QueryAttributes_SetTimeStep, METH_VARARGS},
    {"GetTimeStep", QueryAttributes_GetTimeStep, METH_VARARGS},
    {"SetUseGlobalId", QueryAttributes_SetUseGlobalId, METH_VARARGS},
    {"GetUseGlobalId", QueryAttributes_GetUseGlobalId, METH_VARARGS},
    {"SetXUnits", QueryAttributes_SetXUnits, METH_VARARGS},
    {"GetXUnits", QueryAttributes_GetXUnits, METH_VARARGS},
    {"SetYUnits", QueryAttributes_SetYUnits, METH_VARARGS},
    {"GetYUnits", QueryAttributes_GetYUnits, METH_VARARGS},
    {"SetDarg1", QueryAttributes_SetDarg1, METH_VARARGS},
    {"GetDarg1", QueryAttributes_GetDarg1, METH_VARARGS},
    {"SetDarg2", QueryAttributes_SetDarg2, METH_VARARGS},
    {"GetDarg2", QueryAttributes_GetDarg2, METH_VARARGS},
    {"SetFloatFormat", QueryAttributes_SetFloatFormat, METH_VARARGS},
    {"GetFloatFormat", QueryAttributes_GetFloatFormat, METH_VARARGS},
    {"SetXmlResult", QueryAttributes_SetXmlResult, METH_VARARGS},
    {"GetXmlResult", QueryAttributes_GetXmlResult, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
QueryAttributes_dealloc(PyObject *v)
{
   QueryAttributesObject *obj = (QueryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
QueryAttributes_compare(PyObject *v, PyObject *w)
{
    QueryAttributes *a = ((QueryAttributesObject *)v)->data;
    QueryAttributes *b = ((QueryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
QueryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return QueryAttributes_GetName(self, NULL);
    if(strcmp(name, "variables") == 0)
        return QueryAttributes_GetVariables(self, NULL);
    if(strcmp(name, "resultsMessage") == 0)
        return QueryAttributes_GetResultsMessage(self, NULL);
    if(strcmp(name, "worldPoint") == 0)
        return QueryAttributes_GetWorldPoint(self, NULL);
    if(strcmp(name, "domain") == 0)
        return QueryAttributes_GetDomain(self, NULL);
    if(strcmp(name, "element") == 0)
        return QueryAttributes_GetElement(self, NULL);
    if(strcmp(name, "resultsValue") == 0)
        return QueryAttributes_GetResultsValue(self, NULL);
    if(strcmp(name, "elementType") == 0)
        return QueryAttributes_GetElementType(self, NULL);
    if(strcmp(name, "Zone") == 0)
        return PyInt_FromLong(long(QueryAttributes::Zone));
    if(strcmp(name, "Node") == 0)
        return PyInt_FromLong(long(QueryAttributes::Node));

    if(strcmp(name, "timeStep") == 0)
        return QueryAttributes_GetTimeStep(self, NULL);
    if(strcmp(name, "useGlobalId") == 0)
        return QueryAttributes_GetUseGlobalId(self, NULL);
    if(strcmp(name, "xUnits") == 0)
        return QueryAttributes_GetXUnits(self, NULL);
    if(strcmp(name, "yUnits") == 0)
        return QueryAttributes_GetYUnits(self, NULL);
    if(strcmp(name, "darg1") == 0)
        return QueryAttributes_GetDarg1(self, NULL);
    if(strcmp(name, "darg2") == 0)
        return QueryAttributes_GetDarg2(self, NULL);
    if(strcmp(name, "floatFormat") == 0)
        return QueryAttributes_GetFloatFormat(self, NULL);
    if(strcmp(name, "xmlResult") == 0)
        return QueryAttributes_GetXmlResult(self, NULL);

    return Py_FindMethod(QueryAttributes_methods, self, name);
}

static int
QueryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = QueryAttributes_SetName(self, tuple);
    else if(strcmp(name, "variables") == 0)
        obj = QueryAttributes_SetVariables(self, tuple);
    else if(strcmp(name, "resultsMessage") == 0)
        obj = QueryAttributes_SetResultsMessage(self, tuple);
    else if(strcmp(name, "worldPoint") == 0)
        obj = QueryAttributes_SetWorldPoint(self, tuple);
    else if(strcmp(name, "domain") == 0)
        obj = QueryAttributes_SetDomain(self, tuple);
    else if(strcmp(name, "element") == 0)
        obj = QueryAttributes_SetElement(self, tuple);
    else if(strcmp(name, "resultsValue") == 0)
        obj = QueryAttributes_SetResultsValue(self, tuple);
    else if(strcmp(name, "elementType") == 0)
        obj = QueryAttributes_SetElementType(self, tuple);
    else if(strcmp(name, "timeStep") == 0)
        obj = QueryAttributes_SetTimeStep(self, tuple);
    else if(strcmp(name, "useGlobalId") == 0)
        obj = QueryAttributes_SetUseGlobalId(self, tuple);
    else if(strcmp(name, "xUnits") == 0)
        obj = QueryAttributes_SetXUnits(self, tuple);
    else if(strcmp(name, "yUnits") == 0)
        obj = QueryAttributes_SetYUnits(self, tuple);
    else if(strcmp(name, "darg1") == 0)
        obj = QueryAttributes_SetDarg1(self, tuple);
    else if(strcmp(name, "darg2") == 0)
        obj = QueryAttributes_SetDarg2(self, tuple);
    else if(strcmp(name, "floatFormat") == 0)
        obj = QueryAttributes_SetFloatFormat(self, tuple);
    else if(strcmp(name, "xmlResult") == 0)
        obj = QueryAttributes_SetXmlResult(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
QueryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)v;
    fprintf(fp, "%s", PyQueryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
QueryAttributes_str(PyObject *v)
{
    QueryAttributesObject *obj = (QueryAttributesObject *)v;
    return PyString_FromString(PyQueryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *QueryAttributes_Purpose = "This class contains attributes used for query.";
#else
static char *QueryAttributes_Purpose = "This class contains attributes used for query.";
#endif

//
// The type description structure
//
static PyTypeObject QueryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "QueryAttributes",                    // tp_name
    sizeof(QueryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)QueryAttributes_dealloc,  // tp_dealloc
    (printfunc)QueryAttributes_print,     // tp_print
    (getattrfunc)QueryAttributes_getattr, // tp_getattr
    (setattrfunc)QueryAttributes_setattr, // tp_setattr
    (cmpfunc)QueryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)QueryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    QueryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static QueryAttributes *defaultAtts = 0;
static QueryAttributes *currentAtts = 0;

static PyObject *
NewQueryAttributes(int useCurrent)
{
    QueryAttributesObject *newObject;
    newObject = PyObject_NEW(QueryAttributesObject, &QueryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new QueryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new QueryAttributes(*defaultAtts);
    else
        newObject->data = new QueryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapQueryAttributes(const QueryAttributes *attr)
{
    QueryAttributesObject *newObject;
    newObject = PyObject_NEW(QueryAttributesObject, &QueryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (QueryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
QueryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewQueryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef QueryAttributesMethods[] = {
    {"QueryAttributes", QueryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *QueryAttributesObserver = 0;

std::string
PyQueryAttributes_GetLogString()
{
    std::string s("QueryAtts = QueryAttributes()\n");
    if(currentAtts != 0)
        s += PyQueryAttributes_ToString(currentAtts, "QueryAtts.");
    return s;
}

static void
PyQueryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    QueryAttributes *atts = (QueryAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("QueryAtts = QueryAttributes()\n");
        s += PyQueryAttributes_ToString(currentAtts, "QueryAtts.");
        cb(s);
    }
}

void
PyQueryAttributes_StartUp(QueryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyQueryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(QueryAttributesObserver == 0)
    {
        QueryAttributesObserver = new ObserverToCallback(subj,
            PyQueryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyQueryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete QueryAttributesObserver;
    QueryAttributesObserver = 0;
}

PyMethodDef *
PyQueryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return QueryAttributesMethods;
}

bool
PyQueryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &QueryAttributesType);
}

QueryAttributes *
PyQueryAttributes_FromPyObject(PyObject *obj)
{
    QueryAttributesObject *obj2 = (QueryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyQueryAttributes_New()
{
    return NewQueryAttributes(0);
}

PyObject *
PyQueryAttributes_Wrap(const QueryAttributes *attr)
{
    return WrapQueryAttributes(attr);
}

void
PyQueryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    QueryAttributesObject *obj2 = (QueryAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyQueryAttributes_SetDefaults(const QueryAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new QueryAttributes(*atts);
}

