/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPrinterAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyPrinterAttributes
//
// Purpose: 
//   This class contains the attributes used for controlling printers.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:04:02 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a PrinterAttributes.
//
struct PrinterAttributesObject
{
    PyObject_HEAD
    PrinterAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPrinterAttributes(int);

std::string
PyPrinterAttributes_ToString(const PrinterAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sprinterName = \"%s\"\n", prefix, atts->GetPrinterName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sprintProgram = \"%s\"\n", prefix, atts->GetPrintProgram().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdocumentName = \"%s\"\n", prefix, atts->GetDocumentName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%screator = \"%s\"\n", prefix, atts->GetCreator().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumCopies = %d\n", prefix, atts->GetNumCopies());
    str += tmpStr;
    if(atts->GetPortrait())
        SNPRINTF(tmpStr, 1000, "%sportrait = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sportrait = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPrintColor())
        SNPRINTF(tmpStr, 1000, "%sprintColor = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sprintColor = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOutputToFile())
        SNPRINTF(tmpStr, 1000, "%soutputToFile = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soutputToFile = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soutputToFileName = \"%s\"\n", prefix, atts->GetOutputToFileName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spageSize = %d\n", prefix, atts->GetPageSize());
    str += tmpStr;
    return str;
}

static PyObject *
PrinterAttributes_Notify(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_SetPrinterName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the printerName in the object.
    obj->data->SetPrinterName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetPrinterName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPrinterName().c_str());
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetPrintProgram(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the printProgram in the object.
    obj->data->SetPrintProgram(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetPrintProgram(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPrintProgram().c_str());
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetDocumentName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the documentName in the object.
    obj->data->SetDocumentName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetDocumentName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDocumentName().c_str());
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetCreator(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the creator in the object.
    obj->data->SetCreator(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetCreator(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCreator().c_str());
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetNumCopies(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numCopies in the object.
    obj->data->SetNumCopies((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetNumCopies(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumCopies()));
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetPortrait(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the portrait in the object.
    obj->data->SetPortrait(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetPortrait(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPortrait()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetPrintColor(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the printColor in the object.
    obj->data->SetPrintColor(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetPrintColor(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPrintColor()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetOutputToFile(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputToFile in the object.
    obj->data->SetOutputToFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetOutputToFile(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOutputToFile()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetOutputToFileName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outputToFileName in the object.
    obj->data->SetOutputToFileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetOutputToFileName(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutputToFileName().c_str());
    return retval;
}

/*static*/ PyObject *
PrinterAttributes_SetPageSize(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pageSize in the object.
    obj->data->SetPageSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PrinterAttributes_GetPageSize(PyObject *self, PyObject *args)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPageSize()));
    return retval;
}



static struct PyMethodDef PrinterAttributes_methods[] = {
    {"Notify", PrinterAttributes_Notify, METH_VARARGS},
    {"SetPrinterName", PrinterAttributes_SetPrinterName, METH_VARARGS},
    {"GetPrinterName", PrinterAttributes_GetPrinterName, METH_VARARGS},
    {"SetPrintProgram", PrinterAttributes_SetPrintProgram, METH_VARARGS},
    {"GetPrintProgram", PrinterAttributes_GetPrintProgram, METH_VARARGS},
    {"SetDocumentName", PrinterAttributes_SetDocumentName, METH_VARARGS},
    {"GetDocumentName", PrinterAttributes_GetDocumentName, METH_VARARGS},
    {"SetCreator", PrinterAttributes_SetCreator, METH_VARARGS},
    {"GetCreator", PrinterAttributes_GetCreator, METH_VARARGS},
    {"SetNumCopies", PrinterAttributes_SetNumCopies, METH_VARARGS},
    {"GetNumCopies", PrinterAttributes_GetNumCopies, METH_VARARGS},
    {"SetPortrait", PrinterAttributes_SetPortrait, METH_VARARGS},
    {"GetPortrait", PrinterAttributes_GetPortrait, METH_VARARGS},
    {"SetPrintColor", PrinterAttributes_SetPrintColor, METH_VARARGS},
    {"GetPrintColor", PrinterAttributes_GetPrintColor, METH_VARARGS},
    {"SetOutputToFile", PrinterAttributes_SetOutputToFile, METH_VARARGS},
    {"GetOutputToFile", PrinterAttributes_GetOutputToFile, METH_VARARGS},
    {"SetOutputToFileName", PrinterAttributes_SetOutputToFileName, METH_VARARGS},
    {"GetOutputToFileName", PrinterAttributes_GetOutputToFileName, METH_VARARGS},
    {"SetPageSize", PrinterAttributes_SetPageSize, METH_VARARGS},
    {"GetPageSize", PrinterAttributes_GetPageSize, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PrinterAttributes_dealloc(PyObject *v)
{
   PrinterAttributesObject *obj = (PrinterAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PrinterAttributes_compare(PyObject *v, PyObject *w)
{
    PrinterAttributes *a = ((PrinterAttributesObject *)v)->data;
    PrinterAttributes *b = ((PrinterAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PrinterAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "printerName") == 0)
        return PrinterAttributes_GetPrinterName(self, NULL);
    if(strcmp(name, "printProgram") == 0)
        return PrinterAttributes_GetPrintProgram(self, NULL);
    if(strcmp(name, "documentName") == 0)
        return PrinterAttributes_GetDocumentName(self, NULL);
    if(strcmp(name, "creator") == 0)
        return PrinterAttributes_GetCreator(self, NULL);
    if(strcmp(name, "numCopies") == 0)
        return PrinterAttributes_GetNumCopies(self, NULL);
    if(strcmp(name, "portrait") == 0)
        return PrinterAttributes_GetPortrait(self, NULL);
    if(strcmp(name, "printColor") == 0)
        return PrinterAttributes_GetPrintColor(self, NULL);
    if(strcmp(name, "outputToFile") == 0)
        return PrinterAttributes_GetOutputToFile(self, NULL);
    if(strcmp(name, "outputToFileName") == 0)
        return PrinterAttributes_GetOutputToFileName(self, NULL);
    if(strcmp(name, "pageSize") == 0)
        return PrinterAttributes_GetPageSize(self, NULL);

    return Py_FindMethod(PrinterAttributes_methods, self, name);
}

static int
PrinterAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "printerName") == 0)
        obj = PrinterAttributes_SetPrinterName(self, tuple);
    else if(strcmp(name, "printProgram") == 0)
        obj = PrinterAttributes_SetPrintProgram(self, tuple);
    else if(strcmp(name, "documentName") == 0)
        obj = PrinterAttributes_SetDocumentName(self, tuple);
    else if(strcmp(name, "creator") == 0)
        obj = PrinterAttributes_SetCreator(self, tuple);
    else if(strcmp(name, "numCopies") == 0)
        obj = PrinterAttributes_SetNumCopies(self, tuple);
    else if(strcmp(name, "portrait") == 0)
        obj = PrinterAttributes_SetPortrait(self, tuple);
    else if(strcmp(name, "printColor") == 0)
        obj = PrinterAttributes_SetPrintColor(self, tuple);
    else if(strcmp(name, "outputToFile") == 0)
        obj = PrinterAttributes_SetOutputToFile(self, tuple);
    else if(strcmp(name, "outputToFileName") == 0)
        obj = PrinterAttributes_SetOutputToFileName(self, tuple);
    else if(strcmp(name, "pageSize") == 0)
        obj = PrinterAttributes_SetPageSize(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
PrinterAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)v;
    fprintf(fp, "%s", PyPrinterAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PrinterAttributes_str(PyObject *v)
{
    PrinterAttributesObject *obj = (PrinterAttributesObject *)v;
    return PyString_FromString(PyPrinterAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PrinterAttributes_Purpose = "This class contains the attributes used for controlling printers.";
#else
static char *PrinterAttributes_Purpose = "This class contains the attributes used for controlling printers.";
#endif

//
// The type description structure
//
static PyTypeObject PrinterAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PrinterAttributes",                    // tp_name
    sizeof(PrinterAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PrinterAttributes_dealloc,  // tp_dealloc
    (printfunc)PrinterAttributes_print,     // tp_print
    (getattrfunc)PrinterAttributes_getattr, // tp_getattr
    (setattrfunc)PrinterAttributes_setattr, // tp_setattr
    (cmpfunc)PrinterAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PrinterAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PrinterAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PrinterAttributes *defaultAtts = 0;
static PrinterAttributes *currentAtts = 0;

static PyObject *
NewPrinterAttributes(int useCurrent)
{
    PrinterAttributesObject *newObject;
    newObject = PyObject_NEW(PrinterAttributesObject, &PrinterAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PrinterAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PrinterAttributes(*defaultAtts);
    else
        newObject->data = new PrinterAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPrinterAttributes(const PrinterAttributes *attr)
{
    PrinterAttributesObject *newObject;
    newObject = PyObject_NEW(PrinterAttributesObject, &PrinterAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PrinterAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PrinterAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPrinterAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PrinterAttributesMethods[] = {
    {"PrinterAttributes", PrinterAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PrinterAttributesObserver = 0;

std::string
PyPrinterAttributes_GetLogString()
{
    std::string s("PrinterAtts = PrinterAttributes()\n");
    if(currentAtts != 0)
        s += PyPrinterAttributes_ToString(currentAtts, "PrinterAtts.");
    return s;
}

static void
PyPrinterAttributes_CallLogRoutine(Subject *subj, void *data)
{
    PrinterAttributes *atts = (PrinterAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PrinterAtts = PrinterAttributes()\n");
        s += PyPrinterAttributes_ToString(currentAtts, "PrinterAtts.");
        cb(s);
    }
}

void
PyPrinterAttributes_StartUp(PrinterAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPrinterAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PrinterAttributesObserver == 0)
    {
        PrinterAttributesObserver = new ObserverToCallback(subj,
            PyPrinterAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPrinterAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PrinterAttributesObserver;
    PrinterAttributesObserver = 0;
}

PyMethodDef *
PyPrinterAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PrinterAttributesMethods;
}

bool
PyPrinterAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PrinterAttributesType);
}

PrinterAttributes *
PyPrinterAttributes_FromPyObject(PyObject *obj)
{
    PrinterAttributesObject *obj2 = (PrinterAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPrinterAttributes_New()
{
    return NewPrinterAttributes(0);
}

PyObject *
PyPrinterAttributes_Wrap(const PrinterAttributes *attr)
{
    return WrapPrinterAttributes(attr);
}

void
PyPrinterAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PrinterAttributesObject *obj2 = (PrinterAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPrinterAttributes_SetDefaults(const PrinterAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PrinterAttributes(*atts);
}

