/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPickVarInfo.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyPickVarInfo
//
// Purpose: 
//   This class contains PickVarInfo.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:47 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a PickVarInfo.
//
struct PickVarInfoObject
{
    PyObject_HEAD
    PickVarInfo *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPickVarInfo(int);

std::string
PyPickVarInfo_ToString(const PickVarInfo *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%svariableName = \"%s\"\n", prefix, atts->GetVariableName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svariableType = \"%s\"\n", prefix, atts->GetVariableType().c_str());
    str += tmpStr;
    {   const stringVector &names = atts->GetNames();
        SNPRINTF(tmpStr, 1000, "%snames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < names.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", names[i].c_str());
            str += tmpStr;
            if(i < names.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &values = atts->GetValues();
        SNPRINTF(tmpStr, 1000, "%svalues = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < values.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", values[i]);
            str += tmpStr;
            if(i < values.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &mixNames = atts->GetMixNames();
        SNPRINTF(tmpStr, 1000, "%smixNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < mixNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", mixNames[i].c_str());
            str += tmpStr;
            if(i < mixNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &mixValues = atts->GetMixValues();
        SNPRINTF(tmpStr, 1000, "%smixValues = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < mixValues.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", mixValues[i]);
            str += tmpStr;
            if(i < mixValues.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetMixVar())
        SNPRINTF(tmpStr, 1000, "%smixVar = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smixVar = 0\n", prefix);
    str += tmpStr;
    const char *centering_names = "Nodal, Zonal, None";
    switch (atts->GetCentering())
    {
      case PickVarInfo::Nodal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNodal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PickVarInfo::Zonal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sZonal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PickVarInfo::None:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNone  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smiscMessage = \"%s\"\n", prefix, atts->GetMiscMessage().c_str());
    str += tmpStr;
    {   const intVector &numMatsPerZone = atts->GetNumMatsPerZone();
        SNPRINTF(tmpStr, 1000, "%snumMatsPerZone = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numMatsPerZone.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numMatsPerZone[i]);
            str += tmpStr;
            if(i < numMatsPerZone.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &matNames = atts->GetMatNames();
        SNPRINTF(tmpStr, 1000, "%smatNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < matNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", matNames[i].c_str());
            str += tmpStr;
            if(i < matNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &numSpecsPerMat = atts->GetNumSpecsPerMat();
        SNPRINTF(tmpStr, 1000, "%snumSpecsPerMat = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numSpecsPerMat.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numSpecsPerMat[i]);
            str += tmpStr;
            if(i < numSpecsPerMat.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sfloatFormat = \"%s\"\n", prefix, atts->GetFloatFormat().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
PickVarInfo_Notify(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_SetVariableName(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variableName in the object.
    obj->data->SetVariableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetVariableName(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariableName().c_str());
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetVariableType(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variableType in the object.
    obj->data->SetVariableType(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetVariableType(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariableType().c_str());
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    stringVector  &vec = obj->data->GetNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the names in the object as modified.
    obj->data->SelectNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the names.
    const stringVector &names = obj->data->GetNames();
    PyObject *retval = PyTuple_New(names.size());
    for(size_t i = 0; i < names.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(names[i].c_str()));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetValues(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    doubleVector  &vec = obj->data->GetValues();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the values in the object as modified.
    obj->data->SelectValues();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetValues(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the values.
    const doubleVector &values = obj->data->GetValues();
    PyObject *retval = PyTuple_New(values.size());
    for(size_t i = 0; i < values.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(values[i]));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetMixNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    stringVector  &vec = obj->data->GetMixNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the mixNames in the object as modified.
    obj->data->SelectMixNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetMixNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the mixNames.
    const stringVector &mixNames = obj->data->GetMixNames();
    PyObject *retval = PyTuple_New(mixNames.size());
    for(size_t i = 0; i < mixNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(mixNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetMixValues(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    doubleVector  &vec = obj->data->GetMixValues();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the mixValues in the object as modified.
    obj->data->SelectMixValues();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetMixValues(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the mixValues.
    const doubleVector &mixValues = obj->data->GetMixValues();
    PyObject *retval = PyTuple_New(mixValues.size());
    for(size_t i = 0; i < mixValues.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(mixValues[i]));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetMixVar(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the mixVar in the object.
    obj->data->SetMixVar(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetMixVar(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMixVar()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetCentering(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centering in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCentering(PickVarInfo::Centering(ival));
    else
    {
        fprintf(stderr, "An invalid centering value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Nodal, Zonal, None.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetCentering(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCentering()));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetMiscMessage(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the miscMessage in the object.
    obj->data->SetMiscMessage(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetMiscMessage(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMiscMessage().c_str());
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetNumMatsPerZone(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    intVector  &vec = obj->data->GetNumMatsPerZone();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numMatsPerZone in the object as modified.
    obj->data->SelectNumMatsPerZone();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetNumMatsPerZone(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the numMatsPerZone.
    const intVector &numMatsPerZone = obj->data->GetNumMatsPerZone();
    PyObject *retval = PyTuple_New(numMatsPerZone.size());
    for(size_t i = 0; i < numMatsPerZone.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numMatsPerZone[i])));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetMatNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    stringVector  &vec = obj->data->GetMatNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the matNames in the object as modified.
    obj->data->SelectMatNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetMatNames(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the matNames.
    const stringVector &matNames = obj->data->GetMatNames();
    PyObject *retval = PyTuple_New(matNames.size());
    for(size_t i = 0; i < matNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(matNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetNumSpecsPerMat(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    intVector  &vec = obj->data->GetNumSpecsPerMat();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numSpecsPerMat in the object as modified.
    obj->data->SelectNumSpecsPerMat();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetNumSpecsPerMat(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    // Allocate a tuple the with enough entries to hold the numSpecsPerMat.
    const intVector &numSpecsPerMat = obj->data->GetNumSpecsPerMat();
    PyObject *retval = PyTuple_New(numSpecsPerMat.size());
    for(size_t i = 0; i < numSpecsPerMat.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numSpecsPerMat[i])));
    return retval;
}

/*static*/ PyObject *
PickVarInfo_SetFloatFormat(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the floatFormat in the object.
    obj->data->SetFloatFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PickVarInfo_GetFloatFormat(PyObject *self, PyObject *args)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFloatFormat().c_str());
    return retval;
}



static struct PyMethodDef PickVarInfo_methods[] = {
    {"Notify", PickVarInfo_Notify, METH_VARARGS},
    {"SetVariableName", PickVarInfo_SetVariableName, METH_VARARGS},
    {"GetVariableName", PickVarInfo_GetVariableName, METH_VARARGS},
    {"SetVariableType", PickVarInfo_SetVariableType, METH_VARARGS},
    {"GetVariableType", PickVarInfo_GetVariableType, METH_VARARGS},
    {"SetNames", PickVarInfo_SetNames, METH_VARARGS},
    {"GetNames", PickVarInfo_GetNames, METH_VARARGS},
    {"SetValues", PickVarInfo_SetValues, METH_VARARGS},
    {"GetValues", PickVarInfo_GetValues, METH_VARARGS},
    {"SetMixNames", PickVarInfo_SetMixNames, METH_VARARGS},
    {"GetMixNames", PickVarInfo_GetMixNames, METH_VARARGS},
    {"SetMixValues", PickVarInfo_SetMixValues, METH_VARARGS},
    {"GetMixValues", PickVarInfo_GetMixValues, METH_VARARGS},
    {"SetMixVar", PickVarInfo_SetMixVar, METH_VARARGS},
    {"GetMixVar", PickVarInfo_GetMixVar, METH_VARARGS},
    {"SetCentering", PickVarInfo_SetCentering, METH_VARARGS},
    {"GetCentering", PickVarInfo_GetCentering, METH_VARARGS},
    {"SetMiscMessage", PickVarInfo_SetMiscMessage, METH_VARARGS},
    {"GetMiscMessage", PickVarInfo_GetMiscMessage, METH_VARARGS},
    {"SetNumMatsPerZone", PickVarInfo_SetNumMatsPerZone, METH_VARARGS},
    {"GetNumMatsPerZone", PickVarInfo_GetNumMatsPerZone, METH_VARARGS},
    {"SetMatNames", PickVarInfo_SetMatNames, METH_VARARGS},
    {"GetMatNames", PickVarInfo_GetMatNames, METH_VARARGS},
    {"SetNumSpecsPerMat", PickVarInfo_SetNumSpecsPerMat, METH_VARARGS},
    {"GetNumSpecsPerMat", PickVarInfo_GetNumSpecsPerMat, METH_VARARGS},
    {"SetFloatFormat", PickVarInfo_SetFloatFormat, METH_VARARGS},
    {"GetFloatFormat", PickVarInfo_GetFloatFormat, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PickVarInfo_dealloc(PyObject *v)
{
   PickVarInfoObject *obj = (PickVarInfoObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PickVarInfo_compare(PyObject *v, PyObject *w)
{
    PickVarInfo *a = ((PickVarInfoObject *)v)->data;
    PickVarInfo *b = ((PickVarInfoObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PickVarInfo_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "variableName") == 0)
        return PickVarInfo_GetVariableName(self, NULL);
    if(strcmp(name, "variableType") == 0)
        return PickVarInfo_GetVariableType(self, NULL);
    if(strcmp(name, "names") == 0)
        return PickVarInfo_GetNames(self, NULL);
    if(strcmp(name, "values") == 0)
        return PickVarInfo_GetValues(self, NULL);
    if(strcmp(name, "mixNames") == 0)
        return PickVarInfo_GetMixNames(self, NULL);
    if(strcmp(name, "mixValues") == 0)
        return PickVarInfo_GetMixValues(self, NULL);
    if(strcmp(name, "mixVar") == 0)
        return PickVarInfo_GetMixVar(self, NULL);
    if(strcmp(name, "centering") == 0)
        return PickVarInfo_GetCentering(self, NULL);
    if(strcmp(name, "Nodal") == 0)
        return PyInt_FromLong(long(PickVarInfo::Nodal));
    if(strcmp(name, "Zonal") == 0)
        return PyInt_FromLong(long(PickVarInfo::Zonal));
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(PickVarInfo::None));

    if(strcmp(name, "miscMessage") == 0)
        return PickVarInfo_GetMiscMessage(self, NULL);
    if(strcmp(name, "numMatsPerZone") == 0)
        return PickVarInfo_GetNumMatsPerZone(self, NULL);
    if(strcmp(name, "matNames") == 0)
        return PickVarInfo_GetMatNames(self, NULL);
    if(strcmp(name, "numSpecsPerMat") == 0)
        return PickVarInfo_GetNumSpecsPerMat(self, NULL);
    if(strcmp(name, "floatFormat") == 0)
        return PickVarInfo_GetFloatFormat(self, NULL);

    return Py_FindMethod(PickVarInfo_methods, self, name);
}

static int
PickVarInfo_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "variableName") == 0)
        obj = PickVarInfo_SetVariableName(self, tuple);
    else if(strcmp(name, "variableType") == 0)
        obj = PickVarInfo_SetVariableType(self, tuple);
    else if(strcmp(name, "names") == 0)
        obj = PickVarInfo_SetNames(self, tuple);
    else if(strcmp(name, "values") == 0)
        obj = PickVarInfo_SetValues(self, tuple);
    else if(strcmp(name, "mixNames") == 0)
        obj = PickVarInfo_SetMixNames(self, tuple);
    else if(strcmp(name, "mixValues") == 0)
        obj = PickVarInfo_SetMixValues(self, tuple);
    else if(strcmp(name, "mixVar") == 0)
        obj = PickVarInfo_SetMixVar(self, tuple);
    else if(strcmp(name, "centering") == 0)
        obj = PickVarInfo_SetCentering(self, tuple);
    else if(strcmp(name, "miscMessage") == 0)
        obj = PickVarInfo_SetMiscMessage(self, tuple);
    else if(strcmp(name, "numMatsPerZone") == 0)
        obj = PickVarInfo_SetNumMatsPerZone(self, tuple);
    else if(strcmp(name, "matNames") == 0)
        obj = PickVarInfo_SetMatNames(self, tuple);
    else if(strcmp(name, "numSpecsPerMat") == 0)
        obj = PickVarInfo_SetNumSpecsPerMat(self, tuple);
    else if(strcmp(name, "floatFormat") == 0)
        obj = PickVarInfo_SetFloatFormat(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
PickVarInfo_print(PyObject *v, FILE *fp, int flags)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)v;
    fprintf(fp, "%s", PyPickVarInfo_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PickVarInfo_str(PyObject *v)
{
    PickVarInfoObject *obj = (PickVarInfoObject *)v;
    return PyString_FromString(PyPickVarInfo_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PickVarInfo_Purpose = "This class contains PickVarInfo.";
#else
static char *PickVarInfo_Purpose = "This class contains PickVarInfo.";
#endif

//
// The type description structure
//
static PyTypeObject PickVarInfoType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PickVarInfo",                    // tp_name
    sizeof(PickVarInfoObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PickVarInfo_dealloc,  // tp_dealloc
    (printfunc)PickVarInfo_print,     // tp_print
    (getattrfunc)PickVarInfo_getattr, // tp_getattr
    (setattrfunc)PickVarInfo_setattr, // tp_setattr
    (cmpfunc)PickVarInfo_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PickVarInfo_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PickVarInfo_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PickVarInfo *defaultAtts = 0;
static PickVarInfo *currentAtts = 0;

static PyObject *
NewPickVarInfo(int useCurrent)
{
    PickVarInfoObject *newObject;
    newObject = PyObject_NEW(PickVarInfoObject, &PickVarInfoType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PickVarInfo(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PickVarInfo(*defaultAtts);
    else
        newObject->data = new PickVarInfo;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPickVarInfo(const PickVarInfo *attr)
{
    PickVarInfoObject *newObject;
    newObject = PyObject_NEW(PickVarInfoObject, &PickVarInfoType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PickVarInfo *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PickVarInfo_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPickVarInfo(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PickVarInfoMethods[] = {
    {"PickVarInfo", PickVarInfo_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PickVarInfoObserver = 0;

std::string
PyPickVarInfo_GetLogString()
{
    std::string s("PickVarInfo = PickVarInfo()\n");
    if(currentAtts != 0)
        s += PyPickVarInfo_ToString(currentAtts, "PickVarInfo.");
    return s;
}

static void
PyPickVarInfo_CallLogRoutine(Subject *subj, void *data)
{
    PickVarInfo *atts = (PickVarInfo *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PickVarInfo = PickVarInfo()\n");
        s += PyPickVarInfo_ToString(currentAtts, "PickVarInfo.");
        cb(s);
    }
}

void
PyPickVarInfo_StartUp(PickVarInfo *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPickVarInfo_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PickVarInfoObserver == 0)
    {
        PickVarInfoObserver = new ObserverToCallback(subj,
            PyPickVarInfo_CallLogRoutine, (void *)data);
    }

}

void
PyPickVarInfo_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PickVarInfoObserver;
    PickVarInfoObserver = 0;
}

PyMethodDef *
PyPickVarInfo_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PickVarInfoMethods;
}

bool
PyPickVarInfo_Check(PyObject *obj)
{
    return (obj->ob_type == &PickVarInfoType);
}

PickVarInfo *
PyPickVarInfo_FromPyObject(PyObject *obj)
{
    PickVarInfoObject *obj2 = (PickVarInfoObject *)obj;
    return obj2->data;
}

PyObject *
PyPickVarInfo_New()
{
    return NewPickVarInfo(0);
}

PyObject *
PyPickVarInfo_Wrap(const PickVarInfo *attr)
{
    return WrapPickVarInfo(attr);
}

void
PyPickVarInfo_SetParent(PyObject *obj, PyObject *parent)
{
    PickVarInfoObject *obj2 = (PickVarInfoObject *)obj;
    obj2->parent = parent;
}

void
PyPickVarInfo_SetDefaults(const PickVarInfo *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PickVarInfo(*atts);
}

