/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMachineProfile.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyLaunchProfile.h>

// ****************************************************************************
// Module: PyMachineProfile
//
// Purpose: 
//   This class contains information about a host for a remote VisIt engine.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MachineProfile.
//
struct MachineProfileObject
{
    PyObject_HEAD
    MachineProfile *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMachineProfile(int);

std::string
PyMachineProfile_ToString(const MachineProfile *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%shost = \"%s\"\n", prefix, atts->GetHost().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%suserName = \"%s\"\n", prefix, atts->GetUserName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shostAliases = \"%s\"\n", prefix, atts->GetHostAliases().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shostNickname = \"%s\"\n", prefix, atts->GetHostNickname().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdirectory = \"%s\"\n", prefix, atts->GetDirectory().c_str());
    str += tmpStr;
    if(atts->GetShareOneBatchJob())
        SNPRINTF(tmpStr, 1000, "%sshareOneBatchJob = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshareOneBatchJob = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSshPortSpecified())
        SNPRINTF(tmpStr, 1000, "%ssshPortSpecified = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssshPortSpecified = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssshPort = %d\n", prefix, atts->GetSshPort());
    str += tmpStr;
    const char *clientHostDetermination_names = "MachineName, ManuallySpecified, ParsedFromSSHCLIENT";
    switch (atts->GetClientHostDetermination())
    {
      case MachineProfile::MachineName:
          SNPRINTF(tmpStr, 1000, "%sclientHostDetermination = %sMachineName  # %s\n", prefix, prefix, clientHostDetermination_names);
          str += tmpStr;
          break;
      case MachineProfile::ManuallySpecified:
          SNPRINTF(tmpStr, 1000, "%sclientHostDetermination = %sManuallySpecified  # %s\n", prefix, prefix, clientHostDetermination_names);
          str += tmpStr;
          break;
      case MachineProfile::ParsedFromSSHCLIENT:
          SNPRINTF(tmpStr, 1000, "%sclientHostDetermination = %sParsedFromSSHCLIENT  # %s\n", prefix, prefix, clientHostDetermination_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smanualClientHostName = \"%s\"\n", prefix, atts->GetManualClientHostName().c_str());
    str += tmpStr;
    if(atts->GetTunnelSSH())
        SNPRINTF(tmpStr, 1000, "%stunnelSSH = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stunnelSSH = 0\n", prefix);
    str += tmpStr;
    { // new scope
        int index = 0;
        // Create string representation of launchProfiles from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetLaunchProfiles().begin(); pos != atts->GetLaunchProfiles().end(); ++pos, ++index)
        {
            const LaunchProfile *current = (const LaunchProfile *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetLaunchProfiles(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyLaunchProfile_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#launchProfiles does not contain any LaunchProfile objects.\n";
    }
    SNPRINTF(tmpStr, 1000, "%sactiveProfile = %d\n", prefix, atts->GetActiveProfile());
    str += tmpStr;
    return str;
}

static PyObject *
MachineProfile_Notify(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_SetHost(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the host in the object.
    obj->data->SetHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetHost(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHost().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetUserName(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the userName in the object.
    obj->data->SetUserName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetUserName(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetUserName().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetHostAliases(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the hostAliases in the object.
    obj->data->SetHostAliases(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetHostAliases(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHostAliases().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetHostNickname(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the hostNickname in the object.
    obj->data->SetHostNickname(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetHostNickname(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHostNickname().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetDirectory(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the directory in the object.
    obj->data->SetDirectory(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetDirectory(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDirectory().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetShareOneBatchJob(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the shareOneBatchJob in the object.
    obj->data->SetShareOneBatchJob(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetShareOneBatchJob(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShareOneBatchJob()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetSshPortSpecified(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sshPortSpecified in the object.
    obj->data->SetSshPortSpecified(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetSshPortSpecified(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSshPortSpecified()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetSshPort(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sshPort in the object.
    obj->data->SetSshPort((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetSshPort(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSshPort()));
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetClientHostDetermination(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clientHostDetermination in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetClientHostDetermination(MachineProfile::ClientHostDetermination(ival));
    else
    {
        fprintf(stderr, "An invalid clientHostDetermination value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "MachineName, ManuallySpecified, ParsedFromSSHCLIENT.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetClientHostDetermination(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetClientHostDetermination()));
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetManualClientHostName(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the manualClientHostName in the object.
    obj->data->SetManualClientHostName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetManualClientHostName(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetManualClientHostName().c_str());
    return retval;
}

/*static*/ PyObject *
MachineProfile_SetTunnelSSH(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tunnelSSH in the object.
    obj->data->SetTunnelSSH(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetTunnelSSH(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTunnelSSH()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MachineProfile_GetLaunchProfiles(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || index >= obj->data->GetLaunchProfiles().size())
    {
        char msg[200];
        if(obj->data->GetLaunchProfiles().size() == 0)
            SNPRINTF(msg, 200, "The index is invalid because launchProfiles is empty.");
        else
            SNPRINTF(msg, 200, "The index is invalid. Use index values in: [0, %ld).", obj->data->GetLaunchProfiles().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyLaunchProfile_Wrap(&obj->data->GetLaunchProfiles(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyLaunchProfile_SetParent(retval, self);

    return retval;
}

PyObject *
MachineProfile_GetNumLaunchProfiles(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    return PyInt_FromLong((long)obj->data->GetLaunchProfiles().size());
}

PyObject *
MachineProfile_AddLaunchProfiles(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyLaunchProfile_Check(element))
    {
        char msg[400];
        SNPRINTF(msg, 400, "The AddLaunchProfiles method only accepts LaunchProfile objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    LaunchProfile *newData = PyLaunchProfile_FromPyObject(element);
    obj->data->AddLaunchProfiles(*newData);
    obj->data->SelectLaunchProfiles();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MachineProfile_Remove_One_LaunchProfiles(PyObject *self, int index)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveLaunchProfiles() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetLaunchProfiles();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectLaunchProfiles();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
MachineProfile_RemoveLaunchProfiles(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    MachineProfileObject *obj = (MachineProfileObject *)self;
    if(index < 0 || index >= obj->data->GetNumLaunchProfiles())
    {
        PyErr_SetString(PyExc_IndexError, "Index out of range");
        return NULL;
    }

    return MachineProfile_Remove_One_LaunchProfiles(self, index);
}

PyObject *
MachineProfile_ClearLaunchProfiles(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    int n = obj->data->GetNumLaunchProfiles();
    for(int i = 0; i < n; ++i)
    {
        MachineProfile_Remove_One_LaunchProfiles(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_SetActiveProfile(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the activeProfile in the object.
    obj->data->SetActiveProfile((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MachineProfile_GetActiveProfile(PyObject *self, PyObject *args)
{
    MachineProfileObject *obj = (MachineProfileObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetActiveProfile()));
    return retval;
}



PyMethodDef PyMachineProfile_methods[MACHINEPROFILE_NMETH] = {
    {"Notify", MachineProfile_Notify, METH_VARARGS},
    {"SetHost", MachineProfile_SetHost, METH_VARARGS},
    {"GetHost", MachineProfile_GetHost, METH_VARARGS},
    {"SetUserName", MachineProfile_SetUserName, METH_VARARGS},
    {"GetUserName", MachineProfile_GetUserName, METH_VARARGS},
    {"SetHostAliases", MachineProfile_SetHostAliases, METH_VARARGS},
    {"GetHostAliases", MachineProfile_GetHostAliases, METH_VARARGS},
    {"SetHostNickname", MachineProfile_SetHostNickname, METH_VARARGS},
    {"GetHostNickname", MachineProfile_GetHostNickname, METH_VARARGS},
    {"SetDirectory", MachineProfile_SetDirectory, METH_VARARGS},
    {"GetDirectory", MachineProfile_GetDirectory, METH_VARARGS},
    {"SetShareOneBatchJob", MachineProfile_SetShareOneBatchJob, METH_VARARGS},
    {"GetShareOneBatchJob", MachineProfile_GetShareOneBatchJob, METH_VARARGS},
    {"SetSshPortSpecified", MachineProfile_SetSshPortSpecified, METH_VARARGS},
    {"GetSshPortSpecified", MachineProfile_GetSshPortSpecified, METH_VARARGS},
    {"SetSshPort", MachineProfile_SetSshPort, METH_VARARGS},
    {"GetSshPort", MachineProfile_GetSshPort, METH_VARARGS},
    {"SetClientHostDetermination", MachineProfile_SetClientHostDetermination, METH_VARARGS},
    {"GetClientHostDetermination", MachineProfile_GetClientHostDetermination, METH_VARARGS},
    {"SetManualClientHostName", MachineProfile_SetManualClientHostName, METH_VARARGS},
    {"GetManualClientHostName", MachineProfile_GetManualClientHostName, METH_VARARGS},
    {"SetTunnelSSH", MachineProfile_SetTunnelSSH, METH_VARARGS},
    {"GetTunnelSSH", MachineProfile_GetTunnelSSH, METH_VARARGS},
    {"GetLaunchProfiles", MachineProfile_GetLaunchProfiles, METH_VARARGS},
    {"GetNumLaunchProfiles", MachineProfile_GetNumLaunchProfiles, METH_VARARGS},
    {"AddLaunchProfiles", MachineProfile_AddLaunchProfiles, METH_VARARGS},
    {"RemoveLaunchProfiles", MachineProfile_RemoveLaunchProfiles, METH_VARARGS},
    {"ClearLaunchProfiles", MachineProfile_ClearLaunchProfiles, METH_VARARGS},
    {"SetActiveProfile", MachineProfile_SetActiveProfile, METH_VARARGS},
    {"GetActiveProfile", MachineProfile_GetActiveProfile, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MachineProfile_dealloc(PyObject *v)
{
   MachineProfileObject *obj = (MachineProfileObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MachineProfile_compare(PyObject *v, PyObject *w)
{
    MachineProfile *a = ((MachineProfileObject *)v)->data;
    MachineProfile *b = ((MachineProfileObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMachineProfile_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "host") == 0)
        return MachineProfile_GetHost(self, NULL);
    if(strcmp(name, "userName") == 0)
        return MachineProfile_GetUserName(self, NULL);
    if(strcmp(name, "hostAliases") == 0)
        return MachineProfile_GetHostAliases(self, NULL);
    if(strcmp(name, "hostNickname") == 0)
        return MachineProfile_GetHostNickname(self, NULL);
    if(strcmp(name, "directory") == 0)
        return MachineProfile_GetDirectory(self, NULL);
    if(strcmp(name, "shareOneBatchJob") == 0)
        return MachineProfile_GetShareOneBatchJob(self, NULL);
    if(strcmp(name, "sshPortSpecified") == 0)
        return MachineProfile_GetSshPortSpecified(self, NULL);
    if(strcmp(name, "sshPort") == 0)
        return MachineProfile_GetSshPort(self, NULL);
    if(strcmp(name, "clientHostDetermination") == 0)
        return MachineProfile_GetClientHostDetermination(self, NULL);
    if(strcmp(name, "MachineName") == 0)
        return PyInt_FromLong(long(MachineProfile::MachineName));
    if(strcmp(name, "ManuallySpecified") == 0)
        return PyInt_FromLong(long(MachineProfile::ManuallySpecified));
    if(strcmp(name, "ParsedFromSSHCLIENT") == 0)
        return PyInt_FromLong(long(MachineProfile::ParsedFromSSHCLIENT));

    if(strcmp(name, "manualClientHostName") == 0)
        return MachineProfile_GetManualClientHostName(self, NULL);
    if(strcmp(name, "tunnelSSH") == 0)
        return MachineProfile_GetTunnelSSH(self, NULL);
    if(strcmp(name, "launchProfiles") == 0)
        return MachineProfile_GetLaunchProfiles(self, NULL);
    if(strcmp(name, "activeProfile") == 0)
        return MachineProfile_GetActiveProfile(self, NULL);

    return Py_FindMethod(PyMachineProfile_methods, self, name);
}

int
PyMachineProfile_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "host") == 0)
        obj = MachineProfile_SetHost(self, tuple);
    else if(strcmp(name, "userName") == 0)
        obj = MachineProfile_SetUserName(self, tuple);
    else if(strcmp(name, "hostAliases") == 0)
        obj = MachineProfile_SetHostAliases(self, tuple);
    else if(strcmp(name, "hostNickname") == 0)
        obj = MachineProfile_SetHostNickname(self, tuple);
    else if(strcmp(name, "directory") == 0)
        obj = MachineProfile_SetDirectory(self, tuple);
    else if(strcmp(name, "shareOneBatchJob") == 0)
        obj = MachineProfile_SetShareOneBatchJob(self, tuple);
    else if(strcmp(name, "sshPortSpecified") == 0)
        obj = MachineProfile_SetSshPortSpecified(self, tuple);
    else if(strcmp(name, "sshPort") == 0)
        obj = MachineProfile_SetSshPort(self, tuple);
    else if(strcmp(name, "clientHostDetermination") == 0)
        obj = MachineProfile_SetClientHostDetermination(self, tuple);
    else if(strcmp(name, "manualClientHostName") == 0)
        obj = MachineProfile_SetManualClientHostName(self, tuple);
    else if(strcmp(name, "tunnelSSH") == 0)
        obj = MachineProfile_SetTunnelSSH(self, tuple);
    else if(strcmp(name, "activeProfile") == 0)
        obj = MachineProfile_SetActiveProfile(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
MachineProfile_print(PyObject *v, FILE *fp, int flags)
{
    MachineProfileObject *obj = (MachineProfileObject *)v;
    fprintf(fp, "%s", PyMachineProfile_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MachineProfile_str(PyObject *v)
{
    MachineProfileObject *obj = (MachineProfileObject *)v;
    return PyString_FromString(PyMachineProfile_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MachineProfile_Purpose = "This class contains information about a host for a remote VisIt engine.";
#else
static char *MachineProfile_Purpose = "This class contains information about a host for a remote VisIt engine.";
#endif

//
// The type description structure
//
static PyTypeObject MachineProfileType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MachineProfile",                    // tp_name
    sizeof(MachineProfileObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MachineProfile_dealloc,  // tp_dealloc
    (printfunc)MachineProfile_print,     // tp_print
    (getattrfunc)PyMachineProfile_getattr, // tp_getattr
    (setattrfunc)PyMachineProfile_setattr, // tp_setattr
    (cmpfunc)MachineProfile_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MachineProfile_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MachineProfile_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MachineProfile *defaultAtts = 0;
static MachineProfile *currentAtts = 0;

static PyObject *
NewMachineProfile(int useCurrent)
{
    MachineProfileObject *newObject;
    newObject = PyObject_NEW(MachineProfileObject, &MachineProfileType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MachineProfile(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MachineProfile(*defaultAtts);
    else
        newObject->data = new MachineProfile;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMachineProfile(const MachineProfile *attr)
{
    MachineProfileObject *newObject;
    newObject = PyObject_NEW(MachineProfileObject, &MachineProfileType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MachineProfile *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MachineProfile_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMachineProfile(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MachineProfileMethods[] = {
    {"MachineProfile", MachineProfile_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MachineProfileObserver = 0;

std::string
PyMachineProfile_GetLogString()
{
    std::string s("MachineProfile = MachineProfile()\n");
    if(currentAtts != 0)
        s += PyMachineProfile_ToString(currentAtts, "MachineProfile.");
    return s;
}

static void
PyMachineProfile_CallLogRoutine(Subject *subj, void *data)
{
    MachineProfile *atts = (MachineProfile *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MachineProfile = MachineProfile()\n");
        s += PyMachineProfile_ToString(currentAtts, "MachineProfile.");
        cb(s);
    }
}

void
PyMachineProfile_StartUp(MachineProfile *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMachineProfile_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MachineProfileObserver == 0)
    {
        MachineProfileObserver = new ObserverToCallback(subj,
            PyMachineProfile_CallLogRoutine, (void *)data);
    }

}

void
PyMachineProfile_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MachineProfileObserver;
    MachineProfileObserver = 0;
}

PyMethodDef *
PyMachineProfile_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MachineProfileMethods;
}

bool
PyMachineProfile_Check(PyObject *obj)
{
    return (obj->ob_type == &MachineProfileType);
}

MachineProfile *
PyMachineProfile_FromPyObject(PyObject *obj)
{
    MachineProfileObject *obj2 = (MachineProfileObject *)obj;
    return obj2->data;
}

PyObject *
PyMachineProfile_New()
{
    return NewMachineProfile(0);
}

PyObject *
PyMachineProfile_Wrap(const MachineProfile *attr)
{
    return WrapMachineProfile(attr);
}

void
PyMachineProfile_SetParent(PyObject *obj, PyObject *parent)
{
    MachineProfileObject *obj2 = (MachineProfileObject *)obj;
    obj2->parent = parent;
}

void
PyMachineProfile_SetDefaults(const MachineProfile *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MachineProfile(*atts);
}

