/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyKeyframeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyKeyframeAttributes
//
// Purpose: 
//   This class contains the attributes used for keyframing.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:55 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a KeyframeAttributes.
//
struct KeyframeAttributesObject
{
    PyObject_HEAD
    KeyframeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewKeyframeAttributes(int);

std::string
PyKeyframeAttributes_ToString(const KeyframeAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetEnabled())
        SNPRINTF(tmpStr, 1000, "%senabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%senabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snFrames = %d\n", prefix, atts->GetNFrames());
    str += tmpStr;
    if(atts->GetNFramesWasUserSet())
        SNPRINTF(tmpStr, 1000, "%snFramesWasUserSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snFramesWasUserSet = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
KeyframeAttributes_Notify(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
KeyframeAttributes_SetEnabled(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enabled in the object.
    obj->data->SetEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
KeyframeAttributes_GetEnabled(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
KeyframeAttributes_SetNFrames(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nFrames in the object.
    obj->data->SetNFrames((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
KeyframeAttributes_GetNFrames(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNFrames()));
    return retval;
}

/*static*/ PyObject *
KeyframeAttributes_SetNFramesWasUserSet(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nFramesWasUserSet in the object.
    obj->data->SetNFramesWasUserSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
KeyframeAttributes_GetNFramesWasUserSet(PyObject *self, PyObject *args)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNFramesWasUserSet()?1L:0L);
    return retval;
}



static struct PyMethodDef KeyframeAttributes_methods[] = {
    {"Notify", KeyframeAttributes_Notify, METH_VARARGS},
    {"SetEnabled", KeyframeAttributes_SetEnabled, METH_VARARGS},
    {"GetEnabled", KeyframeAttributes_GetEnabled, METH_VARARGS},
    {"SetNFrames", KeyframeAttributes_SetNFrames, METH_VARARGS},
    {"GetNFrames", KeyframeAttributes_GetNFrames, METH_VARARGS},
    {"SetNFramesWasUserSet", KeyframeAttributes_SetNFramesWasUserSet, METH_VARARGS},
    {"GetNFramesWasUserSet", KeyframeAttributes_GetNFramesWasUserSet, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
KeyframeAttributes_dealloc(PyObject *v)
{
   KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
KeyframeAttributes_compare(PyObject *v, PyObject *w)
{
    KeyframeAttributes *a = ((KeyframeAttributesObject *)v)->data;
    KeyframeAttributes *b = ((KeyframeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
KeyframeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "enabled") == 0)
        return KeyframeAttributes_GetEnabled(self, NULL);
    if(strcmp(name, "nFrames") == 0)
        return KeyframeAttributes_GetNFrames(self, NULL);
    if(strcmp(name, "nFramesWasUserSet") == 0)
        return KeyframeAttributes_GetNFramesWasUserSet(self, NULL);

    return Py_FindMethod(KeyframeAttributes_methods, self, name);
}

static int
KeyframeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "enabled") == 0)
        obj = KeyframeAttributes_SetEnabled(self, tuple);
    else if(strcmp(name, "nFrames") == 0)
        obj = KeyframeAttributes_SetNFrames(self, tuple);
    else if(strcmp(name, "nFramesWasUserSet") == 0)
        obj = KeyframeAttributes_SetNFramesWasUserSet(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
KeyframeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;
    fprintf(fp, "%s", PyKeyframeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
KeyframeAttributes_str(PyObject *v)
{
    KeyframeAttributesObject *obj = (KeyframeAttributesObject *)v;
    return PyString_FromString(PyKeyframeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *KeyframeAttributes_Purpose = "This class contains the attributes used for keyframing.";
#else
static char *KeyframeAttributes_Purpose = "This class contains the attributes used for keyframing.";
#endif

//
// The type description structure
//
static PyTypeObject KeyframeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "KeyframeAttributes",                    // tp_name
    sizeof(KeyframeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)KeyframeAttributes_dealloc,  // tp_dealloc
    (printfunc)KeyframeAttributes_print,     // tp_print
    (getattrfunc)KeyframeAttributes_getattr, // tp_getattr
    (setattrfunc)KeyframeAttributes_setattr, // tp_setattr
    (cmpfunc)KeyframeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)KeyframeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    KeyframeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static KeyframeAttributes *defaultAtts = 0;
static KeyframeAttributes *currentAtts = 0;

static PyObject *
NewKeyframeAttributes(int useCurrent)
{
    KeyframeAttributesObject *newObject;
    newObject = PyObject_NEW(KeyframeAttributesObject, &KeyframeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new KeyframeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new KeyframeAttributes(*defaultAtts);
    else
        newObject->data = new KeyframeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapKeyframeAttributes(const KeyframeAttributes *attr)
{
    KeyframeAttributesObject *newObject;
    newObject = PyObject_NEW(KeyframeAttributesObject, &KeyframeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (KeyframeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
KeyframeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewKeyframeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef KeyframeAttributesMethods[] = {
    {"KeyframeAttributes", KeyframeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *KeyframeAttributesObserver = 0;

std::string
PyKeyframeAttributes_GetLogString()
{
    std::string s("KeyframeAtts = KeyframeAttributes()\n");
    if(currentAtts != 0)
        s += PyKeyframeAttributes_ToString(currentAtts, "KeyframeAtts.");
    return s;
}

static void
PyKeyframeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    KeyframeAttributes *atts = (KeyframeAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("KeyframeAtts = KeyframeAttributes()\n");
        s += PyKeyframeAttributes_ToString(currentAtts, "KeyframeAtts.");
        cb(s);
    }
}

void
PyKeyframeAttributes_StartUp(KeyframeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyKeyframeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(KeyframeAttributesObserver == 0)
    {
        KeyframeAttributesObserver = new ObserverToCallback(subj,
            PyKeyframeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyKeyframeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete KeyframeAttributesObserver;
    KeyframeAttributesObserver = 0;
}

PyMethodDef *
PyKeyframeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return KeyframeAttributesMethods;
}

bool
PyKeyframeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &KeyframeAttributesType);
}

KeyframeAttributes *
PyKeyframeAttributes_FromPyObject(PyObject *obj)
{
    KeyframeAttributesObject *obj2 = (KeyframeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyKeyframeAttributes_New()
{
    return NewKeyframeAttributes(0);
}

PyObject *
PyKeyframeAttributes_Wrap(const KeyframeAttributes *attr)
{
    return WrapKeyframeAttributes(attr);
}

void
PyKeyframeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    KeyframeAttributesObject *obj2 = (KeyframeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyKeyframeAttributes_SetDefaults(const KeyframeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new KeyframeAttributes(*atts);
}

