/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyGaussianControlPointList.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyGaussianControlPoint.h>

// ****************************************************************************
// Module: PyGaussianControlPointList
//
// Purpose: 
//   This class contains a list of GaussianControlPoint objects.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:46 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a GaussianControlPointList.
//
struct GaussianControlPointListObject
{
    PyObject_HEAD
    GaussianControlPointList *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewGaussianControlPointList(int);

std::string
PyGaussianControlPointList_ToString(const GaussianControlPointList *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    { // new scope
        int index = 0;
        // Create string representation of controlPoints from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetControlPoints().begin(); pos != atts->GetControlPoints().end(); ++pos, ++index)
        {
            const GaussianControlPoint *current = (const GaussianControlPoint *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetControlPoints(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyGaussianControlPoint_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#controlPoints does not contain any GaussianControlPoint objects.\n";
    }
    return str;
}

static PyObject *
GaussianControlPointList_Notify(PyObject *self, PyObject *args)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPointList_GetControlPoints(PyObject *self, PyObject *args)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || index >= obj->data->GetControlPoints().size())
    {
        char msg[200];
        if(obj->data->GetControlPoints().size() == 0)
            SNPRINTF(msg, 200, "The index is invalid because controlPoints is empty.");
        else
            SNPRINTF(msg, 200, "The index is invalid. Use index values in: [0, %ld).", obj->data->GetControlPoints().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyGaussianControlPoint_Wrap(&obj->data->GetControlPoints(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyGaussianControlPoint_SetParent(retval, self);

    return retval;
}

PyObject *
GaussianControlPointList_GetNumControlPoints(PyObject *self, PyObject *args)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    return PyInt_FromLong((long)obj->data->GetControlPoints().size());
}

PyObject *
GaussianControlPointList_AddControlPoints(PyObject *self, PyObject *args)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyGaussianControlPoint_Check(element))
    {
        char msg[400];
        SNPRINTF(msg, 400, "The AddControlPoints method only accepts GaussianControlPoint objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    GaussianControlPoint *newData = PyGaussianControlPoint_FromPyObject(element);
    obj->data->AddControlPoints(*newData);
    obj->data->SelectControlPoints();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
GaussianControlPointList_Remove_One_ControlPoints(PyObject *self, int index)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveControlPoints() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetControlPoints();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectControlPoints();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
GaussianControlPointList_RemoveControlPoints(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    if(index < 0 || index >= obj->data->GetNumControlPoints())
    {
        PyErr_SetString(PyExc_IndexError, "Index out of range");
        return NULL;
    }

    return GaussianControlPointList_Remove_One_ControlPoints(self, index);
}

PyObject *
GaussianControlPointList_ClearControlPoints(PyObject *self, PyObject *args)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)self;
    int n = obj->data->GetNumControlPoints();
    for(int i = 0; i < n; ++i)
    {
        GaussianControlPointList_Remove_One_ControlPoints(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}



static struct PyMethodDef GaussianControlPointList_methods[] = {
    {"Notify", GaussianControlPointList_Notify, METH_VARARGS},
    {"GetControlPoints", GaussianControlPointList_GetControlPoints, METH_VARARGS},
    {"GetNumControlPoints", GaussianControlPointList_GetNumControlPoints, METH_VARARGS},
    {"AddControlPoints", GaussianControlPointList_AddControlPoints, METH_VARARGS},
    {"RemoveControlPoints", GaussianControlPointList_RemoveControlPoints, METH_VARARGS},
    {"ClearControlPoints", GaussianControlPointList_ClearControlPoints, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GaussianControlPointList_dealloc(PyObject *v)
{
   GaussianControlPointListObject *obj = (GaussianControlPointListObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
GaussianControlPointList_compare(PyObject *v, PyObject *w)
{
    GaussianControlPointList *a = ((GaussianControlPointListObject *)v)->data;
    GaussianControlPointList *b = ((GaussianControlPointListObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
GaussianControlPointList_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "controlPoints") == 0)
        return GaussianControlPointList_GetControlPoints(self, NULL);

    return Py_FindMethod(GaussianControlPointList_methods, self, name);
}

static int
GaussianControlPointList_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;


    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
GaussianControlPointList_print(PyObject *v, FILE *fp, int flags)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)v;
    fprintf(fp, "%s", PyGaussianControlPointList_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
GaussianControlPointList_str(PyObject *v)
{
    GaussianControlPointListObject *obj = (GaussianControlPointListObject *)v;
    return PyString_FromString(PyGaussianControlPointList_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *GaussianControlPointList_Purpose = "This class contains a list of GaussianControlPoint objects.";
#else
static char *GaussianControlPointList_Purpose = "This class contains a list of GaussianControlPoint objects.";
#endif

//
// The type description structure
//
static PyTypeObject GaussianControlPointListType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GaussianControlPointList",                    // tp_name
    sizeof(GaussianControlPointListObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GaussianControlPointList_dealloc,  // tp_dealloc
    (printfunc)GaussianControlPointList_print,     // tp_print
    (getattrfunc)GaussianControlPointList_getattr, // tp_getattr
    (setattrfunc)GaussianControlPointList_setattr, // tp_setattr
    (cmpfunc)GaussianControlPointList_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GaussianControlPointList_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GaussianControlPointList_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GaussianControlPointList *defaultAtts = 0;
static GaussianControlPointList *currentAtts = 0;

static PyObject *
NewGaussianControlPointList(int useCurrent)
{
    GaussianControlPointListObject *newObject;
    newObject = PyObject_NEW(GaussianControlPointListObject, &GaussianControlPointListType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new GaussianControlPointList(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new GaussianControlPointList(*defaultAtts);
    else
        newObject->data = new GaussianControlPointList;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapGaussianControlPointList(const GaussianControlPointList *attr)
{
    GaussianControlPointListObject *newObject;
    newObject = PyObject_NEW(GaussianControlPointListObject, &GaussianControlPointListType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GaussianControlPointList *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GaussianControlPointList_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewGaussianControlPointList(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GaussianControlPointListMethods[] = {
    {"GaussianControlPointList", GaussianControlPointList_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GaussianControlPointListObserver = 0;

std::string
PyGaussianControlPointList_GetLogString()
{
    std::string s("GaussianControlPointList = GaussianControlPointList()\n");
    if(currentAtts != 0)
        s += PyGaussianControlPointList_ToString(currentAtts, "GaussianControlPointList.");
    return s;
}

static void
PyGaussianControlPointList_CallLogRoutine(Subject *subj, void *data)
{
    GaussianControlPointList *atts = (GaussianControlPointList *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("GaussianControlPointList = GaussianControlPointList()\n");
        s += PyGaussianControlPointList_ToString(currentAtts, "GaussianControlPointList.");
        cb(s);
    }
}

void
PyGaussianControlPointList_StartUp(GaussianControlPointList *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyGaussianControlPointList_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GaussianControlPointListObserver == 0)
    {
        GaussianControlPointListObserver = new ObserverToCallback(subj,
            PyGaussianControlPointList_CallLogRoutine, (void *)data);
    }

}

void
PyGaussianControlPointList_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GaussianControlPointListObserver;
    GaussianControlPointListObserver = 0;
}

PyMethodDef *
PyGaussianControlPointList_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GaussianControlPointListMethods;
}

bool
PyGaussianControlPointList_Check(PyObject *obj)
{
    return (obj->ob_type == &GaussianControlPointListType);
}

GaussianControlPointList *
PyGaussianControlPointList_FromPyObject(PyObject *obj)
{
    GaussianControlPointListObject *obj2 = (GaussianControlPointListObject *)obj;
    return obj2->data;
}

PyObject *
PyGaussianControlPointList_New()
{
    return NewGaussianControlPointList(0);
}

PyObject *
PyGaussianControlPointList_Wrap(const GaussianControlPointList *attr)
{
    return WrapGaussianControlPointList(attr);
}

void
PyGaussianControlPointList_SetParent(PyObject *obj, PyObject *parent)
{
    GaussianControlPointListObject *obj2 = (GaussianControlPointListObject *)obj;
    obj2->parent = parent;
}

void
PyGaussianControlPointList_SetDefaults(const GaussianControlPointList *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GaussianControlPointList(*atts);
}

