/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyGaussianControlPoint.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyGaussianControlPoint
//
// Purpose: 
//   This class contains the information for a gaussian in the opacity bar.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:52 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a GaussianControlPoint.
//
struct GaussianControlPointObject
{
    PyObject_HEAD
    GaussianControlPoint *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewGaussianControlPoint(int);

std::string
PyGaussianControlPoint_ToString(const GaussianControlPoint *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sx = %g\n", prefix, atts->GetX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sheight = %g\n", prefix, atts->GetHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%swidth = %g\n", prefix, atts->GetWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sxBias = %g\n", prefix, atts->GetXBias());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syBias = %g\n", prefix, atts->GetYBias());
    str += tmpStr;
    return str;
}

static PyObject *
GaussianControlPoint_Notify(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_SetX(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the x in the object.
    obj->data->SetX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_GetX(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetX()));
    return retval;
}

/*static*/ PyObject *
GaussianControlPoint_SetHeight(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the height in the object.
    obj->data->SetHeight(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_GetHeight(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetHeight()));
    return retval;
}

/*static*/ PyObject *
GaussianControlPoint_SetWidth(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the width in the object.
    obj->data->SetWidth(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_GetWidth(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetWidth()));
    return retval;
}

/*static*/ PyObject *
GaussianControlPoint_SetXBias(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the xBias in the object.
    obj->data->SetXBias(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_GetXBias(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetXBias()));
    return retval;
}

/*static*/ PyObject *
GaussianControlPoint_SetYBias(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the yBias in the object.
    obj->data->SetYBias(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
GaussianControlPoint_GetYBias(PyObject *self, PyObject *args)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetYBias()));
    return retval;
}



static struct PyMethodDef GaussianControlPoint_methods[] = {
    {"Notify", GaussianControlPoint_Notify, METH_VARARGS},
    {"SetX", GaussianControlPoint_SetX, METH_VARARGS},
    {"GetX", GaussianControlPoint_GetX, METH_VARARGS},
    {"SetHeight", GaussianControlPoint_SetHeight, METH_VARARGS},
    {"GetHeight", GaussianControlPoint_GetHeight, METH_VARARGS},
    {"SetWidth", GaussianControlPoint_SetWidth, METH_VARARGS},
    {"GetWidth", GaussianControlPoint_GetWidth, METH_VARARGS},
    {"SetXBias", GaussianControlPoint_SetXBias, METH_VARARGS},
    {"GetXBias", GaussianControlPoint_GetXBias, METH_VARARGS},
    {"SetYBias", GaussianControlPoint_SetYBias, METH_VARARGS},
    {"GetYBias", GaussianControlPoint_GetYBias, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
GaussianControlPoint_dealloc(PyObject *v)
{
   GaussianControlPointObject *obj = (GaussianControlPointObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
GaussianControlPoint_compare(PyObject *v, PyObject *w)
{
    GaussianControlPoint *a = ((GaussianControlPointObject *)v)->data;
    GaussianControlPoint *b = ((GaussianControlPointObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
GaussianControlPoint_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "x") == 0)
        return GaussianControlPoint_GetX(self, NULL);
    if(strcmp(name, "height") == 0)
        return GaussianControlPoint_GetHeight(self, NULL);
    if(strcmp(name, "width") == 0)
        return GaussianControlPoint_GetWidth(self, NULL);
    if(strcmp(name, "xBias") == 0)
        return GaussianControlPoint_GetXBias(self, NULL);
    if(strcmp(name, "yBias") == 0)
        return GaussianControlPoint_GetYBias(self, NULL);

    return Py_FindMethod(GaussianControlPoint_methods, self, name);
}

static int
GaussianControlPoint_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "x") == 0)
        obj = GaussianControlPoint_SetX(self, tuple);
    else if(strcmp(name, "height") == 0)
        obj = GaussianControlPoint_SetHeight(self, tuple);
    else if(strcmp(name, "width") == 0)
        obj = GaussianControlPoint_SetWidth(self, tuple);
    else if(strcmp(name, "xBias") == 0)
        obj = GaussianControlPoint_SetXBias(self, tuple);
    else if(strcmp(name, "yBias") == 0)
        obj = GaussianControlPoint_SetYBias(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
GaussianControlPoint_print(PyObject *v, FILE *fp, int flags)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)v;
    fprintf(fp, "%s", PyGaussianControlPoint_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
GaussianControlPoint_str(PyObject *v)
{
    GaussianControlPointObject *obj = (GaussianControlPointObject *)v;
    return PyString_FromString(PyGaussianControlPoint_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *GaussianControlPoint_Purpose = "This class contains the information for a gaussian in the opacity bar.";
#else
static char *GaussianControlPoint_Purpose = "This class contains the information for a gaussian in the opacity bar.";
#endif

//
// The type description structure
//
static PyTypeObject GaussianControlPointType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "GaussianControlPoint",                    // tp_name
    sizeof(GaussianControlPointObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)GaussianControlPoint_dealloc,  // tp_dealloc
    (printfunc)GaussianControlPoint_print,     // tp_print
    (getattrfunc)GaussianControlPoint_getattr, // tp_getattr
    (setattrfunc)GaussianControlPoint_setattr, // tp_setattr
    (cmpfunc)GaussianControlPoint_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)GaussianControlPoint_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    GaussianControlPoint_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static GaussianControlPoint *defaultAtts = 0;
static GaussianControlPoint *currentAtts = 0;

static PyObject *
NewGaussianControlPoint(int useCurrent)
{
    GaussianControlPointObject *newObject;
    newObject = PyObject_NEW(GaussianControlPointObject, &GaussianControlPointType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new GaussianControlPoint(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new GaussianControlPoint(*defaultAtts);
    else
        newObject->data = new GaussianControlPoint;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapGaussianControlPoint(const GaussianControlPoint *attr)
{
    GaussianControlPointObject *newObject;
    newObject = PyObject_NEW(GaussianControlPointObject, &GaussianControlPointType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (GaussianControlPoint *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
GaussianControlPoint_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewGaussianControlPoint(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef GaussianControlPointMethods[] = {
    {"GaussianControlPoint", GaussianControlPoint_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *GaussianControlPointObserver = 0;

std::string
PyGaussianControlPoint_GetLogString()
{
    std::string s("GaussianControlPoint = GaussianControlPoint()\n");
    if(currentAtts != 0)
        s += PyGaussianControlPoint_ToString(currentAtts, "GaussianControlPoint.");
    return s;
}

static void
PyGaussianControlPoint_CallLogRoutine(Subject *subj, void *data)
{
    GaussianControlPoint *atts = (GaussianControlPoint *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("GaussianControlPoint = GaussianControlPoint()\n");
        s += PyGaussianControlPoint_ToString(currentAtts, "GaussianControlPoint.");
        cb(s);
    }
}

void
PyGaussianControlPoint_StartUp(GaussianControlPoint *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyGaussianControlPoint_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(GaussianControlPointObserver == 0)
    {
        GaussianControlPointObserver = new ObserverToCallback(subj,
            PyGaussianControlPoint_CallLogRoutine, (void *)data);
    }

}

void
PyGaussianControlPoint_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete GaussianControlPointObserver;
    GaussianControlPointObserver = 0;
}

PyMethodDef *
PyGaussianControlPoint_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return GaussianControlPointMethods;
}

bool
PyGaussianControlPoint_Check(PyObject *obj)
{
    return (obj->ob_type == &GaussianControlPointType);
}

GaussianControlPoint *
PyGaussianControlPoint_FromPyObject(PyObject *obj)
{
    GaussianControlPointObject *obj2 = (GaussianControlPointObject *)obj;
    return obj2->data;
}

PyObject *
PyGaussianControlPoint_New()
{
    return NewGaussianControlPoint(0);
}

PyObject *
PyGaussianControlPoint_Wrap(const GaussianControlPoint *attr)
{
    return WrapGaussianControlPoint(attr);
}

void
PyGaussianControlPoint_SetParent(PyObject *obj, PyObject *parent)
{
    GaussianControlPointObject *obj2 = (GaussianControlPointObject *)obj;
    obj2->parent = parent;
}

void
PyGaussianControlPoint_SetDefaults(const GaussianControlPoint *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new GaussianControlPoint(*atts);
}

