/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyExpression.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyExpression
//
// Purpose: 
//   This class contains an expression.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:49 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a Expression.
//
struct ExpressionObject
{
    PyObject_HEAD
    Expression *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewExpression(int);

std::string
PyExpression_ToString(const Expression *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdefinition = \"%s\"\n", prefix, atts->GetDefinition().c_str());
    str += tmpStr;
    if(atts->GetHidden())
        SNPRINTF(tmpStr, 1000, "%shidden = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shidden = 0\n", prefix);
    str += tmpStr;
    const char *type_names = "Unknown, ScalarMeshVar, VectorMeshVar, TensorMeshVar, SymmetricTensorMeshVar, "
        "ArrayMeshVar, CurveMeshVar, Mesh, Material, "
        "Species";
    switch (atts->GetType())
    {
      case Expression::Unknown:
          SNPRINTF(tmpStr, 1000, "%stype = %sUnknown  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::ScalarMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sScalarMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::VectorMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sVectorMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::TensorMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sTensorMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::SymmetricTensorMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sSymmetricTensorMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::ArrayMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sArrayMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::CurveMeshVar:
          SNPRINTF(tmpStr, 1000, "%stype = %sCurveMeshVar  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::Mesh:
          SNPRINTF(tmpStr, 1000, "%stype = %sMesh  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::Material:
          SNPRINTF(tmpStr, 1000, "%stype = %sMaterial  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      case Expression::Species:
          SNPRINTF(tmpStr, 1000, "%stype = %sSpecies  # %s\n", prefix, prefix, type_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetFromDB())
        SNPRINTF(tmpStr, 1000, "%sfromDB = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfromDB = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFromOperator())
        SNPRINTF(tmpStr, 1000, "%sfromOperator = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfromOperator = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdbName = \"%s\"\n", prefix, atts->GetDbName().c_str());
    str += tmpStr;
    if(atts->GetAutoExpression())
        SNPRINTF(tmpStr, 1000, "%sautoExpression = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sautoExpression = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
Expression_Notify(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_SetName(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetName(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
Expression_SetDefinition(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the definition in the object.
    obj->data->SetDefinition(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetDefinition(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDefinition().c_str());
    return retval;
}

/*static*/ PyObject *
Expression_SetHidden(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hidden in the object.
    obj->data->SetHidden(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetHidden(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHidden()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Expression_SetType(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the type in the object.
    if(ival >= 0 && ival < 10)
        obj->data->SetType(Expression::ExprType(ival));
    else
    {
        fprintf(stderr, "An invalid type value was given. "
                        "Valid values are in the range of [0,9]. "
                        "You can also use the following names: "
                        "Unknown, ScalarMeshVar, VectorMeshVar, TensorMeshVar, SymmetricTensorMeshVar, "
                        "ArrayMeshVar, CurveMeshVar, Mesh, Material, "
                        "Species.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetType(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetType()));
    return retval;
}

/*static*/ PyObject *
Expression_SetFromDB(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fromDB in the object.
    obj->data->SetFromDB(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetFromDB(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFromDB()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Expression_SetFromOperator(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fromOperator in the object.
    obj->data->SetFromOperator(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetFromOperator(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFromOperator()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Expression_SetDbName(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the dbName in the object.
    obj->data->SetDbName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetDbName(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDbName().c_str());
    return retval;
}

/*static*/ PyObject *
Expression_SetAutoExpression(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoExpression in the object.
    obj->data->SetAutoExpression(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Expression_GetAutoExpression(PyObject *self, PyObject *args)
{
    ExpressionObject *obj = (ExpressionObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoExpression()?1L:0L);
    return retval;
}



static struct PyMethodDef Expression_methods[] = {
    {"Notify", Expression_Notify, METH_VARARGS},
    {"SetName", Expression_SetName, METH_VARARGS},
    {"GetName", Expression_GetName, METH_VARARGS},
    {"SetDefinition", Expression_SetDefinition, METH_VARARGS},
    {"GetDefinition", Expression_GetDefinition, METH_VARARGS},
    {"SetHidden", Expression_SetHidden, METH_VARARGS},
    {"GetHidden", Expression_GetHidden, METH_VARARGS},
    {"SetType", Expression_SetType, METH_VARARGS},
    {"GetType", Expression_GetType, METH_VARARGS},
    {"SetFromDB", Expression_SetFromDB, METH_VARARGS},
    {"GetFromDB", Expression_GetFromDB, METH_VARARGS},
    {"SetFromOperator", Expression_SetFromOperator, METH_VARARGS},
    {"GetFromOperator", Expression_GetFromOperator, METH_VARARGS},
    {"SetDbName", Expression_SetDbName, METH_VARARGS},
    {"GetDbName", Expression_GetDbName, METH_VARARGS},
    {"SetAutoExpression", Expression_SetAutoExpression, METH_VARARGS},
    {"GetAutoExpression", Expression_GetAutoExpression, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
Expression_dealloc(PyObject *v)
{
   ExpressionObject *obj = (ExpressionObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
Expression_compare(PyObject *v, PyObject *w)
{
    Expression *a = ((ExpressionObject *)v)->data;
    Expression *b = ((ExpressionObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
Expression_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return Expression_GetName(self, NULL);
    if(strcmp(name, "definition") == 0)
        return Expression_GetDefinition(self, NULL);
    if(strcmp(name, "hidden") == 0)
        return Expression_GetHidden(self, NULL);
    if(strcmp(name, "type") == 0)
        return Expression_GetType(self, NULL);
    if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(Expression::Unknown));
    if(strcmp(name, "ScalarMeshVar") == 0)
        return PyInt_FromLong(long(Expression::ScalarMeshVar));
    if(strcmp(name, "VectorMeshVar") == 0)
        return PyInt_FromLong(long(Expression::VectorMeshVar));
    if(strcmp(name, "TensorMeshVar") == 0)
        return PyInt_FromLong(long(Expression::TensorMeshVar));
    if(strcmp(name, "SymmetricTensorMeshVar") == 0)
        return PyInt_FromLong(long(Expression::SymmetricTensorMeshVar));
    if(strcmp(name, "ArrayMeshVar") == 0)
        return PyInt_FromLong(long(Expression::ArrayMeshVar));
    if(strcmp(name, "CurveMeshVar") == 0)
        return PyInt_FromLong(long(Expression::CurveMeshVar));
    if(strcmp(name, "Mesh") == 0)
        return PyInt_FromLong(long(Expression::Mesh));
    if(strcmp(name, "Material") == 0)
        return PyInt_FromLong(long(Expression::Material));
    if(strcmp(name, "Species") == 0)
        return PyInt_FromLong(long(Expression::Species));

    if(strcmp(name, "fromDB") == 0)
        return Expression_GetFromDB(self, NULL);
    if(strcmp(name, "fromOperator") == 0)
        return Expression_GetFromOperator(self, NULL);
    if(strcmp(name, "dbName") == 0)
        return Expression_GetDbName(self, NULL);
    if(strcmp(name, "autoExpression") == 0)
        return Expression_GetAutoExpression(self, NULL);

    return Py_FindMethod(Expression_methods, self, name);
}

static int
Expression_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = Expression_SetName(self, tuple);
    else if(strcmp(name, "definition") == 0)
        obj = Expression_SetDefinition(self, tuple);
    else if(strcmp(name, "hidden") == 0)
        obj = Expression_SetHidden(self, tuple);
    else if(strcmp(name, "type") == 0)
        obj = Expression_SetType(self, tuple);
    else if(strcmp(name, "fromDB") == 0)
        obj = Expression_SetFromDB(self, tuple);
    else if(strcmp(name, "fromOperator") == 0)
        obj = Expression_SetFromOperator(self, tuple);
    else if(strcmp(name, "dbName") == 0)
        obj = Expression_SetDbName(self, tuple);
    else if(strcmp(name, "autoExpression") == 0)
        obj = Expression_SetAutoExpression(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
Expression_print(PyObject *v, FILE *fp, int flags)
{
    ExpressionObject *obj = (ExpressionObject *)v;
    fprintf(fp, "%s", PyExpression_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
Expression_str(PyObject *v)
{
    ExpressionObject *obj = (ExpressionObject *)v;
    return PyString_FromString(PyExpression_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *Expression_Purpose = "This class contains an expression.";
#else
static char *Expression_Purpose = "This class contains an expression.";
#endif

//
// The type description structure
//
static PyTypeObject ExpressionType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "Expression",                    // tp_name
    sizeof(ExpressionObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)Expression_dealloc,  // tp_dealloc
    (printfunc)Expression_print,     // tp_print
    (getattrfunc)Expression_getattr, // tp_getattr
    (setattrfunc)Expression_setattr, // tp_setattr
    (cmpfunc)Expression_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)Expression_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    Expression_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static Expression *defaultAtts = 0;
static Expression *currentAtts = 0;

static PyObject *
NewExpression(int useCurrent)
{
    ExpressionObject *newObject;
    newObject = PyObject_NEW(ExpressionObject, &ExpressionType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new Expression(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new Expression(*defaultAtts);
    else
        newObject->data = new Expression;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapExpression(const Expression *attr)
{
    ExpressionObject *newObject;
    newObject = PyObject_NEW(ExpressionObject, &ExpressionType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (Expression *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
Expression_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewExpression(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ExpressionMethods[] = {
    {"Expression", Expression_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ExpressionObserver = 0;

std::string
PyExpression_GetLogString()
{
    std::string s("Expression = Expression()\n");
    if(currentAtts != 0)
        s += PyExpression_ToString(currentAtts, "Expression.");
    return s;
}

static void
PyExpression_CallLogRoutine(Subject *subj, void *data)
{
    Expression *atts = (Expression *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("Expression = Expression()\n");
        s += PyExpression_ToString(currentAtts, "Expression.");
        cb(s);
    }
}

void
PyExpression_StartUp(Expression *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyExpression_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ExpressionObserver == 0)
    {
        ExpressionObserver = new ObserverToCallback(subj,
            PyExpression_CallLogRoutine, (void *)data);
    }

}

void
PyExpression_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ExpressionObserver;
    ExpressionObserver = 0;
}

PyMethodDef *
PyExpression_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ExpressionMethods;
}

bool
PyExpression_Check(PyObject *obj)
{
    return (obj->ob_type == &ExpressionType);
}

Expression *
PyExpression_FromPyObject(PyObject *obj)
{
    ExpressionObject *obj2 = (ExpressionObject *)obj;
    return obj2->data;
}

PyObject *
PyExpression_New()
{
    return NewExpression(0);
}

PyObject *
PyExpression_Wrap(const Expression *attr)
{
    return WrapExpression(attr);
}

void
PyExpression_SetParent(PyObject *obj, PyObject *parent)
{
    ExpressionObject *obj2 = (ExpressionObject *)obj;
    obj2->parent = parent;
}

void
PyExpression_SetDefaults(const Expression *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new Expression(*atts);
}

