/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyDBOptionsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyDBOptionsAttributes
//
// Purpose: 
//   Attributes of database options
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Mar 16 21:51:25 PST 2009
//
// ****************************************************************************

//
// This struct contains the Python type information and a DBOptionsAttributes.
//
struct DBOptionsAttributesObject
{
    PyObject_HEAD
    DBOptionsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewDBOptionsAttributes(int);

std::string
PyDBOptionsAttributes_ToString(const DBOptionsAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    {   const intVector &types = atts->GetTypes();
        SNPRINTF(tmpStr, 1000, "%stypes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < types.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", types[i]);
            str += tmpStr;
            if(i < types.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
DBOptionsAttributes_Notify(PyObject *self, PyObject *args)
{
    DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DBOptionsAttributes_SetTypes(PyObject *self, PyObject *args)
{
    DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)self;

    intVector  &vec = obj->data->GetTypes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the types in the object as modified.
    obj->data->SelectTypes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
DBOptionsAttributes_GetTypes(PyObject *self, PyObject *args)
{
    DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the types.
    const intVector &types = obj->data->GetTypes();
    PyObject *retval = PyTuple_New(types.size());
    for(size_t i = 0; i < types.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(types[i])));
    return retval;
}



static struct PyMethodDef DBOptionsAttributes_methods[] = {
    {"Notify", DBOptionsAttributes_Notify, METH_VARARGS},
    {"SetTypes", DBOptionsAttributes_SetTypes, METH_VARARGS},
    {"GetTypes", DBOptionsAttributes_GetTypes, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
DBOptionsAttributes_dealloc(PyObject *v)
{
   DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
DBOptionsAttributes_compare(PyObject *v, PyObject *w)
{
    DBOptionsAttributes *a = ((DBOptionsAttributesObject *)v)->data;
    DBOptionsAttributes *b = ((DBOptionsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
DBOptionsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "types") == 0)
        return DBOptionsAttributes_GetTypes(self, NULL);

    return Py_FindMethod(DBOptionsAttributes_methods, self, name);
}

static int
DBOptionsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "types") == 0)
        obj = DBOptionsAttributes_SetTypes(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
DBOptionsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)v;
    fprintf(fp, "%s", PyDBOptionsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
DBOptionsAttributes_str(PyObject *v)
{
    DBOptionsAttributesObject *obj = (DBOptionsAttributesObject *)v;
    return PyString_FromString(PyDBOptionsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *DBOptionsAttributes_Purpose = "Attributes of database options";
#else
static char *DBOptionsAttributes_Purpose = "Attributes of database options";
#endif

//
// The type description structure
//
static PyTypeObject DBOptionsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "DBOptionsAttributes",                    // tp_name
    sizeof(DBOptionsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)DBOptionsAttributes_dealloc,  // tp_dealloc
    (printfunc)DBOptionsAttributes_print,     // tp_print
    (getattrfunc)DBOptionsAttributes_getattr, // tp_getattr
    (setattrfunc)DBOptionsAttributes_setattr, // tp_setattr
    (cmpfunc)DBOptionsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)DBOptionsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    DBOptionsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static DBOptionsAttributes *defaultAtts = 0;
static DBOptionsAttributes *currentAtts = 0;

static PyObject *
NewDBOptionsAttributes(int useCurrent)
{
    DBOptionsAttributesObject *newObject;
    newObject = PyObject_NEW(DBOptionsAttributesObject, &DBOptionsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new DBOptionsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new DBOptionsAttributes(*defaultAtts);
    else
        newObject->data = new DBOptionsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapDBOptionsAttributes(const DBOptionsAttributes *attr)
{
    DBOptionsAttributesObject *newObject;
    newObject = PyObject_NEW(DBOptionsAttributesObject, &DBOptionsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (DBOptionsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
DBOptionsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewDBOptionsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef DBOptionsAttributesMethods[] = {
    {"DBOptionsAttributes", DBOptionsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *DBOptionsAttributesObserver = 0;

std::string
PyDBOptionsAttributes_GetLogString()
{
    std::string s("DBOptionsAtts = DBOptionsAttributes()\n");
    if(currentAtts != 0)
        s += PyDBOptionsAttributes_ToString(currentAtts, "DBOptionsAtts.");
    return s;
}

static void
PyDBOptionsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    DBOptionsAttributes *atts = (DBOptionsAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("DBOptionsAtts = DBOptionsAttributes()\n");
        s += PyDBOptionsAttributes_ToString(currentAtts, "DBOptionsAtts.");
        cb(s);
    }
}

void
PyDBOptionsAttributes_StartUp(DBOptionsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyDBOptionsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(DBOptionsAttributesObserver == 0)
    {
        DBOptionsAttributesObserver = new ObserverToCallback(subj,
            PyDBOptionsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyDBOptionsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete DBOptionsAttributesObserver;
    DBOptionsAttributesObserver = 0;
}

PyMethodDef *
PyDBOptionsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return DBOptionsAttributesMethods;
}

bool
PyDBOptionsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &DBOptionsAttributesType);
}

DBOptionsAttributes *
PyDBOptionsAttributes_FromPyObject(PyObject *obj)
{
    DBOptionsAttributesObject *obj2 = (DBOptionsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyDBOptionsAttributes_New()
{
    return NewDBOptionsAttributes(0);
}

PyObject *
PyDBOptionsAttributes_Wrap(const DBOptionsAttributes *attr)
{
    return WrapDBOptionsAttributes(attr);
}

void
PyDBOptionsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    DBOptionsAttributesObject *obj2 = (DBOptionsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyDBOptionsAttributes_SetDefaults(const DBOptionsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new DBOptionsAttributes(*atts);
}

