/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyConstructDDFAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyConstructDDFAttributes
//
// Purpose: 
//   Attributes for constructing DDFs
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:04:08 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConstructDDFAttributes.
//
struct ConstructDDFAttributesObject
{
    PyObject_HEAD
    ConstructDDFAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewConstructDDFAttributes(int);

std::string
PyConstructDDFAttributes_ToString(const ConstructDDFAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sddfName = \"%s\"\n", prefix, atts->GetDdfName().c_str());
    str += tmpStr;
    {   const stringVector &varnames = atts->GetVarnames();
        SNPRINTF(tmpStr, 1000, "%svarnames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < varnames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", varnames[i].c_str());
            str += tmpStr;
            if(i < varnames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &ranges = atts->GetRanges();
        SNPRINTF(tmpStr, 1000, "%sranges = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < ranges.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", ranges[i]);
            str += tmpStr;
            if(i < ranges.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%scodomainName = \"%s\"\n", prefix, atts->GetCodomainName().c_str());
    str += tmpStr;
    const char *statisticalOperator_names = "Average, Minimum, Maximum, StandardDeviation, Variance, "
        "Percentile, Median, InterquartileRange, Sum, "
        "Count";
    switch (atts->GetStatisticalOperator())
    {
      case ConstructDDFAttributes::Average:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sAverage  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Minimum:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sMinimum  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Maximum:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sMaximum  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::StandardDeviation:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sStandardDeviation  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Variance:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sVariance  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Percentile:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sPercentile  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Median:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sMedian  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::InterquartileRange:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sInterquartileRange  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Sum:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sSum  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Count:
          SNPRINTF(tmpStr, 1000, "%sstatisticalOperator = %sCount  # %s\n", prefix, prefix, statisticalOperator_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%spercentile = %g\n", prefix, atts->GetPercentile());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sundefinedValue = %g\n", prefix, atts->GetUndefinedValue());
    str += tmpStr;
    const char *binningScheme_names = "Uniform, Unknown";
    switch (atts->GetBinningScheme())
    {
      case ConstructDDFAttributes::Uniform:
          SNPRINTF(tmpStr, 1000, "%sbinningScheme = %sUniform  # %s\n", prefix, prefix, binningScheme_names);
          str += tmpStr;
          break;
      case ConstructDDFAttributes::Unknown:
          SNPRINTF(tmpStr, 1000, "%sbinningScheme = %sUnknown  # %s\n", prefix, prefix, binningScheme_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const intVector &numSamples = atts->GetNumSamples();
        SNPRINTF(tmpStr, 1000, "%snumSamples = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numSamples.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numSamples[i]);
            str += tmpStr;
            if(i < numSamples.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetOverTime())
        SNPRINTF(tmpStr, 1000, "%soverTime = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soverTime = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStart = %d\n", prefix, atts->GetTimeStart());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeEnd = %d\n", prefix, atts->GetTimeEnd());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStride = %d\n", prefix, atts->GetTimeStride());
    str += tmpStr;
    return str;
}

static PyObject *
ConstructDDFAttributes_Notify(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetDdfName(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the ddfName in the object.
    obj->data->SetDdfName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetDdfName(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDdfName().c_str());
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetVarnames(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    stringVector  &vec = obj->data->GetVarnames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the varnames in the object as modified.
    obj->data->SelectVarnames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetVarnames(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the varnames.
    const stringVector &varnames = obj->data->GetVarnames();
    PyObject *retval = PyTuple_New(varnames.size());
    for(size_t i = 0; i < varnames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(varnames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetRanges(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    doubleVector  &vec = obj->data->GetRanges();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the ranges in the object as modified.
    obj->data->SelectRanges();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetRanges(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the ranges.
    const doubleVector &ranges = obj->data->GetRanges();
    PyObject *retval = PyTuple_New(ranges.size());
    for(size_t i = 0; i < ranges.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(ranges[i]));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetCodomainName(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the codomainName in the object.
    obj->data->SetCodomainName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetCodomainName(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCodomainName().c_str());
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetStatisticalOperator(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the statisticalOperator in the object.
    if(ival >= 0 && ival < 10)
        obj->data->SetStatisticalOperator(ConstructDDFAttributes::StatisticalOperator(ival));
    else
    {
        fprintf(stderr, "An invalid statisticalOperator value was given. "
                        "Valid values are in the range of [0,9]. "
                        "You can also use the following names: "
                        "Average, Minimum, Maximum, StandardDeviation, Variance, "
                        "Percentile, Median, InterquartileRange, Sum, "
                        "Count.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetStatisticalOperator(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStatisticalOperator()));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetPercentile(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the percentile in the object.
    obj->data->SetPercentile(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetPercentile(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPercentile());
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetUndefinedValue(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the undefinedValue in the object.
    obj->data->SetUndefinedValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetUndefinedValue(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUndefinedValue());
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetBinningScheme(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the binningScheme in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetBinningScheme(ConstructDDFAttributes::BinningScheme(ival));
    else
    {
        fprintf(stderr, "An invalid binningScheme value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Uniform, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetBinningScheme(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBinningScheme()));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetNumSamples(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    intVector  &vec = obj->data->GetNumSamples();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numSamples in the object as modified.
    obj->data->SelectNumSamples();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetNumSamples(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the numSamples.
    const intVector &numSamples = obj->data->GetNumSamples();
    PyObject *retval = PyTuple_New(numSamples.size());
    for(size_t i = 0; i < numSamples.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numSamples[i])));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetOverTime(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overTime in the object.
    obj->data->SetOverTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetOverTime(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOverTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetTimeStart(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStart in the object.
    obj->data->SetTimeStart((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetTimeStart(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStart()));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetTimeEnd(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeEnd in the object.
    obj->data->SetTimeEnd((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetTimeEnd(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeEnd()));
    return retval;
}

/*static*/ PyObject *
ConstructDDFAttributes_SetTimeStride(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStride in the object.
    obj->data->SetTimeStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDDFAttributes_GetTimeStride(PyObject *self, PyObject *args)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStride()));
    return retval;
}



static struct PyMethodDef ConstructDDFAttributes_methods[] = {
    {"Notify", ConstructDDFAttributes_Notify, METH_VARARGS},
    {"SetDdfName", ConstructDDFAttributes_SetDdfName, METH_VARARGS},
    {"GetDdfName", ConstructDDFAttributes_GetDdfName, METH_VARARGS},
    {"SetVarnames", ConstructDDFAttributes_SetVarnames, METH_VARARGS},
    {"GetVarnames", ConstructDDFAttributes_GetVarnames, METH_VARARGS},
    {"SetRanges", ConstructDDFAttributes_SetRanges, METH_VARARGS},
    {"GetRanges", ConstructDDFAttributes_GetRanges, METH_VARARGS},
    {"SetCodomainName", ConstructDDFAttributes_SetCodomainName, METH_VARARGS},
    {"GetCodomainName", ConstructDDFAttributes_GetCodomainName, METH_VARARGS},
    {"SetStatisticalOperator", ConstructDDFAttributes_SetStatisticalOperator, METH_VARARGS},
    {"GetStatisticalOperator", ConstructDDFAttributes_GetStatisticalOperator, METH_VARARGS},
    {"SetPercentile", ConstructDDFAttributes_SetPercentile, METH_VARARGS},
    {"GetPercentile", ConstructDDFAttributes_GetPercentile, METH_VARARGS},
    {"SetUndefinedValue", ConstructDDFAttributes_SetUndefinedValue, METH_VARARGS},
    {"GetUndefinedValue", ConstructDDFAttributes_GetUndefinedValue, METH_VARARGS},
    {"SetBinningScheme", ConstructDDFAttributes_SetBinningScheme, METH_VARARGS},
    {"GetBinningScheme", ConstructDDFAttributes_GetBinningScheme, METH_VARARGS},
    {"SetNumSamples", ConstructDDFAttributes_SetNumSamples, METH_VARARGS},
    {"GetNumSamples", ConstructDDFAttributes_GetNumSamples, METH_VARARGS},
    {"SetOverTime", ConstructDDFAttributes_SetOverTime, METH_VARARGS},
    {"GetOverTime", ConstructDDFAttributes_GetOverTime, METH_VARARGS},
    {"SetTimeStart", ConstructDDFAttributes_SetTimeStart, METH_VARARGS},
    {"GetTimeStart", ConstructDDFAttributes_GetTimeStart, METH_VARARGS},
    {"SetTimeEnd", ConstructDDFAttributes_SetTimeEnd, METH_VARARGS},
    {"GetTimeEnd", ConstructDDFAttributes_GetTimeEnd, METH_VARARGS},
    {"SetTimeStride", ConstructDDFAttributes_SetTimeStride, METH_VARARGS},
    {"GetTimeStride", ConstructDDFAttributes_GetTimeStride, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConstructDDFAttributes_dealloc(PyObject *v)
{
   ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ConstructDDFAttributes_compare(PyObject *v, PyObject *w)
{
    ConstructDDFAttributes *a = ((ConstructDDFAttributesObject *)v)->data;
    ConstructDDFAttributes *b = ((ConstructDDFAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
ConstructDDFAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "ddfName") == 0)
        return ConstructDDFAttributes_GetDdfName(self, NULL);
    if(strcmp(name, "varnames") == 0)
        return ConstructDDFAttributes_GetVarnames(self, NULL);
    if(strcmp(name, "ranges") == 0)
        return ConstructDDFAttributes_GetRanges(self, NULL);
    if(strcmp(name, "codomainName") == 0)
        return ConstructDDFAttributes_GetCodomainName(self, NULL);
    if(strcmp(name, "statisticalOperator") == 0)
        return ConstructDDFAttributes_GetStatisticalOperator(self, NULL);
    if(strcmp(name, "Average") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Average));
    if(strcmp(name, "Minimum") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Minimum));
    if(strcmp(name, "Maximum") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Maximum));
    if(strcmp(name, "StandardDeviation") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::StandardDeviation));
    if(strcmp(name, "Variance") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Variance));
    if(strcmp(name, "Percentile") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Percentile));
    if(strcmp(name, "Median") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Median));
    if(strcmp(name, "InterquartileRange") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::InterquartileRange));
    if(strcmp(name, "Sum") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Sum));
    if(strcmp(name, "Count") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Count));

    if(strcmp(name, "percentile") == 0)
        return ConstructDDFAttributes_GetPercentile(self, NULL);
    if(strcmp(name, "undefinedValue") == 0)
        return ConstructDDFAttributes_GetUndefinedValue(self, NULL);
    if(strcmp(name, "binningScheme") == 0)
        return ConstructDDFAttributes_GetBinningScheme(self, NULL);
    if(strcmp(name, "Uniform") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Uniform));
    if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(ConstructDDFAttributes::Unknown));

    if(strcmp(name, "numSamples") == 0)
        return ConstructDDFAttributes_GetNumSamples(self, NULL);
    if(strcmp(name, "overTime") == 0)
        return ConstructDDFAttributes_GetOverTime(self, NULL);
    if(strcmp(name, "timeStart") == 0)
        return ConstructDDFAttributes_GetTimeStart(self, NULL);
    if(strcmp(name, "timeEnd") == 0)
        return ConstructDDFAttributes_GetTimeEnd(self, NULL);
    if(strcmp(name, "timeStride") == 0)
        return ConstructDDFAttributes_GetTimeStride(self, NULL);

    return Py_FindMethod(ConstructDDFAttributes_methods, self, name);
}

static int
ConstructDDFAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "ddfName") == 0)
        obj = ConstructDDFAttributes_SetDdfName(self, tuple);
    else if(strcmp(name, "varnames") == 0)
        obj = ConstructDDFAttributes_SetVarnames(self, tuple);
    else if(strcmp(name, "ranges") == 0)
        obj = ConstructDDFAttributes_SetRanges(self, tuple);
    else if(strcmp(name, "codomainName") == 0)
        obj = ConstructDDFAttributes_SetCodomainName(self, tuple);
    else if(strcmp(name, "statisticalOperator") == 0)
        obj = ConstructDDFAttributes_SetStatisticalOperator(self, tuple);
    else if(strcmp(name, "percentile") == 0)
        obj = ConstructDDFAttributes_SetPercentile(self, tuple);
    else if(strcmp(name, "undefinedValue") == 0)
        obj = ConstructDDFAttributes_SetUndefinedValue(self, tuple);
    else if(strcmp(name, "binningScheme") == 0)
        obj = ConstructDDFAttributes_SetBinningScheme(self, tuple);
    else if(strcmp(name, "numSamples") == 0)
        obj = ConstructDDFAttributes_SetNumSamples(self, tuple);
    else if(strcmp(name, "overTime") == 0)
        obj = ConstructDDFAttributes_SetOverTime(self, tuple);
    else if(strcmp(name, "timeStart") == 0)
        obj = ConstructDDFAttributes_SetTimeStart(self, tuple);
    else if(strcmp(name, "timeEnd") == 0)
        obj = ConstructDDFAttributes_SetTimeEnd(self, tuple);
    else if(strcmp(name, "timeStride") == 0)
        obj = ConstructDDFAttributes_SetTimeStride(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
ConstructDDFAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)v;
    fprintf(fp, "%s", PyConstructDDFAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ConstructDDFAttributes_str(PyObject *v)
{
    ConstructDDFAttributesObject *obj = (ConstructDDFAttributesObject *)v;
    return PyString_FromString(PyConstructDDFAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ConstructDDFAttributes_Purpose = "Attributes for constructing DDFs";
#else
static char *ConstructDDFAttributes_Purpose = "Attributes for constructing DDFs";
#endif

//
// The type description structure
//
static PyTypeObject ConstructDDFAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConstructDDFAttributes",                    // tp_name
    sizeof(ConstructDDFAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConstructDDFAttributes_dealloc,  // tp_dealloc
    (printfunc)ConstructDDFAttributes_print,     // tp_print
    (getattrfunc)ConstructDDFAttributes_getattr, // tp_getattr
    (setattrfunc)ConstructDDFAttributes_setattr, // tp_setattr
    (cmpfunc)ConstructDDFAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ConstructDDFAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConstructDDFAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConstructDDFAttributes *defaultAtts = 0;
static ConstructDDFAttributes *currentAtts = 0;

static PyObject *
NewConstructDDFAttributes(int useCurrent)
{
    ConstructDDFAttributesObject *newObject;
    newObject = PyObject_NEW(ConstructDDFAttributesObject, &ConstructDDFAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ConstructDDFAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ConstructDDFAttributes(*defaultAtts);
    else
        newObject->data = new ConstructDDFAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapConstructDDFAttributes(const ConstructDDFAttributes *attr)
{
    ConstructDDFAttributesObject *newObject;
    newObject = PyObject_NEW(ConstructDDFAttributesObject, &ConstructDDFAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConstructDDFAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConstructDDFAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewConstructDDFAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConstructDDFAttributesMethods[] = {
    {"ConstructDDFAttributes", ConstructDDFAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConstructDDFAttributesObserver = 0;

std::string
PyConstructDDFAttributes_GetLogString()
{
    std::string s("ConstructDDFAtts = ConstructDDFAttributes()\n");
    if(currentAtts != 0)
        s += PyConstructDDFAttributes_ToString(currentAtts, "ConstructDDFAtts.");
    return s;
}

static void
PyConstructDDFAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ConstructDDFAttributes *atts = (ConstructDDFAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ConstructDDFAtts = ConstructDDFAttributes()\n");
        s += PyConstructDDFAttributes_ToString(currentAtts, "ConstructDDFAtts.");
        cb(s);
    }
}

void
PyConstructDDFAttributes_StartUp(ConstructDDFAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyConstructDDFAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConstructDDFAttributesObserver == 0)
    {
        ConstructDDFAttributesObserver = new ObserverToCallback(subj,
            PyConstructDDFAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyConstructDDFAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConstructDDFAttributesObserver;
    ConstructDDFAttributesObserver = 0;
}

PyMethodDef *
PyConstructDDFAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConstructDDFAttributesMethods;
}

bool
PyConstructDDFAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConstructDDFAttributesType);
}

ConstructDDFAttributes *
PyConstructDDFAttributes_FromPyObject(PyObject *obj)
{
    ConstructDDFAttributesObject *obj2 = (ConstructDDFAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConstructDDFAttributes_New()
{
    return NewConstructDDFAttributes(0);
}

PyObject *
PyConstructDDFAttributes_Wrap(const ConstructDDFAttributes *attr)
{
    return WrapConstructDDFAttributes(attr);
}

void
PyConstructDDFAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ConstructDDFAttributesObject *obj2 = (ConstructDDFAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyConstructDDFAttributes_SetDefaults(const ConstructDDFAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConstructDDFAttributes(*atts);
}

