/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAxisTitles.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyFontAttributes.h>

// ****************************************************************************
// Module: PyAxisTitles
//
// Purpose: 
//   Contains the title properties for one axis.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:04:05 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a AxisTitles.
//
struct AxisTitlesObject
{
    PyObject_HEAD
    AxisTitles *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxisTitles(int);

std::string
PyAxisTitles_ToString(const AxisTitles *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetVisible())
        SNPRINTF(tmpStr, 1000, "%svisible = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%svisible = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "font.";
        str += PyFontAttributes_ToString(&atts->GetFont(), objPrefix.c_str());
    }
    if(atts->GetUserTitle())
        SNPRINTF(tmpStr, 1000, "%suserTitle = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suserTitle = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUserUnits())
        SNPRINTF(tmpStr, 1000, "%suserUnits = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suserUnits = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stitle = \"%s\"\n", prefix, atts->GetTitle().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sunits = \"%s\"\n", prefix, atts->GetUnits().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
AxisTitles_Notify(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_SetVisible(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetVisible(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AxisTitles_SetFont(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The font field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetFont(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetFont(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetFont());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AxisTitles_SetUserTitle(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userTitle in the object.
    obj->data->SetUserTitle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetUserTitle(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserTitle()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AxisTitles_SetUserUnits(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userUnits in the object.
    obj->data->SetUserUnits(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetUserUnits(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserUnits()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AxisTitles_SetTitle(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the title in the object.
    obj->data->SetTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetTitle(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTitle().c_str());
    return retval;
}

/*static*/ PyObject *
AxisTitles_SetUnits(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the units in the object.
    obj->data->SetUnits(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTitles_GetUnits(PyObject *self, PyObject *args)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetUnits().c_str());
    return retval;
}



static struct PyMethodDef AxisTitles_methods[] = {
    {"Notify", AxisTitles_Notify, METH_VARARGS},
    {"SetVisible", AxisTitles_SetVisible, METH_VARARGS},
    {"GetVisible", AxisTitles_GetVisible, METH_VARARGS},
    {"SetFont", AxisTitles_SetFont, METH_VARARGS},
    {"GetFont", AxisTitles_GetFont, METH_VARARGS},
    {"SetUserTitle", AxisTitles_SetUserTitle, METH_VARARGS},
    {"GetUserTitle", AxisTitles_GetUserTitle, METH_VARARGS},
    {"SetUserUnits", AxisTitles_SetUserUnits, METH_VARARGS},
    {"GetUserUnits", AxisTitles_GetUserUnits, METH_VARARGS},
    {"SetTitle", AxisTitles_SetTitle, METH_VARARGS},
    {"GetTitle", AxisTitles_GetTitle, METH_VARARGS},
    {"SetUnits", AxisTitles_SetUnits, METH_VARARGS},
    {"GetUnits", AxisTitles_GetUnits, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AxisTitles_dealloc(PyObject *v)
{
   AxisTitlesObject *obj = (AxisTitlesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AxisTitles_compare(PyObject *v, PyObject *w)
{
    AxisTitles *a = ((AxisTitlesObject *)v)->data;
    AxisTitles *b = ((AxisTitlesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
AxisTitles_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return AxisTitles_GetVisible(self, NULL);
    if(strcmp(name, "font") == 0)
        return AxisTitles_GetFont(self, NULL);
    if(strcmp(name, "userTitle") == 0)
        return AxisTitles_GetUserTitle(self, NULL);
    if(strcmp(name, "userUnits") == 0)
        return AxisTitles_GetUserUnits(self, NULL);
    if(strcmp(name, "title") == 0)
        return AxisTitles_GetTitle(self, NULL);
    if(strcmp(name, "units") == 0)
        return AxisTitles_GetUnits(self, NULL);

    return Py_FindMethod(AxisTitles_methods, self, name);
}

static int
AxisTitles_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "visible") == 0)
        obj = AxisTitles_SetVisible(self, tuple);
    else if(strcmp(name, "font") == 0)
        obj = AxisTitles_SetFont(self, tuple);
    else if(strcmp(name, "userTitle") == 0)
        obj = AxisTitles_SetUserTitle(self, tuple);
    else if(strcmp(name, "userUnits") == 0)
        obj = AxisTitles_SetUserUnits(self, tuple);
    else if(strcmp(name, "title") == 0)
        obj = AxisTitles_SetTitle(self, tuple);
    else if(strcmp(name, "units") == 0)
        obj = AxisTitles_SetUnits(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
AxisTitles_print(PyObject *v, FILE *fp, int flags)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)v;
    fprintf(fp, "%s", PyAxisTitles_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AxisTitles_str(PyObject *v)
{
    AxisTitlesObject *obj = (AxisTitlesObject *)v;
    return PyString_FromString(PyAxisTitles_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AxisTitles_Purpose = "Contains the title properties for one axis.";
#else
static char *AxisTitles_Purpose = "Contains the title properties for one axis.";
#endif

//
// The type description structure
//
static PyTypeObject AxisTitlesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AxisTitles",                    // tp_name
    sizeof(AxisTitlesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AxisTitles_dealloc,  // tp_dealloc
    (printfunc)AxisTitles_print,     // tp_print
    (getattrfunc)AxisTitles_getattr, // tp_getattr
    (setattrfunc)AxisTitles_setattr, // tp_setattr
    (cmpfunc)AxisTitles_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AxisTitles_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AxisTitles_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AxisTitles *defaultAtts = 0;
static AxisTitles *currentAtts = 0;

static PyObject *
NewAxisTitles(int useCurrent)
{
    AxisTitlesObject *newObject;
    newObject = PyObject_NEW(AxisTitlesObject, &AxisTitlesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AxisTitles(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AxisTitles(*defaultAtts);
    else
        newObject->data = new AxisTitles;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxisTitles(const AxisTitles *attr)
{
    AxisTitlesObject *newObject;
    newObject = PyObject_NEW(AxisTitlesObject, &AxisTitlesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AxisTitles *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AxisTitles_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxisTitles(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AxisTitlesMethods[] = {
    {"AxisTitles", AxisTitles_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AxisTitlesObserver = 0;

std::string
PyAxisTitles_GetLogString()
{
    std::string s("AxisTitles = AxisTitles()\n");
    if(currentAtts != 0)
        s += PyAxisTitles_ToString(currentAtts, "AxisTitles.");
    return s;
}

static void
PyAxisTitles_CallLogRoutine(Subject *subj, void *data)
{
    AxisTitles *atts = (AxisTitles *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AxisTitles = AxisTitles()\n");
        s += PyAxisTitles_ToString(currentAtts, "AxisTitles.");
        cb(s);
    }
}

void
PyAxisTitles_StartUp(AxisTitles *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxisTitles_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AxisTitlesObserver == 0)
    {
        AxisTitlesObserver = new ObserverToCallback(subj,
            PyAxisTitles_CallLogRoutine, (void *)data);
    }

}

void
PyAxisTitles_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AxisTitlesObserver;
    AxisTitlesObserver = 0;
}

PyMethodDef *
PyAxisTitles_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AxisTitlesMethods;
}

bool
PyAxisTitles_Check(PyObject *obj)
{
    return (obj->ob_type == &AxisTitlesType);
}

AxisTitles *
PyAxisTitles_FromPyObject(PyObject *obj)
{
    AxisTitlesObject *obj2 = (AxisTitlesObject *)obj;
    return obj2->data;
}

PyObject *
PyAxisTitles_New()
{
    return NewAxisTitles(0);
}

PyObject *
PyAxisTitles_Wrap(const AxisTitles *attr)
{
    return WrapAxisTitles(attr);
}

void
PyAxisTitles_SetParent(PyObject *obj, PyObject *parent)
{
    AxisTitlesObject *obj2 = (AxisTitlesObject *)obj;
    obj2->parent = parent;
}

void
PyAxisTitles_SetDefaults(const AxisTitles *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AxisTitles(*atts);
}

