/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAxisAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyAxisTitles.h>
#include <PyAxisLabels.h>
#include <PyAxisTickMarks.h>

// ****************************************************************************
// Module: PyAxisAttributes
//
// Purpose: 
//   Contains the properties for one axis.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:53 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a AxisAttributes.
//
struct AxisAttributesObject
{
    PyObject_HEAD
    AxisAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxisAttributes(int);

std::string
PyAxisAttributes_ToString(const AxisAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "title.";
        str += PyAxisTitles_ToString(&atts->GetTitle(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "label.";
        str += PyAxisLabels_ToString(&atts->GetLabel(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "tickMarks.";
        str += PyAxisTickMarks_ToString(&atts->GetTickMarks(), objPrefix.c_str());
    }
    if(atts->GetGrid())
        SNPRINTF(tmpStr, 1000, "%sgrid = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sgrid = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
AxisAttributes_Notify(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAttributes_SetTitle(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxisTitles_Check(newValue))
    {
        fprintf(stderr, "The title field can only be set with AxisTitles objects.\n");
        return NULL;
    }

    obj->data->SetTitle(*PyAxisTitles_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAttributes_GetTitle(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxisTitles_Wrap(&obj->data->GetTitle());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxisTitles_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AxisAttributes_SetLabel(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxisLabels_Check(newValue))
    {
        fprintf(stderr, "The label field can only be set with AxisLabels objects.\n");
        return NULL;
    }

    obj->data->SetLabel(*PyAxisLabels_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAttributes_GetLabel(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxisLabels_Wrap(&obj->data->GetLabel());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxisLabels_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AxisAttributes_SetTickMarks(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxisTickMarks_Check(newValue))
    {
        fprintf(stderr, "The tickMarks field can only be set with AxisTickMarks objects.\n");
        return NULL;
    }

    obj->data->SetTickMarks(*PyAxisTickMarks_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAttributes_GetTickMarks(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxisTickMarks_Wrap(&obj->data->GetTickMarks());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxisTickMarks_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AxisAttributes_SetGrid(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the grid in the object.
    obj->data->SetGrid(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAttributes_GetGrid(PyObject *self, PyObject *args)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetGrid()?1L:0L);
    return retval;
}



static struct PyMethodDef AxisAttributes_methods[] = {
    {"Notify", AxisAttributes_Notify, METH_VARARGS},
    {"SetTitle", AxisAttributes_SetTitle, METH_VARARGS},
    {"GetTitle", AxisAttributes_GetTitle, METH_VARARGS},
    {"SetLabel", AxisAttributes_SetLabel, METH_VARARGS},
    {"GetLabel", AxisAttributes_GetLabel, METH_VARARGS},
    {"SetTickMarks", AxisAttributes_SetTickMarks, METH_VARARGS},
    {"GetTickMarks", AxisAttributes_GetTickMarks, METH_VARARGS},
    {"SetGrid", AxisAttributes_SetGrid, METH_VARARGS},
    {"GetGrid", AxisAttributes_GetGrid, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AxisAttributes_dealloc(PyObject *v)
{
   AxisAttributesObject *obj = (AxisAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AxisAttributes_compare(PyObject *v, PyObject *w)
{
    AxisAttributes *a = ((AxisAttributesObject *)v)->data;
    AxisAttributes *b = ((AxisAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
AxisAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "title") == 0)
        return AxisAttributes_GetTitle(self, NULL);
    if(strcmp(name, "label") == 0)
        return AxisAttributes_GetLabel(self, NULL);
    if(strcmp(name, "tickMarks") == 0)
        return AxisAttributes_GetTickMarks(self, NULL);
    if(strcmp(name, "grid") == 0)
        return AxisAttributes_GetGrid(self, NULL);

    return Py_FindMethod(AxisAttributes_methods, self, name);
}

static int
AxisAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "title") == 0)
        obj = AxisAttributes_SetTitle(self, tuple);
    else if(strcmp(name, "label") == 0)
        obj = AxisAttributes_SetLabel(self, tuple);
    else if(strcmp(name, "tickMarks") == 0)
        obj = AxisAttributes_SetTickMarks(self, tuple);
    else if(strcmp(name, "grid") == 0)
        obj = AxisAttributes_SetGrid(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
AxisAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)v;
    fprintf(fp, "%s", PyAxisAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AxisAttributes_str(PyObject *v)
{
    AxisAttributesObject *obj = (AxisAttributesObject *)v;
    return PyString_FromString(PyAxisAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AxisAttributes_Purpose = "Contains the properties for one axis.";
#else
static char *AxisAttributes_Purpose = "Contains the properties for one axis.";
#endif

//
// The type description structure
//
static PyTypeObject AxisAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AxisAttributes",                    // tp_name
    sizeof(AxisAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AxisAttributes_dealloc,  // tp_dealloc
    (printfunc)AxisAttributes_print,     // tp_print
    (getattrfunc)AxisAttributes_getattr, // tp_getattr
    (setattrfunc)AxisAttributes_setattr, // tp_setattr
    (cmpfunc)AxisAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AxisAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AxisAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AxisAttributes *defaultAtts = 0;
static AxisAttributes *currentAtts = 0;

static PyObject *
NewAxisAttributes(int useCurrent)
{
    AxisAttributesObject *newObject;
    newObject = PyObject_NEW(AxisAttributesObject, &AxisAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AxisAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AxisAttributes(*defaultAtts);
    else
        newObject->data = new AxisAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxisAttributes(const AxisAttributes *attr)
{
    AxisAttributesObject *newObject;
    newObject = PyObject_NEW(AxisAttributesObject, &AxisAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AxisAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AxisAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxisAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AxisAttributesMethods[] = {
    {"AxisAttributes", AxisAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AxisAttributesObserver = 0;

std::string
PyAxisAttributes_GetLogString()
{
    std::string s("AxisAtts = AxisAttributes()\n");
    if(currentAtts != 0)
        s += PyAxisAttributes_ToString(currentAtts, "AxisAtts.");
    return s;
}

static void
PyAxisAttributes_CallLogRoutine(Subject *subj, void *data)
{
    AxisAttributes *atts = (AxisAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AxisAtts = AxisAttributes()\n");
        s += PyAxisAttributes_ToString(currentAtts, "AxisAtts.");
        cb(s);
    }
}

void
PyAxisAttributes_StartUp(AxisAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxisAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AxisAttributesObserver == 0)
    {
        AxisAttributesObserver = new ObserverToCallback(subj,
            PyAxisAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyAxisAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AxisAttributesObserver;
    AxisAttributesObserver = 0;
}

PyMethodDef *
PyAxisAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AxisAttributesMethods;
}

bool
PyAxisAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AxisAttributesType);
}

AxisAttributes *
PyAxisAttributes_FromPyObject(PyObject *obj)
{
    AxisAttributesObject *obj2 = (AxisAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAxisAttributes_New()
{
    return NewAxisAttributes(0);
}

PyObject *
PyAxisAttributes_Wrap(const AxisAttributes *attr)
{
    return WrapAxisAttributes(attr);
}

void
PyAxisAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    AxisAttributesObject *obj2 = (AxisAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyAxisAttributes_SetDefaults(const AxisAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AxisAttributes(*atts);
}

