/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLineObject.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyLineObject
//
// Purpose: 
//   Line Annotation Object
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Sep 1 14:56:14 PST 2004
//
// Modifications:
//
//   Hank Childs, Wed Jun 14 17:37:03 PDT 2006
//   Call UpdateAnnotationsHelper more often (this will cause "Set..." calls
//   to actually go to the viewer).
//
// ****************************************************************************

/* CUSTOM - Functions that we need in visitmodule.C */
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);

//
// This struct contains the Python type information and a LineObject.
//
struct LineObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewLineObject();

static PyObject *
LineObject_Notify(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_SetVisible(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetVisible(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

static PyObject *
LineObject_SetActive(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetActive(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
LineObject_SetPosition(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    double *dvals = obj->data->GetPosition();
/* CUSTOM - Had to make position dd, not ddd. */
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetPosition(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(3);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position[i])));
    return retval;
}

static PyObject *
LineObject_SetPosition2(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    double *dvals = obj->data->GetPosition2();
/* CUSTOM - Had to make position dd, not ddd. */
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position2 in the object as modified.
    obj->data->SelectPosition2();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetPosition2(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position2.
    PyObject *retval = PyTuple_New(3);
    const double *position2 = obj->data->GetPosition2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position2[i])));
    return retval;
}

static PyObject *
LineObject_SetWidth(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
/* CUSTOM */
    obj->data->GetColor2().SetRed(ival);
    //obj->data->SetWidth(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetWidth(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor2().Red()));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetWidth()));
    return retval;
}

static PyObject *
LineObject_SetColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
/* CUSTOM */
    obj->data->SetColor1(ca);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetColor(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}

static PyObject *
LineObject_SetOpacity(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacity in the object.
/* CUSTOM */
    obj->data->GetColor1().SetAlpha(ival);
    //obj->data->SetOpacity(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetOpacity(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor1().Alpha()));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacity()));
    return retval;
}

static PyObject *
LineObject_SetBeginArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the beginArrow in the object.
/* CUSTOM */
    obj->data->GetColor2().SetGreen(ival);
    //obj->data->SetBeginArrow(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetBeginArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor2().Green()));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetBeginArrow()));
    return retval;
}

static PyObject *
LineObject_SetEndArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the endArrow in the object.
/* CUSTOM */
    obj->data->GetColor2().SetBlue(ival);
    //obj->data->SetEndArrow(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LineObject_GetEndArrow(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColor2().Blue()));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetEndArrow()));
    return retval;
}

/* CUSTOM - Added this... */
static PyObject *
LineObject_Delete(PyObject *self, PyObject *args)
{
    LineObjectObject *obj = (LineObjectObject *)self;

    // Tell the VisIt module to decrement the reference count for the
    // AnnotationObject pointed to by obj->data. If there are no more
    // references, this object will own it.
    obj->owns = DeleteAnnotationObjectHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef LineObject_methods[] = {
    {"Notify", LineObject_Notify, METH_VARARGS},
    {"SetVisible", LineObject_SetVisible, METH_VARARGS},
    {"GetVisible", LineObject_GetVisible, METH_VARARGS},
    {"SetActive", LineObject_SetActive, METH_VARARGS},
    {"GetActive", LineObject_GetActive, METH_VARARGS},
    {"SetPosition", LineObject_SetPosition, METH_VARARGS},
    {"GetPosition", LineObject_GetPosition, METH_VARARGS},
    {"SetPosition2", LineObject_SetPosition2, METH_VARARGS},
    {"GetPosition2", LineObject_GetPosition2, METH_VARARGS},
    {"SetWidth", LineObject_SetWidth, METH_VARARGS},
    {"GetWidth", LineObject_GetWidth, METH_VARARGS},
    {"SetColor", LineObject_SetColor, METH_VARARGS},
    {"GetColor", LineObject_GetColor, METH_VARARGS},
    {"SetOpacity", LineObject_SetOpacity, METH_VARARGS},
    {"GetOpacity", LineObject_GetOpacity, METH_VARARGS},
    {"SetBeginArrow", LineObject_SetBeginArrow, METH_VARARGS},
    {"GetBeginArrow", LineObject_GetBeginArrow, METH_VARARGS},
    {"SetEndArrow", LineObject_SetEndArrow, METH_VARARGS},
    {"GetEndArrow", LineObject_GetEndArrow, METH_VARARGS},
/* CUSTOM - Added this... */
    {"Delete", LineObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LineObject_dealloc(PyObject *v)
{
   LineObjectObject *obj = (LineObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
LineObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((LineObjectObject *)v)->data;
    AnnotationObject *b = ((LineObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
LineObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return LineObject_GetVisible(self, NULL);
    if(strcmp(name, "active") == 0)
        return LineObject_GetActive(self, NULL);
    if(strcmp(name, "position") == 0)
        return LineObject_GetPosition(self, NULL);
    if(strcmp(name, "position2") == 0)
        return LineObject_GetPosition2(self, NULL);
    if(strcmp(name, "width") == 0)
        return LineObject_GetWidth(self, NULL);
    if(strcmp(name, "color") == 0)
        return LineObject_GetColor(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return LineObject_GetOpacity(self, NULL);
    if(strcmp(name, "beginArrow") == 0)
        return LineObject_GetBeginArrow(self, NULL);
    if(strcmp(name, "endArrow") == 0)
        return LineObject_GetEndArrow(self, NULL);

    return Py_FindMethod(LineObject_methods, self, name);
}

static int
LineObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "visible") == 0)
        retval = (LineObject_SetVisible(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (LineObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "position") == 0)
        retval = (LineObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "position2") == 0)
        retval = (LineObject_SetPosition2(self, tuple) != NULL);
    else if(strcmp(name, "width") == 0)
        retval = (LineObject_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "color") == 0)
        retval = (LineObject_SetColor(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (LineObject_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "beginArrow") == 0)
        retval = (LineObject_SetBeginArrow(self, tuple) != NULL);
    else if(strcmp(name, "endArrow") == 0)
        retval = (LineObject_SetEndArrow(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
LineObject_print(PyObject *v, FILE *fp, int flags)
{
    LineObjectObject *obj = (LineObjectObject *)v;

    if(obj->data->GetVisible())
        fprintf(fp, "visible = 1\n");
    else
        fprintf(fp, "visible = 0\n");
    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");
    {   const double *position = obj->data->GetPosition();
        fprintf(fp, "position = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", position[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *position2 = obj->data->GetPosition2();
        fprintf(fp, "position2 = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", position2[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
/* CUSTOM - Next few lines. */
    fprintf(fp, "width = %d\n", obj->data->GetColor2().Red());
    const unsigned char *color = obj->data->GetColor1().GetColor();
    fprintf(fp, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    fprintf(fp, "opacity = %d\n", obj->data->GetColor1().Alpha());
    fprintf(fp, "beginArrow = %d\n", obj->data->GetColor2().Green());
    fprintf(fp, "endArrow = %d\n", obj->data->GetColor2().Blue());

    return 0;
}

#include <snprintf.h>
PyObject *
PyLineObject_StringRepresentation(const AnnotationObject *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *objectType_names = "Text2D, Text3D, TimeSlider, Line2D, Arrow2D, Arrow3D, Box, Image";
    if(atts->GetObjectType() == AnnotationObject::Text2D)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Text2D  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::Text3D)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Text3D  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::TimeSlider)
        {
             SNPRINTF(tmpStr, 1000, "objectType = TimeSlider  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::Line2D)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Line2D  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::Arrow2D)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Arrow2D  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::Arrow3D)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Arrow3D  # %s\n", objectType_names);
             str += tmpStr;
        }
    else if(atts->GetObjectType() == AnnotationObject::Box)
        {
             SNPRINTF(tmpStr, 1000, "objectType = Box  # %s\n", objectType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "objectType = Image  # %s\n", objectType_names);
             str += tmpStr;
        }

    if(atts->GetVisible())
        SNPRINTF(tmpStr, 1000, "visible = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "visible = 0\n");
    str += tmpStr;
    if(atts->GetActive())
        SNPRINTF(tmpStr, 1000, "active = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "active = 0\n");
    str += tmpStr;
    {   const double *position = atts->GetPosition();
        SNPRINTF(tmpStr, 1000, "position = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", position[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *position2 = atts->GetPosition2();
        SNPRINTF(tmpStr, 1000, "position2 = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", position2[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
/* CUSTOM - Next few lines. */
    SNPRINTF(tmpStr, 1000, "width = %d\n", atts->GetColor2().Red());
    str += tmpStr;
    const unsigned char *color = atts->GetColor1().GetColor();
    SNPRINTF(tmpStr, 1000, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "opacity = %d\n", atts->GetColor1().Alpha());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "beginArrow = %d\n", atts->GetColor2().Green());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "endArrow = %d\n", atts->GetColor2().Blue());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
LineObject_str(PyObject *v)
{
    LineObjectObject *obj = (LineObjectObject *)v;
    return PyLineObject_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LineObject_Purpose = "Line Annotation Object";
#else
static char *LineObject_Purpose = "Line Annotation Object";
#endif

//
// The type description structure
//
static PyTypeObject LineObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LineObject",                    // tp_name
    sizeof(LineObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LineObject_dealloc,  // tp_dealloc
    (printfunc)LineObject_print,     // tp_print
    (getattrfunc)LineObject_getattr, // tp_getattr
    (setattrfunc)LineObject_setattr, // tp_setattr
    (cmpfunc)LineObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LineObject_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LineObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AnnotationObject *defaultAtts = 0;

static PyObject *
NewLineObject()
{
    LineObjectObject *newObject;
    newObject = PyObject_NEW(LineObjectObject, &LineObjectType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new AnnotationObject(*defaultAtts);
    else
        newObject->data = new AnnotationObject;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapLineObject(const AnnotationObject *attr)
{
    LineObjectObject *newObject;
    newObject = PyObject_NEW(LineObjectObject, &LineObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AnnotationObject *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LineObject_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewLineObject();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LineObjectMethods[] = {
    {"LineObject", LineObject_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LineObjectObserver = 0;
static bool LineObjectEnableLogging = true;

static void
PyLineObject_WriteLog(Subject *subj, void *data)
{
    AnnotationObject *atts = (AnnotationObject *)subj;
    FILE *logFile = (FILE *)data;

    if(!LineObjectEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# LineObject_WriteLog()\n");
}

void
PyLineObject_StartUp(AnnotationObject *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyLineObject_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LineObjectObserver == 0)
    {
        LineObjectObserver = new ObserverToCallback(subj,
            PyLineObject_WriteLog, (void *)logFile);
    }

    LineObjectEnableLogging = true;
}

void
PyLineObject_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LineObjectObserver;
    LineObjectObserver = 0;
}

PyMethodDef *
PyLineObject_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LineObjectMethods;
}

bool
PyLineObject_Check(PyObject *obj)
{
    return (obj->ob_type == &LineObjectType);
}

AnnotationObject *
PyLineObject_FromPyObject(PyObject *obj)
{
    LineObjectObject *obj2 = (LineObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyLineObject_NewPyObject()
{
    return NewLineObject();
}

PyObject *
PyLineObject_WrapPyObject(const AnnotationObject *attr)
{
    return WrapLineObject(attr);
}

void
PyLineObject_SetLogging(bool val)
{
    LineObjectEnableLogging = val;
}

void
PyLineObject_SetDefaults(const AnnotationObject *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AnnotationObject(*atts);
}
