/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLegendAttributesObject.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>
#include <legend_defines.h>

// Functions that we need in visitmodule.C
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);


//
// Helper functions to get bits out of the annotation attributes.
//

bool
GetBool(const AnnotationObject *annot, int bit)
{
    return (annot->GetIntAttribute1() & (1 << bit)) != 0;
}

void
SetBool(AnnotationObject *annot, int bit, bool val)
{
    int shifted = (1 << bit);
    int mask = ~shifted;
    int data = annot->GetIntAttribute1();
    annot->SetIntAttribute1((data & mask) | (val ? shifted : 0));
}

#define SETGET_FLAG(NAME, BIT)\
static PyObject *\
LegendAttributesObject_Set##NAME(PyObject *self, PyObject *args)\
{\
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;\
    int ival;\
    if(!PyArg_ParseTuple(args, "i", &ival))\
        return NULL;\
    SetBool(obj->data, BIT, ival!=0);\
    UpdateAnnotationHelper(obj->data);\
    Py_INCREF(Py_None);\
    return Py_None;\
}\
\
static PyObject *\
LegendAttributesObject_Get##NAME(PyObject *self, PyObject *args)\
{\
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;\
    PyObject *retval = PyInt_FromLong(GetBool(obj->data,BIT)?1L:0L);\
    return retval;\
}

// ****************************************************************************
// Module: PyLegendAttributesObject
//
// Purpose: 
//   This class is a Python wrapper arround AnnotationObject that makes it
//   look like a Text2D object.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Dec 4 09:53:48 PDT 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a LegendAttributesObject.
//
struct LegendAttributesObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewLegendAttributesObject();

static PyObject *
LegendAttributesObject_SetActive(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetActive(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
LegendAttributesObject_SetPosition(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    double *dvals = obj->data->GetPosition();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetPosition(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(2);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position[i])));
    return retval;
}

static PyObject *
LegendAttributesObject_SetXScale(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the width in the object.
/*CUSTOM*/
    double *pos2 = obj->data->GetPosition2();
    pos2[0] = dval;
    obj->data->SelectPosition2();
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetXScale(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
/*CUSTOM*/
    double *pos2 = obj->data->GetPosition2();
    PyObject *retval = PyFloat_FromDouble(double(pos2[0]));
    return retval;
}

static PyObject *
LegendAttributesObject_SetYScale(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the width in the object.
/*CUSTOM*/
    double *pos2 = obj->data->GetPosition2();
    pos2[1] = dval;
    obj->data->SelectPosition2();
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetYScale(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
/*CUSTOM*/
    double *pos2 = obj->data->GetPosition2();
    PyObject *retval = PyFloat_FromDouble(double(pos2[1]));
    return retval;
}

static PyObject *
LegendAttributesObject_SetTextColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the textColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTextColor(ca);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetTextColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the textColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *textColor = obj->data->GetTextColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(textColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(textColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(textColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(textColor[3])));
    return retval;
}

static PyObject *
LegendAttributesObject_SetBoundingBoxColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the Color1 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetColor1(ca);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetBoundingBoxColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the Color1.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *Color1 = obj->data->GetColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(Color1[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(Color1[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(Color1[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(Color1[3])));
    return retval;
}

static PyObject *
LegendAttributesObject_SetUseForegroundForTextColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundForTextColor in the object.
    obj->data->SetUseForegroundForTextColor(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetUseForegroundForTextColor(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundForTextColor()?1L:0L);
    return retval;
}

static PyObject *
LegendAttributesObject_SetNumberFormat(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the number format in the object.
/*CUSTOM*/
    stringVector s; s.push_back(str);
    obj->data->SetText(s);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetNumberFormat(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
/*CUSTOM*/
    const stringVector &s = obj->data->GetText();
    PyObject *retval = PyString_FromString(s.size() > 0 ? s[0].c_str(): "");
    return retval;
}

static PyObject *
LegendAttributesObject_SetFontFamily(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fontFamily in the object.
    if(ival >= 0 && ival < 3)
    {
/*CUSTOM*/
        obj->data->SetFontFamily(AnnotationObject::FontFamily(ival));
        UpdateAnnotationHelper(obj->data);
    }
    else
    {
        fprintf(stderr, "An invalid fontFamily value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Arial, Courier, Times.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetFontFamily(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFontFamily()));
    return retval;
}

static PyObject *
LegendAttributesObject_SetFontBold(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fontBold in the object.
    obj->data->SetFontBold(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetFontBold(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFontBold()?1L:0L);
    return retval;
}

static PyObject *
LegendAttributesObject_SetFontItalic(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fontItalic in the object.
    obj->data->SetFontItalic(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetFontItalic(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFontItalic()?1L:0L);
    return retval;
}

static PyObject *
LegendAttributesObject_SetFontShadow(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fontShadow in the object.
    obj->data->SetFontShadow(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetFontShadow(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFontShadow()?1L:0L);
    return retval;
}

static PyObject *
LegendAttributesObject_SetFontHeight(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the font height in the object.
/*CUSTOM*/
    obj->data->SetDoubleAttribute1(dval);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetFontHeight(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
/*CUSTOM*/
    return PyFloat_FromDouble(obj->data->GetDoubleAttribute1());
}

// Create some set/get functions for the bits from IntAttribute1.
SETGET_FLAG(ManagePosition,  LEGEND_MANAGE_POSITION)
SETGET_FLAG(DrawBoundingBox, LEGEND_DRAW_BOX)
SETGET_FLAG(DrawTitle,       LEGEND_DRAW_TITLE)
SETGET_FLAG(DrawMinMax,      LEGEND_DRAW_MINMAX)
SETGET_FLAG(ControlTicks,    LEGEND_CONTROL_TICKS)
SETGET_FLAG(MinMaxInclusive, LEGEND_MINMAX_INCLUSIVE)


static PyObject *
LegendAttributesObject_SetOrientation(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    char *str;
    int oIndex = -1;
    if(PyArg_ParseTuple(args, "s", &str))
    {
        const char *oNames[] = {"VerticalRight", "VerticalLeft", "HorizontalTop", "HorizontalBottom"};
        for(int i = 0; i < 4; i++)
            if (strcmp(str, oNames[i])==0)
            {
                oIndex = i;
                break;
            }
    }
    else
    {
        if(PyArg_ParseTuple(args, "i", &oIndex))
            PyErr_Clear();
        else
            return NULL;
    }

    if (oIndex == 0)
    {
        SetBool(obj->data, LEGEND_ORIENTATION0, 0);
        SetBool(obj->data, LEGEND_ORIENTATION1, 0);
    }
    else if (oIndex == 1)
    {
        SetBool(obj->data, LEGEND_ORIENTATION0, 0);
        SetBool(obj->data, LEGEND_ORIENTATION1, 1);
    }
    else if (oIndex == 2)
    {
        SetBool(obj->data, LEGEND_ORIENTATION0, 1);
        SetBool(obj->data, LEGEND_ORIENTATION1, 0);
    }
    else if (oIndex == 3)
    {
        SetBool(obj->data, LEGEND_ORIENTATION0, 1);
        SetBool(obj->data, LEGEND_ORIENTATION1, 1);
    }
    else
        return NULL;
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}


static PyObject *
LegendAttributesObject_GetOrientation(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    PyObject *retval = NULL;
    int or0 = GetBool(obj->data, LEGEND_ORIENTATION0);
    int or1 = GetBool(obj->data, LEGEND_ORIENTATION1);

    if (!or0 && !or1)
        retval = PyInt_FromLong(0L); // VerticalRight
    else if (!or0 && or1)
        retval = PyInt_FromLong(1L); // VerticalLeft
    else if (or0 && !or1)
        retval = PyInt_FromLong(2L); // HorizontalTop
    else if (or0 && or1)
        retval = PyInt_FromLong(3L); // HorizontalBottom

    return retval;
}

static PyObject *
LegendAttributesObject_SetDrawLabels(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    char *str;
    int oIndex = -1;
    if(PyArg_ParseTuple(args, "s", &str))
    {
        const char *oNames[] = {"None", "Values", "Labels", "Both"};
        for(int i = 0; i < 4; i++)
            if (strcmp(str, oNames[i])==0)
            {
                oIndex = i;
                break;
            }
    }
    else
    {
        if(PyArg_ParseTuple(args, "i", &oIndex))
            PyErr_Clear();
        else
            return NULL;
    }

    if (oIndex == 0)
    {
        SetBool(obj->data, LEGEND_DRAW_VALUES, 0);
        SetBool(obj->data, LEGEND_DRAW_LABELS, 0);
    }
    else if (oIndex == 1)
    {
        SetBool(obj->data, LEGEND_DRAW_VALUES, 1);
        SetBool(obj->data, LEGEND_DRAW_LABELS, 0);
    }
    else if (oIndex == 2)
    {
        SetBool(obj->data, LEGEND_DRAW_VALUES, 0);
        SetBool(obj->data, LEGEND_DRAW_LABELS, 1);
    }
    else if (oIndex == 3)
    {
        SetBool(obj->data, LEGEND_DRAW_VALUES, 1);
        SetBool(obj->data, LEGEND_DRAW_LABELS, 1);
    }
    else
        return NULL;
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}


static PyObject *
LegendAttributesObject_GetDrawLabels(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    PyObject *retval = NULL;
    int dv = GetBool(obj->data, LEGEND_DRAW_VALUES);
    int dl = GetBool(obj->data, LEGEND_DRAW_LABELS);

    if (!dv && !dl)
        retval = PyInt_FromLong(0L); // None
    else if (dv && !dl)
        retval = PyInt_FromLong(1L); // Values
    else if (!dv && dl)
        retval = PyInt_FromLong(2L); // Labels
    else if (dv && dl)
        retval = PyInt_FromLong(3L); // Both

    return retval;
}

static PyObject *
LegendAttributesObject_SetNumTicks(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the number of ticks in the object.
/*CUSTOM*/
    obj->data->SetIntAttribute2(ival);
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetNumTicks(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
/*CUSTOM*/
    return PyInt_FromLong(obj->data->GetIntAttribute2());
}


static PyObject *
LegendAttributesObject_SetSuppliedValues(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    doubleVector &vec = obj->data->GetDoubleVector1(); 
    PyObject     *tuple;

    if (obj->data->GetIntAttribute3() != LEGEND_TYPE_VARIABLE)
    {
        cerr <<"   Cannot set suppliedValues for this type of legend." << endl;
        Py_INCREF(Py_None);
        return Py_None;
    }

    if (!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for (int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if (PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if (PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if (PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else 
                vec[i] = 0.;
        }
    }
   else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    obj->data->SetDoubleVector1(vec);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetSuppliedValues(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the suppliedValues.
    const doubleVector &suppliedValues = obj->data->GetDoubleVector1();
    PyObject *retval = PyTuple_New(suppliedValues.size());
    for (size_t i = 0; i < suppliedValues.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(suppliedValues[i]));
    return retval;
}

static PyObject *
LegendAttributesObject_SetSuppliedLabels(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;

    stringVector &vec = obj->data->GetStringVector1(); 
    PyObject     *tuple;

    if (!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for (int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if (PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else 
                vec[i] = std::string("");
        }
    }
   else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    obj->data->SetStringVector1(vec);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegendAttributesObject_GetSuppliedLabels(PyObject *self, PyObject *args)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the suppliedLabels.
    const stringVector &suppliedLabels = obj->data->GetStringVector1();
    PyObject *retval = PyTuple_New(suppliedLabels.size());
    for (size_t i = 0; i < suppliedLabels.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(suppliedLabels[i].c_str()));
    return retval;
}



static PyObject *
LegendAttributesObject_Delete(PyObject *self, PyObject *args)
{
    printf("Legend annotation objects cannot be deleted. If you want "
           "to delete the object, you can delete the plot that created it "
           "or turn the legend off via the plot attributes.\n");
    Py_INCREF(Py_None);
    return Py_None;
}


static struct PyMethodDef LegendAttributesObject_methods[] = {
    {"SetActive", LegendAttributesObject_SetActive, METH_VARARGS},
    {"GetActive", LegendAttributesObject_GetActive, METH_VARARGS},
    {"SetPosition", LegendAttributesObject_SetPosition, METH_VARARGS},
    {"GetPosition", LegendAttributesObject_GetPosition, METH_VARARGS},
    {"SetXScale", LegendAttributesObject_SetXScale, METH_VARARGS},
    {"GetXScale", LegendAttributesObject_GetXScale, METH_VARARGS},
    {"SetYScale", LegendAttributesObject_SetYScale, METH_VARARGS},
    {"GetYScale", LegendAttributesObject_GetYScale, METH_VARARGS},
    {"SetTextColor", LegendAttributesObject_SetTextColor, METH_VARARGS},
    {"GetTextColor", LegendAttributesObject_GetTextColor, METH_VARARGS},
    {"SetBoundingBoxColor", LegendAttributesObject_SetBoundingBoxColor, METH_VARARGS},
    {"GetBoundingBoxColor", LegendAttributesObject_GetBoundingBoxColor, METH_VARARGS},
    {"SetUseForegroundForTextColor", LegendAttributesObject_SetUseForegroundForTextColor, METH_VARARGS},
    {"GetUseForegroundForTextColor", LegendAttributesObject_GetUseForegroundForTextColor, METH_VARARGS},
    {"SetNumberFormat", LegendAttributesObject_SetNumberFormat, METH_VARARGS},
    {"GetNumberFormat", LegendAttributesObject_GetNumberFormat, METH_VARARGS},
    {"SetFontFamily", LegendAttributesObject_SetFontFamily, METH_VARARGS},
    {"GetFontFamily", LegendAttributesObject_GetFontFamily, METH_VARARGS},
    {"SetFontBold", LegendAttributesObject_SetFontBold, METH_VARARGS},
    {"GetFontBold", LegendAttributesObject_GetFontBold, METH_VARARGS},
    {"SetFontItalic", LegendAttributesObject_SetFontItalic, METH_VARARGS},
    {"GetFontItalic", LegendAttributesObject_GetFontItalic, METH_VARARGS},
    {"SetFontShadow", LegendAttributesObject_SetFontShadow, METH_VARARGS},
    {"GetFontShadow", LegendAttributesObject_GetFontShadow, METH_VARARGS},
    {"SetFontHeight", LegendAttributesObject_SetFontHeight, METH_VARARGS},
    {"GetFontHeight", LegendAttributesObject_GetFontHeight, METH_VARARGS},
    {"SetManagePosition", LegendAttributesObject_SetManagePosition, METH_VARARGS},
    {"GetManagePosition", LegendAttributesObject_GetManagePosition, METH_VARARGS},
    {"SetDrawBoundingBox", LegendAttributesObject_SetDrawBoundingBox, METH_VARARGS},
    {"GetDrawBoundingBox", LegendAttributesObject_GetDrawBoundingBox, METH_VARARGS},
    {"SetDrawLabels", LegendAttributesObject_SetDrawLabels, METH_VARARGS},
    {"GetDrawLabels", LegendAttributesObject_GetDrawLabels, METH_VARARGS},
    {"SetDrawTitle", LegendAttributesObject_SetDrawTitle, METH_VARARGS},
    {"GetDrawTitle", LegendAttributesObject_GetDrawTitle, METH_VARARGS},
    {"SetOrientation", LegendAttributesObject_SetOrientation, METH_VARARGS},
    {"GetOrientation", LegendAttributesObject_GetOrientation, METH_VARARGS},
    {"SetDrawMinMax", LegendAttributesObject_SetDrawMinMax, METH_VARARGS},
    {"GetDrawMinMax", LegendAttributesObject_GetDrawMinMax, METH_VARARGS},
    {"SetControlTicks", LegendAttributesObject_SetControlTicks, METH_VARARGS},
    {"GetControlTicks", LegendAttributesObject_GetControlTicks, METH_VARARGS},
    {"SetMinMaxInclusive", LegendAttributesObject_SetMinMaxInclusive, METH_VARARGS},
    {"GetMinMaxInclusive", LegendAttributesObject_GetMinMaxInclusive, METH_VARARGS},
    {"SetNumTicks", LegendAttributesObject_SetNumTicks, METH_VARARGS},
    {"GetNumTicks", LegendAttributesObject_GetNumTicks, METH_VARARGS},
    {"SetSuppliedValues", LegendAttributesObject_SetSuppliedValues, METH_VARARGS},
    {"GetSuppliedValues", LegendAttributesObject_GetSuppliedValues, METH_VARARGS},
    {"SetSuppliedLabels", LegendAttributesObject_SetSuppliedLabels, METH_VARARGS},
    {"GetSuppliedLabels", LegendAttributesObject_GetSuppliedLabels, METH_VARARGS},
    {"Delete", LegendAttributesObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LegendAttributesObject_dealloc(PyObject *v)
{
   LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
LegendAttributesObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((LegendAttributesObjectObject *)v)->data;
    AnnotationObject *b = ((LegendAttributesObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
LegendAttributesObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "active") == 0)
        return LegendAttributesObject_GetActive(self, NULL);
    if(strcmp(name, "position") == 0)
        return LegendAttributesObject_GetPosition(self, NULL);
    if(strcmp(name, "xScale") == 0)
        return LegendAttributesObject_GetXScale(self, NULL);
    if(strcmp(name, "yScale") == 0)
        return LegendAttributesObject_GetYScale(self, NULL);
    if(strcmp(name, "textColor") == 0)
        return LegendAttributesObject_GetTextColor(self, NULL);
    if(strcmp(name, "boundingBoxColor") == 0)
        return LegendAttributesObject_GetBoundingBoxColor(self, NULL);
    if(strcmp(name, "useForegroundForTextColor") == 0)
        return LegendAttributesObject_GetUseForegroundForTextColor(self, NULL);
    if(strcmp(name, "numberFormat") == 0)
        return LegendAttributesObject_GetNumberFormat(self, NULL);
    if(strcmp(name, "fontFamily") == 0)
        return LegendAttributesObject_GetFontFamily(self, NULL);
    if(strcmp(name, "Arial") == 0)
        return PyInt_FromLong(long(AnnotationObject::Arial));
    else if(strcmp(name, "Courier") == 0)
        return PyInt_FromLong(long(AnnotationObject::Courier));
    else if(strcmp(name, "Times") == 0)
        return PyInt_FromLong(long(AnnotationObject::Times));

    if(strcmp(name, "fontBold") == 0)
        return LegendAttributesObject_GetFontBold(self, NULL);
    if(strcmp(name, "fontItalic") == 0)
        return LegendAttributesObject_GetFontItalic(self, NULL);
    if(strcmp(name, "fontShadow") == 0)
        return LegendAttributesObject_GetFontShadow(self, NULL);
    if(strcmp(name, "fontHeight") == 0)
        return LegendAttributesObject_GetFontHeight(self, NULL);

    if(strcmp(name, "managePosition") == 0)
        return LegendAttributesObject_GetManagePosition(self, NULL);
    if(strcmp(name, "drawBoundingBox") == 0)
        return LegendAttributesObject_GetDrawBoundingBox(self, NULL);
    if(strcmp(name, "drawLabels") == 0)
        return LegendAttributesObject_GetDrawLabels(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(0L);
    else if(strcmp(name, "Values") == 0)
        return PyInt_FromLong(1L);
    else if(strcmp(name, "Labels") == 0)
        return PyInt_FromLong(2L);
    else if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(3L);

    if(strcmp(name, "drawTitle") == 0)
        return LegendAttributesObject_GetDrawTitle(self, NULL);
    if(strcmp(name, "drawMinMax") == 0)
        return LegendAttributesObject_GetDrawMinMax(self, NULL);

    if(strcmp(name, "orientation") == 0)
        return LegendAttributesObject_GetOrientation(self, NULL);
    if(strcmp(name, "VerticalRight") == 0)
        return PyInt_FromLong(0L);
    else if(strcmp(name, "VerticalLeft") == 0)
        return PyInt_FromLong(1L);
    else if(strcmp(name, "HorizontalTop") == 0)
        return PyInt_FromLong(2L);
    else if(strcmp(name, "HorizontalBottom") == 0)
        return PyInt_FromLong(3L);

    if(strcmp(name, "controlTicks") == 0)
        return LegendAttributesObject_GetControlTicks(self, NULL);
    if(strcmp(name, "minMaxInclusive") == 0)
        return LegendAttributesObject_GetMinMaxInclusive(self, NULL);
    if(strcmp(name, "numTicks") == 0)
        return LegendAttributesObject_GetNumTicks(self, NULL);
    if(strcmp(name, "suppliedValues") == 0)
        return LegendAttributesObject_GetSuppliedValues(self, NULL);
    if(strcmp(name, "suppliedLabels") == 0)
        return LegendAttributesObject_GetSuppliedLabels(self, NULL);

    return Py_FindMethod(LegendAttributesObject_methods, self, name);
}

static int
LegendAttributesObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "active") == 0)
        retval = (LegendAttributesObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "position") == 0)
        retval = (LegendAttributesObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "xScale") == 0)
        retval = (LegendAttributesObject_SetXScale(self, tuple) != NULL);
    else if(strcmp(name, "yScale") == 0)
        retval = (LegendAttributesObject_SetYScale(self, tuple) != NULL);
    else if(strcmp(name, "textColor") == 0)
        retval = (LegendAttributesObject_SetTextColor(self, tuple) != NULL);
    else if(strcmp(name, "boundingBoxColor") == 0)
        retval = (LegendAttributesObject_SetBoundingBoxColor(self, tuple) != NULL);
    else if(strcmp(name, "useForegroundForTextColor") == 0)
        retval = (LegendAttributesObject_SetUseForegroundForTextColor(self, tuple) != NULL);
    else if(strcmp(name, "numberFormat") == 0)
        retval = (LegendAttributesObject_SetNumberFormat(self, tuple) != NULL);
    else if(strcmp(name, "fontFamily") == 0)
        retval = (LegendAttributesObject_SetFontFamily(self, tuple) != NULL);
    else if(strcmp(name, "fontBold") == 0)
        retval = (LegendAttributesObject_SetFontBold(self, tuple) != NULL);
    else if(strcmp(name, "fontItalic") == 0)
        retval = (LegendAttributesObject_SetFontItalic(self, tuple) != NULL);
    else if(strcmp(name, "fontShadow") == 0)
        retval = (LegendAttributesObject_SetFontShadow(self, tuple) != NULL);
    else if(strcmp(name, "fontHeight") == 0)
        retval = (LegendAttributesObject_SetFontHeight(self, tuple) != NULL);
    else if(strcmp(name, "managePosition") == 0)
        retval = (LegendAttributesObject_SetManagePosition(self, tuple) != NULL);
    else if(strcmp(name, "drawBoundingBox") == 0)
        retval = (LegendAttributesObject_SetDrawBoundingBox(self, tuple) != NULL);
    else if(strcmp(name, "drawLabels") == 0)
        retval = (LegendAttributesObject_SetDrawLabels(self, tuple) != NULL);
    else if(strcmp(name, "drawTitle") == 0)
        retval = (LegendAttributesObject_SetDrawTitle(self, tuple) != NULL);
    else if(strcmp(name, "drawMinMax") == 0)
        retval = (LegendAttributesObject_SetDrawMinMax(self, tuple) != NULL);
    else if(strcmp(name, "orientation") == 0)
        retval = (LegendAttributesObject_SetOrientation(self, tuple) != NULL);
    else if(strcmp(name, "controlTicks") == 0)
        retval = (LegendAttributesObject_SetControlTicks(self, tuple) != NULL);
    else if(strcmp(name, "minMaxInclusive") == 0)
        retval = (LegendAttributesObject_SetMinMaxInclusive(self, tuple) != NULL);
    else if(strcmp(name, "numTicks") == 0)
        retval = (LegendAttributesObject_SetNumTicks(self, tuple) != NULL);
    else if(strcmp(name, "suppliedValues") == 0)
        retval = (LegendAttributesObject_SetSuppliedValues(self, tuple) != NULL);
    else if(strcmp(name, "suppliedLabels") == 0)
        retval = (LegendAttributesObject_SetSuppliedLabels(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
LegendAttributesObject_print(PyObject *v, FILE *fp, int flags)
{
    LegendAttributesObjectObject *obj = (LegendAttributesObjectObject *)v;

    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");

    fprintf(fp, "managePosition = %d\n", 
        GetBool(obj->data, LEGEND_MANAGE_POSITION)?1:0);

/*CUSTOM*/
    {   const double *position = obj->data->GetPosition();
        fprintf(fp, "position = (%g, %g)\n", position[0], position[1]);
    }
    const double *position2 = obj->data->GetPosition2();
    fprintf(fp, "xScale = %g\n", position2[0]);
    fprintf(fp, "yScale = %g\n", position2[1]);
    const unsigned char *textColor = obj->data->GetTextColor().GetColor();
    fprintf(fp, "textColor = (%d, %d, %d, %d)\n", int(textColor[0]), int(textColor[1]), int(textColor[2]), int(textColor[3]));
    if(obj->data->GetUseForegroundForTextColor())
        fprintf(fp, "useForegroundForTextColor = 1\n");
    else
        fprintf(fp, "useForegroundForTextColor = 0\n");

    fprintf(fp, "drawBoundingBox = %d\n", 
        GetBool(obj->data, LEGEND_DRAW_BOX)?1:0);
    const unsigned char *bboxColor = obj->data->GetColor1().GetColor();
    fprintf(fp, "boundingBoxColor = (%d, %d, %d, %d)\n", int(bboxColor[0]), int(bboxColor[1]), int(bboxColor[2]), int(bboxColor[3]));

    const stringVector &s = obj->data->GetText();
    fprintf(fp, "numberFormat = \"%s\"\n", s.size() > 0 ? s[0].c_str() : "");
    const char *fontFamily_names = "Arial, Courier, Times";
    if(obj->data->GetFontFamily() == AnnotationObject::Arial)
        fprintf(fp, "fontFamily = Arial  # %s\n", fontFamily_names);
    else if(obj->data->GetFontFamily() == AnnotationObject::Courier)
        fprintf(fp, "fontFamily = Courier  # %s\n", fontFamily_names);
    else
        fprintf(fp, "fontFamily = Times  # %s\n", fontFamily_names);

    if(obj->data->GetFontBold())
        fprintf(fp, "fontBold = 1\n");
    else
        fprintf(fp, "fontBold = 0\n");
    if(obj->data->GetFontItalic())
        fprintf(fp, "fontItalic = 1\n");
    else
        fprintf(fp, "fontItalic = 0\n");
    if(obj->data->GetFontShadow())
        fprintf(fp, "fontShadow = 1\n");
    else
        fprintf(fp, "fontShadow = 0\n");

    fprintf(fp, "fontHeight = %g\n", 
            obj->data->GetDoubleAttribute1());

    const char *drawLabelNames = "None, Values, Labels, Both";
    if (!GetBool(obj->data, LEGEND_DRAW_VALUES))
      if (!GetBool(obj->data, LEGEND_DRAW_LABELS))
          fprintf(fp, "drawLabels = None # %s\n", drawLabelNames);
      else 
          fprintf(fp, "drawLabels = Labels # %s\n", drawLabelNames);
    else 
      if (!GetBool(obj->data, LEGEND_DRAW_LABELS))
          fprintf(fp, "drawLabels = Values # %s\n", drawLabelNames);
      else 
          fprintf(fp, "drawLabels = Both # %s\n", drawLabelNames);

    fprintf(fp, "drawTitle = %d\n", 
        GetBool(obj->data, LEGEND_DRAW_TITLE)?1:0);

    fprintf(fp, "drawMinMax = %d\n", 
        GetBool(obj->data, LEGEND_DRAW_MINMAX)?1:0);

    const char *orientationNames = "VerticalRight, VerticalLeft, HorizontalTop, HorizontalBottom";
    if (!GetBool(obj->data, LEGEND_ORIENTATION0))
        if (!GetBool(obj->data, LEGEND_ORIENTATION1))
            fprintf(fp, "orientation = VerticalRight  # %s\n", orientationNames); 
        else
            fprintf(fp, "orientation = VerticalLeft  # %s\n", orientationNames); 
    else
        if (!GetBool(obj->data, LEGEND_ORIENTATION1))
            fprintf(fp, "orientation = HorizontalTop  # %s\n", orientationNames); 
        else
            fprintf(fp, "orientation = HorizontalBottom  # %s\n", orientationNames); 

    fprintf(fp, "controlTicks = %d\n", 
            GetBool(obj->data, LEGEND_CONTROL_TICKS)?1:0);
    fprintf(fp, "numTicks = %d\n", 
            obj->data->GetIntAttribute2());
    fprintf(fp, "minMaxInclusive = %d\n", 
            GetBool(obj->data, LEGEND_MINMAX_INCLUSIVE)?1:0);

    if (obj->data->GetIntAttribute3() == LEGEND_TYPE_VARIABLE)
    {
        const doubleVector & sv = obj->data->GetDoubleVector1();
        fprintf(fp, "suppliedValues = (");
        for (size_t i = 0; i < sv.size(); ++i)
        {
            if (i < sv.size() -1)
                fprintf(fp, "%g, ", sv[i]);
            else
                fprintf(fp, "%g", sv[i]);
        }
        fprintf(fp, ")\n");
    }
    else
    {
        const stringVector & sl = obj->data->GetStringVector2();
        fprintf(fp, "suppliedValues = (");
        for (size_t i = 0; i < sl.size(); ++i)
        {
            if (i < sl.size() -1)
                fprintf(fp, "%s, ", sl[i].c_str());
            else
                fprintf(fp, "%s", sl[i].c_str());
        }
        fprintf(fp, ")\n");
    }

    const stringVector & sl = obj->data->GetStringVector1();
    fprintf(fp, "suppliedLabels = (");
    for (size_t i = 0; i < sl.size(); ++i)
    {
        if (i < sl.size() -1)
            fprintf(fp, "%s, ", sl[i].c_str());
        else
            fprintf(fp, "%s", sl[i].c_str());
    }
    fprintf(fp, ")\n");

    return 0;
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LegendAttributesObject_Purpose = "This class defines defines an interface to a legend annotation object.";
#else
static char *LegendAttributesObject_Purpose = "This class defines defines an interface to a legend annotation object.";
#endif

//
// The type description structure
//
static PyTypeObject LegendAttributesObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LegendAttributesObject",                    // tp_name
    sizeof(LegendAttributesObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LegendAttributesObject_dealloc,  // tp_dealloc
    (printfunc)LegendAttributesObject_print,     // tp_print
    (getattrfunc)LegendAttributesObject_getattr, // tp_getattr
    (setattrfunc)LegendAttributesObject_setattr, // tp_setattr
    (cmpfunc)LegendAttributesObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LegendAttributesObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PyObject *
NewLegendAttributesObject()
{
    LegendAttributesObjectObject *newObject;
    newObject = PyObject_NEW(LegendAttributesObjectObject, &LegendAttributesObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = new AnnotationObject;
    newObject->data->SetObjectType(AnnotationObject::LegendAttributes);
    newObject->owns = true;

    return (PyObject *)newObject;
}

static PyObject *
WrapLegendAttributesObject(AnnotationObject *annot)
{
    LegendAttributesObjectObject *newObject;
    newObject = PyObject_NEW(LegendAttributesObjectObject, &LegendAttributesObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = annot;
    newObject->owns = false;

    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

bool
PyLegendAttributesObject_Check(PyObject *obj)
{
    return (obj->ob_type == &LegendAttributesObjectType);
}

AnnotationObject *
PyLegendAttributesObject_FromPyObject(PyObject *obj)
{
    LegendAttributesObjectObject *obj2 = (LegendAttributesObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyLegendAttributesObject_NewPyObject()
{
    return NewLegendAttributesObject();
}

PyObject *
PyLegendAttributesObject_WrapPyObject(AnnotationObject *attr)
{
    return WrapLegendAttributesObject(attr);
}

