/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ViewerProperties.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Init utility for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerProperties::Init()
{
    nowin = false;
    windowFullScreen = 0;
    windowSmall = false;
    noConfig = false;
    defaultStereoToOn = false;
    useWindowMetrics = true;
    applicationLocale = "default";
    launchedByClient = false;
    suppressMessages = false;
    numEngineRestarts = 2;

    ViewerProperties::SelectAll();
}

// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Copy utility for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewerProperties::Copy(const ViewerProperties &obj)
{
    nowin = obj.nowin;
    windowBorders = obj.windowBorders;
    windowShift = obj.windowShift;
    windowPreShift = obj.windowPreShift;
    windowGeometry = obj.windowGeometry;
    windowFullScreen = obj.windowFullScreen;
    windowSmall = obj.windowSmall;
    noConfig = obj.noConfig;
    defaultStereoToOn = obj.defaultStereoToOn;
    useWindowMetrics = obj.useWindowMetrics;
    configurationFileName = obj.configurationFileName;
    applicationLocale = obj.applicationLocale;
    launchedByClient = obj.launchedByClient;
    suppressMessages = obj.suppressMessages;
    numEngineRestarts = obj.numEngineRestarts;

    ViewerProperties::SelectAll();
}

// Type map format string
const char *ViewerProperties::TypeMapFormatString = VIEWERPROPERTIES_TMFS;
const AttributeGroup::private_tmfs_t ViewerProperties::TmfsStruct = {VIEWERPROPERTIES_TMFS};


// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Default constructor for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties::ViewerProperties() : 
    AttributeSubject(ViewerProperties::TypeMapFormatString)
{
    ViewerProperties::Init();
}

// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Constructor for the derived classes of ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties::ViewerProperties(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerProperties::Init();
}

// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Copy constructor for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties::ViewerProperties(const ViewerProperties &obj) : 
    AttributeSubject(ViewerProperties::TypeMapFormatString)
{
    ViewerProperties::Copy(obj);
}

// ****************************************************************************
// Method: ViewerProperties::ViewerProperties
//
// Purpose: 
//   Copy constructor for derived classes of the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties::ViewerProperties(const ViewerProperties &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewerProperties::Copy(obj);
}

// ****************************************************************************
// Method: ViewerProperties::~ViewerProperties
//
// Purpose: 
//   Destructor for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties::~ViewerProperties()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewerProperties::operator = 
//
// Purpose: 
//   Assignment operator for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewerProperties& 
ViewerProperties::operator = (const ViewerProperties &obj)
{
    if (this == &obj) return *this;

    ViewerProperties::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewerProperties::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerProperties::operator == (const ViewerProperties &obj) const
{
    // Create the return value
    return ((nowin == obj.nowin) &&
            (windowBorders == obj.windowBorders) &&
            (windowShift == obj.windowShift) &&
            (windowPreShift == obj.windowPreShift) &&
            (windowGeometry == obj.windowGeometry) &&
            (windowFullScreen == obj.windowFullScreen) &&
            (windowSmall == obj.windowSmall) &&
            (noConfig == obj.noConfig) &&
            (defaultStereoToOn == obj.defaultStereoToOn) &&
            (useWindowMetrics == obj.useWindowMetrics) &&
            (configurationFileName == obj.configurationFileName) &&
            (applicationLocale == obj.applicationLocale) &&
            (launchedByClient == obj.launchedByClient) &&
            (suppressMessages == obj.suppressMessages) &&
            (numEngineRestarts == obj.numEngineRestarts));
}

// ****************************************************************************
// Method: ViewerProperties::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerProperties::operator != (const ViewerProperties &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewerProperties::TypeName
//
// Purpose: 
//   Type name method for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewerProperties::TypeName() const
{
    return "ViewerProperties";
}

// ****************************************************************************
// Method: ViewerProperties::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewerProperties::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewerProperties *tmp = (const ViewerProperties *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewerProperties::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerProperties::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewerProperties(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewerProperties::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewerProperties class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewerProperties::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewerProperties(*this);
    else
        retval = new ViewerProperties;

    return retval;
}

// ****************************************************************************
// Method: ViewerProperties::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewerProperties::SelectAll()
{
    Select(ID_nowin,                 (void *)&nowin);
    Select(ID_windowBorders,         (void *)&windowBorders);
    Select(ID_windowShift,           (void *)&windowShift);
    Select(ID_windowPreShift,        (void *)&windowPreShift);
    Select(ID_windowGeometry,        (void *)&windowGeometry);
    Select(ID_windowFullScreen,      (void *)&windowFullScreen);
    Select(ID_windowSmall,           (void *)&windowSmall);
    Select(ID_noConfig,              (void *)&noConfig);
    Select(ID_defaultStereoToOn,     (void *)&defaultStereoToOn);
    Select(ID_useWindowMetrics,      (void *)&useWindowMetrics);
    Select(ID_configurationFileName, (void *)&configurationFileName);
    Select(ID_applicationLocale,     (void *)&applicationLocale);
    Select(ID_launchedByClient,      (void *)&launchedByClient);
    Select(ID_suppressMessages,      (void *)&suppressMessages);
    Select(ID_numEngineRestarts,     (void *)&numEngineRestarts);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerProperties::SetNowin(bool nowin_)
{
    nowin = nowin_;
    Select(ID_nowin, (void *)&nowin);
}

void
ViewerProperties::SetWindowBorders(const std::string &windowBorders_)
{
    windowBorders = windowBorders_;
    Select(ID_windowBorders, (void *)&windowBorders);
}

void
ViewerProperties::SetWindowShift(const std::string &windowShift_)
{
    windowShift = windowShift_;
    Select(ID_windowShift, (void *)&windowShift);
}

void
ViewerProperties::SetWindowPreShift(const std::string &windowPreShift_)
{
    windowPreShift = windowPreShift_;
    Select(ID_windowPreShift, (void *)&windowPreShift);
}

void
ViewerProperties::SetWindowGeometry(const std::string &windowGeometry_)
{
    windowGeometry = windowGeometry_;
    Select(ID_windowGeometry, (void *)&windowGeometry);
}

void
ViewerProperties::SetWindowFullScreen(int windowFullScreen_)
{
    windowFullScreen = windowFullScreen_;
    Select(ID_windowFullScreen, (void *)&windowFullScreen);
}

void
ViewerProperties::SetWindowSmall(bool windowSmall_)
{
    windowSmall = windowSmall_;
    Select(ID_windowSmall, (void *)&windowSmall);
}

void
ViewerProperties::SetNoConfig(bool noConfig_)
{
    noConfig = noConfig_;
    Select(ID_noConfig, (void *)&noConfig);
}

void
ViewerProperties::SetDefaultStereoToOn(bool defaultStereoToOn_)
{
    defaultStereoToOn = defaultStereoToOn_;
    Select(ID_defaultStereoToOn, (void *)&defaultStereoToOn);
}

void
ViewerProperties::SetUseWindowMetrics(bool useWindowMetrics_)
{
    useWindowMetrics = useWindowMetrics_;
    Select(ID_useWindowMetrics, (void *)&useWindowMetrics);
}

void
ViewerProperties::SetConfigurationFileName(const std::string &configurationFileName_)
{
    configurationFileName = configurationFileName_;
    Select(ID_configurationFileName, (void *)&configurationFileName);
}

void
ViewerProperties::SetApplicationLocale(const std::string &applicationLocale_)
{
    applicationLocale = applicationLocale_;
    Select(ID_applicationLocale, (void *)&applicationLocale);
}

void
ViewerProperties::SetLaunchedByClient(bool launchedByClient_)
{
    launchedByClient = launchedByClient_;
    Select(ID_launchedByClient, (void *)&launchedByClient);
}

void
ViewerProperties::SetSuppressMessages(bool suppressMessages_)
{
    suppressMessages = suppressMessages_;
    Select(ID_suppressMessages, (void *)&suppressMessages);
}

void
ViewerProperties::SetNumEngineRestarts(int numEngineRestarts_)
{
    numEngineRestarts = numEngineRestarts_;
    Select(ID_numEngineRestarts, (void *)&numEngineRestarts);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ViewerProperties::GetNowin() const
{
    return nowin;
}

const std::string &
ViewerProperties::GetWindowBorders() const
{
    return windowBorders;
}

std::string &
ViewerProperties::GetWindowBorders()
{
    return windowBorders;
}

const std::string &
ViewerProperties::GetWindowShift() const
{
    return windowShift;
}

std::string &
ViewerProperties::GetWindowShift()
{
    return windowShift;
}

const std::string &
ViewerProperties::GetWindowPreShift() const
{
    return windowPreShift;
}

std::string &
ViewerProperties::GetWindowPreShift()
{
    return windowPreShift;
}

const std::string &
ViewerProperties::GetWindowGeometry() const
{
    return windowGeometry;
}

std::string &
ViewerProperties::GetWindowGeometry()
{
    return windowGeometry;
}

int
ViewerProperties::GetWindowFullScreen() const
{
    return windowFullScreen;
}

bool
ViewerProperties::GetWindowSmall() const
{
    return windowSmall;
}

bool
ViewerProperties::GetNoConfig() const
{
    return noConfig;
}

bool
ViewerProperties::GetDefaultStereoToOn() const
{
    return defaultStereoToOn;
}

bool
ViewerProperties::GetUseWindowMetrics() const
{
    return useWindowMetrics;
}

const std::string &
ViewerProperties::GetConfigurationFileName() const
{
    return configurationFileName;
}

std::string &
ViewerProperties::GetConfigurationFileName()
{
    return configurationFileName;
}

const std::string &
ViewerProperties::GetApplicationLocale() const
{
    return applicationLocale;
}

std::string &
ViewerProperties::GetApplicationLocale()
{
    return applicationLocale;
}

bool
ViewerProperties::GetLaunchedByClient() const
{
    return launchedByClient;
}

bool
ViewerProperties::GetSuppressMessages() const
{
    return suppressMessages;
}

int
ViewerProperties::GetNumEngineRestarts() const
{
    return numEngineRestarts;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewerProperties::SelectWindowBorders()
{
    Select(ID_windowBorders, (void *)&windowBorders);
}

void
ViewerProperties::SelectWindowShift()
{
    Select(ID_windowShift, (void *)&windowShift);
}

void
ViewerProperties::SelectWindowPreShift()
{
    Select(ID_windowPreShift, (void *)&windowPreShift);
}

void
ViewerProperties::SelectWindowGeometry()
{
    Select(ID_windowGeometry, (void *)&windowGeometry);
}

void
ViewerProperties::SelectConfigurationFileName()
{
    Select(ID_configurationFileName, (void *)&configurationFileName);
}

void
ViewerProperties::SelectApplicationLocale()
{
    Select(ID_applicationLocale, (void *)&applicationLocale);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

