/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef WELLBOREATTRIBUTES_H
#define WELLBOREATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>
#include <ColorControlPointList.h>
#include <ColorAttribute.h>
#include <ColorAttributeList.h>

// ****************************************************************************
// Class: WellBoreAttributes
//
// Purpose:
//    This class contains the plot attributes for the well bore plot.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class WellBoreAttributes : public AttributeSubject
{
public:
    enum WellRenderingMode
    {
        Lines,
        Cylinders
    };
    enum DetailLevel
    {
        Low,
        Medium,
        High,
        Super
    };
    enum ColoringMethod
    {
        ColorBySingleColor,
        ColorByMultipleColors,
        ColorByColorTable
    };
    enum WellAnnotation
    {
        None,
        StemOnly,
        NameOnly,
        StemAndName
    };

    WellBoreAttributes();
    WellBoreAttributes(const WellBoreAttributes &obj);
    virtual ~WellBoreAttributes();

    virtual WellBoreAttributes& operator = (const WellBoreAttributes &obj);
    virtual bool operator == (const WellBoreAttributes &obj) const;
    virtual bool operator != (const WellBoreAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectDefaultPalette();
    void SelectChangedColors();
    void SelectColorTableName();
    void SelectSingleColor();
    void SelectMultiColor();
    void SelectWellBores();
    void SelectWellNames();

    // Property setting methods
    void SetDefaultPalette(const ColorControlPointList &defaultPalette_);
    void SetChangedColors(const unsignedCharVector &changedColors_);
    void SetColorType(ColoringMethod colorType_);
    void SetColorTableName(const std::string &colorTableName_);
    void SetSingleColor(const ColorAttribute &singleColor_);
    void SetMultiColor(const ColorAttributeList &multiColor_);
    void SetDrawWellsAs(WellRenderingMode drawWellsAs_);
    void SetWellCylinderQuality(DetailLevel wellCylinderQuality_);
    void SetWellRadius(float wellRadius_);
    void SetWellLineWidth(int wellLineWidth_);
    void SetWellLineStyle(int wellLineStyle_);
    void SetWellAnnotation(WellAnnotation wellAnnotation_);
    void SetWellStemHeight(float wellStemHeight_);
    void SetWellNameScale(float wellNameScale_);
    void SetLegendFlag(bool legendFlag_);
    void SetNWellBores(int nWellBores_);
    void SetWellBores(const intVector &wellBores_);
    void SetWellNames(const stringVector &wellNames_);

    // Property getting methods
    const ColorControlPointList &GetDefaultPalette() const;
          ColorControlPointList &GetDefaultPalette();
    const unsignedCharVector    &GetChangedColors() const;
          unsignedCharVector    &GetChangedColors();
    ColoringMethod              GetColorType() const;
    const std::string           &GetColorTableName() const;
          std::string           &GetColorTableName();
    const ColorAttribute        &GetSingleColor() const;
          ColorAttribute        &GetSingleColor();
    const ColorAttributeList    &GetMultiColor() const;
          ColorAttributeList    &GetMultiColor();
    WellRenderingMode           GetDrawWellsAs() const;
    DetailLevel                 GetWellCylinderQuality() const;
    float                       GetWellRadius() const;
    int                         GetWellLineWidth() const;
    int                         GetWellLineStyle() const;
    WellAnnotation              GetWellAnnotation() const;
    float                       GetWellStemHeight() const;
    float                       GetWellNameScale() const;
    bool                        GetLegendFlag() const;
    int                         GetNWellBores() const;
    const intVector             &GetWellBores() const;
          intVector             &GetWellBores();
    const stringVector          &GetWellNames() const;
          stringVector          &GetWellNames();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string WellRenderingMode_ToString(WellRenderingMode);
    static bool WellRenderingMode_FromString(const std::string &, WellRenderingMode &);
protected:
    static std::string WellRenderingMode_ToString(int);
public:
    static std::string DetailLevel_ToString(DetailLevel);
    static bool DetailLevel_FromString(const std::string &, DetailLevel &);
protected:
    static std::string DetailLevel_ToString(int);
public:
    static std::string ColoringMethod_ToString(ColoringMethod);
    static bool ColoringMethod_FromString(const std::string &, ColoringMethod &);
protected:
    static std::string ColoringMethod_ToString(int);
public:
    static std::string WellAnnotation_ToString(WellAnnotation);
    static bool WellAnnotation_FromString(const std::string &, WellAnnotation &);
protected:
    static std::string WellAnnotation_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void EnlargeMultiColor(int newSize);
    bool ColorIsChanged(int index) const;
    void MarkColorAsChanged(int index);
    bool ChangesRequireRecalculation(const WellBoreAttributes &);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_defaultPalette = 0,
        ID_changedColors,
        ID_colorType,
        ID_colorTableName,
        ID_singleColor,
        ID_multiColor,
        ID_drawWellsAs,
        ID_wellCylinderQuality,
        ID_wellRadius,
        ID_wellLineWidth,
        ID_wellLineStyle,
        ID_wellAnnotation,
        ID_wellStemHeight,
        ID_wellNameScale,
        ID_legendFlag,
        ID_nWellBores,
        ID_wellBores,
        ID_wellNames
    };

private:
    ColorControlPointList defaultPalette;
    unsignedCharVector    changedColors;
    int                   colorType;
    std::string           colorTableName;
    ColorAttribute        singleColor;
    ColorAttributeList    multiColor;
    int                   drawWellsAs;
    int                   wellCylinderQuality;
    float                 wellRadius;
    int                   wellLineWidth;
    int                   wellLineStyle;
    int                   wellAnnotation;
    float                 wellStemHeight;
    float                 wellNameScale;
    bool                  legendFlag;
    int                   nWellBores;
    intVector             wellBores;
    stringVector          wellNames;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
};

#endif
