/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TransferFunctionWidget.h>
#include <DataNode.h>

//
// Enum conversion methods for TransferFunctionWidget::WidgetType
//

static const char *WidgetType_strings[] = {
"Rectangle", "Triangle", "Paraboloid", 
"Ellipsoid"};

std::string
TransferFunctionWidget::WidgetType_ToString(TransferFunctionWidget::WidgetType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return WidgetType_strings[index];
}

std::string
TransferFunctionWidget::WidgetType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return WidgetType_strings[index];
}

bool
TransferFunctionWidget::WidgetType_FromString(const std::string &s, TransferFunctionWidget::WidgetType &val)
{
    val = TransferFunctionWidget::Rectangle;
    for(int i = 0; i < 4; ++i)
    {
        if(s == WidgetType_strings[i])
        {
            val = (WidgetType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Init utility for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TransferFunctionWidget::Init()
{
    Type = Rectangle;
    Name = "unnamed";
    BaseColor[0] = 1;
    BaseColor[1] = 1;
    BaseColor[2] = 1;
    BaseColor[3] = 1;
    Position[0] = 0;
    Position[1] = 0;
    Position[2] = 0;
    Position[3] = 0;
    Position[4] = 0;
    Position[5] = 0;
    Position[6] = 0;
    Position[7] = 0;

    TransferFunctionWidget::SelectAll();
}

// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Copy utility for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TransferFunctionWidget::Copy(const TransferFunctionWidget &obj)
{

    Type = obj.Type;
    Name = obj.Name;
    for(int i = 0; i < 4; ++i)
        BaseColor[i] = obj.BaseColor[i];

    for(int i = 0; i < 8; ++i)
        Position[i] = obj.Position[i];


    TransferFunctionWidget::SelectAll();
}

// Type map format string
const char *TransferFunctionWidget::TypeMapFormatString = TRANSFERFUNCTIONWIDGET_TMFS;
const AttributeGroup::private_tmfs_t TransferFunctionWidget::TmfsStruct = {TRANSFERFUNCTIONWIDGET_TMFS};


// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Default constructor for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget::TransferFunctionWidget() : 
    AttributeSubject(TransferFunctionWidget::TypeMapFormatString)
{
    TransferFunctionWidget::Init();
}

// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Constructor for the derived classes of TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget::TransferFunctionWidget(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TransferFunctionWidget::Init();
}

// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Copy constructor for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget::TransferFunctionWidget(const TransferFunctionWidget &obj) : 
    AttributeSubject(TransferFunctionWidget::TypeMapFormatString)
{
    TransferFunctionWidget::Copy(obj);
}

// ****************************************************************************
// Method: TransferFunctionWidget::TransferFunctionWidget
//
// Purpose: 
//   Copy constructor for derived classes of the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget::TransferFunctionWidget(const TransferFunctionWidget &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TransferFunctionWidget::Copy(obj);
}

// ****************************************************************************
// Method: TransferFunctionWidget::~TransferFunctionWidget
//
// Purpose: 
//   Destructor for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget::~TransferFunctionWidget()
{
    // nothing here
}

// ****************************************************************************
// Method: TransferFunctionWidget::operator = 
//
// Purpose: 
//   Assignment operator for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TransferFunctionWidget& 
TransferFunctionWidget::operator = (const TransferFunctionWidget &obj)
{
    if (this == &obj) return *this;

    TransferFunctionWidget::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TransferFunctionWidget::operator == 
//
// Purpose: 
//   Comparison operator == for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TransferFunctionWidget::operator == (const TransferFunctionWidget &obj) const
{
    // Compare the BaseColor arrays.
    bool BaseColor_equal = true;
    for(int i = 0; i < 4 && BaseColor_equal; ++i)
        BaseColor_equal = (BaseColor[i] == obj.BaseColor[i]);

    // Compare the Position arrays.
    bool Position_equal = true;
    for(int i = 0; i < 8 && Position_equal; ++i)
        Position_equal = (Position[i] == obj.Position[i]);

    // Create the return value
    return ((Type == obj.Type) &&
            (Name == obj.Name) &&
            BaseColor_equal &&
            Position_equal);
}

// ****************************************************************************
// Method: TransferFunctionWidget::operator != 
//
// Purpose: 
//   Comparison operator != for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TransferFunctionWidget::operator != (const TransferFunctionWidget &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TransferFunctionWidget::TypeName
//
// Purpose: 
//   Type name method for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TransferFunctionWidget::TypeName() const
{
    return "TransferFunctionWidget";
}

// ****************************************************************************
// Method: TransferFunctionWidget::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TransferFunctionWidget::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TransferFunctionWidget *tmp = (const TransferFunctionWidget *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TransferFunctionWidget::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TransferFunctionWidget::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TransferFunctionWidget(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TransferFunctionWidget::NewInstance
//
// Purpose: 
//   NewInstance method for the TransferFunctionWidget class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TransferFunctionWidget::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TransferFunctionWidget(*this);
    else
        retval = new TransferFunctionWidget;

    return retval;
}

// ****************************************************************************
// Method: TransferFunctionWidget::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TransferFunctionWidget::SelectAll()
{
    Select(ID_Type,      (void *)&Type);
    Select(ID_Name,      (void *)&Name);
    Select(ID_BaseColor, (void *)BaseColor, 4);
    Select(ID_Position,  (void *)Position, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TransferFunctionWidget::SetType(TransferFunctionWidget::WidgetType Type_)
{
    Type = Type_;
    Select(ID_Type, (void *)&Type);
}

void
TransferFunctionWidget::SetName(const std::string &Name_)
{
    Name = Name_;
    Select(ID_Name, (void *)&Name);
}

void
TransferFunctionWidget::SetBaseColor(const float *BaseColor_)
{
    BaseColor[0] = BaseColor_[0];
    BaseColor[1] = BaseColor_[1];
    BaseColor[2] = BaseColor_[2];
    BaseColor[3] = BaseColor_[3];
    Select(ID_BaseColor, (void *)BaseColor, 4);
}

void
TransferFunctionWidget::SetPosition(const float *Position_)
{
    for(int i = 0; i < 8; ++i)
        Position[i] = Position_[i];
    Select(ID_Position, (void *)Position, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

TransferFunctionWidget::WidgetType
TransferFunctionWidget::GetType() const
{
    return WidgetType(Type);
}

const std::string &
TransferFunctionWidget::GetName() const
{
    return Name;
}

std::string &
TransferFunctionWidget::GetName()
{
    return Name;
}

const float *
TransferFunctionWidget::GetBaseColor() const
{
    return BaseColor;
}

float *
TransferFunctionWidget::GetBaseColor()
{
    return BaseColor;
}

const float *
TransferFunctionWidget::GetPosition() const
{
    return Position;
}

float *
TransferFunctionWidget::GetPosition()
{
    return Position;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TransferFunctionWidget::SelectName()
{
    Select(ID_Name, (void *)&Name);
}

void
TransferFunctionWidget::SelectBaseColor()
{
    Select(ID_BaseColor, (void *)BaseColor, 4);
}

void
TransferFunctionWidget::SelectPosition()
{
    Select(ID_Position, (void *)Position, 8);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TransferFunctionWidget::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TransferFunctionWidget::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_Type:      return "Type";
    case ID_Name:      return "Name";
    case ID_BaseColor: return "BaseColor";
    case ID_Position:  return "Position";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TransferFunctionWidget::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TransferFunctionWidget::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_Type:      return FieldType_enum;
    case ID_Name:      return FieldType_string;
    case ID_BaseColor: return FieldType_floatArray;
    case ID_Position:  return FieldType_floatArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TransferFunctionWidget::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TransferFunctionWidget::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_Type:      return "enum";
    case ID_Name:      return "string";
    case ID_BaseColor: return "floatArray";
    case ID_Position:  return "floatArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TransferFunctionWidget::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TransferFunctionWidget::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TransferFunctionWidget &obj = *((const TransferFunctionWidget*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_Type:
        {  // new scope
        retval = (Type == obj.Type);
        }
        break;
    case ID_Name:
        {  // new scope
        retval = (Name == obj.Name);
        }
        break;
    case ID_BaseColor:
        {  // new scope
        // Compare the BaseColor arrays.
        bool BaseColor_equal = true;
        for(int i = 0; i < 4 && BaseColor_equal; ++i)
            BaseColor_equal = (BaseColor[i] == obj.BaseColor[i]);

        retval = BaseColor_equal;
        }
        break;
    case ID_Position:
        {  // new scope
        // Compare the Position arrays.
        bool Position_equal = true;
        for(int i = 0; i < 8 && Position_equal; ++i)
            Position_equal = (Position[i] == obj.Position[i]);

        retval = Position_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

