/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyVolumeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPointList.h>
#include <PyGaussianControlPointList.h>
#include <PyTransferFunctionWidget.h>

// ****************************************************************************
// Module: PyVolumeAttributes
//
// Purpose: 
//   This class contains the plot attributes for the volume plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a VolumeAttributes.
//
struct VolumeAttributesObject
{
    PyObject_HEAD
    VolumeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewVolumeAttributes(int);

std::string
PyVolumeAttributes_ToString(const VolumeAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "colorControlPoints.";
        str += PyColorControlPointList_ToString(&atts->GetColorControlPoints(), objPrefix.c_str());
    }
    SNPRINTF(tmpStr, 1000, "%sopacityAttenuation = %g\n", prefix, atts->GetOpacityAttenuation());
    str += tmpStr;
    const char *opacityMode_names = "FreeformMode, GaussianMode, ColorTableMode";
    switch (atts->GetOpacityMode())
    {
      case VolumeAttributes::FreeformMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sFreeformMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      case VolumeAttributes::GaussianMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sGaussianMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      case VolumeAttributes::ColorTableMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sColorTableMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "opacityControlPoints.";
        str += PyGaussianControlPointList_ToString(&atts->GetOpacityControlPoints(), objPrefix.c_str());
    }
    SNPRINTF(tmpStr, 1000, "%sresampleTarget = %d\n", prefix, atts->GetResampleTarget());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVariable = \"%s\"\n", prefix, atts->GetOpacityVariable().c_str());
    str += tmpStr;
    {   const unsigned char *freeformOpacity = atts->GetFreeformOpacity();
        SNPRINTF(tmpStr, 1000, "%sfreeformOpacity = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 256; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(freeformOpacity[i]));
            str += tmpStr;
            if(i < 255)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseColorVarMin())
        SNPRINTF(tmpStr, 1000, "%suseColorVarMin = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseColorVarMin = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorVarMin = %g\n", prefix, atts->GetColorVarMin());
    str += tmpStr;
    if(atts->GetUseColorVarMax())
        SNPRINTF(tmpStr, 1000, "%suseColorVarMax = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseColorVarMax = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorVarMax = %g\n", prefix, atts->GetColorVarMax());
    str += tmpStr;
    if(atts->GetUseOpacityVarMin())
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMin = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMin = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMin = %g\n", prefix, atts->GetOpacityVarMin());
    str += tmpStr;
    if(atts->GetUseOpacityVarMax())
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMax = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMax = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMax = %g\n", prefix, atts->GetOpacityVarMax());
    str += tmpStr;
    if(atts->GetSmoothData())
        SNPRINTF(tmpStr, 1000, "%ssmoothData = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssmoothData = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssamplesPerRay = %d\n", prefix, atts->GetSamplesPerRay());
    str += tmpStr;
    const char *rendererType_names = "Splatting, Texture3D, RayCasting, RayCastingIntegration, SLIVR, "
        "Tuvok";
    switch (atts->GetRendererType())
    {
      case VolumeAttributes::Splatting:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sSplatting  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Texture3D:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sTexture3D  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCasting:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCasting  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCastingIntegration:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCastingIntegration  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::SLIVR:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sSLIVR  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Tuvok:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sTuvok  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *gradientType_names = "CenteredDifferences, SobelOperator";
    switch (atts->GetGradientType())
    {
      case VolumeAttributes::CenteredDifferences:
          SNPRINTF(tmpStr, 1000, "%sgradientType = %sCenteredDifferences  # %s\n", prefix, prefix, gradientType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::SobelOperator:
          SNPRINTF(tmpStr, 1000, "%sgradientType = %sSobelOperator  # %s\n", prefix, prefix, gradientType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%snum3DSlices = %d\n", prefix, atts->GetNum3DSlices());
    str += tmpStr;
    const char *scaling_names = "Linear, Log10, Skew";
    switch (atts->GetScaling())
    {
      case VolumeAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Log10:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog10  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sSkew  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sskewFactor = %g\n", prefix, atts->GetSkewFactor());
    str += tmpStr;
    const char *sampling_names = "KernelBased, Rasterization";
    switch (atts->GetSampling())
    {
      case VolumeAttributes::KernelBased:
          SNPRINTF(tmpStr, 1000, "%ssampling = %sKernelBased  # %s\n", prefix, prefix, sampling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Rasterization:
          SNPRINTF(tmpStr, 1000, "%ssampling = %sRasterization  # %s\n", prefix, prefix, sampling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%srendererSamples = %g\n", prefix, atts->GetRendererSamples());
    str += tmpStr;
    { // new scope
        int index = 0;
        // Create string representation of transferFunction2DWidgets from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetTransferFunction2DWidgets().begin(); pos != atts->GetTransferFunction2DWidgets().end(); ++pos, ++index)
        {
            const TransferFunctionWidget *current = (const TransferFunctionWidget *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetTransferFunction2DWidgets(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyTransferFunctionWidget_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#transferFunction2DWidgets does not contain any TransferFunctionWidget objects.\n";
    }
    SNPRINTF(tmpStr, 1000, "%stransferFunctionDim = %d\n", prefix, atts->GetTransferFunctionDim());
    str += tmpStr;
    const char *lowGradientLightingReduction_names = "Off, Lowest, Lower, Low, Medium, "
        "High, Higher, Highest";
    switch (atts->GetLowGradientLightingReduction())
    {
      case VolumeAttributes::Off:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sOff  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Lowest:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLowest  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Lower:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLower  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLow  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sMedium  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::High:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHigh  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Higher:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHigher  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Highest:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHighest  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetLowGradientLightingClampFlag())
        SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampValue = %g\n", prefix, atts->GetLowGradientLightingClampValue());
    str += tmpStr;
    return str;
}

static PyObject *
VolumeAttributes_Notify(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyColorControlPointList_Check(newValue))
    {
        fprintf(stderr, "The colorControlPoints field can only be set with ColorControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetColorControlPoints(*PyColorControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPointList_Wrap(&obj->data->GetColorControlPoints());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityAttenuation in the object.
    obj->data->SetOpacityAttenuation(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityAttenuation()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOpacityMode(VolumeAttributes::OpacityModes(ival));
    else
    {
        fprintf(stderr, "An invalid opacityMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "FreeformMode, GaussianMode, ColorTableMode.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityMode()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyGaussianControlPointList_Check(newValue))
    {
        fprintf(stderr, "The opacityControlPoints field can only be set with GaussianControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetOpacityControlPoints(*PyGaussianControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyGaussianControlPointList_Wrap(&obj->data->GetOpacityControlPoints());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyGaussianControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resampleTarget in the object.
    obj->data->SetResampleTarget((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetResampleTarget()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the opacityVariable in the object.
    obj->data->SetOpacityVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOpacityVariable().c_str());
    return retval;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Oct 14 08:24:34 PDT 2005
//    Added custom code, to parse different types of args:
//    (int index, int val) -- sets the opacity value at the specified index
//    (list or tuple object) --  as long as it is numeric and has length
//    of 256, will set the opacity values to the values in the list or tuple.
//
// ****************************************************************************

static PyObject *
VolumeAttributes_SetFreeformOpacity(PyObject *self, PyObject *args)
{
//
// THIS METHOD IS CUSTOM CODED!!!!!!.
//
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    unsigned char *cvals = obj->data->GetFreeformOpacity();
    int opacity, index;
    if(PyArg_ParseTuple(args, "ii", &index, &opacity))
    {
        if(index >= 0 && index < 256)
        {
            if(opacity < 0) opacity = 0;
            if(opacity > 255) opacity = 255;
            cvals[index] = (unsigned char)(opacity);
        }
    }
    else
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
        {
            return NULL;
        }
        if(PyTuple_Check(tuple) || PyList_Check(tuple))
        {
            if(PySequence_Size(tuple) != 256)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PySequence_Size(tuple); ++i)
            {
                int c;
                PyObject *item = PySequence_GetItem(tuple, i);
                if(PyInt_Check(item))
                    c = int(PyInt_AS_LONG(item));
                else if(PyFloat_Check(item))
                    c = int(PyFloat_AS_DOUBLE(item));
                else if(PyLong_Check(item))
                    c = int(PyLong_AsDouble(item));
                else
                    c = 0;
                Py_DECREF(item);
                if(c < 0) c = 0;
                if(c > 255) c = 255;
                cvals[i] = (unsigned char)(c);
           }
        }
        else
            return NULL;
    }

    // Mark the freeformOpacity in the object as modified.
    obj->data->SelectFreeformOpacity();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetFreeformOpacity(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the freeformOpacity.
    PyObject *retval = PyTuple_New(256);
    const unsigned char *freeformOpacity = obj->data->GetFreeformOpacity();
    for(int i = 0; i < 256; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(freeformOpacity[i])));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMin in the object.
    obj->data->SetUseColorVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMin in the object.
    obj->data->SetColorVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMin()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMax in the object.
    obj->data->SetUseColorVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMax()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMax in the object.
    obj->data->SetColorVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMax()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMin in the object.
    obj->data->SetUseOpacityVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMin in the object.
    obj->data->SetOpacityVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMin()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMax in the object.
    obj->data->SetUseOpacityVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMax()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMax in the object.
    obj->data->SetOpacityVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMax()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothData in the object.
    obj->data->SetSmoothData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothData()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesPerRay in the object.
    obj->data->SetSamplesPerRay((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesPerRay()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rendererType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetRendererType(VolumeAttributes::Renderer(ival));
    else
    {
        fprintf(stderr, "An invalid rendererType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Splatting, Texture3D, RayCasting, RayCastingIntegration, SLIVR, "
                        "Tuvok.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRendererType()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the gradientType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGradientType(VolumeAttributes::GradientType(ival));
    else
    {
        fprintf(stderr, "An invalid gradientType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CenteredDifferences, SobelOperator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGradientType()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetNum3DSlices(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the num3DSlices in the object.
    obj->data->SetNum3DSlices((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetNum3DSlices(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNum3DSlices()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetScaling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(VolumeAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log10, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetScaling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSampling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSampling(VolumeAttributes::SamplingType(ival));
    else
    {
        fprintf(stderr, "An invalid sampling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "KernelBased, Rasterization.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSampling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampling()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetRendererSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the rendererSamples in the object.
    obj->data->SetRendererSamples(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetRendererSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRendererSamples()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_GetTransferFunction2DWidgets(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || index >= obj->data->GetTransferFunction2DWidgets().size())
    {
        char msg[200];
        if(obj->data->GetTransferFunction2DWidgets().size() == 0)
            SNPRINTF(msg, 200, "The index is invalid because transferFunction2DWidgets is empty.");
        else
            SNPRINTF(msg, 200, "The index is invalid. Use index values in: [0, %ld).", obj->data->GetTransferFunction2DWidgets().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyTransferFunctionWidget_Wrap(&obj->data->GetTransferFunction2DWidgets(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyTransferFunctionWidget_SetParent(retval, self);

    return retval;
}

PyObject *
VolumeAttributes_GetNumTransferFunction2DWidgets(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    return PyInt_FromLong((long)obj->data->GetTransferFunction2DWidgets().size());
}

PyObject *
VolumeAttributes_AddTransferFunction2DWidgets(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyTransferFunctionWidget_Check(element))
    {
        char msg[400];
        SNPRINTF(msg, 400, "The AddTransferFunction2DWidgets method only accepts TransferFunctionWidget objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    TransferFunctionWidget *newData = PyTransferFunctionWidget_FromPyObject(element);
    obj->data->AddTransferFunction2DWidgets(*newData);
    obj->data->SelectTransferFunction2DWidgets();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
VolumeAttributes_Remove_One_TransferFunction2DWidgets(PyObject *self, int index)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveTransferFunction2DWidgets() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetTransferFunction2DWidgets();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectTransferFunction2DWidgets();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
VolumeAttributes_RemoveTransferFunction2DWidgets(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    if(index < 0 || index >= obj->data->GetNumTransferFunction2DWidgets())
    {
        PyErr_SetString(PyExc_IndexError, "Index out of range");
        return NULL;
    }

    return VolumeAttributes_Remove_One_TransferFunction2DWidgets(self, index);
}

PyObject *
VolumeAttributes_ClearTransferFunction2DWidgets(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    int n = obj->data->GetNumTransferFunction2DWidgets();
    for(int i = 0; i < n; ++i)
    {
        VolumeAttributes_Remove_One_TransferFunction2DWidgets(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_SetTransferFunctionDim(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the transferFunctionDim in the object.
    obj->data->SetTransferFunctionDim((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetTransferFunctionDim(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTransferFunctionDim()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingReduction(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lowGradientLightingReduction in the object.
    if(ival >= 0 && ival < 8)
        obj->data->SetLowGradientLightingReduction(VolumeAttributes::LowGradientLightingReduction(ival));
    else
    {
        fprintf(stderr, "An invalid lowGradientLightingReduction value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Off, Lowest, Lower, Low, Medium, "
                        "High, Higher, Highest.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingReduction(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLowGradientLightingReduction()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingClampFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lowGradientLightingClampFlag in the object.
    obj->data->SetLowGradientLightingClampFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingClampFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLowGradientLightingClampFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingClampValue(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lowGradientLightingClampValue in the object.
    obj->data->SetLowGradientLightingClampValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingClampValue(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLowGradientLightingClampValue());
    return retval;
}



PyMethodDef PyVolumeAttributes_methods[VOLUMEATTRIBUTES_NMETH] = {
    {"Notify", VolumeAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", VolumeAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", VolumeAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", VolumeAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", VolumeAttributes_GetLightingFlag, METH_VARARGS},
    {"SetColorControlPoints", VolumeAttributes_SetColorControlPoints, METH_VARARGS},
    {"GetColorControlPoints", VolumeAttributes_GetColorControlPoints, METH_VARARGS},
    {"SetOpacityAttenuation", VolumeAttributes_SetOpacityAttenuation, METH_VARARGS},
    {"GetOpacityAttenuation", VolumeAttributes_GetOpacityAttenuation, METH_VARARGS},
    {"SetOpacityMode", VolumeAttributes_SetOpacityMode, METH_VARARGS},
    {"GetOpacityMode", VolumeAttributes_GetOpacityMode, METH_VARARGS},
    {"SetOpacityControlPoints", VolumeAttributes_SetOpacityControlPoints, METH_VARARGS},
    {"GetOpacityControlPoints", VolumeAttributes_GetOpacityControlPoints, METH_VARARGS},
    {"SetResampleTarget", VolumeAttributes_SetResampleTarget, METH_VARARGS},
    {"GetResampleTarget", VolumeAttributes_GetResampleTarget, METH_VARARGS},
    {"SetOpacityVariable", VolumeAttributes_SetOpacityVariable, METH_VARARGS},
    {"GetOpacityVariable", VolumeAttributes_GetOpacityVariable, METH_VARARGS},
    {"SetFreeformOpacity", VolumeAttributes_SetFreeformOpacity, METH_VARARGS},
    {"GetFreeformOpacity", VolumeAttributes_GetFreeformOpacity, METH_VARARGS},
    {"SetUseColorVarMin", VolumeAttributes_SetUseColorVarMin, METH_VARARGS},
    {"GetUseColorVarMin", VolumeAttributes_GetUseColorVarMin, METH_VARARGS},
    {"SetColorVarMin", VolumeAttributes_SetColorVarMin, METH_VARARGS},
    {"GetColorVarMin", VolumeAttributes_GetColorVarMin, METH_VARARGS},
    {"SetUseColorVarMax", VolumeAttributes_SetUseColorVarMax, METH_VARARGS},
    {"GetUseColorVarMax", VolumeAttributes_GetUseColorVarMax, METH_VARARGS},
    {"SetColorVarMax", VolumeAttributes_SetColorVarMax, METH_VARARGS},
    {"GetColorVarMax", VolumeAttributes_GetColorVarMax, METH_VARARGS},
    {"SetUseOpacityVarMin", VolumeAttributes_SetUseOpacityVarMin, METH_VARARGS},
    {"GetUseOpacityVarMin", VolumeAttributes_GetUseOpacityVarMin, METH_VARARGS},
    {"SetOpacityVarMin", VolumeAttributes_SetOpacityVarMin, METH_VARARGS},
    {"GetOpacityVarMin", VolumeAttributes_GetOpacityVarMin, METH_VARARGS},
    {"SetUseOpacityVarMax", VolumeAttributes_SetUseOpacityVarMax, METH_VARARGS},
    {"GetUseOpacityVarMax", VolumeAttributes_GetUseOpacityVarMax, METH_VARARGS},
    {"SetOpacityVarMax", VolumeAttributes_SetOpacityVarMax, METH_VARARGS},
    {"GetOpacityVarMax", VolumeAttributes_GetOpacityVarMax, METH_VARARGS},
    {"SetSmoothData", VolumeAttributes_SetSmoothData, METH_VARARGS},
    {"GetSmoothData", VolumeAttributes_GetSmoothData, METH_VARARGS},
    {"SetSamplesPerRay", VolumeAttributes_SetSamplesPerRay, METH_VARARGS},
    {"GetSamplesPerRay", VolumeAttributes_GetSamplesPerRay, METH_VARARGS},
    {"SetRendererType", VolumeAttributes_SetRendererType, METH_VARARGS},
    {"GetRendererType", VolumeAttributes_GetRendererType, METH_VARARGS},
    {"SetGradientType", VolumeAttributes_SetGradientType, METH_VARARGS},
    {"GetGradientType", VolumeAttributes_GetGradientType, METH_VARARGS},
    {"SetNum3DSlices", VolumeAttributes_SetNum3DSlices, METH_VARARGS},
    {"GetNum3DSlices", VolumeAttributes_GetNum3DSlices, METH_VARARGS},
    {"SetScaling", VolumeAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", VolumeAttributes_GetScaling, METH_VARARGS},
    {"SetSkewFactor", VolumeAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", VolumeAttributes_GetSkewFactor, METH_VARARGS},
    {"SetSampling", VolumeAttributes_SetSampling, METH_VARARGS},
    {"GetSampling", VolumeAttributes_GetSampling, METH_VARARGS},
    {"SetRendererSamples", VolumeAttributes_SetRendererSamples, METH_VARARGS},
    {"GetRendererSamples", VolumeAttributes_GetRendererSamples, METH_VARARGS},
    {"GetTransferFunction2DWidgets", VolumeAttributes_GetTransferFunction2DWidgets, METH_VARARGS},
    {"GetNumTransferFunction2DWidgets", VolumeAttributes_GetNumTransferFunction2DWidgets, METH_VARARGS},
    {"AddTransferFunction2DWidgets", VolumeAttributes_AddTransferFunction2DWidgets, METH_VARARGS},
    {"RemoveTransferFunction2DWidgets", VolumeAttributes_RemoveTransferFunction2DWidgets, METH_VARARGS},
    {"ClearTransferFunction2DWidgets", VolumeAttributes_ClearTransferFunction2DWidgets, METH_VARARGS},
    {"SetTransferFunctionDim", VolumeAttributes_SetTransferFunctionDim, METH_VARARGS},
    {"GetTransferFunctionDim", VolumeAttributes_GetTransferFunctionDim, METH_VARARGS},
    {"SetLowGradientLightingReduction", VolumeAttributes_SetLowGradientLightingReduction, METH_VARARGS},
    {"GetLowGradientLightingReduction", VolumeAttributes_GetLowGradientLightingReduction, METH_VARARGS},
    {"SetLowGradientLightingClampFlag", VolumeAttributes_SetLowGradientLightingClampFlag, METH_VARARGS},
    {"GetLowGradientLightingClampFlag", VolumeAttributes_GetLowGradientLightingClampFlag, METH_VARARGS},
    {"SetLowGradientLightingClampValue", VolumeAttributes_SetLowGradientLightingClampValue, METH_VARARGS},
    {"GetLowGradientLightingClampValue", VolumeAttributes_GetLowGradientLightingClampValue, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
VolumeAttributes_dealloc(PyObject *v)
{
   VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
VolumeAttributes_compare(PyObject *v, PyObject *w)
{
    VolumeAttributes *a = ((VolumeAttributesObject *)v)->data;
    VolumeAttributes *b = ((VolumeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyVolumeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return VolumeAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return VolumeAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "colorControlPoints") == 0)
        return VolumeAttributes_GetColorControlPoints(self, NULL);
    if(strcmp(name, "opacityAttenuation") == 0)
        return VolumeAttributes_GetOpacityAttenuation(self, NULL);
    if(strcmp(name, "opacityMode") == 0)
        return VolumeAttributes_GetOpacityMode(self, NULL);
    if(strcmp(name, "FreeformMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::FreeformMode));
    if(strcmp(name, "GaussianMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::GaussianMode));
    if(strcmp(name, "ColorTableMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::ColorTableMode));

    if(strcmp(name, "opacityControlPoints") == 0)
        return VolumeAttributes_GetOpacityControlPoints(self, NULL);
    if(strcmp(name, "resampleTarget") == 0)
        return VolumeAttributes_GetResampleTarget(self, NULL);
    if(strcmp(name, "opacityVariable") == 0)
        return VolumeAttributes_GetOpacityVariable(self, NULL);
    if(strcmp(name, "freeformOpacity") == 0)
        return VolumeAttributes_GetFreeformOpacity(self, NULL);
    if(strcmp(name, "useColorVarMin") == 0)
        return VolumeAttributes_GetUseColorVarMin(self, NULL);
    if(strcmp(name, "colorVarMin") == 0)
        return VolumeAttributes_GetColorVarMin(self, NULL);
    if(strcmp(name, "useColorVarMax") == 0)
        return VolumeAttributes_GetUseColorVarMax(self, NULL);
    if(strcmp(name, "colorVarMax") == 0)
        return VolumeAttributes_GetColorVarMax(self, NULL);
    if(strcmp(name, "useOpacityVarMin") == 0)
        return VolumeAttributes_GetUseOpacityVarMin(self, NULL);
    if(strcmp(name, "opacityVarMin") == 0)
        return VolumeAttributes_GetOpacityVarMin(self, NULL);
    if(strcmp(name, "useOpacityVarMax") == 0)
        return VolumeAttributes_GetUseOpacityVarMax(self, NULL);
    if(strcmp(name, "opacityVarMax") == 0)
        return VolumeAttributes_GetOpacityVarMax(self, NULL);
    if(strcmp(name, "smoothData") == 0)
        return VolumeAttributes_GetSmoothData(self, NULL);
    if(strcmp(name, "samplesPerRay") == 0)
        return VolumeAttributes_GetSamplesPerRay(self, NULL);
    if(strcmp(name, "rendererType") == 0)
        return VolumeAttributes_GetRendererType(self, NULL);
    if(strcmp(name, "Splatting") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Splatting));
    if(strcmp(name, "Texture3D") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Texture3D));
    if(strcmp(name, "RayCasting") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCasting));
    if(strcmp(name, "RayCastingIntegration") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCastingIntegration));
    if(strcmp(name, "SLIVR") == 0)
        return PyInt_FromLong(long(VolumeAttributes::SLIVR));
    if(strcmp(name, "Tuvok") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Tuvok));

    if(strcmp(name, "gradientType") == 0)
        return VolumeAttributes_GetGradientType(self, NULL);
    if(strcmp(name, "CenteredDifferences") == 0)
        return PyInt_FromLong(long(VolumeAttributes::CenteredDifferences));
    if(strcmp(name, "SobelOperator") == 0)
        return PyInt_FromLong(long(VolumeAttributes::SobelOperator));

    if(strcmp(name, "num3DSlices") == 0)
        return VolumeAttributes_GetNum3DSlices(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return VolumeAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Linear));
    if(strcmp(name, "Log10") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Log10));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Skew));

    if(strcmp(name, "skewFactor") == 0)
        return VolumeAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "sampling") == 0)
        return VolumeAttributes_GetSampling(self, NULL);
    if(strcmp(name, "KernelBased") == 0)
        return PyInt_FromLong(long(VolumeAttributes::KernelBased));
    if(strcmp(name, "Rasterization") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Rasterization));

    if(strcmp(name, "rendererSamples") == 0)
        return VolumeAttributes_GetRendererSamples(self, NULL);
    if(strcmp(name, "transferFunction2DWidgets") == 0)
        return VolumeAttributes_GetTransferFunction2DWidgets(self, NULL);
    if(strcmp(name, "transferFunctionDim") == 0)
        return VolumeAttributes_GetTransferFunctionDim(self, NULL);
    if(strcmp(name, "lowGradientLightingReduction") == 0)
        return VolumeAttributes_GetLowGradientLightingReduction(self, NULL);
    if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Off));
    if(strcmp(name, "Lowest") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Lowest));
    if(strcmp(name, "Lower") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Lower));
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(VolumeAttributes::High));
    if(strcmp(name, "Higher") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Higher));
    if(strcmp(name, "Highest") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Highest));

    if(strcmp(name, "lowGradientLightingClampFlag") == 0)
        return VolumeAttributes_GetLowGradientLightingClampFlag(self, NULL);
    if(strcmp(name, "lowGradientLightingClampValue") == 0)
        return VolumeAttributes_GetLowGradientLightingClampValue(self, NULL);

    return Py_FindMethod(PyVolumeAttributes_methods, self, name);
}

int
PyVolumeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = VolumeAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = VolumeAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "colorControlPoints") == 0)
        obj = VolumeAttributes_SetColorControlPoints(self, tuple);
    else if(strcmp(name, "opacityAttenuation") == 0)
        obj = VolumeAttributes_SetOpacityAttenuation(self, tuple);
    else if(strcmp(name, "opacityMode") == 0)
        obj = VolumeAttributes_SetOpacityMode(self, tuple);
    else if(strcmp(name, "opacityControlPoints") == 0)
        obj = VolumeAttributes_SetOpacityControlPoints(self, tuple);
    else if(strcmp(name, "resampleTarget") == 0)
        obj = VolumeAttributes_SetResampleTarget(self, tuple);
    else if(strcmp(name, "opacityVariable") == 0)
        obj = VolumeAttributes_SetOpacityVariable(self, tuple);
    else if(strcmp(name, "freeformOpacity") == 0)
        obj = VolumeAttributes_SetFreeformOpacity(self, tuple);
    else if(strcmp(name, "useColorVarMin") == 0)
        obj = VolumeAttributes_SetUseColorVarMin(self, tuple);
    else if(strcmp(name, "colorVarMin") == 0)
        obj = VolumeAttributes_SetColorVarMin(self, tuple);
    else if(strcmp(name, "useColorVarMax") == 0)
        obj = VolumeAttributes_SetUseColorVarMax(self, tuple);
    else if(strcmp(name, "colorVarMax") == 0)
        obj = VolumeAttributes_SetColorVarMax(self, tuple);
    else if(strcmp(name, "useOpacityVarMin") == 0)
        obj = VolumeAttributes_SetUseOpacityVarMin(self, tuple);
    else if(strcmp(name, "opacityVarMin") == 0)
        obj = VolumeAttributes_SetOpacityVarMin(self, tuple);
    else if(strcmp(name, "useOpacityVarMax") == 0)
        obj = VolumeAttributes_SetUseOpacityVarMax(self, tuple);
    else if(strcmp(name, "opacityVarMax") == 0)
        obj = VolumeAttributes_SetOpacityVarMax(self, tuple);
    else if(strcmp(name, "smoothData") == 0)
        obj = VolumeAttributes_SetSmoothData(self, tuple);
    else if(strcmp(name, "samplesPerRay") == 0)
        obj = VolumeAttributes_SetSamplesPerRay(self, tuple);
    else if(strcmp(name, "rendererType") == 0)
        obj = VolumeAttributes_SetRendererType(self, tuple);
    else if(strcmp(name, "gradientType") == 0)
        obj = VolumeAttributes_SetGradientType(self, tuple);
    else if(strcmp(name, "num3DSlices") == 0)
        obj = VolumeAttributes_SetNum3DSlices(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = VolumeAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "skewFactor") == 0)
        obj = VolumeAttributes_SetSkewFactor(self, tuple);
    else if(strcmp(name, "sampling") == 0)
        obj = VolumeAttributes_SetSampling(self, tuple);
    else if(strcmp(name, "rendererSamples") == 0)
        obj = VolumeAttributes_SetRendererSamples(self, tuple);
    else if(strcmp(name, "transferFunctionDim") == 0)
        obj = VolumeAttributes_SetTransferFunctionDim(self, tuple);
    else if(strcmp(name, "lowGradientLightingReduction") == 0)
        obj = VolumeAttributes_SetLowGradientLightingReduction(self, tuple);
    else if(strcmp(name, "lowGradientLightingClampFlag") == 0)
        obj = VolumeAttributes_SetLowGradientLightingClampFlag(self, tuple);
    else if(strcmp(name, "lowGradientLightingClampValue") == 0)
        obj = VolumeAttributes_SetLowGradientLightingClampValue(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
VolumeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
    fprintf(fp, "%s", PyVolumeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
VolumeAttributes_str(PyObject *v)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
    return PyString_FromString(PyVolumeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *VolumeAttributes_Purpose = "This class contains the plot attributes for the volume plot.";
#else
static char *VolumeAttributes_Purpose = "This class contains the plot attributes for the volume plot.";
#endif

//
// The type description structure
//
static PyTypeObject VolumeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "VolumeAttributes",                    // tp_name
    sizeof(VolumeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)VolumeAttributes_dealloc,  // tp_dealloc
    (printfunc)VolumeAttributes_print,     // tp_print
    (getattrfunc)PyVolumeAttributes_getattr, // tp_getattr
    (setattrfunc)PyVolumeAttributes_setattr, // tp_setattr
    (cmpfunc)VolumeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)VolumeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    VolumeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static VolumeAttributes *defaultAtts = 0;
static VolumeAttributes *currentAtts = 0;

static PyObject *
NewVolumeAttributes(int useCurrent)
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new VolumeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new VolumeAttributes(*defaultAtts);
    else
        newObject->data = new VolumeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapVolumeAttributes(const VolumeAttributes *attr)
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (VolumeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
VolumeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewVolumeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef VolumeAttributesMethods[] = {
    {"VolumeAttributes", VolumeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *VolumeAttributesObserver = 0;

std::string
PyVolumeAttributes_GetLogString()
{
    std::string s("VolumeAtts = VolumeAttributes()\n");
    if(currentAtts != 0)
        s += PyVolumeAttributes_ToString(currentAtts, "VolumeAtts.");
    return s;
}

static void
PyVolumeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    VolumeAttributes *atts = (VolumeAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("VolumeAtts = VolumeAttributes()\n");
        s += PyVolumeAttributes_ToString(currentAtts, "VolumeAtts.");
        cb(s);
    }
}

void
PyVolumeAttributes_StartUp(VolumeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyVolumeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(VolumeAttributesObserver == 0)
    {
        VolumeAttributesObserver = new ObserverToCallback(subj,
            PyVolumeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyVolumeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete VolumeAttributesObserver;
    VolumeAttributesObserver = 0;
}

PyMethodDef *
PyVolumeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return VolumeAttributesMethods;
}

bool
PyVolumeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &VolumeAttributesType);
}

VolumeAttributes *
PyVolumeAttributes_FromPyObject(PyObject *obj)
{
    VolumeAttributesObject *obj2 = (VolumeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyVolumeAttributes_New()
{
    return NewVolumeAttributes(0);
}

PyObject *
PyVolumeAttributes_Wrap(const VolumeAttributes *attr)
{
    return WrapVolumeAttributes(attr);
}

void
PyVolumeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    VolumeAttributesObject *obj2 = (VolumeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyVolumeAttributes_SetDefaults(const VolumeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new VolumeAttributes(*atts);
}

