/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyStreamlineAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyStreamlineAttributes
//
// Purpose: 
//   Attributes for the Streamline plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a StreamlineAttributes.
//
struct StreamlineAttributesObject
{
    PyObject_HEAD
    StreamlineAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewStreamlineAttributes(int);

std::string
PyStreamlineAttributes_ToString(const StreamlineAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *sourceType_names = "SpecifiedPoint, SpecifiedPointList, SpecifiedLine, SpecifiedCircle, SpecifiedPlane, "
        "SpecifiedSphere, SpecifiedBox";
    switch (atts->GetSourceType())
    {
      case StreamlineAttributes::SpecifiedPoint:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPoint  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedPointList:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPointList  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedLine:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedCircle:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedCircle  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedPlane:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPlane  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedSphere:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedSphere  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::SpecifiedBox:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedBox  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stermination = %g\n", prefix, atts->GetTermination());
    str += tmpStr;
    {   const double *pointSource = atts->GetPointSource();
        SNPRINTF(tmpStr, 1000, "%spointSource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        SNPRINTF(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        SNPRINTF(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeOrigin = atts->GetPlaneOrigin();
        SNPRINTF(tmpStr, 1000, "%splaneOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNormal = atts->GetPlaneNormal();
        SNPRINTF(tmpStr, 1000, "%splaneNormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeUpAxis = atts->GetPlaneUpAxis();
        SNPRINTF(tmpStr, 1000, "%splaneUpAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeUpAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%splaneRadius = %g\n", prefix, atts->GetPlaneRadius());
    str += tmpStr;
    {   const double *sphereOrigin = atts->GetSphereOrigin();
        SNPRINTF(tmpStr, 1000, "%ssphereOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", sphereOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%ssphereRadius = %g\n", prefix, atts->GetSphereRadius());
    str += tmpStr;
    {   const double *boxExtents = atts->GetBoxExtents();
        SNPRINTF(tmpStr, 1000, "%sboxExtents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", boxExtents[i]);
            str += tmpStr;
            if(i < 5)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseWholeBox())
        SNPRINTF(tmpStr, 1000, "%suseWholeBox = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseWholeBox = 0\n", prefix);
    str += tmpStr;
    {   const doubleVector &pointList = atts->GetPointList();
        SNPRINTF(tmpStr, 1000, "%spointList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < pointList.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pointList[i]);
            str += tmpStr;
            if(i < pointList.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%spointDensity = %d\n", prefix, atts->GetPointDensity());
    str += tmpStr;
    const char *displayMethod_names = "Lines, Tubes, Ribbons";
    switch (atts->GetDisplayMethod())
    {
      case StreamlineAttributes::Lines:
          SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sLines  # %s\n", prefix, prefix, displayMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Tubes:
          SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sTubes  # %s\n", prefix, prefix, displayMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Ribbons:
          SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sRibbons  # %s\n", prefix, prefix, displayMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetShowSeeds())
        SNPRINTF(tmpStr, 1000, "%sshowSeeds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowSeeds = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowHeads())
        SNPRINTF(tmpStr, 1000, "%sshowHeads = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowHeads = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeRadius = %g\n", prefix, atts->GetTubeRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sribbonWidth = %g\n", prefix, atts->GetRibbonWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const char *coloringMethod_names = "Solid, ColorBySpeed, ColorByVorticity, ColorByLength, ColorByTime, "
        "ColorBySeedPointID, ColorByVariable";
    switch (atts->GetColoringMethod())
    {
      case StreamlineAttributes::Solid:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sSolid  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorBySpeed:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorBySpeed  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorByVorticity:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorByVorticity  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorByLength:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorByLength  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorByTime:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorByTime  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorBySeedPointID:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorBySeedPointID  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ColorByVariable:
          SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorByVariable  # %s\n", prefix, prefix, coloringMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    const char *streamlineDirection_names = "Forward, Backward, Both";
    switch (atts->GetStreamlineDirection())
    {
      case StreamlineAttributes::Forward:
          SNPRINTF(tmpStr, 1000, "%sstreamlineDirection = %sForward  # %s\n", prefix, prefix, streamlineDirection_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Backward:
          SNPRINTF(tmpStr, 1000, "%sstreamlineDirection = %sBackward  # %s\n", prefix, prefix, streamlineDirection_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Both:
          SNPRINTF(tmpStr, 1000, "%sstreamlineDirection = %sBoth  # %s\n", prefix, prefix, streamlineDirection_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sabsTol = %g\n", prefix, atts->GetAbsTol());
    str += tmpStr;
    const char *terminationType_names = "Distance, Time, Step";
    switch (atts->GetTerminationType())
    {
      case StreamlineAttributes::Distance:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sDistance  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Time:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sTime  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Step:
          SNPRINTF(tmpStr, 1000, "%sterminationType = %sStep  # %s\n", prefix, prefix, terminationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *integrationType_names = "DormandPrince, AdamsBashforth, M3DC1Integrator";
    switch (atts->GetIntegrationType())
    {
      case StreamlineAttributes::DormandPrince:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::AdamsBashforth:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::M3DC1Integrator:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sM3DC1Integrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *streamlineAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave";
    switch (atts->GetStreamlineAlgorithmType())
    {
      case StreamlineAttributes::LoadOnDemand:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::ParallelStaticDomains:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::MasterSlave:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxStreamlineProcessCount = %d\n", prefix, atts->GetMaxStreamlineProcessCount());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    if(atts->GetPathlines())
        SNPRINTF(tmpStr, 1000, "%spathlines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spathlines = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scoloringVariable = \"%s\"\n", prefix, atts->GetColoringVariable().c_str());
    str += tmpStr;
    if(atts->GetLegendMinFlag())
        SNPRINTF(tmpStr, 1000, "%slegendMinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendMinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendMaxFlag())
        SNPRINTF(tmpStr, 1000, "%slegendMaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendMaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slegendMin = %g\n", prefix, atts->GetLegendMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slegendMax = %g\n", prefix, atts->GetLegendMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdisplayBegin = %g\n", prefix, atts->GetDisplayBegin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdisplayEnd = %g\n", prefix, atts->GetDisplayEnd());
    str += tmpStr;
    if(atts->GetDisplayBeginFlag())
        SNPRINTF(tmpStr, 1000, "%sdisplayBeginFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisplayBeginFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDisplayEndFlag())
        SNPRINTF(tmpStr, 1000, "%sdisplayEndFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisplayEndFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sseedDisplayRadius = %g\n", prefix, atts->GetSeedDisplayRadius());
    str += tmpStr;
    const char *headDisplayType_names = "Sphere, Cone";
    switch (atts->GetHeadDisplayType())
    {
      case StreamlineAttributes::Sphere:
          SNPRINTF(tmpStr, 1000, "%sheadDisplayType = %sSphere  # %s\n", prefix, prefix, headDisplayType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Cone:
          SNPRINTF(tmpStr, 1000, "%sheadDisplayType = %sCone  # %s\n", prefix, prefix, headDisplayType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sheadDisplayRadius = %g\n", prefix, atts->GetHeadDisplayRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sheadDisplayHeight = %g\n", prefix, atts->GetHeadDisplayHeight());
    str += tmpStr;
    const char *opacityType_names = "None, Constant, Ramp, VariableRange";
    switch (atts->GetOpacityType())
    {
      case StreamlineAttributes::None:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sNone  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Constant:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sConstant  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Ramp:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sRamp  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::VariableRange:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sVariableRange  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sopacityVariable = \"%s\"\n", prefix, atts->GetOpacityVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMin = %g\n", prefix, atts->GetOpacityVarMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMax = %g\n", prefix, atts->GetOpacityVarMax());
    str += tmpStr;
    if(atts->GetOpacityVarMinFlag())
        SNPRINTF(tmpStr, 1000, "%sopacityVarMinFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sopacityVarMinFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOpacityVarMaxFlag())
        SNPRINTF(tmpStr, 1000, "%sopacityVarMaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sopacityVarMaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stubeDisplayDensity = %d\n", prefix, atts->GetTubeDisplayDensity());
    str += tmpStr;
    const char *geomDisplayQuality_names = "Low, Medium, High, Super";
    switch (atts->GetGeomDisplayQuality())
    {
      case StreamlineAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%sgeomDisplayQuality = %sLow  # %s\n", prefix, prefix, geomDisplayQuality_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%sgeomDisplayQuality = %sMedium  # %s\n", prefix, prefix, geomDisplayQuality_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::High:
          SNPRINTF(tmpStr, 1000, "%sgeomDisplayQuality = %sHigh  # %s\n", prefix, prefix, geomDisplayQuality_names);
          str += tmpStr;
          break;
      case StreamlineAttributes::Super:
          SNPRINTF(tmpStr, 1000, "%sgeomDisplayQuality = %sSuper  # %s\n", prefix, prefix, geomDisplayQuality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
StreamlineAttributes_Notify(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetSourceType(StreamlineAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, SpecifiedPointList, SpecifiedLine, SpecifiedCircle, SpecifiedPlane, "
                        "SpecifiedSphere, SpecifiedBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetTermination(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termination in the object.
    obj->data->SetTermination(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetTermination(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermination());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPlaneOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeOrigin in the object as modified.
    obj->data->SelectPlaneOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPlaneOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *planeOrigin = obj->data->GetPlaneOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeOrigin[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPlaneNormal(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNormal in the object as modified.
    obj->data->SelectPlaneNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPlaneNormal(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNormal.
    PyObject *retval = PyTuple_New(3);
    const double *planeNormal = obj->data->GetPlaneNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNormal[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPlaneUpAxis(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeUpAxis in the object as modified.
    obj->data->SelectPlaneUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPlaneUpAxis(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeUpAxis.
    PyObject *retval = PyTuple_New(3);
    const double *planeUpAxis = obj->data->GetPlaneUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeUpAxis[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPlaneRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the planeRadius in the object.
    obj->data->SetPlaneRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPlaneRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPlaneRadius());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetSphereOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetSphereOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the sphereOrigin in the object as modified.
    obj->data->SelectSphereOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetSphereOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sphereOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *sphereOrigin = obj->data->GetSphereOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(sphereOrigin[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetSphereRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sphereRadius in the object.
    obj->data->SetSphereRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetSphereRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSphereRadius());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetBoxExtents(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetBoxExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the boxExtents in the object as modified.
    obj->data->SelectBoxExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetBoxExtents(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boxExtents.
    PyObject *retval = PyTuple_New(6);
    const double *boxExtents = obj->data->GetBoxExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(boxExtents[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetUseWholeBox(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useWholeBox in the object.
    obj->data->SetUseWholeBox(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetUseWholeBox(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseWholeBox()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPointList(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    doubleVector  &vec = obj->data->GetPointList();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the pointList in the object as modified.
    obj->data->SelectPointList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPointList(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointList.
    const doubleVector &pointList = obj->data->GetPointList();
    PyObject *retval = PyTuple_New(pointList.size());
    for(size_t i = 0; i < pointList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointList[i]));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPointDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointDensity in the object.
    obj->data->SetPointDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPointDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointDensity()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetDisplayMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayMethod(StreamlineAttributes::DisplayMethod(ival));
    else
    {
        fprintf(stderr, "An invalid displayMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Lines, Tubes, Ribbons.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetDisplayMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayMethod()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetShowSeeds(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showSeeds in the object.
    obj->data->SetShowSeeds(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetShowSeeds(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowSeeds()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetShowHeads(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showHeads in the object.
    obj->data->SetShowHeads(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetShowHeads(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowHeads()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetTubeRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tubeRadius in the object.
    obj->data->SetTubeRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetTubeRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTubeRadius());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetRibbonWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the ribbonWidth in the object.
    obj->data->SetRibbonWidth(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetRibbonWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRibbonWidth());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetColoringMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coloringMethod in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetColoringMethod(StreamlineAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid coloringMethod value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Solid, ColorBySpeed, ColorByVorticity, ColorByLength, ColorByTime, "
                        "ColorBySeedPointID, ColorByVariable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetColoringMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColoringMethod()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetStreamlineDirection(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the streamlineDirection in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetStreamlineDirection(StreamlineAttributes::IntegrationDirection(ival));
    else
    {
        fprintf(stderr, "An invalid streamlineDirection value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Forward, Backward, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetStreamlineDirection(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStreamlineDirection()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetAbsTol(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTol in the object.
    obj->data->SetAbsTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetAbsTol(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTol());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetTerminationType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminationType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTerminationType(StreamlineAttributes::TerminationType(ival));
    else
    {
        fprintf(stderr, "An invalid terminationType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Distance, Time, Step.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetTerminationType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTerminationType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetIntegrationType(StreamlineAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "DormandPrince, AdamsBashforth, M3DC1Integrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetStreamlineAlgorithmType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the streamlineAlgorithmType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetStreamlineAlgorithmType(StreamlineAttributes::StreamlineAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid streamlineAlgorithmType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetStreamlineAlgorithmType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStreamlineAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetMaxStreamlineProcessCount(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxStreamlineProcessCount in the object.
    obj->data->SetMaxStreamlineProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetMaxStreamlineProcessCount(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxStreamlineProcessCount()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetPathlines(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlines in the object.
    obj->data->SetPathlines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetPathlines(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetColoringVariable(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the coloringVariable in the object.
    obj->data->SetColoringVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetColoringVariable(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColoringVariable().c_str());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLegendMinFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendMinFlag in the object.
    obj->data->SetLegendMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLegendMinFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLegendMaxFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendMaxFlag in the object.
    obj->data->SetLegendMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLegendMaxFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLegendMin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the legendMin in the object.
    obj->data->SetLegendMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLegendMin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLegendMin());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetLegendMax(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the legendMax in the object.
    obj->data->SetLegendMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetLegendMax(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLegendMax());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetDisplayBegin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the displayBegin in the object.
    obj->data->SetDisplayBegin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetDisplayBegin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDisplayBegin());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetDisplayEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the displayEnd in the object.
    obj->data->SetDisplayEnd(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetDisplayEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDisplayEnd());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetDisplayBeginFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayBeginFlag in the object.
    obj->data->SetDisplayBeginFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetDisplayBeginFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayBeginFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetDisplayEndFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayEndFlag in the object.
    obj->data->SetDisplayEndFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetDisplayEndFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayEndFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetSeedDisplayRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the seedDisplayRadius in the object.
    obj->data->SetSeedDisplayRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetSeedDisplayRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSeedDisplayRadius());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetHeadDisplayType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the headDisplayType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetHeadDisplayType(StreamlineAttributes::GeomDisplayType(ival));
    else
    {
        fprintf(stderr, "An invalid headDisplayType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Sphere, Cone.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetHeadDisplayType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHeadDisplayType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetHeadDisplayRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the headDisplayRadius in the object.
    obj->data->SetHeadDisplayRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetHeadDisplayRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHeadDisplayRadius());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetHeadDisplayHeight(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the headDisplayHeight in the object.
    obj->data->SetHeadDisplayHeight(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetHeadDisplayHeight(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHeadDisplayHeight());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetOpacityType(StreamlineAttributes::OpacityType(ival));
    else
    {
        fprintf(stderr, "An invalid opacityType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, Constant, Ramp, VariableRange.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityType()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityVariable(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the opacityVariable in the object.
    obj->data->SetOpacityVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityVariable(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOpacityVariable().c_str());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityVarMin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacityVarMin in the object.
    obj->data->SetOpacityVarMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityVarMin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacityVarMin());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityVarMax(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacityVarMax in the object.
    obj->data->SetOpacityVarMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityVarMax(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacityVarMax());
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityVarMinFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityVarMinFlag in the object.
    obj->data->SetOpacityVarMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityVarMinFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOpacityVarMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetOpacityVarMaxFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityVarMaxFlag in the object.
    obj->data->SetOpacityVarMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetOpacityVarMaxFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOpacityVarMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetTubeDisplayDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tubeDisplayDensity in the object.
    obj->data->SetTubeDisplayDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetTubeDisplayDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTubeDisplayDensity()));
    return retval;
}

/*static*/ PyObject *
StreamlineAttributes_SetGeomDisplayQuality(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the geomDisplayQuality in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetGeomDisplayQuality(StreamlineAttributes::DisplayQuality(ival));
    else
    {
        fprintf(stderr, "An invalid geomDisplayQuality value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Low, Medium, High, Super.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
StreamlineAttributes_GetGeomDisplayQuality(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGeomDisplayQuality()));
    return retval;
}



PyMethodDef PyStreamlineAttributes_methods[STREAMLINEATTRIBUTES_NMETH] = {
    {"Notify", StreamlineAttributes_Notify, METH_VARARGS},
    {"SetSourceType", StreamlineAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", StreamlineAttributes_GetSourceType, METH_VARARGS},
    {"SetMaxStepLength", StreamlineAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", StreamlineAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetTermination", StreamlineAttributes_SetTermination, METH_VARARGS},
    {"GetTermination", StreamlineAttributes_GetTermination, METH_VARARGS},
    {"SetPointSource", StreamlineAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", StreamlineAttributes_GetPointSource, METH_VARARGS},
    {"SetLineStart", StreamlineAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", StreamlineAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", StreamlineAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", StreamlineAttributes_GetLineEnd, METH_VARARGS},
    {"SetPlaneOrigin", StreamlineAttributes_SetPlaneOrigin, METH_VARARGS},
    {"GetPlaneOrigin", StreamlineAttributes_GetPlaneOrigin, METH_VARARGS},
    {"SetPlaneNormal", StreamlineAttributes_SetPlaneNormal, METH_VARARGS},
    {"GetPlaneNormal", StreamlineAttributes_GetPlaneNormal, METH_VARARGS},
    {"SetPlaneUpAxis", StreamlineAttributes_SetPlaneUpAxis, METH_VARARGS},
    {"GetPlaneUpAxis", StreamlineAttributes_GetPlaneUpAxis, METH_VARARGS},
    {"SetPlaneRadius", StreamlineAttributes_SetPlaneRadius, METH_VARARGS},
    {"GetPlaneRadius", StreamlineAttributes_GetPlaneRadius, METH_VARARGS},
    {"SetSphereOrigin", StreamlineAttributes_SetSphereOrigin, METH_VARARGS},
    {"GetSphereOrigin", StreamlineAttributes_GetSphereOrigin, METH_VARARGS},
    {"SetSphereRadius", StreamlineAttributes_SetSphereRadius, METH_VARARGS},
    {"GetSphereRadius", StreamlineAttributes_GetSphereRadius, METH_VARARGS},
    {"SetBoxExtents", StreamlineAttributes_SetBoxExtents, METH_VARARGS},
    {"GetBoxExtents", StreamlineAttributes_GetBoxExtents, METH_VARARGS},
    {"SetUseWholeBox", StreamlineAttributes_SetUseWholeBox, METH_VARARGS},
    {"GetUseWholeBox", StreamlineAttributes_GetUseWholeBox, METH_VARARGS},
    {"SetPointList", StreamlineAttributes_SetPointList, METH_VARARGS},
    {"GetPointList", StreamlineAttributes_GetPointList, METH_VARARGS},
    {"SetPointDensity", StreamlineAttributes_SetPointDensity, METH_VARARGS},
    {"GetPointDensity", StreamlineAttributes_GetPointDensity, METH_VARARGS},
    {"SetDisplayMethod", StreamlineAttributes_SetDisplayMethod, METH_VARARGS},
    {"GetDisplayMethod", StreamlineAttributes_GetDisplayMethod, METH_VARARGS},
    {"SetShowSeeds", StreamlineAttributes_SetShowSeeds, METH_VARARGS},
    {"GetShowSeeds", StreamlineAttributes_GetShowSeeds, METH_VARARGS},
    {"SetShowHeads", StreamlineAttributes_SetShowHeads, METH_VARARGS},
    {"GetShowHeads", StreamlineAttributes_GetShowHeads, METH_VARARGS},
    {"SetTubeRadius", StreamlineAttributes_SetTubeRadius, METH_VARARGS},
    {"GetTubeRadius", StreamlineAttributes_GetTubeRadius, METH_VARARGS},
    {"SetRibbonWidth", StreamlineAttributes_SetRibbonWidth, METH_VARARGS},
    {"GetRibbonWidth", StreamlineAttributes_GetRibbonWidth, METH_VARARGS},
    {"SetLineWidth", StreamlineAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", StreamlineAttributes_GetLineWidth, METH_VARARGS},
    {"SetColoringMethod", StreamlineAttributes_SetColoringMethod, METH_VARARGS},
    {"GetColoringMethod", StreamlineAttributes_GetColoringMethod, METH_VARARGS},
    {"SetColorTableName", StreamlineAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", StreamlineAttributes_GetColorTableName, METH_VARARGS},
    {"SetSingleColor", StreamlineAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", StreamlineAttributes_GetSingleColor, METH_VARARGS},
    {"SetLegendFlag", StreamlineAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", StreamlineAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", StreamlineAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", StreamlineAttributes_GetLightingFlag, METH_VARARGS},
    {"SetStreamlineDirection", StreamlineAttributes_SetStreamlineDirection, METH_VARARGS},
    {"GetStreamlineDirection", StreamlineAttributes_GetStreamlineDirection, METH_VARARGS},
    {"SetRelTol", StreamlineAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", StreamlineAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTol", StreamlineAttributes_SetAbsTol, METH_VARARGS},
    {"GetAbsTol", StreamlineAttributes_GetAbsTol, METH_VARARGS},
    {"SetTerminationType", StreamlineAttributes_SetTerminationType, METH_VARARGS},
    {"GetTerminationType", StreamlineAttributes_GetTerminationType, METH_VARARGS},
    {"SetIntegrationType", StreamlineAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", StreamlineAttributes_GetIntegrationType, METH_VARARGS},
    {"SetStreamlineAlgorithmType", StreamlineAttributes_SetStreamlineAlgorithmType, METH_VARARGS},
    {"GetStreamlineAlgorithmType", StreamlineAttributes_GetStreamlineAlgorithmType, METH_VARARGS},
    {"SetMaxStreamlineProcessCount", StreamlineAttributes_SetMaxStreamlineProcessCount, METH_VARARGS},
    {"GetMaxStreamlineProcessCount", StreamlineAttributes_GetMaxStreamlineProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", StreamlineAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", StreamlineAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", StreamlineAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", StreamlineAttributes_GetWorkGroupSize, METH_VARARGS},
    {"SetPathlines", StreamlineAttributes_SetPathlines, METH_VARARGS},
    {"GetPathlines", StreamlineAttributes_GetPathlines, METH_VARARGS},
    {"SetColoringVariable", StreamlineAttributes_SetColoringVariable, METH_VARARGS},
    {"GetColoringVariable", StreamlineAttributes_GetColoringVariable, METH_VARARGS},
    {"SetLegendMinFlag", StreamlineAttributes_SetLegendMinFlag, METH_VARARGS},
    {"GetLegendMinFlag", StreamlineAttributes_GetLegendMinFlag, METH_VARARGS},
    {"SetLegendMaxFlag", StreamlineAttributes_SetLegendMaxFlag, METH_VARARGS},
    {"GetLegendMaxFlag", StreamlineAttributes_GetLegendMaxFlag, METH_VARARGS},
    {"SetLegendMin", StreamlineAttributes_SetLegendMin, METH_VARARGS},
    {"GetLegendMin", StreamlineAttributes_GetLegendMin, METH_VARARGS},
    {"SetLegendMax", StreamlineAttributes_SetLegendMax, METH_VARARGS},
    {"GetLegendMax", StreamlineAttributes_GetLegendMax, METH_VARARGS},
    {"SetDisplayBegin", StreamlineAttributes_SetDisplayBegin, METH_VARARGS},
    {"GetDisplayBegin", StreamlineAttributes_GetDisplayBegin, METH_VARARGS},
    {"SetDisplayEnd", StreamlineAttributes_SetDisplayEnd, METH_VARARGS},
    {"GetDisplayEnd", StreamlineAttributes_GetDisplayEnd, METH_VARARGS},
    {"SetDisplayBeginFlag", StreamlineAttributes_SetDisplayBeginFlag, METH_VARARGS},
    {"GetDisplayBeginFlag", StreamlineAttributes_GetDisplayBeginFlag, METH_VARARGS},
    {"SetDisplayEndFlag", StreamlineAttributes_SetDisplayEndFlag, METH_VARARGS},
    {"GetDisplayEndFlag", StreamlineAttributes_GetDisplayEndFlag, METH_VARARGS},
    {"SetSeedDisplayRadius", StreamlineAttributes_SetSeedDisplayRadius, METH_VARARGS},
    {"GetSeedDisplayRadius", StreamlineAttributes_GetSeedDisplayRadius, METH_VARARGS},
    {"SetHeadDisplayType", StreamlineAttributes_SetHeadDisplayType, METH_VARARGS},
    {"GetHeadDisplayType", StreamlineAttributes_GetHeadDisplayType, METH_VARARGS},
    {"SetHeadDisplayRadius", StreamlineAttributes_SetHeadDisplayRadius, METH_VARARGS},
    {"GetHeadDisplayRadius", StreamlineAttributes_GetHeadDisplayRadius, METH_VARARGS},
    {"SetHeadDisplayHeight", StreamlineAttributes_SetHeadDisplayHeight, METH_VARARGS},
    {"GetHeadDisplayHeight", StreamlineAttributes_GetHeadDisplayHeight, METH_VARARGS},
    {"SetOpacityType", StreamlineAttributes_SetOpacityType, METH_VARARGS},
    {"GetOpacityType", StreamlineAttributes_GetOpacityType, METH_VARARGS},
    {"SetOpacityVariable", StreamlineAttributes_SetOpacityVariable, METH_VARARGS},
    {"GetOpacityVariable", StreamlineAttributes_GetOpacityVariable, METH_VARARGS},
    {"SetOpacity", StreamlineAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", StreamlineAttributes_GetOpacity, METH_VARARGS},
    {"SetOpacityVarMin", StreamlineAttributes_SetOpacityVarMin, METH_VARARGS},
    {"GetOpacityVarMin", StreamlineAttributes_GetOpacityVarMin, METH_VARARGS},
    {"SetOpacityVarMax", StreamlineAttributes_SetOpacityVarMax, METH_VARARGS},
    {"GetOpacityVarMax", StreamlineAttributes_GetOpacityVarMax, METH_VARARGS},
    {"SetOpacityVarMinFlag", StreamlineAttributes_SetOpacityVarMinFlag, METH_VARARGS},
    {"GetOpacityVarMinFlag", StreamlineAttributes_GetOpacityVarMinFlag, METH_VARARGS},
    {"SetOpacityVarMaxFlag", StreamlineAttributes_SetOpacityVarMaxFlag, METH_VARARGS},
    {"GetOpacityVarMaxFlag", StreamlineAttributes_GetOpacityVarMaxFlag, METH_VARARGS},
    {"SetTubeDisplayDensity", StreamlineAttributes_SetTubeDisplayDensity, METH_VARARGS},
    {"GetTubeDisplayDensity", StreamlineAttributes_GetTubeDisplayDensity, METH_VARARGS},
    {"SetGeomDisplayQuality", StreamlineAttributes_SetGeomDisplayQuality, METH_VARARGS},
    {"GetGeomDisplayQuality", StreamlineAttributes_GetGeomDisplayQuality, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
StreamlineAttributes_dealloc(PyObject *v)
{
   StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
StreamlineAttributes_compare(PyObject *v, PyObject *w)
{
    StreamlineAttributes *a = ((StreamlineAttributesObject *)v)->data;
    StreamlineAttributes *b = ((StreamlineAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyStreamlineAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return StreamlineAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedPoint));
    if(strcmp(name, "SpecifiedPointList") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedPointList));
    if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedLine));
    if(strcmp(name, "SpecifiedCircle") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedCircle));
    if(strcmp(name, "SpecifiedPlane") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedPlane));
    if(strcmp(name, "SpecifiedSphere") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedSphere));
    if(strcmp(name, "SpecifiedBox") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedBox));

    if(strcmp(name, "maxStepLength") == 0)
        return StreamlineAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "termination") == 0)
        return StreamlineAttributes_GetTermination(self, NULL);
    if(strcmp(name, "pointSource") == 0)
        return StreamlineAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return StreamlineAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return StreamlineAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "planeOrigin") == 0)
        return StreamlineAttributes_GetPlaneOrigin(self, NULL);
    if(strcmp(name, "planeNormal") == 0)
        return StreamlineAttributes_GetPlaneNormal(self, NULL);
    if(strcmp(name, "planeUpAxis") == 0)
        return StreamlineAttributes_GetPlaneUpAxis(self, NULL);
    if(strcmp(name, "planeRadius") == 0)
        return StreamlineAttributes_GetPlaneRadius(self, NULL);
    if(strcmp(name, "sphereOrigin") == 0)
        return StreamlineAttributes_GetSphereOrigin(self, NULL);
    if(strcmp(name, "sphereRadius") == 0)
        return StreamlineAttributes_GetSphereRadius(self, NULL);
    if(strcmp(name, "boxExtents") == 0)
        return StreamlineAttributes_GetBoxExtents(self, NULL);
    if(strcmp(name, "useWholeBox") == 0)
        return StreamlineAttributes_GetUseWholeBox(self, NULL);
    if(strcmp(name, "pointList") == 0)
        return StreamlineAttributes_GetPointList(self, NULL);
    if(strcmp(name, "pointDensity") == 0)
        return StreamlineAttributes_GetPointDensity(self, NULL);
    if(strcmp(name, "displayMethod") == 0)
        return StreamlineAttributes_GetDisplayMethod(self, NULL);
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Lines));
    if(strcmp(name, "Tubes") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Tubes));
    if(strcmp(name, "Ribbons") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Ribbons));

    if(strcmp(name, "showSeeds") == 0)
        return StreamlineAttributes_GetShowSeeds(self, NULL);
    if(strcmp(name, "showHeads") == 0)
        return StreamlineAttributes_GetShowHeads(self, NULL);
    if(strcmp(name, "tubeRadius") == 0)
        return StreamlineAttributes_GetTubeRadius(self, NULL);
    if(strcmp(name, "ribbonWidth") == 0)
        return StreamlineAttributes_GetRibbonWidth(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return StreamlineAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "coloringMethod") == 0)
        return StreamlineAttributes_GetColoringMethod(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Solid));
    if(strcmp(name, "ColorBySpeed") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorBySpeed));
    if(strcmp(name, "ColorByVorticity") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorByVorticity));
    if(strcmp(name, "ColorByLength") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorByLength));
    if(strcmp(name, "ColorByTime") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorByTime));
    if(strcmp(name, "ColorBySeedPointID") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorBySeedPointID));
    if(strcmp(name, "ColorByVariable") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorByVariable));

    if(strcmp(name, "colorTableName") == 0)
        return StreamlineAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return StreamlineAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return StreamlineAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return StreamlineAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "streamlineDirection") == 0)
        return StreamlineAttributes_GetStreamlineDirection(self, NULL);
    if(strcmp(name, "Forward") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Forward));
    if(strcmp(name, "Backward") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Backward));
    if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Both));

    if(strcmp(name, "relTol") == 0)
        return StreamlineAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTol") == 0)
        return StreamlineAttributes_GetAbsTol(self, NULL);
    if(strcmp(name, "terminationType") == 0)
        return StreamlineAttributes_GetTerminationType(self, NULL);
    if(strcmp(name, "Distance") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Distance));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Time));
    if(strcmp(name, "Step") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Step));

    if(strcmp(name, "integrationType") == 0)
        return StreamlineAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::AdamsBashforth));
    if(strcmp(name, "M3DC1Integrator") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::M3DC1Integrator));

    if(strcmp(name, "streamlineAlgorithmType") == 0)
        return StreamlineAttributes_GetStreamlineAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::MasterSlave));

    if(strcmp(name, "maxStreamlineProcessCount") == 0)
        return StreamlineAttributes_GetMaxStreamlineProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return StreamlineAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return StreamlineAttributes_GetWorkGroupSize(self, NULL);
    if(strcmp(name, "pathlines") == 0)
        return StreamlineAttributes_GetPathlines(self, NULL);
    if(strcmp(name, "coloringVariable") == 0)
        return StreamlineAttributes_GetColoringVariable(self, NULL);
    if(strcmp(name, "legendMinFlag") == 0)
        return StreamlineAttributes_GetLegendMinFlag(self, NULL);
    if(strcmp(name, "legendMaxFlag") == 0)
        return StreamlineAttributes_GetLegendMaxFlag(self, NULL);
    if(strcmp(name, "legendMin") == 0)
        return StreamlineAttributes_GetLegendMin(self, NULL);
    if(strcmp(name, "legendMax") == 0)
        return StreamlineAttributes_GetLegendMax(self, NULL);
    if(strcmp(name, "displayBegin") == 0)
        return StreamlineAttributes_GetDisplayBegin(self, NULL);
    if(strcmp(name, "displayEnd") == 0)
        return StreamlineAttributes_GetDisplayEnd(self, NULL);
    if(strcmp(name, "displayBeginFlag") == 0)
        return StreamlineAttributes_GetDisplayBeginFlag(self, NULL);
    if(strcmp(name, "displayEndFlag") == 0)
        return StreamlineAttributes_GetDisplayEndFlag(self, NULL);
    if(strcmp(name, "seedDisplayRadius") == 0)
        return StreamlineAttributes_GetSeedDisplayRadius(self, NULL);
    if(strcmp(name, "headDisplayType") == 0)
        return StreamlineAttributes_GetHeadDisplayType(self, NULL);
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Sphere));
    if(strcmp(name, "Cone") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Cone));

    if(strcmp(name, "headDisplayRadius") == 0)
        return StreamlineAttributes_GetHeadDisplayRadius(self, NULL);
    if(strcmp(name, "headDisplayHeight") == 0)
        return StreamlineAttributes_GetHeadDisplayHeight(self, NULL);
    if(strcmp(name, "opacityType") == 0)
        return StreamlineAttributes_GetOpacityType(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::None));
    if(strcmp(name, "Constant") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Constant));
    if(strcmp(name, "Ramp") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Ramp));
    if(strcmp(name, "VariableRange") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::VariableRange));

    if(strcmp(name, "opacityVariable") == 0)
        return StreamlineAttributes_GetOpacityVariable(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return StreamlineAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "opacityVarMin") == 0)
        return StreamlineAttributes_GetOpacityVarMin(self, NULL);
    if(strcmp(name, "opacityVarMax") == 0)
        return StreamlineAttributes_GetOpacityVarMax(self, NULL);
    if(strcmp(name, "opacityVarMinFlag") == 0)
        return StreamlineAttributes_GetOpacityVarMinFlag(self, NULL);
    if(strcmp(name, "opacityVarMaxFlag") == 0)
        return StreamlineAttributes_GetOpacityVarMaxFlag(self, NULL);
    if(strcmp(name, "tubeDisplayDensity") == 0)
        return StreamlineAttributes_GetTubeDisplayDensity(self, NULL);
    if(strcmp(name, "geomDisplayQuality") == 0)
        return StreamlineAttributes_GetGeomDisplayQuality(self, NULL);
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::High));
    if(strcmp(name, "Super") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Super));


    return Py_FindMethod(PyStreamlineAttributes_methods, self, name);
}

int
PyStreamlineAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "sourceType") == 0)
        obj = StreamlineAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = StreamlineAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "termination") == 0)
        obj = StreamlineAttributes_SetTermination(self, tuple);
    else if(strcmp(name, "pointSource") == 0)
        obj = StreamlineAttributes_SetPointSource(self, tuple);
    else if(strcmp(name, "lineStart") == 0)
        obj = StreamlineAttributes_SetLineStart(self, tuple);
    else if(strcmp(name, "lineEnd") == 0)
        obj = StreamlineAttributes_SetLineEnd(self, tuple);
    else if(strcmp(name, "planeOrigin") == 0)
        obj = StreamlineAttributes_SetPlaneOrigin(self, tuple);
    else if(strcmp(name, "planeNormal") == 0)
        obj = StreamlineAttributes_SetPlaneNormal(self, tuple);
    else if(strcmp(name, "planeUpAxis") == 0)
        obj = StreamlineAttributes_SetPlaneUpAxis(self, tuple);
    else if(strcmp(name, "planeRadius") == 0)
        obj = StreamlineAttributes_SetPlaneRadius(self, tuple);
    else if(strcmp(name, "sphereOrigin") == 0)
        obj = StreamlineAttributes_SetSphereOrigin(self, tuple);
    else if(strcmp(name, "sphereRadius") == 0)
        obj = StreamlineAttributes_SetSphereRadius(self, tuple);
    else if(strcmp(name, "boxExtents") == 0)
        obj = StreamlineAttributes_SetBoxExtents(self, tuple);
    else if(strcmp(name, "useWholeBox") == 0)
        obj = StreamlineAttributes_SetUseWholeBox(self, tuple);
    else if(strcmp(name, "pointList") == 0)
        obj = StreamlineAttributes_SetPointList(self, tuple);
    else if(strcmp(name, "pointDensity") == 0)
        obj = StreamlineAttributes_SetPointDensity(self, tuple);
    else if(strcmp(name, "displayMethod") == 0)
        obj = StreamlineAttributes_SetDisplayMethod(self, tuple);
    else if(strcmp(name, "showSeeds") == 0)
        obj = StreamlineAttributes_SetShowSeeds(self, tuple);
    else if(strcmp(name, "showHeads") == 0)
        obj = StreamlineAttributes_SetShowHeads(self, tuple);
    else if(strcmp(name, "tubeRadius") == 0)
        obj = StreamlineAttributes_SetTubeRadius(self, tuple);
    else if(strcmp(name, "ribbonWidth") == 0)
        obj = StreamlineAttributes_SetRibbonWidth(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = StreamlineAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "coloringMethod") == 0)
        obj = StreamlineAttributes_SetColoringMethod(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = StreamlineAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = StreamlineAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = StreamlineAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = StreamlineAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "streamlineDirection") == 0)
        obj = StreamlineAttributes_SetStreamlineDirection(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = StreamlineAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTol") == 0)
        obj = StreamlineAttributes_SetAbsTol(self, tuple);
    else if(strcmp(name, "terminationType") == 0)
        obj = StreamlineAttributes_SetTerminationType(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = StreamlineAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "streamlineAlgorithmType") == 0)
        obj = StreamlineAttributes_SetStreamlineAlgorithmType(self, tuple);
    else if(strcmp(name, "maxStreamlineProcessCount") == 0)
        obj = StreamlineAttributes_SetMaxStreamlineProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = StreamlineAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = StreamlineAttributes_SetWorkGroupSize(self, tuple);
    else if(strcmp(name, "pathlines") == 0)
        obj = StreamlineAttributes_SetPathlines(self, tuple);
    else if(strcmp(name, "coloringVariable") == 0)
        obj = StreamlineAttributes_SetColoringVariable(self, tuple);
    else if(strcmp(name, "legendMinFlag") == 0)
        obj = StreamlineAttributes_SetLegendMinFlag(self, tuple);
    else if(strcmp(name, "legendMaxFlag") == 0)
        obj = StreamlineAttributes_SetLegendMaxFlag(self, tuple);
    else if(strcmp(name, "legendMin") == 0)
        obj = StreamlineAttributes_SetLegendMin(self, tuple);
    else if(strcmp(name, "legendMax") == 0)
        obj = StreamlineAttributes_SetLegendMax(self, tuple);
    else if(strcmp(name, "displayBegin") == 0)
        obj = StreamlineAttributes_SetDisplayBegin(self, tuple);
    else if(strcmp(name, "displayEnd") == 0)
        obj = StreamlineAttributes_SetDisplayEnd(self, tuple);
    else if(strcmp(name, "displayBeginFlag") == 0)
        obj = StreamlineAttributes_SetDisplayBeginFlag(self, tuple);
    else if(strcmp(name, "displayEndFlag") == 0)
        obj = StreamlineAttributes_SetDisplayEndFlag(self, tuple);
    else if(strcmp(name, "seedDisplayRadius") == 0)
        obj = StreamlineAttributes_SetSeedDisplayRadius(self, tuple);
    else if(strcmp(name, "headDisplayType") == 0)
        obj = StreamlineAttributes_SetHeadDisplayType(self, tuple);
    else if(strcmp(name, "headDisplayRadius") == 0)
        obj = StreamlineAttributes_SetHeadDisplayRadius(self, tuple);
    else if(strcmp(name, "headDisplayHeight") == 0)
        obj = StreamlineAttributes_SetHeadDisplayHeight(self, tuple);
    else if(strcmp(name, "opacityType") == 0)
        obj = StreamlineAttributes_SetOpacityType(self, tuple);
    else if(strcmp(name, "opacityVariable") == 0)
        obj = StreamlineAttributes_SetOpacityVariable(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = StreamlineAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "opacityVarMin") == 0)
        obj = StreamlineAttributes_SetOpacityVarMin(self, tuple);
    else if(strcmp(name, "opacityVarMax") == 0)
        obj = StreamlineAttributes_SetOpacityVarMax(self, tuple);
    else if(strcmp(name, "opacityVarMinFlag") == 0)
        obj = StreamlineAttributes_SetOpacityVarMinFlag(self, tuple);
    else if(strcmp(name, "opacityVarMaxFlag") == 0)
        obj = StreamlineAttributes_SetOpacityVarMaxFlag(self, tuple);
    else if(strcmp(name, "tubeDisplayDensity") == 0)
        obj = StreamlineAttributes_SetTubeDisplayDensity(self, tuple);
    else if(strcmp(name, "geomDisplayQuality") == 0)
        obj = StreamlineAttributes_SetGeomDisplayQuality(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
StreamlineAttributes_print(PyObject *v, FILE *fp, int flags)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;
    fprintf(fp, "%s", PyStreamlineAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
StreamlineAttributes_str(PyObject *v)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;
    return PyString_FromString(PyStreamlineAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *StreamlineAttributes_Purpose = "Attributes for the Streamline plot";
#else
static char *StreamlineAttributes_Purpose = "Attributes for the Streamline plot";
#endif

//
// The type description structure
//
static PyTypeObject StreamlineAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "StreamlineAttributes",                    // tp_name
    sizeof(StreamlineAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)StreamlineAttributes_dealloc,  // tp_dealloc
    (printfunc)StreamlineAttributes_print,     // tp_print
    (getattrfunc)PyStreamlineAttributes_getattr, // tp_getattr
    (setattrfunc)PyStreamlineAttributes_setattr, // tp_setattr
    (cmpfunc)StreamlineAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)StreamlineAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    StreamlineAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static StreamlineAttributes *defaultAtts = 0;
static StreamlineAttributes *currentAtts = 0;

static PyObject *
NewStreamlineAttributes(int useCurrent)
{
    StreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(StreamlineAttributesObject, &StreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new StreamlineAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new StreamlineAttributes(*defaultAtts);
    else
        newObject->data = new StreamlineAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapStreamlineAttributes(const StreamlineAttributes *attr)
{
    StreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(StreamlineAttributesObject, &StreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (StreamlineAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
StreamlineAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewStreamlineAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef StreamlineAttributesMethods[] = {
    {"StreamlineAttributes", StreamlineAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *StreamlineAttributesObserver = 0;

std::string
PyStreamlineAttributes_GetLogString()
{
    std::string s("StreamlineAtts = StreamlineAttributes()\n");
    if(currentAtts != 0)
        s += PyStreamlineAttributes_ToString(currentAtts, "StreamlineAtts.");
    return s;
}

static void
PyStreamlineAttributes_CallLogRoutine(Subject *subj, void *data)
{
    StreamlineAttributes *atts = (StreamlineAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("StreamlineAtts = StreamlineAttributes()\n");
        s += PyStreamlineAttributes_ToString(currentAtts, "StreamlineAtts.");
        cb(s);
    }
}

void
PyStreamlineAttributes_StartUp(StreamlineAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyStreamlineAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(StreamlineAttributesObserver == 0)
    {
        StreamlineAttributesObserver = new ObserverToCallback(subj,
            PyStreamlineAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyStreamlineAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete StreamlineAttributesObserver;
    StreamlineAttributesObserver = 0;
}

PyMethodDef *
PyStreamlineAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return StreamlineAttributesMethods;
}

bool
PyStreamlineAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &StreamlineAttributesType);
}

StreamlineAttributes *
PyStreamlineAttributes_FromPyObject(PyObject *obj)
{
    StreamlineAttributesObject *obj2 = (StreamlineAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyStreamlineAttributes_New()
{
    return NewStreamlineAttributes(0);
}

PyObject *
PyStreamlineAttributes_Wrap(const StreamlineAttributes *attr)
{
    return WrapStreamlineAttributes(attr);
}

void
PyStreamlineAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    StreamlineAttributesObject *obj2 = (StreamlineAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyStreamlineAttributes_SetDefaults(const StreamlineAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new StreamlineAttributes(*atts);
}

