/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLegacyStreamlineAttributes.h>
#include <ObserverToCallback.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyLegacyStreamlineAttributes
//
// Purpose: 
//   Attributes for the LegacyStreamline plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Feb 5 15:15:22 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a LegacyStreamlineAttributes.
//
struct LegacyStreamlineAttributesObject
{
    PyObject_HEAD
    LegacyStreamlineAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLegacyStreamlineAttributes(int);

std::string
PyLegacyStreamlineAttributes_ToString(const LegacyStreamlineAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *sourceType_names = "SpecifiedPoint, SpecifiedLine, SpecifiedPlane, SpecifiedSphere, SpecifiedBox";
    if(atts->GetSourceType() == LegacyStreamlineAttributes::SpecifiedPoint)
    {
        SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPoint  # %s\n", prefix, prefix, sourceType_names);
        str += tmpStr;
    }
    else if(atts->GetSourceType() == LegacyStreamlineAttributes::SpecifiedLine)
    {
        SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
        str += tmpStr;
    }
    else if(atts->GetSourceType() == LegacyStreamlineAttributes::SpecifiedPlane)
    {
        SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPlane  # %s\n", prefix, prefix, sourceType_names);
        str += tmpStr;
    }
    else if(atts->GetSourceType() == LegacyStreamlineAttributes::SpecifiedSphere)
    {
        SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedSphere  # %s\n", prefix, prefix, sourceType_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedBox  # %s\n", prefix, prefix, sourceType_names);
        str += tmpStr;
    }

    SNPRINTF(tmpStr, 1000, "%sstepLength = %g\n", prefix, atts->GetStepLength());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxTime = %g\n", prefix, atts->GetMaxTime());
    str += tmpStr;
    {   const double *pointSource = atts->GetPointSource();
        SNPRINTF(tmpStr, 1000, "%spointSource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        SNPRINTF(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        SNPRINTF(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeOrigin = atts->GetPlaneOrigin();
        SNPRINTF(tmpStr, 1000, "%splaneOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNormal = atts->GetPlaneNormal();
        SNPRINTF(tmpStr, 1000, "%splaneNormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeUpAxis = atts->GetPlaneUpAxis();
        SNPRINTF(tmpStr, 1000, "%splaneUpAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeUpAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%splaneRadius = %g\n", prefix, atts->GetPlaneRadius());
    str += tmpStr;
    {   const double *sphereOrigin = atts->GetSphereOrigin();
        SNPRINTF(tmpStr, 1000, "%ssphereOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", sphereOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%ssphereRadius = %g\n", prefix, atts->GetSphereRadius());
    str += tmpStr;
    {   const double *boxExtents = atts->GetBoxExtents();
        SNPRINTF(tmpStr, 1000, "%sboxExtents = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", boxExtents[i]);
            str += tmpStr;
            if(i < 5)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseWholeBox())
        SNPRINTF(tmpStr, 1000, "%suseWholeBox = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseWholeBox = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointDensity = %d\n", prefix, atts->GetPointDensity());
    str += tmpStr;
    const char *displayMethod_names = "Lines, Tubes, Ribbons";
    if(atts->GetDisplayMethod() == LegacyStreamlineAttributes::Lines)
    {
        SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sLines  # %s\n", prefix, prefix, displayMethod_names);
        str += tmpStr;
    }
    else if(atts->GetDisplayMethod() == LegacyStreamlineAttributes::Tubes)
    {
        SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sTubes  # %s\n", prefix, prefix, displayMethod_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%sdisplayMethod = %sRibbons  # %s\n", prefix, prefix, displayMethod_names);
        str += tmpStr;
    }

    if(atts->GetShowStart())
        SNPRINTF(tmpStr, 1000, "%sshowStart = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowStart = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const char *coloringMethod_names = "Solid, ColorBySpeed, ColorByVorticity";
    if(atts->GetColoringMethod() == LegacyStreamlineAttributes::Solid)
    {
        SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sSolid  # %s\n", prefix, prefix, coloringMethod_names);
        str += tmpStr;
    }
    else if(atts->GetColoringMethod() == LegacyStreamlineAttributes::ColorBySpeed)
    {
        SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorBySpeed  # %s\n", prefix, prefix, coloringMethod_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%scoloringMethod = %sColorByVorticity  # %s\n", prefix, prefix, coloringMethod_names);
        str += tmpStr;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    const char *StreamlineDirection_names = "Forward, Backward, Both";
    if(atts->GetStreamlineDirection() == LegacyStreamlineAttributes::Forward)
    {
        SNPRINTF(tmpStr, 1000, "%sStreamlineDirection = %sForward  # %s\n", prefix, prefix, StreamlineDirection_names);
        str += tmpStr;
    }
    else if(atts->GetStreamlineDirection() == LegacyStreamlineAttributes::Backward)
    {
        SNPRINTF(tmpStr, 1000, "%sStreamlineDirection = %sBackward  # %s\n", prefix, prefix, StreamlineDirection_names);
        str += tmpStr;
    }
    else
    {
        SNPRINTF(tmpStr, 1000, "%sStreamlineDirection = %sBoth  # %s\n", prefix, prefix, StreamlineDirection_names);
        str += tmpStr;
    }

    return str;
}

static PyObject *
LegacyStreamlineAttributes_Notify(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetSourceType(LegacyStreamlineAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, SpecifiedLine, SpecifiedPlane, SpecifiedSphere, SpecifiedBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetStepLength(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the stepLength in the object.
    obj->data->SetStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetStepLength(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStepLength());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetMaxTime(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTime in the object.
    obj->data->SetMaxTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetMaxTime(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTime());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPlaneOrigin(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeOrigin in the object as modified.
    obj->data->SelectPlaneOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPlaneOrigin(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *planeOrigin = obj->data->GetPlaneOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeOrigin[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPlaneNormal(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNormal in the object as modified.
    obj->data->SelectPlaneNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPlaneNormal(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNormal.
    PyObject *retval = PyTuple_New(3);
    const double *planeNormal = obj->data->GetPlaneNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNormal[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPlaneUpAxis(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeUpAxis in the object as modified.
    obj->data->SelectPlaneUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPlaneUpAxis(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeUpAxis.
    PyObject *retval = PyTuple_New(3);
    const double *planeUpAxis = obj->data->GetPlaneUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeUpAxis[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPlaneRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the planeRadius in the object.
    obj->data->SetPlaneRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPlaneRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPlaneRadius());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetSphereOrigin(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetSphereOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the sphereOrigin in the object as modified.
    obj->data->SelectSphereOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetSphereOrigin(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sphereOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *sphereOrigin = obj->data->GetSphereOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(sphereOrigin[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetSphereRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sphereRadius in the object.
    obj->data->SetSphereRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetSphereRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSphereRadius());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetBoxExtents(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double *dvals = obj->data->GetBoxExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the boxExtents in the object as modified.
    obj->data->SelectBoxExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetBoxExtents(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boxExtents.
    PyObject *retval = PyTuple_New(6);
    const double *boxExtents = obj->data->GetBoxExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(boxExtents[i]));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetUseWholeBox(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useWholeBox in the object.
    obj->data->SetUseWholeBox(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetUseWholeBox(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseWholeBox()?1L:0L);
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetPointDensity(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointDensity in the object.
    obj->data->SetPointDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetPointDensity(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointDensity()));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetDisplayMethod(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayMethod(LegacyStreamlineAttributes::DisplayMethod(ival));
    else
    {
        fprintf(stderr, "An invalid displayMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Lines, Tubes, Ribbons.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetDisplayMethod(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayMethod()));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetShowStart(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showStart in the object.
    obj->data->SetShowStart(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetShowStart(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowStart()?1L:0L);
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetRadius(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetColoringMethod(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coloringMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColoringMethod(LegacyStreamlineAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid coloringMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Solid, ColorBySpeed, ColorByVorticity.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetColoringMethod(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColoringMethod()));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

static PyObject *
LegacyStreamlineAttributes_SetStreamlineDirection(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the StreamlineDirection in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetStreamlineDirection(LegacyStreamlineAttributes::IntegrationDirection(ival));
    else
    {
        fprintf(stderr, "An invalid StreamlineDirection value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Forward, Backward, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LegacyStreamlineAttributes_GetStreamlineDirection(PyObject *self, PyObject *args)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStreamlineDirection()));
    return retval;
}



static struct PyMethodDef LegacyStreamlineAttributes_methods[] = {
    {"Notify", LegacyStreamlineAttributes_Notify, METH_VARARGS},
    {"SetSourceType", LegacyStreamlineAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", LegacyStreamlineAttributes_GetSourceType, METH_VARARGS},
    {"SetStepLength", LegacyStreamlineAttributes_SetStepLength, METH_VARARGS},
    {"GetStepLength", LegacyStreamlineAttributes_GetStepLength, METH_VARARGS},
    {"SetMaxTime", LegacyStreamlineAttributes_SetMaxTime, METH_VARARGS},
    {"GetMaxTime", LegacyStreamlineAttributes_GetMaxTime, METH_VARARGS},
    {"SetPointSource", LegacyStreamlineAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", LegacyStreamlineAttributes_GetPointSource, METH_VARARGS},
    {"SetLineStart", LegacyStreamlineAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", LegacyStreamlineAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", LegacyStreamlineAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", LegacyStreamlineAttributes_GetLineEnd, METH_VARARGS},
    {"SetPlaneOrigin", LegacyStreamlineAttributes_SetPlaneOrigin, METH_VARARGS},
    {"GetPlaneOrigin", LegacyStreamlineAttributes_GetPlaneOrigin, METH_VARARGS},
    {"SetPlaneNormal", LegacyStreamlineAttributes_SetPlaneNormal, METH_VARARGS},
    {"GetPlaneNormal", LegacyStreamlineAttributes_GetPlaneNormal, METH_VARARGS},
    {"SetPlaneUpAxis", LegacyStreamlineAttributes_SetPlaneUpAxis, METH_VARARGS},
    {"GetPlaneUpAxis", LegacyStreamlineAttributes_GetPlaneUpAxis, METH_VARARGS},
    {"SetPlaneRadius", LegacyStreamlineAttributes_SetPlaneRadius, METH_VARARGS},
    {"GetPlaneRadius", LegacyStreamlineAttributes_GetPlaneRadius, METH_VARARGS},
    {"SetSphereOrigin", LegacyStreamlineAttributes_SetSphereOrigin, METH_VARARGS},
    {"GetSphereOrigin", LegacyStreamlineAttributes_GetSphereOrigin, METH_VARARGS},
    {"SetSphereRadius", LegacyStreamlineAttributes_SetSphereRadius, METH_VARARGS},
    {"GetSphereRadius", LegacyStreamlineAttributes_GetSphereRadius, METH_VARARGS},
    {"SetBoxExtents", LegacyStreamlineAttributes_SetBoxExtents, METH_VARARGS},
    {"GetBoxExtents", LegacyStreamlineAttributes_GetBoxExtents, METH_VARARGS},
    {"SetUseWholeBox", LegacyStreamlineAttributes_SetUseWholeBox, METH_VARARGS},
    {"GetUseWholeBox", LegacyStreamlineAttributes_GetUseWholeBox, METH_VARARGS},
    {"SetPointDensity", LegacyStreamlineAttributes_SetPointDensity, METH_VARARGS},
    {"GetPointDensity", LegacyStreamlineAttributes_GetPointDensity, METH_VARARGS},
    {"SetDisplayMethod", LegacyStreamlineAttributes_SetDisplayMethod, METH_VARARGS},
    {"GetDisplayMethod", LegacyStreamlineAttributes_GetDisplayMethod, METH_VARARGS},
    {"SetShowStart", LegacyStreamlineAttributes_SetShowStart, METH_VARARGS},
    {"GetShowStart", LegacyStreamlineAttributes_GetShowStart, METH_VARARGS},
    {"SetRadius", LegacyStreamlineAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", LegacyStreamlineAttributes_GetRadius, METH_VARARGS},
    {"SetLineWidth", LegacyStreamlineAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", LegacyStreamlineAttributes_GetLineWidth, METH_VARARGS},
    {"SetColoringMethod", LegacyStreamlineAttributes_SetColoringMethod, METH_VARARGS},
    {"GetColoringMethod", LegacyStreamlineAttributes_GetColoringMethod, METH_VARARGS},
    {"SetColorTableName", LegacyStreamlineAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", LegacyStreamlineAttributes_GetColorTableName, METH_VARARGS},
    {"SetSingleColor", LegacyStreamlineAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", LegacyStreamlineAttributes_GetSingleColor, METH_VARARGS},
    {"SetLegendFlag", LegacyStreamlineAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", LegacyStreamlineAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", LegacyStreamlineAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", LegacyStreamlineAttributes_GetLightingFlag, METH_VARARGS},
    {"SetStreamlineDirection", LegacyStreamlineAttributes_SetStreamlineDirection, METH_VARARGS},
    {"GetStreamlineDirection", LegacyStreamlineAttributes_GetStreamlineDirection, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LegacyStreamlineAttributes_dealloc(PyObject *v)
{
   LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LegacyStreamlineAttributes_compare(PyObject *v, PyObject *w)
{
    LegacyStreamlineAttributes *a = ((LegacyStreamlineAttributesObject *)v)->data;
    LegacyStreamlineAttributes *b = ((LegacyStreamlineAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
LegacyStreamlineAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return LegacyStreamlineAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::SpecifiedPoint));
    else if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::SpecifiedLine));
    else if(strcmp(name, "SpecifiedPlane") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::SpecifiedPlane));
    else if(strcmp(name, "SpecifiedSphere") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::SpecifiedSphere));
    else if(strcmp(name, "SpecifiedBox") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::SpecifiedBox));

    if(strcmp(name, "stepLength") == 0)
        return LegacyStreamlineAttributes_GetStepLength(self, NULL);
    if(strcmp(name, "maxTime") == 0)
        return LegacyStreamlineAttributes_GetMaxTime(self, NULL);
    if(strcmp(name, "pointSource") == 0)
        return LegacyStreamlineAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return LegacyStreamlineAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return LegacyStreamlineAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "planeOrigin") == 0)
        return LegacyStreamlineAttributes_GetPlaneOrigin(self, NULL);
    if(strcmp(name, "planeNormal") == 0)
        return LegacyStreamlineAttributes_GetPlaneNormal(self, NULL);
    if(strcmp(name, "planeUpAxis") == 0)
        return LegacyStreamlineAttributes_GetPlaneUpAxis(self, NULL);
    if(strcmp(name, "planeRadius") == 0)
        return LegacyStreamlineAttributes_GetPlaneRadius(self, NULL);
    if(strcmp(name, "sphereOrigin") == 0)
        return LegacyStreamlineAttributes_GetSphereOrigin(self, NULL);
    if(strcmp(name, "sphereRadius") == 0)
        return LegacyStreamlineAttributes_GetSphereRadius(self, NULL);
    if(strcmp(name, "boxExtents") == 0)
        return LegacyStreamlineAttributes_GetBoxExtents(self, NULL);
    if(strcmp(name, "useWholeBox") == 0)
        return LegacyStreamlineAttributes_GetUseWholeBox(self, NULL);
    if(strcmp(name, "pointDensity") == 0)
        return LegacyStreamlineAttributes_GetPointDensity(self, NULL);
    if(strcmp(name, "displayMethod") == 0)
        return LegacyStreamlineAttributes_GetDisplayMethod(self, NULL);
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Lines));
    else if(strcmp(name, "Tubes") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Tubes));
    else if(strcmp(name, "Ribbons") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Ribbons));

    if(strcmp(name, "showStart") == 0)
        return LegacyStreamlineAttributes_GetShowStart(self, NULL);
    if(strcmp(name, "radius") == 0)
        return LegacyStreamlineAttributes_GetRadius(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return LegacyStreamlineAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "coloringMethod") == 0)
        return LegacyStreamlineAttributes_GetColoringMethod(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Solid));
    else if(strcmp(name, "ColorBySpeed") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::ColorBySpeed));
    else if(strcmp(name, "ColorByVorticity") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::ColorByVorticity));

    if(strcmp(name, "colorTableName") == 0)
        return LegacyStreamlineAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return LegacyStreamlineAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return LegacyStreamlineAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return LegacyStreamlineAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "StreamlineDirection") == 0)
        return LegacyStreamlineAttributes_GetStreamlineDirection(self, NULL);
    if(strcmp(name, "Forward") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Forward));
    else if(strcmp(name, "Backward") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Backward));
    else if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(LegacyStreamlineAttributes::Both));


    return Py_FindMethod(LegacyStreamlineAttributes_methods, self, name);
}

static int
LegacyStreamlineAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "sourceType") == 0)
        retval = (LegacyStreamlineAttributes_SetSourceType(self, tuple) != NULL);
    else if(strcmp(name, "stepLength") == 0)
        retval = (LegacyStreamlineAttributes_SetStepLength(self, tuple) != NULL);
    else if(strcmp(name, "maxTime") == 0)
        retval = (LegacyStreamlineAttributes_SetMaxTime(self, tuple) != NULL);
    else if(strcmp(name, "pointSource") == 0)
        retval = (LegacyStreamlineAttributes_SetPointSource(self, tuple) != NULL);
    else if(strcmp(name, "lineStart") == 0)
        retval = (LegacyStreamlineAttributes_SetLineStart(self, tuple) != NULL);
    else if(strcmp(name, "lineEnd") == 0)
        retval = (LegacyStreamlineAttributes_SetLineEnd(self, tuple) != NULL);
    else if(strcmp(name, "planeOrigin") == 0)
        retval = (LegacyStreamlineAttributes_SetPlaneOrigin(self, tuple) != NULL);
    else if(strcmp(name, "planeNormal") == 0)
        retval = (LegacyStreamlineAttributes_SetPlaneNormal(self, tuple) != NULL);
    else if(strcmp(name, "planeUpAxis") == 0)
        retval = (LegacyStreamlineAttributes_SetPlaneUpAxis(self, tuple) != NULL);
    else if(strcmp(name, "planeRadius") == 0)
        retval = (LegacyStreamlineAttributes_SetPlaneRadius(self, tuple) != NULL);
    else if(strcmp(name, "sphereOrigin") == 0)
        retval = (LegacyStreamlineAttributes_SetSphereOrigin(self, tuple) != NULL);
    else if(strcmp(name, "sphereRadius") == 0)
        retval = (LegacyStreamlineAttributes_SetSphereRadius(self, tuple) != NULL);
    else if(strcmp(name, "boxExtents") == 0)
        retval = (LegacyStreamlineAttributes_SetBoxExtents(self, tuple) != NULL);
    else if(strcmp(name, "useWholeBox") == 0)
        retval = (LegacyStreamlineAttributes_SetUseWholeBox(self, tuple) != NULL);
    else if(strcmp(name, "pointDensity") == 0)
        retval = (LegacyStreamlineAttributes_SetPointDensity(self, tuple) != NULL);
    else if(strcmp(name, "displayMethod") == 0)
        retval = (LegacyStreamlineAttributes_SetDisplayMethod(self, tuple) != NULL);
    else if(strcmp(name, "showStart") == 0)
        retval = (LegacyStreamlineAttributes_SetShowStart(self, tuple) != NULL);
    else if(strcmp(name, "radius") == 0)
        retval = (LegacyStreamlineAttributes_SetRadius(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (LegacyStreamlineAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "coloringMethod") == 0)
        retval = (LegacyStreamlineAttributes_SetColoringMethod(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (LegacyStreamlineAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (LegacyStreamlineAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (LegacyStreamlineAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lightingFlag") == 0)
        retval = (LegacyStreamlineAttributes_SetLightingFlag(self, tuple) != NULL);
    else if(strcmp(name, "StreamlineDirection") == 0)
        retval = (LegacyStreamlineAttributes_SetStreamlineDirection(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
LegacyStreamlineAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)v;
    fprintf(fp, "%s", PyLegacyStreamlineAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LegacyStreamlineAttributes_str(PyObject *v)
{
    LegacyStreamlineAttributesObject *obj = (LegacyStreamlineAttributesObject *)v;
    return PyString_FromString(PyLegacyStreamlineAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
static char *LegacyStreamlineAttributes_Purpose = "Attributes for the LegacyStreamline plot";

//
// The type description structure
//
static PyTypeObject LegacyStreamlineAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LegacyStreamlineAttributes",                    // tp_name
    sizeof(LegacyStreamlineAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LegacyStreamlineAttributes_dealloc,  // tp_dealloc
    (printfunc)LegacyStreamlineAttributes_print,     // tp_print
    (getattrfunc)LegacyStreamlineAttributes_getattr, // tp_getattr
    (setattrfunc)LegacyStreamlineAttributes_setattr, // tp_setattr
    (cmpfunc)LegacyStreamlineAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LegacyStreamlineAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LegacyStreamlineAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LegacyStreamlineAttributes *defaultAtts = 0;
static LegacyStreamlineAttributes *currentAtts = 0;

static PyObject *
NewLegacyStreamlineAttributes(int useCurrent)
{
    LegacyStreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(LegacyStreamlineAttributesObject, &LegacyStreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LegacyStreamlineAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LegacyStreamlineAttributes(*defaultAtts);
    else
        newObject->data = new LegacyStreamlineAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLegacyStreamlineAttributes(const LegacyStreamlineAttributes *attr)
{
    LegacyStreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(LegacyStreamlineAttributesObject, &LegacyStreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LegacyStreamlineAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LegacyStreamlineAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLegacyStreamlineAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LegacyStreamlineAttributesMethods[] = {
    {"LegacyStreamlineAttributes", LegacyStreamlineAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LegacyStreamlineAttributesObserver = 0;

std::string
PyLegacyStreamlineAttributes_GetLogString()
{
    std::string s("LegacyStreamlineAtts = LegacyStreamlineAttributes()\n");
    if(currentAtts != 0)
        s += PyLegacyStreamlineAttributes_ToString(currentAtts, "LegacyStreamlineAtts.");
    return s;
}

static void
PyLegacyStreamlineAttributes_CallLogRoutine(Subject *subj, void *data)
{
    LegacyStreamlineAttributes *atts = (LegacyStreamlineAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LegacyStreamlineAtts = LegacyStreamlineAttributes()\n");
        s += PyLegacyStreamlineAttributes_ToString(currentAtts, "LegacyStreamlineAtts.");
        cb(s);
    }
}

void
PyLegacyStreamlineAttributes_StartUp(LegacyStreamlineAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLegacyStreamlineAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LegacyStreamlineAttributesObserver == 0)
    {
        LegacyStreamlineAttributesObserver = new ObserverToCallback(subj,
            PyLegacyStreamlineAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLegacyStreamlineAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LegacyStreamlineAttributesObserver;
    LegacyStreamlineAttributesObserver = 0;
}

PyMethodDef *
PyLegacyStreamlineAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LegacyStreamlineAttributesMethods;
}

bool
PyLegacyStreamlineAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LegacyStreamlineAttributesType);
}

LegacyStreamlineAttributes *
PyLegacyStreamlineAttributes_FromPyObject(PyObject *obj)
{
    LegacyStreamlineAttributesObject *obj2 = (LegacyStreamlineAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLegacyStreamlineAttributes_New()
{
    return NewLegacyStreamlineAttributes(0);
}

PyObject *
PyLegacyStreamlineAttributes_Wrap(const LegacyStreamlineAttributes *attr)
{
    return WrapLegacyStreamlineAttributes(attr);
}

void
PyLegacyStreamlineAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LegacyStreamlineAttributesObject *obj2 = (LegacyStreamlineAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLegacyStreamlineAttributes_SetDefaults(const LegacyStreamlineAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LegacyStreamlineAttributes(*atts);
}

