/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPseudocolorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyPseudocolorAttributes
//
// Purpose: 
//   Attributes for the pseudocolor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PseudocolorAttributes.
//
struct PseudocolorAttributesObject
{
    PyObject_HEAD
    PseudocolorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPseudocolorAttributes(int);

std::string
PyPseudocolorAttributes_ToString(const PseudocolorAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    const char *centering_names = "Natural, Nodal, Zonal";
    switch (atts->GetCentering())
    {
      case PseudocolorAttributes::Natural:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNatural  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Nodal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sNodal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Zonal:
          SNPRINTF(tmpStr, 1000, "%scentering = %sZonal  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *scaling_names = "Linear, Log, Skew";
    switch (atts->GetScaling())
    {
      case PseudocolorAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sSkew  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case PseudocolorAttributes::OriginalData:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::CurrentPlot:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point, Sphere";
    switch (atts->GetPointType())
    {
      case PseudocolorAttributes::Box:
          SNPRINTF(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Axis:
          SNPRINTF(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Icosahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::Sphere:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sskewFactor = %g\n", prefix, atts->GetSkewFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizeVar = \"%s\"\n", prefix, atts->GetPointSizeVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const char *opacityType_names = "Explicit, ColorTable";
    switch (atts->GetOpacityType())
    {
      case PseudocolorAttributes::Explicit:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sExplicit  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PseudocolorAttributes::ColorTable:
          SNPRINTF(tmpStr, 1000, "%sopacityType = %sColorTable  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
PseudocolorAttributes_Notify(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centering in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCentering(PseudocolorAttributes::Centering(ival));
    else
    {
        fprintf(stderr, "An invalid centering value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, Nodal, Zonal.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCentering()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(PseudocolorAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(PseudocolorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetPointType(PseudocolorAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point, Sphere"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
PseudocolorAttributes_SetOpacityType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOpacityType(PseudocolorAttributes::Opacity(ival));
    else
    {
        fprintf(stderr, "An invalid opacityType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Explicit, ColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PseudocolorAttributes_GetOpacityType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityType()));
    return retval;
}



PyMethodDef PyPseudocolorAttributes_methods[PSEUDOCOLORATTRIBUTES_NMETH] = {
    {"Notify", PseudocolorAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", PseudocolorAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", PseudocolorAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", PseudocolorAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", PseudocolorAttributes_GetLightingFlag, METH_VARARGS},
    {"SetMinFlag", PseudocolorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", PseudocolorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", PseudocolorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", PseudocolorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetCentering", PseudocolorAttributes_SetCentering, METH_VARARGS},
    {"GetCentering", PseudocolorAttributes_GetCentering, METH_VARARGS},
    {"SetScaling", PseudocolorAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", PseudocolorAttributes_GetScaling, METH_VARARGS},
    {"SetLimitsMode", PseudocolorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", PseudocolorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMin", PseudocolorAttributes_SetMin, METH_VARARGS},
    {"GetMin", PseudocolorAttributes_GetMin, METH_VARARGS},
    {"SetMax", PseudocolorAttributes_SetMax, METH_VARARGS},
    {"GetMax", PseudocolorAttributes_GetMax, METH_VARARGS},
    {"SetPointSize", PseudocolorAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", PseudocolorAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", PseudocolorAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", PseudocolorAttributes_GetPointType, METH_VARARGS},
    {"SetSkewFactor", PseudocolorAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", PseudocolorAttributes_GetSkewFactor, METH_VARARGS},
    {"SetOpacity", PseudocolorAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", PseudocolorAttributes_GetOpacity, METH_VARARGS},
    {"SetColorTableName", PseudocolorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", PseudocolorAttributes_GetColorTableName, METH_VARARGS},
    {"SetSmoothingLevel", PseudocolorAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", PseudocolorAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSizeVarEnabled", PseudocolorAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", PseudocolorAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", PseudocolorAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", PseudocolorAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointSizePixels", PseudocolorAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", PseudocolorAttributes_GetPointSizePixels, METH_VARARGS},
    {"SetLineStyle", PseudocolorAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", PseudocolorAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", PseudocolorAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", PseudocolorAttributes_GetLineWidth, METH_VARARGS},
    {"SetOpacityType", PseudocolorAttributes_SetOpacityType, METH_VARARGS},
    {"GetOpacityType", PseudocolorAttributes_GetOpacityType, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PseudocolorAttributes_dealloc(PyObject *v)
{
   PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PseudocolorAttributes_compare(PyObject *v, PyObject *w)
{
    PseudocolorAttributes *a = ((PseudocolorAttributesObject *)v)->data;
    PseudocolorAttributes *b = ((PseudocolorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPseudocolorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return PseudocolorAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return PseudocolorAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return PseudocolorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return PseudocolorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "centering") == 0)
        return PseudocolorAttributes_GetCentering(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Natural));
    if(strcmp(name, "Nodal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Nodal));
    if(strcmp(name, "Zonal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Zonal));

    if(strcmp(name, "scaling") == 0)
        return PseudocolorAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Skew));

    if(strcmp(name, "limitsMode") == 0)
        return PseudocolorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::CurrentPlot));

    if(strcmp(name, "min") == 0)
        return PseudocolorAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return PseudocolorAttributes_GetMax(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return PseudocolorAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return PseudocolorAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Icosahedron));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Sphere));

    if(strcmp(name, "skewFactor") == 0)
        return PseudocolorAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return PseudocolorAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return PseudocolorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return PseudocolorAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return PseudocolorAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return PseudocolorAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return PseudocolorAttributes_GetPointSizePixels(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return PseudocolorAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return PseudocolorAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "opacityType") == 0)
        return PseudocolorAttributes_GetOpacityType(self, NULL);
    if(strcmp(name, "Explicit") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Explicit));
    if(strcmp(name, "ColorTable") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::ColorTable));


    // Try and handle legacy fields in PseudocolorAttributes
    if(strcmp(name, "useColorTableOpacity") == 0)
    {
        PseudocolorAttributesObject *meshObj = (PseudocolorAttributesObject *)self;
        bool useCT = meshObj->data->GetOpacityType() == PseudocolorAttributes::ColorTable;
        return PyInt_FromLong(useCT?1L:0L);
    }
    return Py_FindMethod(PyPseudocolorAttributes_methods, self, name);
}

int
PyPseudocolorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = PseudocolorAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = PseudocolorAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = PseudocolorAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = PseudocolorAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "centering") == 0)
        obj = PseudocolorAttributes_SetCentering(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = PseudocolorAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = PseudocolorAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = PseudocolorAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = PseudocolorAttributes_SetMax(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = PseudocolorAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = PseudocolorAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "skewFactor") == 0)
        obj = PseudocolorAttributes_SetSkewFactor(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = PseudocolorAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = PseudocolorAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = PseudocolorAttributes_SetSmoothingLevel(self, tuple);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        obj = PseudocolorAttributes_SetPointSizeVarEnabled(self, tuple);
    else if(strcmp(name, "pointSizeVar") == 0)
        obj = PseudocolorAttributes_SetPointSizeVar(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = PseudocolorAttributes_SetPointSizePixels(self, tuple);
    else if(strcmp(name, "lineStyle") == 0)
        obj = PseudocolorAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = PseudocolorAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "opacityType") == 0)
        obj = PseudocolorAttributes_SetOpacityType(self, tuple);

    // Try and handle legacy fields in PseudocolorAttributes
    if(obj == NULL)
    {
        PseudocolorAttributesObject *PseudocolorObj = (PseudocolorAttributesObject *)self;
        if(strcmp(name, "useColorTableOpacity") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                PseudocolorObj->data->SetOpacityType(PseudocolorAttributes::Explicit);
            else
                PseudocolorObj->data->SetOpacityType(PseudocolorAttributes::ColorTable);
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PseudocolorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
    fprintf(fp, "%s", PyPseudocolorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PseudocolorAttributes_str(PyObject *v)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
    return PyString_FromString(PyPseudocolorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PseudocolorAttributes_Purpose = "Attributes for the pseudocolor plot";
#else
static char *PseudocolorAttributes_Purpose = "Attributes for the pseudocolor plot";
#endif

//
// The type description structure
//
static PyTypeObject PseudocolorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PseudocolorAttributes",                    // tp_name
    sizeof(PseudocolorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PseudocolorAttributes_dealloc,  // tp_dealloc
    (printfunc)PseudocolorAttributes_print,     // tp_print
    (getattrfunc)PyPseudocolorAttributes_getattr, // tp_getattr
    (setattrfunc)PyPseudocolorAttributes_setattr, // tp_setattr
    (cmpfunc)PseudocolorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PseudocolorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PseudocolorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PseudocolorAttributes *defaultAtts = 0;
static PseudocolorAttributes *currentAtts = 0;

static PyObject *
NewPseudocolorAttributes(int useCurrent)
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PseudocolorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PseudocolorAttributes(*defaultAtts);
    else
        newObject->data = new PseudocolorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPseudocolorAttributes(const PseudocolorAttributes *attr)
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PseudocolorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PseudocolorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPseudocolorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PseudocolorAttributesMethods[] = {
    {"PseudocolorAttributes", PseudocolorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PseudocolorAttributesObserver = 0;

std::string
PyPseudocolorAttributes_GetLogString()
{
    std::string s("PseudocolorAtts = PseudocolorAttributes()\n");
    if(currentAtts != 0)
        s += PyPseudocolorAttributes_ToString(currentAtts, "PseudocolorAtts.");
    return s;
}

static void
PyPseudocolorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    PseudocolorAttributes *atts = (PseudocolorAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PseudocolorAtts = PseudocolorAttributes()\n");
        s += PyPseudocolorAttributes_ToString(currentAtts, "PseudocolorAtts.");
        cb(s);
    }
}

void
PyPseudocolorAttributes_StartUp(PseudocolorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPseudocolorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PseudocolorAttributesObserver == 0)
    {
        PseudocolorAttributesObserver = new ObserverToCallback(subj,
            PyPseudocolorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPseudocolorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PseudocolorAttributesObserver;
    PseudocolorAttributesObserver = 0;
}

PyMethodDef *
PyPseudocolorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PseudocolorAttributesMethods;
}

bool
PyPseudocolorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PseudocolorAttributesType);
}

PseudocolorAttributes *
PyPseudocolorAttributes_FromPyObject(PyObject *obj)
{
    PseudocolorAttributesObject *obj2 = (PseudocolorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPseudocolorAttributes_New()
{
    return NewPseudocolorAttributes(0);
}

PyObject *
PyPseudocolorAttributes_Wrap(const PseudocolorAttributes *attr)
{
    return WrapPseudocolorAttributes(attr);
}

void
PyPseudocolorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PseudocolorAttributesObject *obj2 = (PseudocolorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPseudocolorAttributes_SetDefaults(const PseudocolorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PseudocolorAttributes(*atts);
}

