/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisPoincarePlotWindow.h"

#include <PoincareAttributes.h>
#include <ViewerProxy.h>

#include <QTabWidget>
#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QComboBox>
#include <QGroupBox>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisPoincarePlotWindow::QvisPoincarePlotWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisPoincarePlotWindow::QvisPoincarePlotWindow(const int type,
                         PoincareAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisPostableWindowObserver(subj, caption, shortName, notepad)
{
    plotType = type;
    atts = subj;
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::~QvisPoincarePlotWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisPoincarePlotWindow::~QvisPoincarePlotWindow()
{
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//   Allen Sanderson, Sun Mar  7 12:49:56 PST 2010
//   Change layout of window for 2.0 interface changes.
//
// ****************************************************************************

void
QvisPoincarePlotWindow::CreateWindowContents()
{
    propertyTabs = new QTabWidget(central);
    topLayout->addWidget(propertyTabs);

    // ----------------------------------------------------------------------
    // First tab
    // ----------------------------------------------------------------------
    firstTab = new QWidget(central);
    propertyTabs->addTab(firstTab, tr("Streamlines"));
    
    QGridLayout *mainLayout = new QGridLayout(firstTab);

   // Create the source group box.
    QGroupBox *sourceGroup = new QGroupBox(central);
    sourceGroup->setTitle(tr("Source"));
    mainLayout->addWidget(sourceGroup, 0, 0);
//    mainLayout->setStretchFactor(sourceGroup, 100);
    QGridLayout *sourceLayout = new QGridLayout(sourceGroup);
    sourceLayout->setMargin(5);
    sourceLayout->setSpacing(10);

    sourceTypeLabel = new QLabel(tr("Source Type"), central);
    sourceLayout->addWidget(sourceTypeLabel, 0, 0);

    sourceTypeCombo = new QComboBox(firstTab);
    sourceTypeCombo->addItem(tr("Point"));
    sourceTypeCombo->addItem(tr("Line"));
    connect(sourceTypeCombo, SIGNAL(activated(int)),
           this, SLOT(sourceTypeChanged(int)));
    sourceLayout->addWidget(sourceTypeCombo, 0, 1);


    pointSourceLabel = new QLabel(tr("Location"), central);
    sourceLayout->addWidget(pointSourceLabel, 0, 2);
    pointSource = new QLineEdit(central);
    connect(pointSource, SIGNAL(returnPressed()),
            this, SLOT(pointSourceProcessText()));
    sourceLayout->addWidget(pointSource, 0, 3);



    lineStartLabel = new QLabel(tr("Start Point"), central);
    sourceLayout->addWidget(lineStartLabel, 0, 2);
    lineStart = new QLineEdit(central);
    connect(lineStart, SIGNAL(returnPressed()),
            this, SLOT(lineStartProcessText()));
    sourceLayout->addWidget(lineStart, 0, 3);

    lineEndLabel = new QLabel(tr("End Point"), central);
    sourceLayout->addWidget(lineEndLabel, 1, 2);
    lineEnd = new QLineEdit(central);
    connect(lineEnd, SIGNAL(returnPressed()),
            this, SLOT(lineEndProcessText()));
    sourceLayout->addWidget(lineEnd, 1, 3);

    pointDensityLabel = new QLabel(tr("Point density"), central);
    sourceLayout->addWidget(pointDensityLabel, 2, 2);
    pointDensity = new QSpinBox(central);
    pointDensity->setMinimum(1);
    pointDensity->setMaximum(10000);
    connect(pointDensity, SIGNAL(valueChanged(int)),
            this, SLOT(pointDensityChanged(int)));
    sourceLayout->addWidget(pointDensity, 2, 3);


    // Create the punctures group box.
    QGroupBox *puncturesGroup = new QGroupBox(central);
    puncturesGroup->setTitle(tr("Punctures"));
    mainLayout->addWidget(puncturesGroup, 1, 0);
//    mainLayout->setStretchFactor(puncturesGroup, 100);

    QGridLayout *puncturesLayout = new QGridLayout(puncturesGroup);
    puncturesLayout->setMargin(5);
    puncturesLayout->setSpacing(10);

    minPuncturesLabel = new QLabel(tr("Minimum"), central);
    puncturesLayout->addWidget(minPuncturesLabel, 0, 0);
    minPunctures = new QSpinBox(central);
    minPunctures->setMinimum(1);
    minPunctures->setMaximum(10000);
    connect(minPunctures, SIGNAL(valueChanged(int)),
            this, SLOT(minPuncturesChanged(int)));
    puncturesLayout->addWidget(minPunctures, 0, 1);

    maxPuncturesLabel = new QLabel(tr("Maximum"), central);
    puncturesLayout->addWidget(maxPuncturesLabel, 0, 2);
    maxPunctures = new QSpinBox(central);
    maxPunctures->setMinimum(1);
    maxPunctures->setMaximum(10000);
    connect(maxPunctures, SIGNAL(valueChanged(int)),
            this, SLOT(maxPuncturesChanged(int)));
    puncturesLayout->addWidget(maxPunctures, 0, 3);

   // Create the integration group box.
    QGroupBox *integrationGroup = new QGroupBox(central);
    integrationGroup->setTitle(tr("Integration"));
    mainLayout->addWidget(integrationGroup, 2, 0);
//    mainLayout->setStretchFactor(integrationGroup, 100);
    QGridLayout *integrationLayout = new QGridLayout(integrationGroup);
    integrationLayout->setMargin(5);
    integrationLayout->setSpacing(10);

    integrationTypeLabel = new QLabel(tr("Integrator:"), central);
    integrationLayout->addWidget(integrationTypeLabel,0,0);

    integrationTypeCombo = new QComboBox(firstTab);
    integrationTypeCombo->addItem(tr("Dormand-Prince (Runge-Kutta)"));
    integrationTypeCombo->addItem(tr("Adams-Bashforth (Multi-step)"));
    integrationTypeCombo->addItem(tr("M3D-C1 Integrator"));
    connect(integrationTypeCombo, SIGNAL(activated(int)),
           this, SLOT(integrationTypeChanged(int)));
    integrationLayout->addWidget(integrationTypeCombo, 0, 1);

    maxStepLengthLabel = new QLabel(tr("Maxiumum step length"), central);
    integrationLayout->addWidget(maxStepLengthLabel,1,0);
    maxStepLength = new QLineEdit(central);
    connect(maxStepLength, SIGNAL(returnPressed()),
            this, SLOT(maxStepLengthProcessText()));
    integrationLayout->addWidget(maxStepLength, 1,1);

    relTolLabel = new QLabel(tr("Relative tolerance"), central);
    integrationLayout->addWidget(relTolLabel,2,0);
    relTol = new QLineEdit(central);
    connect(relTol, SIGNAL(returnPressed()),
            this, SLOT(relTolProcessText()));
    integrationLayout->addWidget(relTol, 2,1);

    absTolLabel = new QLabel(tr("Absolute tolerance"), central);
    integrationLayout->addWidget(absTolLabel,3,0);
    absTol = new QLineEdit(central);
    connect(absTol, SIGNAL(returnPressed()),
            this, SLOT(absTolProcessText()));
    integrationLayout->addWidget(absTol, 3,1);

    // ----------------------------------------------------------------------
    // Second tab
    // ----------------------------------------------------------------------
    secondTab = new QWidget(central);
    propertyTabs->addTab(secondTab, tr("Analysis"));
    
    mainLayout = new QGridLayout(secondTab);

    maxToroidalWindingLabel = new QLabel(tr("Max Toroidal Winding"), central);
    mainLayout->addWidget(maxToroidalWindingLabel, 0, 0);
    maxToroidalWinding = new QSpinBox(central);
    maxToroidalWinding->setMinimum(1);
    maxToroidalWinding->setMaximum(1000);
    connect(maxToroidalWinding, SIGNAL(valueChanged(int)),
            this, SLOT(maxToroidalWindingChanged(int)));
    mainLayout->addWidget(maxToroidalWinding, 0, 1);

    overrideToroidalWindingLabel = new QLabel(tr("Override Toroidal Winding"), central);
    mainLayout->addWidget(overrideToroidalWindingLabel, 1, 0);
    overrideToroidalWinding = new QSpinBox(central);
    overrideToroidalWinding->setMinimum(0);
    overrideToroidalWinding->setMaximum(1000);
    connect(overrideToroidalWinding, SIGNAL(valueChanged(int)),
            this, SLOT(overrideToroidalWindingChanged(int)));
    mainLayout->addWidget(overrideToroidalWinding, 1, 1);

    hitRateLabel = new QLabel(tr("Hit Rate"), central);
    mainLayout->addWidget(hitRateLabel, 2, 0);
    hitRate = new QLineEdit(central);
    connect(hitRate, SIGNAL(returnPressed()),
            this, SLOT(hitRateProcessText()));
    mainLayout->addWidget(hitRate, 2, 1);

    overlapsLabel = new QLabel(tr("Overlaps"), central);
    mainLayout->addWidget(overlapsLabel, 4, 0, Qt::AlignTop);
    overlaps = new QWidget(central);
    overlapsButtonGroup= new QButtonGroup(overlaps);
    QHBoxLayout *overlapsLayout = new QHBoxLayout(overlaps);
    overlapsLayout->setMargin(0);
    overlapsLayout->setSpacing(10);
    QRadioButton *overlapsOverlapTypeRaw = new QRadioButton(tr("Raw"), overlaps);
    overlapsButtonGroup->addButton(overlapsOverlapTypeRaw,0);
    overlapsLayout->addWidget(overlapsOverlapTypeRaw);
    QRadioButton *overlapsOverlapTypeRemove = new QRadioButton(tr("Remove"), overlaps);
    overlapsButtonGroup->addButton(overlapsOverlapTypeRemove,1);
    overlapsLayout->addWidget(overlapsOverlapTypeRemove);
    QRadioButton *overlapsOverlapTypeMerge = new QRadioButton(tr("Merge"), overlaps);
    overlapsButtonGroup->addButton(overlapsOverlapTypeMerge,2);
    overlapsLayout->addWidget(overlapsOverlapTypeMerge);
    QRadioButton *overlapsOverlapTypeSmooth = new QRadioButton(tr("Smooth"), overlaps);
    overlapsButtonGroup->addButton(overlapsOverlapTypeSmooth,3);
    overlapsLayout->addWidget(overlapsOverlapTypeSmooth);
    connect(overlapsButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(overlapsChanged(int)));
    mainLayout->addWidget(overlaps, 4, 1, Qt::AlignTop);


   // Create the O/X Point  group box.
    QGroupBox *criticalPointGroup = new QGroupBox(central);
    criticalPointGroup->setTitle(tr("Critical Points"));
    mainLayout->addWidget(criticalPointGroup, 5, 0, 1, 2, Qt::AlignTop);

    QGridLayout *criticalPointLayout = new QGridLayout(criticalPointGroup);
    criticalPointLayout->setMargin(5);
    criticalPointLayout->setSpacing(10);

    showOPoints = new QCheckBox(tr("Detect O Points"), central);
    connect(showOPoints, SIGNAL(toggled(bool)),
            this, SLOT(showOPointsChanged(bool)));
    criticalPointLayout->addWidget(showOPoints, 0, 0);

    OPointMaxIterationsLabel =
      new QLabel(tr(" Maximum iterations"), criticalPointGroup);
    OPointMaxIterations = new QSpinBox(criticalPointGroup);
    OPointMaxIterations->setMinimum(1);
    OPointMaxIterations->setMaximum(10);
    connect(OPointMaxIterations, SIGNAL(valueChanged(int)), 
            this, SLOT(OPointMaxIterationsChanged(int)));
    criticalPointLayout->addWidget( OPointMaxIterationsLabel, 0, 2);
    criticalPointLayout->addWidget( OPointMaxIterations, 0, 3);

    criticalPointGroup->hide();

   // Create the options group box.
    QGroupBox *analysisOptionsGroup = new QGroupBox(central);
    analysisOptionsGroup->setTitle(tr("Options"));
    mainLayout->addWidget(analysisOptionsGroup, 6, 0, 1, 2, Qt::AlignTop);

    QGridLayout *analysisOptionsLayout = new QGridLayout(analysisOptionsGroup);
    analysisOptionsLayout->setMargin(5);
    analysisOptionsLayout->setSpacing(10);

    showIslands = new QCheckBox(tr("Show Islands Only"), central);
    connect(showIslands, SIGNAL(toggled(bool)),
            this, SLOT(showIslandsChanged(bool)));
    analysisOptionsLayout->addWidget(showIslands, 0, 0);

    showChaotic = new QCheckBox(tr("Show Chaotic Fieldlines (as points)"), central);
    connect(showChaotic, SIGNAL(toggled(bool)),
            this, SLOT(showChaoticChanged(bool)));
    analysisOptionsLayout->addWidget(showChaotic, 0, 1);

    showRidgelines = new QCheckBox(tr("Show Rdigelines"), central);
    connect(showRidgelines, SIGNAL(toggled(bool)),
            this, SLOT(showRidgelinesChanged(bool)));
    analysisOptionsLayout->addWidget(showRidgelines, 1, 0);

    verboseFlag = new QCheckBox(tr("Verbose"), central);
    connect(verboseFlag, SIGNAL(toggled(bool)),
            this, SLOT(verboseFlagChanged(bool)));
    analysisOptionsLayout->addWidget(verboseFlag, 1, 1);


    // ----------------------------------------------------------------------
    // Third tab
    // ----------------------------------------------------------------------
    thirdTab = new QWidget(central);
    propertyTabs->addTab(thirdTab, tr("Appearance"));
    
    mainLayout = new QGridLayout(thirdTab);

    // Create the data group box.
    QGroupBox *dataGroup = new QGroupBox(central);
    dataGroup->setTitle(tr("Data"));
    mainLayout->addWidget(dataGroup, 0, 0);

    QGridLayout *dataLayout = new QGridLayout(dataGroup);
    dataLayout->setMargin(5);
    dataLayout->setSpacing(10);
    dataLayout->setColumnStretch(2, 10);


    dataValueLabel = new QLabel(tr("Data value:"), central);
    dataLayout->addWidget(dataValueLabel, 0, 0);

    dataValueCombo = new QComboBox(thirdTab);
    dataValueCombo->addItem(tr("OriginalValue"));
    dataValueCombo->addItem(tr("InputOrder"));
    dataValueCombo->addItem(tr("PointIndex"));
    dataValueCombo->addItem(tr("Plane"));
    dataValueCombo->addItem(tr("WindingGroup"));
    dataValueCombo->addItem(tr("WindingPointOrder"));
    dataValueCombo->addItem(tr("WindingPointOrderModulo"));
    dataValueCombo->addItem(tr("ToroidalWindings"));
    dataValueCombo->addItem(tr("PoloidalWindings"));
    dataValueCombo->addItem(tr("SafetyFactor"));
    dataValueCombo->addItem(tr("Confidence"));
    dataValueCombo->addItem(tr("RidgelineVariance"));
    connect(dataValueCombo, SIGNAL(activated(int)),
           this, SLOT(dataValueChanged(int)));
    dataLayout->addWidget(dataValueCombo, 0, 1);

    dataLayout->addWidget(new QLabel(tr("   "), central), 0, 2);


    // Create the limits group box.
    QGroupBox *limitsGroup = new QGroupBox(central);
    dataLayout->addWidget(limitsGroup, 1, 0, 1, 3);

    QGridLayout *limitsLayout = new QGridLayout(limitsGroup);
    limitsLayout->setMargin(5);
    limitsLayout->setSpacing(10);

    limitsLayout->addWidget(new QLabel(tr("Limits"), central), 0, 0);

    minFlag = new QCheckBox(tr("Minimum"), central);
    limitsLayout->addWidget(minFlag, 0, 1);
    connect(minFlag, SIGNAL(toggled(bool)),
            this, SLOT(minFlagChanged(bool)));
    min = new QLineEdit(central);
    connect(min, SIGNAL(returnPressed()),
            this, SLOT(minProcessText()));
    limitsLayout->addWidget(min, 0, 2);

    maxFlag = new QCheckBox(tr("Maximum"), central);
    connect(maxFlag, SIGNAL(toggled(bool)),
            this, SLOT(maxFlagChanged(bool)));
    limitsLayout->addWidget(maxFlag, 0, 3);

    max = new QLineEdit(central);
    connect(max, SIGNAL(returnPressed()),
            this, SLOT(maxProcessText()));
    limitsLayout->addWidget(max, 0, 4);


    // Create the display group box.
    QGroupBox *displayGroup = new QGroupBox(central);
    displayGroup->setTitle(tr("Display"));
    mainLayout->addWidget(displayGroup, 1, 0);
//    mainLayout->setStretchFactor(displayGroup, 100);
    QGridLayout *displayLayout = new QGridLayout(displayGroup);
    displayLayout->setMargin(5);
    displayLayout->setSpacing(10);

    meshTypeLabel = new QLabel(tr("Mesh:"), central);
    displayLayout->addWidget(meshTypeLabel, 0, 0);

    meshTypeCombo = new QComboBox(thirdTab);
    meshTypeCombo->addItem(tr("Curves"));
    meshTypeCombo->addItem(tr("Surfaces"));
    connect(meshTypeCombo, SIGNAL(activated(int)),
           this, SLOT(meshTypeChanged(int)));
    displayLayout->addWidget(meshTypeCombo, 0, 1);

    numberPlanesLabel = new QLabel(tr("Number of planes"), central);
    displayLayout->addWidget(numberPlanesLabel, 1, 0);
    numberPlanes = new QSpinBox(central);
    numberPlanes->setMinimum(1);
    numberPlanes->setMaximum(250);
    connect(numberPlanes, SIGNAL(valueChanged(int)),
            this, SLOT(numberPlanesChanged(int)));
    displayLayout->addWidget(numberPlanes, 1, 1);

    singlePlaneLabel = new QLabel(tr("Base plane (degrees)"), central);
    displayLayout->addWidget(singlePlaneLabel, 1, 2);
    singlePlane = new QLineEdit(central);
    connect(singlePlane, SIGNAL(returnPressed()),
            this, SLOT(singlePlaneProcessText()));
    displayLayout->addWidget(singlePlane, 1, 3);

    adjustPlaneLabel = new QLabel(tr("Adjust plane index"), central);
    displayLayout->addWidget(adjustPlaneLabel, 1, 2);
    adjustPlane = new QSpinBox(central);
    adjustPlane->setMinimum(-1);
    adjustPlane->setMaximum(250);
    connect(adjustPlane, SIGNAL(valueChanged(int)),
            this, SLOT(adjustPlaneChanged(int)));
    displayLayout->addWidget(adjustPlane, 1, 3);


   // Create the color group box.
    QGroupBox *colorGroup = new QGroupBox(central);
    colorGroup->setTitle(tr("Color"));
    mainLayout->addWidget(colorGroup, 2, 0);
//    mainLayout->setStretchFactor(colorGroup, 100);
    QGridLayout *colorLayout = new QGridLayout(colorGroup);
    colorLayout->setMargin(5);
    colorLayout->setSpacing(10);
    colorLayout->setColumnStretch(2, 10);

//     colorTypeLabel = new QLabel(tr("Color type"), central);
//     colorLayout->addWidget(colorTypeLabel,6,0);
    colorType = new QWidget(central);
    colorTypeButtonGroup= new QButtonGroup(colorType);

    QRadioButton *colorTypeSingleColor =
      new QRadioButton(tr("Custom"), colorType);
    colorTypeButtonGroup->addButton(colorTypeSingleColor,0);
    colorLayout->addWidget(colorTypeSingleColor, 0, 0);

    singleColor = new QvisColorButton(central);
    connect(singleColor, SIGNAL(selectedColor(const QColor&)),
            this, SLOT(singleColorChanged(const QColor&)));
    colorLayout->addWidget(singleColor, 0, 1, Qt::AlignLeft);

    QRadioButton *colorTypeColorTable =
      new QRadioButton(tr("Color Table"), colorType);
    colorTypeButtonGroup->addButton(colorTypeColorTable,1);
    colorLayout->addWidget(colorTypeColorTable, 0, 2, Qt::AlignRight);
    connect(colorTypeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(colorTypeChanged(int)));

    colorTableName = new QvisColorTableButton(central);
    connect(colorTableName, SIGNAL(selectedColorTable(bool, const QString&)),
            this, SLOT(colorTableNameChanged(bool, const QString&)));
    colorLayout->addWidget(colorTableName, 0, 3, Qt::AlignLeft);


   // Create the options group box.
    QGroupBox *optionsGroup = new QGroupBox(central);
    optionsGroup->setTitle(tr("Options"));
    mainLayout->addWidget(optionsGroup, 3, 0);

    QGridLayout *optionsLayout = new QGridLayout(optionsGroup);
    optionsLayout->setMargin(5);
    optionsLayout->setSpacing(10);

    showLines = new QCheckBox(tr("Show Lines"), central);
    connect(showLines, SIGNAL(toggled(bool)),
            this, SLOT(showLinesChanged(bool)));
    optionsLayout->addWidget(showLines, 1, 0);

    showPoints = new QCheckBox(tr("Show Points"), central);
    connect(showPoints, SIGNAL(toggled(bool)),
            this, SLOT(showPointsChanged(bool)));
    optionsLayout->addWidget(showPoints, 1, 1);

    //
    // Create the misc stuff
    //
    QGroupBox * miscGroup = new QGroupBox(central);
    miscGroup->setTitle(tr("Misc"));
    mainLayout->addWidget(miscGroup, 4, 0);

    QGridLayout *miscLayout = new QGridLayout(miscGroup);
    miscLayout->setMargin(5);
    miscLayout->setSpacing(10);
 
    // Create the legend toggle
    legendToggle = new QCheckBox(tr("Legend"), central);
    connect(legendToggle, SIGNAL(toggled(bool)),
            this, SLOT(legendToggled(bool)));
    miscLayout->addWidget(legendToggle, 0, 0);

    // Create the lighting toggle
    lightingToggle = new QCheckBox(tr("Lighting"), central);
    connect(lightingToggle, SIGNAL(toggled(bool)),
            this, SLOT(lightingToggled(bool)));
    miscLayout->addWidget(lightingToggle, 0, 1);

    // ----------------------------------------------------------------------
    // Forth tab
    // ----------------------------------------------------------------------
    forthTab = new QWidget(central);
    propertyTabs->addTab(forthTab, tr("Parallel"));
    
    mainLayout = new QGridLayout(forthTab);

    QGroupBox *algoGrp = new QGroupBox(central);
    algoGrp->setTitle(tr("Parallel streamline options"));
    mainLayout->addWidget(algoGrp, 0, 0, 1, 4);

    // Algorithm group.
    QGridLayout *algoGLayout = new QGridLayout(algoGrp);
    algoGLayout->setSpacing(10);
    algoGLayout->setColumnStretch(1,10);

    slAlgoLabel = new QLabel(tr("Parallelize across"), algoGrp);
    slAlgo = new QComboBox(algoGrp);
    slAlgo->addItem(tr("Streamlines"));
    slAlgo->addItem(tr("Domains"));
    slAlgo->addItem(tr("Streamlines and Domains"));
    connect(slAlgo, SIGNAL(activated(int)),
            this, SLOT(streamlineAlgorithmChanged(int)));
    algoGLayout->addWidget( slAlgoLabel, 1,0);
    algoGLayout->addWidget( slAlgo, 1,1);
    
    maxSLCountLabel = new QLabel(tr("Communication threshold"), algoGrp);
    maxSLCount = new QSpinBox(algoGrp);
    maxSLCount->setMinimum(1);
    maxSLCount->setMaximum(100000);
    connect(maxSLCount, SIGNAL(valueChanged(int)), 
            this, SLOT(maxSLCountChanged(int)));
    algoGLayout->addWidget( maxSLCountLabel, 2,0);
    algoGLayout->addWidget( maxSLCount,2,1);

    maxDomainCacheLabel = new QLabel(tr("Domain cache size"), algoGrp);
    maxDomainCache = new QSpinBox(algoGrp);
    maxDomainCache->setMinimum(1);
    maxDomainCache->setMaximum(100000);
    connect(maxDomainCache, SIGNAL(valueChanged(int)),
            this, SLOT(maxDomainCacheChanged(int)));
    algoGLayout->addWidget( maxDomainCacheLabel, 3,0);
    algoGLayout->addWidget( maxDomainCache, 3,1);

    workGroupSizeLabel = new QLabel(tr("Work group size"), algoGrp);
    workGroupSize = new QSpinBox(algoGrp);
    workGroupSize->setMinimum(2);
    workGroupSize->setMaximum(1000000);
    connect(workGroupSize, SIGNAL(valueChanged(int)),
            this, SLOT(workGroupSizeChanged(int)));
    algoGLayout->addWidget( workGroupSizeLabel, 4,0);
    algoGLayout->addWidget( workGroupSize, 4,1);
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case PoincareAttributes::ID_minPunctures:
            minPunctures->blockSignals(true);
            minPunctures->setValue(atts->GetMinPunctures());
            minPunctures->blockSignals(false);
            break;
          case PoincareAttributes::ID_maxPunctures:
            maxPunctures->blockSignals(true);
            maxPunctures->setValue(atts->GetMaxPunctures());
            maxPunctures->blockSignals(false);
            break;
          case PoincareAttributes::ID_sourceType:
            if (atts->GetSourceType() == PoincareAttributes::SpecifiedPoint)
            {
                pointSource->setEnabled(true);
                pointSourceLabel->setEnabled(true);

                pointSource->show();
                pointSourceLabel->show();
            }
            else
            {
                pointSource->setEnabled(false);
                pointSourceLabel->setEnabled(false);

                pointSource->hide();
                pointSourceLabel->hide();
            }
            if (atts->GetSourceType() == PoincareAttributes::SpecifiedLine)
            {
                lineStart->setEnabled(true);
                lineStartLabel->setEnabled(true);

                lineStartLabel->show();
                lineStart->show();

                lineEnd->setEnabled(true);
                lineEndLabel->setEnabled(true);

                lineEndLabel->show();
                lineEnd->show();

                pointDensity->setEnabled(true);
                pointDensityLabel->setEnabled(true);

                pointDensityLabel->show();
                pointDensity->show();
            }
            else
            {
                lineStart->setEnabled(false);
                lineStartLabel->setEnabled(false);

                lineStartLabel->hide();
                lineStart->hide();

                lineEnd->setEnabled(false);
                lineEndLabel->setEnabled(false);

                lineEndLabel->hide();
                lineEnd->hide();

                pointDensityLabel->setEnabled(false);
                pointDensity->setEnabled(false);

                pointDensityLabel->hide();
                pointDensity->hide();
            }

            sourceTypeCombo->blockSignals(true);
            sourceTypeCombo->setCurrentIndex((int)atts->GetSourceType());
            sourceTypeCombo->blockSignals(false);
            break;
          case PoincareAttributes::ID_pointSource:
            pointSource->setText(DoublesToQString(atts->GetPointSource(), 3));
            break;
          case PoincareAttributes::ID_lineStart:
            lineStart->setText(DoublesToQString(atts->GetLineStart(), 3));
            break;
          case PoincareAttributes::ID_lineEnd:
            lineEnd->setText(DoublesToQString(atts->GetLineEnd(), 3));
            break;
          case PoincareAttributes::ID_pointDensity:
            pointDensity->blockSignals(true);
            pointDensity->setValue(atts->GetPointDensity());
            pointDensity->blockSignals(false);
            break;
          case PoincareAttributes::ID_integrationType:
            // Update lots of widget visibility and enabled states.
            UpdateIntegrationAttributes();

            integrationTypeCombo->blockSignals(true);
            integrationTypeCombo->setCurrentIndex((int)atts->GetIntegrationType());
            integrationTypeCombo->blockSignals(false);
            break;
          case PoincareAttributes::ID_maxStepLength:
            maxStepLength->setText(DoubleToQString(atts->GetMaxStepLength()));
            break;
          case PoincareAttributes::ID_relTol:
            relTol->setText(DoubleToQString(atts->GetRelTol()));
            break;
          case PoincareAttributes::ID_absTol:
            absTol->setText(DoubleToQString(atts->GetAbsTol()));
            break;
          case PoincareAttributes::ID_maxToroidalWinding:
            maxToroidalWinding->blockSignals(true);
            maxToroidalWinding->setValue(atts->GetMaxToroidalWinding());
            maxToroidalWinding->blockSignals(false);
            break;
          case PoincareAttributes::ID_overrideToroidalWinding:
            overrideToroidalWinding->blockSignals(true);
            overrideToroidalWinding->setValue(atts->GetOverrideToroidalWinding());
            overrideToroidalWinding->blockSignals(false);
            break;
          case PoincareAttributes::ID_hitRate:
            hitRate->setText(DoubleToQString(atts->GetHitRate()));
            break;
          case PoincareAttributes::ID_adjustPlane:
            adjustPlane->blockSignals(true);
            adjustPlane->setValue(atts->GetAdjustPlane());
            adjustPlane->blockSignals(false);
            break;
          case PoincareAttributes::ID_overlaps:
            overlapsButtonGroup->blockSignals(true);
            if(overlapsButtonGroup->button((int)atts->GetOverlaps()) != 0)
                overlapsButtonGroup->button((int)atts->GetOverlaps())->setChecked(true);
            overlapsButtonGroup->blockSignals(false);
            break;
          case PoincareAttributes::ID_meshType:
            UpdateMeshTypeAttributes();
            meshTypeCombo->blockSignals(true);
            meshTypeCombo->setCurrentIndex((int)atts->GetMeshType());
            meshTypeCombo->blockSignals(false);
            break;
          case PoincareAttributes::ID_numberPlanes:
            // Disconnect the slot before setting the toggle and
            // reconnect it after. This prevents multiple updates.
            disconnect(numberPlanes, SIGNAL(valueChanged(int)),
                       this, SLOT(numberPlanesChanged(int)));
            numberPlanes->setValue(atts->GetNumberPlanes());
            singlePlaneLabel->setEnabled( atts->GetNumberPlanes() == 1 );
            singlePlane->setEnabled( atts->GetNumberPlanes() == 1 );
            connect(numberPlanes, SIGNAL(valueChanged(int)),
                    this, SLOT(numberPlanesChanged(int)));
            break;
          case PoincareAttributes::ID_singlePlane:
            singlePlane->setText(DoubleToQString(atts->GetSinglePlane()));
            break;
          case PoincareAttributes::ID_min:
            min->setText(DoubleToQString(atts->GetMin()));
            break;
          case PoincareAttributes::ID_max:
            max->setText(DoubleToQString(atts->GetMax()));
            break;
          case PoincareAttributes::ID_minFlag:
            // Disconnect the slot before setting the toggle and
            // reconnect it after. This prevents multiple updates.
            disconnect(minFlag, SIGNAL(toggled(bool)),
                       this, SLOT(minFlagChanged(bool)));
            minFlag->setChecked(atts->GetMinFlag());
            min->setEnabled(atts->GetMinFlag());
            connect(minFlag, SIGNAL(toggled(bool)),
                    this, SLOT(minFlagChanged(bool)));
            break;
          case PoincareAttributes::ID_maxFlag:
            // Disconnect the slot before setting the toggle and
            // reconnect it after. This prevents multiple updates.
            disconnect(maxFlag, SIGNAL(toggled(bool)),
                       this, SLOT(maxFlagChanged(bool)));
            maxFlag->setChecked(atts->GetMaxFlag());
            max->setEnabled(atts->GetMaxFlag());
            connect(maxFlag, SIGNAL(toggled(bool)),
                    this, SLOT(maxFlagChanged(bool)));
            break;
          case PoincareAttributes::ID_colorType:
            colorTypeButtonGroup->blockSignals(true);
            if(colorTypeButtonGroup->button((int)atts->GetColorType()) != 0)
                colorTypeButtonGroup->button((int)atts->GetColorType())->setChecked(true);

            if (atts->GetColorType() == PoincareAttributes::ColorBySingleColor)
            {
                singleColor->setEnabled(true);
                colorTableName->setEnabled(false);
                dataValueCombo->setEnabled(false);
                dataValueLabel->setEnabled(false);
            }
            else
            {
                singleColor->setEnabled(false);
                colorTableName->setEnabled(true);
                dataValueCombo->setEnabled(true);
                dataValueLabel->setEnabled(true);
            }
            colorTypeButtonGroup->blockSignals(false);
            break;
          case PoincareAttributes::ID_singleColor:
            { // new scope
                QColor tempcolor = QColor(atts->GetSingleColor().Red(),
                                   atts->GetSingleColor().Green(),
                                   atts->GetSingleColor().Blue());
                singleColor->blockSignals(true);
                singleColor->setButtonColor(tempcolor);
                singleColor->blockSignals(false);
            }
            break;
          case PoincareAttributes::ID_colorTableName:
            colorTableName->blockSignals(true);
            colorTableName->setColorTable(QString(atts->GetColorTableName().c_str()));
            colorTableName->blockSignals(false);
            break;
          case PoincareAttributes::ID_dataValue:
            dataValueCombo->blockSignals(true);
            dataValueCombo->setCurrentIndex((int)atts->GetDataValue());
            dataValueCombo->blockSignals(false);
            break;
          case PoincareAttributes::ID_showOPoints:
            showOPoints->blockSignals(true);
            showOPoints->setChecked(atts->GetShowOPoints());
            showOPoints->blockSignals(false);
            break;
          case PoincareAttributes::ID_showIslands:
            showIslands->blockSignals(true);
            showIslands->setChecked(atts->GetShowIslands());
            showIslands->blockSignals(false);
            break;
          case PoincareAttributes::ID_showChaotic:
            showChaotic->blockSignals(true);
            showChaotic->setChecked(atts->GetShowChaotic());
            showChaotic->blockSignals(false);
            break;
          case PoincareAttributes::ID_showLines:
            showLines->blockSignals(true);
            showLines->setChecked(atts->GetShowLines());
            showLines->blockSignals(false);
            break;
          case PoincareAttributes::ID_showPoints:
            showPoints->blockSignals(true);
            showPoints->setChecked(atts->GetShowPoints());
            showPoints->blockSignals(false);
            break;
          case PoincareAttributes::ID_showRidgelines:
            showRidgelines->blockSignals(true);
            showRidgelines->setChecked(atts->GetShowRidgelines());
            showRidgelines->blockSignals(false);
            break;
          case PoincareAttributes::ID_verboseFlag:
            verboseFlag->blockSignals(true);
            verboseFlag->setChecked(atts->GetVerboseFlag());
            verboseFlag->blockSignals(false);
            break;
          case PoincareAttributes::ID_legendFlag:
            legendToggle->blockSignals(true);
            legendToggle->setChecked(atts->GetLegendFlag());
            legendToggle->blockSignals(false);
            break;
          case PoincareAttributes::ID_lightingFlag:
            lightingToggle->blockSignals(true);
            lightingToggle->setChecked(atts->GetLightingFlag());
            lightingToggle->blockSignals(false);
            break;

        case PoincareAttributes::ID_streamlineAlgorithmType:
            UpdateAlgorithmAttributes();

            slAlgo->blockSignals(true);
            slAlgo->setCurrentIndex(atts->GetStreamlineAlgorithmType());
            slAlgo->blockSignals(false);
            break;
        case PoincareAttributes::ID_maxStreamlineProcessCount:
            maxSLCount->blockSignals(true);
            maxSLCount->setValue(atts->GetMaxStreamlineProcessCount());
            maxSLCount->blockSignals(false);
            break;
        case PoincareAttributes::ID_maxDomainCacheSize:
            maxDomainCache->blockSignals(true);
            maxDomainCache->setValue(atts->GetMaxDomainCacheSize());
            maxDomainCache->blockSignals(false);
            break;
        case PoincareAttributes::ID_workGroupSize:
            workGroupSize->blockSignals(true);
            workGroupSize->setValue(atts->GetWorkGroupSize());
            workGroupSize->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do pointSource
    if(which_widget == PoincareAttributes::ID_pointSource || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(pointSource, val, 3))
            atts->SetPointSource(val);
        else
        {
            ResettingError(tr("Point Source"),
                DoublesToQString(atts->GetPointSource(),3));
            atts->SetPointSource(atts->GetPointSource());
        }
    }

    // Do lineStart
    if(which_widget == PoincareAttributes::ID_lineStart || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(lineStart, val, 3))
            atts->SetLineStart(val);
        else
        {
            ResettingError(tr("Line Point Start"),
                DoublesToQString(atts->GetLineStart(),3));
            atts->SetLineStart(atts->GetLineStart());
        }
    }

    // Do lineEnd
    if(which_widget == PoincareAttributes::ID_lineEnd || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(lineEnd, val, 3))
            atts->SetLineEnd(val);
        else
        {
            ResettingError(tr("Line Point End"),
                DoublesToQString(atts->GetLineEnd(),3));
            atts->SetLineEnd(atts->GetLineEnd());
        }
    }

    // Do maxStepLength
    if(which_widget == PoincareAttributes::ID_maxStepLength || doAll)
    {
        double val;
        if(LineEditGetDouble(maxStepLength, val))
            atts->SetMaxStepLength(val);
        else
        {
            ResettingError(tr("Maximum step length"),
                DoubleToQString(atts->GetMaxStepLength()));
            atts->SetMaxStepLength(atts->GetMaxStepLength());
        }
    }

    // Do relTol
    if(which_widget == PoincareAttributes::ID_relTol || doAll)
    {
        double val;
        if(LineEditGetDouble(relTol, val))
            atts->SetRelTol(val);
        else
        {
            ResettingError(tr("Relative tolerance"),
                DoubleToQString(atts->GetRelTol()));
            atts->SetRelTol(atts->GetRelTol());
        }
    }

    // Do absTol
    if(which_widget == PoincareAttributes::ID_absTol || doAll)
    {
        double val;
        if(LineEditGetDouble(absTol, val))
            atts->SetAbsTol(val);
        else
        {
            ResettingError(tr("Absolute tolerance"),
                DoubleToQString(atts->GetAbsTol()));
            atts->SetAbsTol(atts->GetAbsTol());
        }
    }

    // Do hitRate
    if(which_widget == PoincareAttributes::ID_hitRate || doAll)
    {
        double val;
        if(LineEditGetDouble(hitRate, val))
            atts->SetHitRate(val);
        else
        {
            ResettingError(tr("hitRate"),
                DoubleToQString(atts->GetHitRate()));
            atts->SetHitRate(atts->GetHitRate());
        }
    }

    // Do singlePlane
    if(which_widget == PoincareAttributes::ID_singlePlane || doAll)
    {
        double val;
        if(LineEditGetDouble(singlePlane, val))
            atts->SetSinglePlane(val);
        else
        {
            ResettingError(tr("singlePlane"),
                IntToQString(atts->GetSinglePlane()));
            atts->SetSinglePlane(atts->GetSinglePlane());
        }
    }

    // Do min
    if(which_widget == PoincareAttributes::ID_min || doAll)
    {
        double val;
        if(LineEditGetDouble(min, val))
            atts->SetMin(val);
        else
        {
            ResettingError(tr("min"),
                DoubleToQString(atts->GetMin()));
            atts->SetMin(atts->GetMin());
        }
    }

    // Do max
    if(which_widget == PoincareAttributes::ID_max || doAll)
    {
        double val;
        if(LineEditGetDouble(max, val))
            atts->SetMax(val);
        else
        {
            ResettingError(tr("max"),
                DoubleToQString(atts->GetMax()));
            atts->SetMax(atts->GetMax());
        }
    }

}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::UpdateIntegrationAttributes
//
// Purpose: 
//   Updates the widgets for the various integration types.
//
// Programmer: Dave Pugmire
// Creation:   Thu Jul 31 14:41:00 EDT 2008
//
// ****************************************************************************

void
QvisPoincarePlotWindow::UpdateIntegrationAttributes()
{
    //Turn off everything.
    maxStepLength->hide();
    maxStepLengthLabel->hide();
    relTol->hide();
    relTolLabel->hide();
    absTol->hide();
    absTolLabel->hide();
    
    switch( atts->GetIntegrationType() )
    {
    case PoincareAttributes::DormandPrince:
        maxStepLength->show();
        maxStepLengthLabel->show();
        maxStepLengthLabel->setText(tr("Maximum step length"));
        relTol->show();
        relTolLabel->show();
        absTol->show();
        absTolLabel->show();
        break;

    case PoincareAttributes::AdamsBashforth:
    case PoincareAttributes::M3DC1Integrator:
        maxStepLength->show();
        maxStepLengthLabel->show();
        maxStepLengthLabel->setText(tr("Step length"));
        absTol->show();
        absTolLabel->show();
        break;
    }
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::UpdateMeshTypeAttributes
//
// Purpose: 
//   Updates the widgets for the various integration types.
//
// Programmer: Dave Pugmire
// Creation:   Fri Aug 1 16:41:38 EDT 2008
//
// ****************************************************************************

void
QvisPoincarePlotWindow::UpdateMeshTypeAttributes()
{
    //Turn off everything.
    singlePlaneLabel->hide();
    singlePlane->hide();
    adjustPlaneLabel->hide();
    adjustPlane->hide();

    switch( atts->GetMeshType() )
    {
    case PoincareAttributes::Curves:
        singlePlaneLabel->show();
        singlePlane->show();
        break;

    case PoincareAttributes::Surfaces:
        adjustPlaneLabel->show();
        adjustPlane->show();
        break;
    }
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::UpdateAlgorithmAttributes
//
// Purpose: 
//   Updates the widgets for the various integration types.
//
// Programmer: Dave Pugmire
// Creation:   Fri Aug 1 16:41:38 EDT 2008
//
// ****************************************************************************

void
QvisPoincarePlotWindow::UpdateAlgorithmAttributes()
{
    //Turn off everything.
    maxDomainCacheLabel->hide();
    maxDomainCache->hide();
    maxSLCountLabel->hide();
    maxSLCount->hide();
    workGroupSizeLabel->hide();
    workGroupSize->hide();

    switch( atts->GetStreamlineAlgorithmType() )
    {
      case PoincareAttributes::LoadOnDemand:
        maxDomainCacheLabel->show();
        maxDomainCache->show();
        break;
    case PoincareAttributes::ParallelStaticDomains:
        maxSLCountLabel->show();
        maxSLCount->show();
        break;

    case PoincareAttributes::MasterSlave:
        maxDomainCacheLabel->show();
        maxDomainCache->show();
        maxSLCountLabel->show();
        maxSLCount->show();
        workGroupSizeLabel->show();
        workGroupSize->show();
        break;
    }
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::Apply
//
// Purpose: 
//   Called to apply changes in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::Apply(bool ignore)
{
    if(AutoUpdate() || ignore)
    {
        GetCurrentValues(-1);
        atts->Notify();

        GetViewerMethods()->SetPlotOptions(plotType);
    }
    else
        atts->Notify();
}


//
// Qt Slot functions
//


// ****************************************************************************
// Method: QvisPoincarePlotWindow::apply
//
// Purpose: 
//   Qt slot function called when apply button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::apply()
{
    Apply(true);
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::makeDefault
//
// Purpose: 
//   Qt slot function called when "Make default" button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::makeDefault()
{
    GetCurrentValues(-1);
    atts->Notify();
    GetViewerMethods()->SetDefaultPlotOptions(plotType);
}


// ****************************************************************************
// Method: QvisPoincarePlotWindow::reset
//
// Purpose: 
//   Qt slot function called when reset button is clicked.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisPoincarePlotWindow::reset()
{
    GetViewerMethods()->ResetPlotOptions(plotType);
}


void
QvisPoincarePlotWindow::sourceTypeChanged(int val)
{
    if(val != atts->GetSourceType())
    {
        atts->SetSourceType(PoincareAttributes::SourceType(val));
        Apply();
    }
}


void
QvisPoincarePlotWindow::pointSourceProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_pointSource);
    Apply();
}


void
QvisPoincarePlotWindow::lineStartProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_lineStart);
    Apply();
}


void
QvisPoincarePlotWindow::lineEndProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_lineEnd);
    Apply();
}


void
QvisPoincarePlotWindow::pointDensityChanged(int val)
{
    atts->SetPointDensity(val);
    Apply();
}


void
QvisPoincarePlotWindow::minPuncturesChanged(int val)
{
    atts->SetMinPunctures(val);
    Apply();
}


void
QvisPoincarePlotWindow::maxPuncturesChanged(int val)
{
    atts->SetMaxPunctures(val);
    Apply();
}


void
QvisPoincarePlotWindow::integrationTypeChanged(int val)
{
    if(val != atts->GetIntegrationType())
    {
        atts->SetIntegrationType(PoincareAttributes::IntegrationType(val));
        Apply();
    }
}


void
QvisPoincarePlotWindow::maxStepLengthProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_maxStepLength);
    Apply();
}


void
QvisPoincarePlotWindow::relTolProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_relTol);
    Apply();
}


void
QvisPoincarePlotWindow::absTolProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_absTol);
    Apply();
}


void
QvisPoincarePlotWindow::maxToroidalWindingChanged(int val)
{
    atts->SetMaxToroidalWinding(val);
    Apply();
}


void
QvisPoincarePlotWindow::overrideToroidalWindingChanged(int val)
{
    atts->SetOverrideToroidalWinding(val);
    Apply();
}


void
QvisPoincarePlotWindow::hitRateProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_hitRate);
    Apply();
}


void
QvisPoincarePlotWindow::overlapsChanged(int val)
{
    if(val != atts->GetOverlaps())
    {
        atts->SetOverlaps(PoincareAttributes::OverlapType(val));
        Apply();
    }
}


void
QvisPoincarePlotWindow::meshTypeChanged(int val)
{
    if(val != atts->GetMeshType())
    {
        atts->SetMeshType(PoincareAttributes::ShowMeshType(val));
        Apply();
    }
}


void
QvisPoincarePlotWindow::numberPlanesChanged(int val)
{
    atts->SetNumberPlanes(val);
    Apply();
}


void
QvisPoincarePlotWindow::singlePlaneProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_singlePlane);
    Apply();
}


void
QvisPoincarePlotWindow::adjustPlaneChanged(int val)
{
    atts->SetAdjustPlane(val);
    Apply();
}


void
QvisPoincarePlotWindow::minProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_min);
    Apply();
}


void
QvisPoincarePlotWindow::maxProcessText()
{
    GetCurrentValues(PoincareAttributes::ID_max);
    Apply();
}


void
QvisPoincarePlotWindow::minFlagChanged(bool val)
{
    atts->SetMinFlag(val);
    Apply();
}


void
QvisPoincarePlotWindow::maxFlagChanged(bool val)
{
    atts->SetMaxFlag(val);
    Apply();
}


void
QvisPoincarePlotWindow::colorTypeChanged(int val)
{
    if(val != atts->GetColorType())
    {
        atts->SetColorType(PoincareAttributes::ColoringMethod(val));
        Apply();
    }
}


void
QvisPoincarePlotWindow::singleColorChanged(const QColor &color)
{
    ColorAttribute temp(color.red(), color.green(), color.blue());
    atts->SetSingleColor(temp);
    SetUpdate(false);
    Apply();
}


void
QvisPoincarePlotWindow::colorTableNameChanged(bool useDefault, const QString &ctName)
{
    atts->SetColorTableName(ctName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisPoincarePlotWindow::dataValueChanged(int val)
{
    if(val != atts->GetDataValue())
    {
        atts->SetDataValue(PoincareAttributes::DataValue(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisPoincarePlotWindow::showOPointsChanged(bool val)
{
    atts->SetShowOPoints(val);
    Apply();
}


void
QvisPoincarePlotWindow::OPointMaxIterationsChanged(int val)
{
    atts->SetOPointMaxInterations(val);
    Apply();
}


void
QvisPoincarePlotWindow::showIslandsChanged(bool val)
{
    atts->SetShowIslands(val);
    Apply();
}


void
QvisPoincarePlotWindow::showChaoticChanged(bool val)
{
    atts->SetShowChaotic(val);
    Apply();
}


void
QvisPoincarePlotWindow::showLinesChanged(bool val)
{
    atts->SetShowLines(val);
    Apply();
}


void
QvisPoincarePlotWindow::showRidgelinesChanged(bool val)
{
    atts->SetShowRidgelines(val);
    Apply();
}


void
QvisPoincarePlotWindow::showPointsChanged(bool val)
{
    atts->SetShowPoints(val);
    Apply();
}


void
QvisPoincarePlotWindow::verboseFlagChanged(bool val)
{
    atts->SetVerboseFlag(val);
    Apply();
}


void
QvisPoincarePlotWindow::legendToggled(bool val)
{
    atts->SetLegendFlag(val);
    SetUpdate(false);
    Apply();
}


void
QvisPoincarePlotWindow::lightingToggled(bool val)
{
    atts->SetLightingFlag(val);
    SetUpdate(false);
    Apply();
}

void
QvisPoincarePlotWindow::streamlineAlgorithmChanged(int val)
{
    if(val != atts->GetStreamlineAlgorithmType())
    {
        atts->SetStreamlineAlgorithmType(PoincareAttributes::StreamlineAlgorithmType(val));
        Apply();
    }
}

void
QvisPoincarePlotWindow::maxSLCountChanged(int val)
{
    atts->SetMaxStreamlineProcessCount(val);
    Apply();
}

void
QvisPoincarePlotWindow::maxDomainCacheChanged(int val)
{
    atts->SetMaxDomainCacheSize(val);
    Apply();
}

void
QvisPoincarePlotWindow::workGroupSizeChanged(int val)
{
    atts->SetWorkGroupSize(val);
    Apply();
}
