/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyPoincareAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPoincareAttributes
//
// Purpose: 
//   Attributes for the Poincare plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PoincareAttributes.
//
struct PoincareAttributesObject
{
    PyObject_HEAD
    PoincareAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPoincareAttributes(int);

std::string
PyPoincareAttributes_ToString(const PoincareAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sminPunctures = %d\n", prefix, atts->GetMinPunctures());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxPunctures = %d\n", prefix, atts->GetMaxPunctures());
    str += tmpStr;
    const char *sourceType_names = "SpecifiedPoint, SpecifiedLine";
    switch (atts->GetSourceType())
    {
      case PoincareAttributes::SpecifiedPoint:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedPoint  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SpecifiedLine:
          SNPRINTF(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *pointSource = atts->GetPointSource();
        SNPRINTF(tmpStr, 1000, "%spointSource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        SNPRINTF(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        SNPRINTF(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%spointDensity = %d\n", prefix, atts->GetPointDensity());
    str += tmpStr;
    const char *integrationType_names = "DormandPrince, AdamsBashforth, M3DC1Integrator";
    switch (atts->GetIntegrationType())
    {
      case PoincareAttributes::DormandPrince:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::AdamsBashforth:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::M3DC1Integrator:
          SNPRINTF(tmpStr, 1000, "%sintegrationType = %sM3DC1Integrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sabsTol = %g\n", prefix, atts->GetAbsTol());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxToroidalWinding = %d\n", prefix, atts->GetMaxToroidalWinding());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soverrideToroidalWinding = %d\n", prefix, atts->GetOverrideToroidalWinding());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shitRate = %g\n", prefix, atts->GetHitRate());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sadjustPlane = %d\n", prefix, atts->GetAdjustPlane());
    str += tmpStr;
    const char *overlaps_names = "Raw, Remove, Merge, Smooth";
    switch (atts->GetOverlaps())
    {
      case PoincareAttributes::Raw:
          SNPRINTF(tmpStr, 1000, "%soverlaps = %sRaw  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Remove:
          SNPRINTF(tmpStr, 1000, "%soverlaps = %sRemove  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Merge:
          SNPRINTF(tmpStr, 1000, "%soverlaps = %sMerge  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Smooth:
          SNPRINTF(tmpStr, 1000, "%soverlaps = %sSmooth  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *meshType_names = "Curves, Surfaces";
    switch (atts->GetMeshType())
    {
      case PoincareAttributes::Curves:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sCurves  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Surfaces:
          SNPRINTF(tmpStr, 1000, "%smeshType = %sSurfaces  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%snumberPlanes = %d\n", prefix, atts->GetNumberPlanes());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssinglePlane = %g\n", prefix, atts->GetSinglePlane());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    const char *colorType_names = "ColorBySingleColor, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case PoincareAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    const char *dataValue_names = "OriginalValue, InputOrder, PointIndex, Plane, WindingOrder, "
        "WindingPointOrder, WindingPointOrderModulo, ToroidalWindings, PoloidalWindings, "
        "SafetyFactor, Confidence, RidgelineVariance";
    switch (atts->GetDataValue())
    {
      case PoincareAttributes::OriginalValue:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sOriginalValue  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::InputOrder:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sInputOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PointIndex:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sPointIndex  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Plane:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sPlane  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingOrder:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sWindingOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingPointOrder:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sWindingPointOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingPointOrderModulo:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sWindingPointOrderModulo  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ToroidalWindings:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sToroidalWindings  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PoloidalWindings:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sPoloidalWindings  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SafetyFactor:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sSafetyFactor  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Confidence:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sConfidence  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::RidgelineVariance:
          SNPRINTF(tmpStr, 1000, "%sdataValue = %sRidgelineVariance  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetShowOPoints())
        SNPRINTF(tmpStr, 1000, "%sshowOPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowOPoints = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sOPointMaxInterations = %d\n", prefix, atts->GetOPointMaxInterations());
    str += tmpStr;
    if(atts->GetShowXPoints())
        SNPRINTF(tmpStr, 1000, "%sshowXPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowXPoints = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sXPointMaxInterations = %d\n", prefix, atts->GetXPointMaxInterations());
    str += tmpStr;
    if(atts->GetShowChaotic())
        SNPRINTF(tmpStr, 1000, "%sshowChaotic = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowChaotic = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowIslands())
        SNPRINTF(tmpStr, 1000, "%sshowIslands = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowIslands = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVerboseFlag())
        SNPRINTF(tmpStr, 1000, "%sverboseFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sverboseFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowRidgelines())
        SNPRINTF(tmpStr, 1000, "%sshowRidgelines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowRidgelines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowLines())
        SNPRINTF(tmpStr, 1000, "%sshowLines = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowPoints())
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    const char *streamlineAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave";
    switch (atts->GetStreamlineAlgorithmType())
    {
      case PoincareAttributes::LoadOnDemand:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ParallelStaticDomains:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::MasterSlave:
          SNPRINTF(tmpStr, 1000, "%sstreamlineAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, streamlineAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%smaxStreamlineProcessCount = %d\n", prefix, atts->GetMaxStreamlineProcessCount());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    return str;
}

static PyObject *
PoincareAttributes_Notify(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_SetMinPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minPunctures in the object.
    obj->data->SetMinPunctures((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMinPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMinPunctures()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxPunctures in the object.
    obj->data->SetMaxPunctures((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxPunctures()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSourceType(PoincareAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, SpecifiedLine.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPointDensity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointDensity in the object.
    obj->data->SetPointDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPointDensity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointDensity()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetIntegrationType(PoincareAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "DormandPrince, AdamsBashforth, M3DC1Integrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAbsTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTol in the object.
    obj->data->SetAbsTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAbsTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTol());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxToroidalWinding in the object.
    obj->data->SetMaxToroidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxToroidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOverrideToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overrideToroidalWinding in the object.
    obj->data->SetOverrideToroidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOverrideToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOverrideToroidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetHitRate(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hitRate in the object.
    obj->data->SetHitRate(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetHitRate(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHitRate());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAdjustPlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the adjustPlane in the object.
    obj->data->SetAdjustPlane((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAdjustPlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAdjustPlane()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOverlaps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overlaps in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetOverlaps(PoincareAttributes::OverlapType(ival));
    else
    {
        fprintf(stderr, "An invalid overlaps value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Raw, Remove, Merge, Smooth.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOverlaps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOverlaps()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMeshType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetMeshType(PoincareAttributes::ShowMeshType(ival));
    else
    {
        fprintf(stderr, "An invalid meshType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Curves, Surfaces.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMeshType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetNumberPlanes(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberPlanes in the object.
    obj->data->SetNumberPlanes((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetNumberPlanes(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberPlanes()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSinglePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the singlePlane in the object.
    obj->data->SetSinglePlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSinglePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSinglePlane());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMin(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMin(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMax(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMax(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetColorType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorType(PoincareAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetColorType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetDataValue(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dataValue in the object.
    if(ival >= 0 && ival < 12)
        obj->data->SetDataValue(PoincareAttributes::DataValue(ival));
    else
    {
        fprintf(stderr, "An invalid dataValue value was given. "
                        "Valid values are in the range of [0,11]. "
                        "You can also use the following names: "
                        "OriginalValue, InputOrder, PointIndex, Plane, WindingOrder, "
                        "WindingPointOrder, WindingPointOrderModulo, ToroidalWindings, PoloidalWindings, "
                        "SafetyFactor, Confidence, RidgelineVariance.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetDataValue(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDataValue()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowOPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showOPoints in the object.
    obj->data->SetShowOPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowOPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowOPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOPointMaxInterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the OPointMaxInterations in the object.
    obj->data->SetOPointMaxInterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOPointMaxInterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOPointMaxInterations()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowXPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showXPoints in the object.
    obj->data->SetShowXPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowXPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowXPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetXPointMaxInterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the XPointMaxInterations in the object.
    obj->data->SetXPointMaxInterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetXPointMaxInterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXPointMaxInterations()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowChaotic(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showChaotic in the object.
    obj->data->SetShowChaotic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowChaotic(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowChaotic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowIslands(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showIslands in the object.
    obj->data->SetShowIslands(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowIslands(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowIslands()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetVerboseFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the verboseFlag in the object.
    obj->data->SetVerboseFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetVerboseFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVerboseFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowRidgelines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showRidgelines in the object.
    obj->data->SetShowRidgelines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowRidgelines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowRidgelines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowLines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLines in the object.
    obj->data->SetShowLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowLines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetStreamlineAlgorithmType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the streamlineAlgorithmType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetStreamlineAlgorithmType(PoincareAttributes::StreamlineAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid streamlineAlgorithmType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetStreamlineAlgorithmType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStreamlineAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxStreamlineProcessCount(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxStreamlineProcessCount in the object.
    obj->data->SetMaxStreamlineProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxStreamlineProcessCount(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxStreamlineProcessCount()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}



PyMethodDef PyPoincareAttributes_methods[POINCAREATTRIBUTES_NMETH] = {
    {"Notify", PoincareAttributes_Notify, METH_VARARGS},
    {"SetMinPunctures", PoincareAttributes_SetMinPunctures, METH_VARARGS},
    {"GetMinPunctures", PoincareAttributes_GetMinPunctures, METH_VARARGS},
    {"SetMaxPunctures", PoincareAttributes_SetMaxPunctures, METH_VARARGS},
    {"GetMaxPunctures", PoincareAttributes_GetMaxPunctures, METH_VARARGS},
    {"SetSourceType", PoincareAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", PoincareAttributes_GetSourceType, METH_VARARGS},
    {"SetPointSource", PoincareAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", PoincareAttributes_GetPointSource, METH_VARARGS},
    {"SetLineStart", PoincareAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", PoincareAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", PoincareAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", PoincareAttributes_GetLineEnd, METH_VARARGS},
    {"SetPointDensity", PoincareAttributes_SetPointDensity, METH_VARARGS},
    {"GetPointDensity", PoincareAttributes_GetPointDensity, METH_VARARGS},
    {"SetIntegrationType", PoincareAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", PoincareAttributes_GetIntegrationType, METH_VARARGS},
    {"SetMaxStepLength", PoincareAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", PoincareAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetRelTol", PoincareAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", PoincareAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTol", PoincareAttributes_SetAbsTol, METH_VARARGS},
    {"GetAbsTol", PoincareAttributes_GetAbsTol, METH_VARARGS},
    {"SetMaxToroidalWinding", PoincareAttributes_SetMaxToroidalWinding, METH_VARARGS},
    {"GetMaxToroidalWinding", PoincareAttributes_GetMaxToroidalWinding, METH_VARARGS},
    {"SetOverrideToroidalWinding", PoincareAttributes_SetOverrideToroidalWinding, METH_VARARGS},
    {"GetOverrideToroidalWinding", PoincareAttributes_GetOverrideToroidalWinding, METH_VARARGS},
    {"SetHitRate", PoincareAttributes_SetHitRate, METH_VARARGS},
    {"GetHitRate", PoincareAttributes_GetHitRate, METH_VARARGS},
    {"SetAdjustPlane", PoincareAttributes_SetAdjustPlane, METH_VARARGS},
    {"GetAdjustPlane", PoincareAttributes_GetAdjustPlane, METH_VARARGS},
    {"SetOverlaps", PoincareAttributes_SetOverlaps, METH_VARARGS},
    {"GetOverlaps", PoincareAttributes_GetOverlaps, METH_VARARGS},
    {"SetMeshType", PoincareAttributes_SetMeshType, METH_VARARGS},
    {"GetMeshType", PoincareAttributes_GetMeshType, METH_VARARGS},
    {"SetNumberPlanes", PoincareAttributes_SetNumberPlanes, METH_VARARGS},
    {"GetNumberPlanes", PoincareAttributes_GetNumberPlanes, METH_VARARGS},
    {"SetSinglePlane", PoincareAttributes_SetSinglePlane, METH_VARARGS},
    {"GetSinglePlane", PoincareAttributes_GetSinglePlane, METH_VARARGS},
    {"SetMin", PoincareAttributes_SetMin, METH_VARARGS},
    {"GetMin", PoincareAttributes_GetMin, METH_VARARGS},
    {"SetMax", PoincareAttributes_SetMax, METH_VARARGS},
    {"GetMax", PoincareAttributes_GetMax, METH_VARARGS},
    {"SetMinFlag", PoincareAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", PoincareAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", PoincareAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", PoincareAttributes_GetMaxFlag, METH_VARARGS},
    {"SetColorType", PoincareAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", PoincareAttributes_GetColorType, METH_VARARGS},
    {"SetSingleColor", PoincareAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", PoincareAttributes_GetSingleColor, METH_VARARGS},
    {"SetColorTableName", PoincareAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", PoincareAttributes_GetColorTableName, METH_VARARGS},
    {"SetDataValue", PoincareAttributes_SetDataValue, METH_VARARGS},
    {"GetDataValue", PoincareAttributes_GetDataValue, METH_VARARGS},
    {"SetShowOPoints", PoincareAttributes_SetShowOPoints, METH_VARARGS},
    {"GetShowOPoints", PoincareAttributes_GetShowOPoints, METH_VARARGS},
    {"SetOPointMaxInterations", PoincareAttributes_SetOPointMaxInterations, METH_VARARGS},
    {"GetOPointMaxInterations", PoincareAttributes_GetOPointMaxInterations, METH_VARARGS},
    {"SetShowXPoints", PoincareAttributes_SetShowXPoints, METH_VARARGS},
    {"GetShowXPoints", PoincareAttributes_GetShowXPoints, METH_VARARGS},
    {"SetXPointMaxInterations", PoincareAttributes_SetXPointMaxInterations, METH_VARARGS},
    {"GetXPointMaxInterations", PoincareAttributes_GetXPointMaxInterations, METH_VARARGS},
    {"SetShowChaotic", PoincareAttributes_SetShowChaotic, METH_VARARGS},
    {"GetShowChaotic", PoincareAttributes_GetShowChaotic, METH_VARARGS},
    {"SetShowIslands", PoincareAttributes_SetShowIslands, METH_VARARGS},
    {"GetShowIslands", PoincareAttributes_GetShowIslands, METH_VARARGS},
    {"SetVerboseFlag", PoincareAttributes_SetVerboseFlag, METH_VARARGS},
    {"GetVerboseFlag", PoincareAttributes_GetVerboseFlag, METH_VARARGS},
    {"SetShowRidgelines", PoincareAttributes_SetShowRidgelines, METH_VARARGS},
    {"GetShowRidgelines", PoincareAttributes_GetShowRidgelines, METH_VARARGS},
    {"SetShowLines", PoincareAttributes_SetShowLines, METH_VARARGS},
    {"GetShowLines", PoincareAttributes_GetShowLines, METH_VARARGS},
    {"SetShowPoints", PoincareAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", PoincareAttributes_GetShowPoints, METH_VARARGS},
    {"SetLegendFlag", PoincareAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", PoincareAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", PoincareAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", PoincareAttributes_GetLightingFlag, METH_VARARGS},
    {"SetStreamlineAlgorithmType", PoincareAttributes_SetStreamlineAlgorithmType, METH_VARARGS},
    {"GetStreamlineAlgorithmType", PoincareAttributes_GetStreamlineAlgorithmType, METH_VARARGS},
    {"SetMaxStreamlineProcessCount", PoincareAttributes_SetMaxStreamlineProcessCount, METH_VARARGS},
    {"GetMaxStreamlineProcessCount", PoincareAttributes_GetMaxStreamlineProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", PoincareAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", PoincareAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", PoincareAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", PoincareAttributes_GetWorkGroupSize, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PoincareAttributes_dealloc(PyObject *v)
{
   PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PoincareAttributes_compare(PyObject *v, PyObject *w)
{
    PoincareAttributes *a = ((PoincareAttributesObject *)v)->data;
    PoincareAttributes *b = ((PoincareAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPoincareAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "minPunctures") == 0)
        return PoincareAttributes_GetMinPunctures(self, NULL);
    if(strcmp(name, "maxPunctures") == 0)
        return PoincareAttributes_GetMaxPunctures(self, NULL);
    if(strcmp(name, "sourceType") == 0)
        return PoincareAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SpecifiedPoint));
    if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SpecifiedLine));

    if(strcmp(name, "pointSource") == 0)
        return PoincareAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return PoincareAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return PoincareAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "pointDensity") == 0)
        return PoincareAttributes_GetPointDensity(self, NULL);
    if(strcmp(name, "integrationType") == 0)
        return PoincareAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(PoincareAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(PoincareAttributes::AdamsBashforth));
    if(strcmp(name, "M3DC1Integrator") == 0)
        return PyInt_FromLong(long(PoincareAttributes::M3DC1Integrator));

    if(strcmp(name, "maxStepLength") == 0)
        return PoincareAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "relTol") == 0)
        return PoincareAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTol") == 0)
        return PoincareAttributes_GetAbsTol(self, NULL);
    if(strcmp(name, "maxToroidalWinding") == 0)
        return PoincareAttributes_GetMaxToroidalWinding(self, NULL);
    if(strcmp(name, "overrideToroidalWinding") == 0)
        return PoincareAttributes_GetOverrideToroidalWinding(self, NULL);
    if(strcmp(name, "hitRate") == 0)
        return PoincareAttributes_GetHitRate(self, NULL);
    if(strcmp(name, "adjustPlane") == 0)
        return PoincareAttributes_GetAdjustPlane(self, NULL);
    if(strcmp(name, "overlaps") == 0)
        return PoincareAttributes_GetOverlaps(self, NULL);
    if(strcmp(name, "Raw") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Raw));
    if(strcmp(name, "Remove") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Remove));
    if(strcmp(name, "Merge") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Merge));
    if(strcmp(name, "Smooth") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Smooth));

    if(strcmp(name, "meshType") == 0)
        return PoincareAttributes_GetMeshType(self, NULL);
    if(strcmp(name, "Curves") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Curves));
    if(strcmp(name, "Surfaces") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Surfaces));

    if(strcmp(name, "numberPlanes") == 0)
        return PoincareAttributes_GetNumberPlanes(self, NULL);
    if(strcmp(name, "singlePlane") == 0)
        return PoincareAttributes_GetSinglePlane(self, NULL);
    if(strcmp(name, "min") == 0)
        return PoincareAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return PoincareAttributes_GetMax(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return PoincareAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return PoincareAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return PoincareAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ColorByColorTable));

    if(strcmp(name, "singleColor") == 0)
        return PoincareAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return PoincareAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "dataValue") == 0)
        return PoincareAttributes_GetDataValue(self, NULL);
    if(strcmp(name, "OriginalValue") == 0)
        return PyInt_FromLong(long(PoincareAttributes::OriginalValue));
    if(strcmp(name, "InputOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::InputOrder));
    if(strcmp(name, "PointIndex") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PointIndex));
    if(strcmp(name, "Plane") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Plane));
    if(strcmp(name, "WindingOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingOrder));
    if(strcmp(name, "WindingPointOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingPointOrder));
    if(strcmp(name, "WindingPointOrderModulo") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingPointOrderModulo));
    if(strcmp(name, "ToroidalWindings") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ToroidalWindings));
    if(strcmp(name, "PoloidalWindings") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PoloidalWindings));
    if(strcmp(name, "SafetyFactor") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SafetyFactor));
    if(strcmp(name, "Confidence") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Confidence));
    if(strcmp(name, "RidgelineVariance") == 0)
        return PyInt_FromLong(long(PoincareAttributes::RidgelineVariance));

    if(strcmp(name, "showOPoints") == 0)
        return PoincareAttributes_GetShowOPoints(self, NULL);
    if(strcmp(name, "OPointMaxInterations") == 0)
        return PoincareAttributes_GetOPointMaxInterations(self, NULL);
    if(strcmp(name, "showXPoints") == 0)
        return PoincareAttributes_GetShowXPoints(self, NULL);
    if(strcmp(name, "XPointMaxInterations") == 0)
        return PoincareAttributes_GetXPointMaxInterations(self, NULL);
    if(strcmp(name, "showChaotic") == 0)
        return PoincareAttributes_GetShowChaotic(self, NULL);
    if(strcmp(name, "showIslands") == 0)
        return PoincareAttributes_GetShowIslands(self, NULL);
    if(strcmp(name, "verboseFlag") == 0)
        return PoincareAttributes_GetVerboseFlag(self, NULL);
    if(strcmp(name, "showRidgelines") == 0)
        return PoincareAttributes_GetShowRidgelines(self, NULL);
    if(strcmp(name, "showLines") == 0)
        return PoincareAttributes_GetShowLines(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return PoincareAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return PoincareAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return PoincareAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "streamlineAlgorithmType") == 0)
        return PoincareAttributes_GetStreamlineAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(PoincareAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(PoincareAttributes::MasterSlave));

    if(strcmp(name, "maxStreamlineProcessCount") == 0)
        return PoincareAttributes_GetMaxStreamlineProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return PoincareAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return PoincareAttributes_GetWorkGroupSize(self, NULL);

    return Py_FindMethod(PyPoincareAttributes_methods, self, name);
}

int
PyPoincareAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "minPunctures") == 0)
        obj = PoincareAttributes_SetMinPunctures(self, tuple);
    else if(strcmp(name, "maxPunctures") == 0)
        obj = PoincareAttributes_SetMaxPunctures(self, tuple);
    else if(strcmp(name, "sourceType") == 0)
        obj = PoincareAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "pointSource") == 0)
        obj = PoincareAttributes_SetPointSource(self, tuple);
    else if(strcmp(name, "lineStart") == 0)
        obj = PoincareAttributes_SetLineStart(self, tuple);
    else if(strcmp(name, "lineEnd") == 0)
        obj = PoincareAttributes_SetLineEnd(self, tuple);
    else if(strcmp(name, "pointDensity") == 0)
        obj = PoincareAttributes_SetPointDensity(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = PoincareAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = PoincareAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = PoincareAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTol") == 0)
        obj = PoincareAttributes_SetAbsTol(self, tuple);
    else if(strcmp(name, "maxToroidalWinding") == 0)
        obj = PoincareAttributes_SetMaxToroidalWinding(self, tuple);
    else if(strcmp(name, "overrideToroidalWinding") == 0)
        obj = PoincareAttributes_SetOverrideToroidalWinding(self, tuple);
    else if(strcmp(name, "hitRate") == 0)
        obj = PoincareAttributes_SetHitRate(self, tuple);
    else if(strcmp(name, "adjustPlane") == 0)
        obj = PoincareAttributes_SetAdjustPlane(self, tuple);
    else if(strcmp(name, "overlaps") == 0)
        obj = PoincareAttributes_SetOverlaps(self, tuple);
    else if(strcmp(name, "meshType") == 0)
        obj = PoincareAttributes_SetMeshType(self, tuple);
    else if(strcmp(name, "numberPlanes") == 0)
        obj = PoincareAttributes_SetNumberPlanes(self, tuple);
    else if(strcmp(name, "singlePlane") == 0)
        obj = PoincareAttributes_SetSinglePlane(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = PoincareAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = PoincareAttributes_SetMax(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = PoincareAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = PoincareAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = PoincareAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = PoincareAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = PoincareAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "dataValue") == 0)
        obj = PoincareAttributes_SetDataValue(self, tuple);
    else if(strcmp(name, "showOPoints") == 0)
        obj = PoincareAttributes_SetShowOPoints(self, tuple);
    else if(strcmp(name, "OPointMaxInterations") == 0)
        obj = PoincareAttributes_SetOPointMaxInterations(self, tuple);
    else if(strcmp(name, "showXPoints") == 0)
        obj = PoincareAttributes_SetShowXPoints(self, tuple);
    else if(strcmp(name, "XPointMaxInterations") == 0)
        obj = PoincareAttributes_SetXPointMaxInterations(self, tuple);
    else if(strcmp(name, "showChaotic") == 0)
        obj = PoincareAttributes_SetShowChaotic(self, tuple);
    else if(strcmp(name, "showIslands") == 0)
        obj = PoincareAttributes_SetShowIslands(self, tuple);
    else if(strcmp(name, "verboseFlag") == 0)
        obj = PoincareAttributes_SetVerboseFlag(self, tuple);
    else if(strcmp(name, "showRidgelines") == 0)
        obj = PoincareAttributes_SetShowRidgelines(self, tuple);
    else if(strcmp(name, "showLines") == 0)
        obj = PoincareAttributes_SetShowLines(self, tuple);
    else if(strcmp(name, "showPoints") == 0)
        obj = PoincareAttributes_SetShowPoints(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = PoincareAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = PoincareAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "streamlineAlgorithmType") == 0)
        obj = PoincareAttributes_SetStreamlineAlgorithmType(self, tuple);
    else if(strcmp(name, "maxStreamlineProcessCount") == 0)
        obj = PoincareAttributes_SetMaxStreamlineProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = PoincareAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = PoincareAttributes_SetWorkGroupSize(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PoincareAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
    fprintf(fp, "%s", PyPoincareAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PoincareAttributes_str(PyObject *v)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
    return PyString_FromString(PyPoincareAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PoincareAttributes_Purpose = "Attributes for the Poincare plot";
#else
static char *PoincareAttributes_Purpose = "Attributes for the Poincare plot";
#endif

//
// The type description structure
//
static PyTypeObject PoincareAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PoincareAttributes",                    // tp_name
    sizeof(PoincareAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PoincareAttributes_dealloc,  // tp_dealloc
    (printfunc)PoincareAttributes_print,     // tp_print
    (getattrfunc)PyPoincareAttributes_getattr, // tp_getattr
    (setattrfunc)PyPoincareAttributes_setattr, // tp_setattr
    (cmpfunc)PoincareAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PoincareAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PoincareAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PoincareAttributes *defaultAtts = 0;
static PoincareAttributes *currentAtts = 0;

static PyObject *
NewPoincareAttributes(int useCurrent)
{
    PoincareAttributesObject *newObject;
    newObject = PyObject_NEW(PoincareAttributesObject, &PoincareAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PoincareAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PoincareAttributes(*defaultAtts);
    else
        newObject->data = new PoincareAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPoincareAttributes(const PoincareAttributes *attr)
{
    PoincareAttributesObject *newObject;
    newObject = PyObject_NEW(PoincareAttributesObject, &PoincareAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PoincareAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PoincareAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPoincareAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PoincareAttributesMethods[] = {
    {"PoincareAttributes", PoincareAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PoincareAttributesObserver = 0;

std::string
PyPoincareAttributes_GetLogString()
{
    std::string s("PoincareAtts = PoincareAttributes()\n");
    if(currentAtts != 0)
        s += PyPoincareAttributes_ToString(currentAtts, "PoincareAtts.");
    return s;
}

static void
PyPoincareAttributes_CallLogRoutine(Subject *subj, void *data)
{
    PoincareAttributes *atts = (PoincareAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PoincareAtts = PoincareAttributes()\n");
        s += PyPoincareAttributes_ToString(currentAtts, "PoincareAtts.");
        cb(s);
    }
}

void
PyPoincareAttributes_StartUp(PoincareAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPoincareAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PoincareAttributesObserver == 0)
    {
        PoincareAttributesObserver = new ObserverToCallback(subj,
            PyPoincareAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPoincareAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PoincareAttributesObserver;
    PoincareAttributesObserver = 0;
}

PyMethodDef *
PyPoincareAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PoincareAttributesMethods;
}

bool
PyPoincareAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PoincareAttributesType);
}

PoincareAttributes *
PyPoincareAttributes_FromPyObject(PyObject *obj)
{
    PoincareAttributesObject *obj2 = (PoincareAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPoincareAttributes_New()
{
    return NewPoincareAttributes(0);
}

PyObject *
PyPoincareAttributes_Wrap(const PoincareAttributes *attr)
{
    return WrapPoincareAttributes(attr);
}

void
PyPoincareAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PoincareAttributesObject *obj2 = (PoincareAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPoincareAttributes_SetDefaults(const PoincareAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PoincareAttributes(*atts);
}

