// ***************************************************************************
//
// Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-400124
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: PoincareAttributes
//
// Purpose:
//    Attributes for the Poincare plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class PoincareAttributes extends AttributeSubject implements Plugin
{
    private static int PoincareAttributes_numAdditionalAtts = 43;

    // Enum values
    public final static int SOURCETYPE_SPECIFIEDPOINT = 0;
    public final static int SOURCETYPE_SPECIFIEDLINE = 1;

    public final static int INTEGRATIONTYPE_DORMANDPRINCE = 0;
    public final static int INTEGRATIONTYPE_ADAMSBASHFORTH = 1;
    public final static int INTEGRATIONTYPE_M3DC1INTEGRATOR = 2;

    public final static int OVERLAPTYPE_RAW = 0;
    public final static int OVERLAPTYPE_REMOVE = 1;
    public final static int OVERLAPTYPE_MERGE = 2;
    public final static int OVERLAPTYPE_SMOOTH = 3;

    public final static int SHOWMESHTYPE_CURVES = 0;
    public final static int SHOWMESHTYPE_SURFACES = 1;

    public final static int COLORINGMETHOD_COLORBYSINGLECOLOR = 0;
    public final static int COLORINGMETHOD_COLORBYCOLORTABLE = 1;

    public final static int DATAVALUE_ORIGINALVALUE = 0;
    public final static int DATAVALUE_INPUTORDER = 1;
    public final static int DATAVALUE_POINTINDEX = 2;
    public final static int DATAVALUE_PLANE = 3;
    public final static int DATAVALUE_WINDINGORDER = 4;
    public final static int DATAVALUE_WINDINGPOINTORDER = 5;
    public final static int DATAVALUE_WINDINGPOINTORDERMODULO = 6;
    public final static int DATAVALUE_TOROIDALWINDINGS = 7;
    public final static int DATAVALUE_POLOIDALWINDINGS = 8;
    public final static int DATAVALUE_SAFETYFACTOR = 9;
    public final static int DATAVALUE_CONFIDENCE = 10;
    public final static int DATAVALUE_RIDGELINEVARIANCE = 11;

    public final static int STREAMLINEALGORITHMTYPE_LOADONDEMAND = 0;
    public final static int STREAMLINEALGORITHMTYPE_PARALLELSTATICDOMAINS = 1;
    public final static int STREAMLINEALGORITHMTYPE_MASTERSLAVE = 2;


    public PoincareAttributes()
    {
        super(PoincareAttributes_numAdditionalAtts);

        minPunctures = 10;
        maxPunctures = 100;
        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        pointDensity = 1;
        integrationType = INTEGRATIONTYPE_ADAMSBASHFORTH;
        maxStepLength = 0.1;
        relTol = 0.0001;
        absTol = 1e-05;
        maxToroidalWinding = 30;
        overrideToroidalWinding = 0;
        hitRate = 0.9;
        adjustPlane = -1;
        overlaps = OVERLAPTYPE_REMOVE;
        meshType = SHOWMESHTYPE_CURVES;
        numberPlanes = 1;
        singlePlane = 0;
        min = 0;
        max = 0;
        minFlag = false;
        maxFlag = false;
        colorType = COLORINGMETHOD_COLORBYSINGLECOLOR;
        singleColor = new ColorAttribute(0, 0, 0);
        colorTableName = new String("Default");
        dataValue = DATAVALUE_SAFETYFACTOR;
        showOPoints = false;
        OPointMaxInterations = 2;
        showXPoints = false;
        XPointMaxInterations = 2;
        showChaotic = false;
        showIslands = false;
        verboseFlag = true;
        showRidgelines = false;
        showLines = true;
        showPoints = false;
        legendFlag = true;
        lightingFlag = true;
        streamlineAlgorithmType = STREAMLINEALGORITHMTYPE_LOADONDEMAND;
        maxStreamlineProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
    }

    public PoincareAttributes(int nMoreFields)
    {
        super(PoincareAttributes_numAdditionalAtts + nMoreFields);

        minPunctures = 10;
        maxPunctures = 100;
        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        pointDensity = 1;
        integrationType = INTEGRATIONTYPE_ADAMSBASHFORTH;
        maxStepLength = 0.1;
        relTol = 0.0001;
        absTol = 1e-05;
        maxToroidalWinding = 30;
        overrideToroidalWinding = 0;
        hitRate = 0.9;
        adjustPlane = -1;
        overlaps = OVERLAPTYPE_REMOVE;
        meshType = SHOWMESHTYPE_CURVES;
        numberPlanes = 1;
        singlePlane = 0;
        min = 0;
        max = 0;
        minFlag = false;
        maxFlag = false;
        colorType = COLORINGMETHOD_COLORBYSINGLECOLOR;
        singleColor = new ColorAttribute(0, 0, 0);
        colorTableName = new String("Default");
        dataValue = DATAVALUE_SAFETYFACTOR;
        showOPoints = false;
        OPointMaxInterations = 2;
        showXPoints = false;
        XPointMaxInterations = 2;
        showChaotic = false;
        showIslands = false;
        verboseFlag = true;
        showRidgelines = false;
        showLines = true;
        showPoints = false;
        legendFlag = true;
        lightingFlag = true;
        streamlineAlgorithmType = STREAMLINEALGORITHMTYPE_LOADONDEMAND;
        maxStreamlineProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
    }

    public PoincareAttributes(PoincareAttributes obj)
    {
        super(PoincareAttributes_numAdditionalAtts);

        int i;

        minPunctures = obj.minPunctures;
        maxPunctures = obj.maxPunctures;
        sourceType = obj.sourceType;
        pointSource = new double[3];
        pointSource[0] = obj.pointSource[0];
        pointSource[1] = obj.pointSource[1];
        pointSource[2] = obj.pointSource[2];

        lineStart = new double[3];
        lineStart[0] = obj.lineStart[0];
        lineStart[1] = obj.lineStart[1];
        lineStart[2] = obj.lineStart[2];

        lineEnd = new double[3];
        lineEnd[0] = obj.lineEnd[0];
        lineEnd[1] = obj.lineEnd[1];
        lineEnd[2] = obj.lineEnd[2];

        pointDensity = obj.pointDensity;
        integrationType = obj.integrationType;
        maxStepLength = obj.maxStepLength;
        relTol = obj.relTol;
        absTol = obj.absTol;
        maxToroidalWinding = obj.maxToroidalWinding;
        overrideToroidalWinding = obj.overrideToroidalWinding;
        hitRate = obj.hitRate;
        adjustPlane = obj.adjustPlane;
        overlaps = obj.overlaps;
        meshType = obj.meshType;
        numberPlanes = obj.numberPlanes;
        singlePlane = obj.singlePlane;
        min = obj.min;
        max = obj.max;
        minFlag = obj.minFlag;
        maxFlag = obj.maxFlag;
        colorType = obj.colorType;
        singleColor = new ColorAttribute(obj.singleColor);
        colorTableName = new String(obj.colorTableName);
        dataValue = obj.dataValue;
        showOPoints = obj.showOPoints;
        OPointMaxInterations = obj.OPointMaxInterations;
        showXPoints = obj.showXPoints;
        XPointMaxInterations = obj.XPointMaxInterations;
        showChaotic = obj.showChaotic;
        showIslands = obj.showIslands;
        verboseFlag = obj.verboseFlag;
        showRidgelines = obj.showRidgelines;
        showLines = obj.showLines;
        showPoints = obj.showPoints;
        legendFlag = obj.legendFlag;
        lightingFlag = obj.lightingFlag;
        streamlineAlgorithmType = obj.streamlineAlgorithmType;
        maxStreamlineProcessCount = obj.maxStreamlineProcessCount;
        maxDomainCacheSize = obj.maxDomainCacheSize;
        workGroupSize = obj.workGroupSize;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return PoincareAttributes_numAdditionalAtts;
    }

    public boolean equals(PoincareAttributes obj)
    {
        int i;

        // Compare the pointSource arrays.
        boolean pointSource_equal = true;
        for(i = 0; i < 3 && pointSource_equal; ++i)
            pointSource_equal = (pointSource[i] == obj.pointSource[i]);

        // Compare the lineStart arrays.
        boolean lineStart_equal = true;
        for(i = 0; i < 3 && lineStart_equal; ++i)
            lineStart_equal = (lineStart[i] == obj.lineStart[i]);

        // Compare the lineEnd arrays.
        boolean lineEnd_equal = true;
        for(i = 0; i < 3 && lineEnd_equal; ++i)
            lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

        // Create the return value
        return ((minPunctures == obj.minPunctures) &&
                (maxPunctures == obj.maxPunctures) &&
                (sourceType == obj.sourceType) &&
                pointSource_equal &&
                lineStart_equal &&
                lineEnd_equal &&
                (pointDensity == obj.pointDensity) &&
                (integrationType == obj.integrationType) &&
                (maxStepLength == obj.maxStepLength) &&
                (relTol == obj.relTol) &&
                (absTol == obj.absTol) &&
                (maxToroidalWinding == obj.maxToroidalWinding) &&
                (overrideToroidalWinding == obj.overrideToroidalWinding) &&
                (hitRate == obj.hitRate) &&
                (adjustPlane == obj.adjustPlane) &&
                (overlaps == obj.overlaps) &&
                (meshType == obj.meshType) &&
                (numberPlanes == obj.numberPlanes) &&
                (singlePlane == obj.singlePlane) &&
                (min == obj.min) &&
                (max == obj.max) &&
                (minFlag == obj.minFlag) &&
                (maxFlag == obj.maxFlag) &&
                (colorType == obj.colorType) &&
                (singleColor == obj.singleColor) &&
                (colorTableName.equals(obj.colorTableName)) &&
                (dataValue == obj.dataValue) &&
                (showOPoints == obj.showOPoints) &&
                (OPointMaxInterations == obj.OPointMaxInterations) &&
                (showXPoints == obj.showXPoints) &&
                (XPointMaxInterations == obj.XPointMaxInterations) &&
                (showChaotic == obj.showChaotic) &&
                (showIslands == obj.showIslands) &&
                (verboseFlag == obj.verboseFlag) &&
                (showRidgelines == obj.showRidgelines) &&
                (showLines == obj.showLines) &&
                (showPoints == obj.showPoints) &&
                (legendFlag == obj.legendFlag) &&
                (lightingFlag == obj.lightingFlag) &&
                (streamlineAlgorithmType == obj.streamlineAlgorithmType) &&
                (maxStreamlineProcessCount == obj.maxStreamlineProcessCount) &&
                (maxDomainCacheSize == obj.maxDomainCacheSize) &&
                (workGroupSize == obj.workGroupSize));
    }

    public String GetName() { return "Poincare"; }
    public String GetVersion() { return "2.0"; }

    // Property setting methods
    public void SetMinPunctures(int minPunctures_)
    {
        minPunctures = minPunctures_;
        Select(0);
    }

    public void SetMaxPunctures(int maxPunctures_)
    {
        maxPunctures = maxPunctures_;
        Select(1);
    }

    public void SetSourceType(int sourceType_)
    {
        sourceType = sourceType_;
        Select(2);
    }

    public void SetPointSource(double[] pointSource_)
    {
        pointSource[0] = pointSource_[0];
        pointSource[1] = pointSource_[1];
        pointSource[2] = pointSource_[2];
        Select(3);
    }

    public void SetPointSource(double e0, double e1, double e2)
    {
        pointSource[0] = e0;
        pointSource[1] = e1;
        pointSource[2] = e2;
        Select(3);
    }

    public void SetLineStart(double[] lineStart_)
    {
        lineStart[0] = lineStart_[0];
        lineStart[1] = lineStart_[1];
        lineStart[2] = lineStart_[2];
        Select(4);
    }

    public void SetLineStart(double e0, double e1, double e2)
    {
        lineStart[0] = e0;
        lineStart[1] = e1;
        lineStart[2] = e2;
        Select(4);
    }

    public void SetLineEnd(double[] lineEnd_)
    {
        lineEnd[0] = lineEnd_[0];
        lineEnd[1] = lineEnd_[1];
        lineEnd[2] = lineEnd_[2];
        Select(5);
    }

    public void SetLineEnd(double e0, double e1, double e2)
    {
        lineEnd[0] = e0;
        lineEnd[1] = e1;
        lineEnd[2] = e2;
        Select(5);
    }

    public void SetPointDensity(int pointDensity_)
    {
        pointDensity = pointDensity_;
        Select(6);
    }

    public void SetIntegrationType(int integrationType_)
    {
        integrationType = integrationType_;
        Select(7);
    }

    public void SetMaxStepLength(double maxStepLength_)
    {
        maxStepLength = maxStepLength_;
        Select(8);
    }

    public void SetRelTol(double relTol_)
    {
        relTol = relTol_;
        Select(9);
    }

    public void SetAbsTol(double absTol_)
    {
        absTol = absTol_;
        Select(10);
    }

    public void SetMaxToroidalWinding(int maxToroidalWinding_)
    {
        maxToroidalWinding = maxToroidalWinding_;
        Select(11);
    }

    public void SetOverrideToroidalWinding(int overrideToroidalWinding_)
    {
        overrideToroidalWinding = overrideToroidalWinding_;
        Select(12);
    }

    public void SetHitRate(double hitRate_)
    {
        hitRate = hitRate_;
        Select(13);
    }

    public void SetAdjustPlane(int adjustPlane_)
    {
        adjustPlane = adjustPlane_;
        Select(14);
    }

    public void SetOverlaps(int overlaps_)
    {
        overlaps = overlaps_;
        Select(15);
    }

    public void SetMeshType(int meshType_)
    {
        meshType = meshType_;
        Select(16);
    }

    public void SetNumberPlanes(int numberPlanes_)
    {
        numberPlanes = numberPlanes_;
        Select(17);
    }

    public void SetSinglePlane(double singlePlane_)
    {
        singlePlane = singlePlane_;
        Select(18);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(19);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(20);
    }

    public void SetMinFlag(boolean minFlag_)
    {
        minFlag = minFlag_;
        Select(21);
    }

    public void SetMaxFlag(boolean maxFlag_)
    {
        maxFlag = maxFlag_;
        Select(22);
    }

    public void SetColorType(int colorType_)
    {
        colorType = colorType_;
        Select(23);
    }

    public void SetSingleColor(ColorAttribute singleColor_)
    {
        singleColor = singleColor_;
        Select(24);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(25);
    }

    public void SetDataValue(int dataValue_)
    {
        dataValue = dataValue_;
        Select(26);
    }

    public void SetShowOPoints(boolean showOPoints_)
    {
        showOPoints = showOPoints_;
        Select(27);
    }

    public void SetOPointMaxInterations(int OPointMaxInterations_)
    {
        OPointMaxInterations = OPointMaxInterations_;
        Select(28);
    }

    public void SetShowXPoints(boolean showXPoints_)
    {
        showXPoints = showXPoints_;
        Select(29);
    }

    public void SetXPointMaxInterations(int XPointMaxInterations_)
    {
        XPointMaxInterations = XPointMaxInterations_;
        Select(30);
    }

    public void SetShowChaotic(boolean showChaotic_)
    {
        showChaotic = showChaotic_;
        Select(31);
    }

    public void SetShowIslands(boolean showIslands_)
    {
        showIslands = showIslands_;
        Select(32);
    }

    public void SetVerboseFlag(boolean verboseFlag_)
    {
        verboseFlag = verboseFlag_;
        Select(33);
    }

    public void SetShowRidgelines(boolean showRidgelines_)
    {
        showRidgelines = showRidgelines_;
        Select(34);
    }

    public void SetShowLines(boolean showLines_)
    {
        showLines = showLines_;
        Select(35);
    }

    public void SetShowPoints(boolean showPoints_)
    {
        showPoints = showPoints_;
        Select(36);
    }

    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(37);
    }

    public void SetLightingFlag(boolean lightingFlag_)
    {
        lightingFlag = lightingFlag_;
        Select(38);
    }

    public void SetStreamlineAlgorithmType(int streamlineAlgorithmType_)
    {
        streamlineAlgorithmType = streamlineAlgorithmType_;
        Select(39);
    }

    public void SetMaxStreamlineProcessCount(int maxStreamlineProcessCount_)
    {
        maxStreamlineProcessCount = maxStreamlineProcessCount_;
        Select(40);
    }

    public void SetMaxDomainCacheSize(int maxDomainCacheSize_)
    {
        maxDomainCacheSize = maxDomainCacheSize_;
        Select(41);
    }

    public void SetWorkGroupSize(int workGroupSize_)
    {
        workGroupSize = workGroupSize_;
        Select(42);
    }

    // Property getting methods
    public int            GetMinPunctures() { return minPunctures; }
    public int            GetMaxPunctures() { return maxPunctures; }
    public int            GetSourceType() { return sourceType; }
    public double[]       GetPointSource() { return pointSource; }
    public double[]       GetLineStart() { return lineStart; }
    public double[]       GetLineEnd() { return lineEnd; }
    public int            GetPointDensity() { return pointDensity; }
    public int            GetIntegrationType() { return integrationType; }
    public double         GetMaxStepLength() { return maxStepLength; }
    public double         GetRelTol() { return relTol; }
    public double         GetAbsTol() { return absTol; }
    public int            GetMaxToroidalWinding() { return maxToroidalWinding; }
    public int            GetOverrideToroidalWinding() { return overrideToroidalWinding; }
    public double         GetHitRate() { return hitRate; }
    public int            GetAdjustPlane() { return adjustPlane; }
    public int            GetOverlaps() { return overlaps; }
    public int            GetMeshType() { return meshType; }
    public int            GetNumberPlanes() { return numberPlanes; }
    public double         GetSinglePlane() { return singlePlane; }
    public double         GetMin() { return min; }
    public double         GetMax() { return max; }
    public boolean        GetMinFlag() { return minFlag; }
    public boolean        GetMaxFlag() { return maxFlag; }
    public int            GetColorType() { return colorType; }
    public ColorAttribute GetSingleColor() { return singleColor; }
    public String         GetColorTableName() { return colorTableName; }
    public int            GetDataValue() { return dataValue; }
    public boolean        GetShowOPoints() { return showOPoints; }
    public int            GetOPointMaxInterations() { return OPointMaxInterations; }
    public boolean        GetShowXPoints() { return showXPoints; }
    public int            GetXPointMaxInterations() { return XPointMaxInterations; }
    public boolean        GetShowChaotic() { return showChaotic; }
    public boolean        GetShowIslands() { return showIslands; }
    public boolean        GetVerboseFlag() { return verboseFlag; }
    public boolean        GetShowRidgelines() { return showRidgelines; }
    public boolean        GetShowLines() { return showLines; }
    public boolean        GetShowPoints() { return showPoints; }
    public boolean        GetLegendFlag() { return legendFlag; }
    public boolean        GetLightingFlag() { return lightingFlag; }
    public int            GetStreamlineAlgorithmType() { return streamlineAlgorithmType; }
    public int            GetMaxStreamlineProcessCount() { return maxStreamlineProcessCount; }
    public int            GetMaxDomainCacheSize() { return maxDomainCacheSize; }
    public int            GetWorkGroupSize() { return workGroupSize; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(minPunctures);
        if(WriteSelect(1, buf))
            buf.WriteInt(maxPunctures);
        if(WriteSelect(2, buf))
            buf.WriteInt(sourceType);
        if(WriteSelect(3, buf))
            buf.WriteDoubleArray(pointSource);
        if(WriteSelect(4, buf))
            buf.WriteDoubleArray(lineStart);
        if(WriteSelect(5, buf))
            buf.WriteDoubleArray(lineEnd);
        if(WriteSelect(6, buf))
            buf.WriteInt(pointDensity);
        if(WriteSelect(7, buf))
            buf.WriteInt(integrationType);
        if(WriteSelect(8, buf))
            buf.WriteDouble(maxStepLength);
        if(WriteSelect(9, buf))
            buf.WriteDouble(relTol);
        if(WriteSelect(10, buf))
            buf.WriteDouble(absTol);
        if(WriteSelect(11, buf))
            buf.WriteInt(maxToroidalWinding);
        if(WriteSelect(12, buf))
            buf.WriteInt(overrideToroidalWinding);
        if(WriteSelect(13, buf))
            buf.WriteDouble(hitRate);
        if(WriteSelect(14, buf))
            buf.WriteInt(adjustPlane);
        if(WriteSelect(15, buf))
            buf.WriteInt(overlaps);
        if(WriteSelect(16, buf))
            buf.WriteInt(meshType);
        if(WriteSelect(17, buf))
            buf.WriteInt(numberPlanes);
        if(WriteSelect(18, buf))
            buf.WriteDouble(singlePlane);
        if(WriteSelect(19, buf))
            buf.WriteDouble(min);
        if(WriteSelect(20, buf))
            buf.WriteDouble(max);
        if(WriteSelect(21, buf))
            buf.WriteBool(minFlag);
        if(WriteSelect(22, buf))
            buf.WriteBool(maxFlag);
        if(WriteSelect(23, buf))
            buf.WriteInt(colorType);
        if(WriteSelect(24, buf))
            singleColor.Write(buf);
        if(WriteSelect(25, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(26, buf))
            buf.WriteInt(dataValue);
        if(WriteSelect(27, buf))
            buf.WriteBool(showOPoints);
        if(WriteSelect(28, buf))
            buf.WriteInt(OPointMaxInterations);
        if(WriteSelect(29, buf))
            buf.WriteBool(showXPoints);
        if(WriteSelect(30, buf))
            buf.WriteInt(XPointMaxInterations);
        if(WriteSelect(31, buf))
            buf.WriteBool(showChaotic);
        if(WriteSelect(32, buf))
            buf.WriteBool(showIslands);
        if(WriteSelect(33, buf))
            buf.WriteBool(verboseFlag);
        if(WriteSelect(34, buf))
            buf.WriteBool(showRidgelines);
        if(WriteSelect(35, buf))
            buf.WriteBool(showLines);
        if(WriteSelect(36, buf))
            buf.WriteBool(showPoints);
        if(WriteSelect(37, buf))
            buf.WriteBool(legendFlag);
        if(WriteSelect(38, buf))
            buf.WriteBool(lightingFlag);
        if(WriteSelect(39, buf))
            buf.WriteInt(streamlineAlgorithmType);
        if(WriteSelect(40, buf))
            buf.WriteInt(maxStreamlineProcessCount);
        if(WriteSelect(41, buf))
            buf.WriteInt(maxDomainCacheSize);
        if(WriteSelect(42, buf))
            buf.WriteInt(workGroupSize);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetMinPunctures(buf.ReadInt());
            break;
        case 1:
            SetMaxPunctures(buf.ReadInt());
            break;
        case 2:
            SetSourceType(buf.ReadInt());
            break;
        case 3:
            SetPointSource(buf.ReadDoubleArray());
            break;
        case 4:
            SetLineStart(buf.ReadDoubleArray());
            break;
        case 5:
            SetLineEnd(buf.ReadDoubleArray());
            break;
        case 6:
            SetPointDensity(buf.ReadInt());
            break;
        case 7:
            SetIntegrationType(buf.ReadInt());
            break;
        case 8:
            SetMaxStepLength(buf.ReadDouble());
            break;
        case 9:
            SetRelTol(buf.ReadDouble());
            break;
        case 10:
            SetAbsTol(buf.ReadDouble());
            break;
        case 11:
            SetMaxToroidalWinding(buf.ReadInt());
            break;
        case 12:
            SetOverrideToroidalWinding(buf.ReadInt());
            break;
        case 13:
            SetHitRate(buf.ReadDouble());
            break;
        case 14:
            SetAdjustPlane(buf.ReadInt());
            break;
        case 15:
            SetOverlaps(buf.ReadInt());
            break;
        case 16:
            SetMeshType(buf.ReadInt());
            break;
        case 17:
            SetNumberPlanes(buf.ReadInt());
            break;
        case 18:
            SetSinglePlane(buf.ReadDouble());
            break;
        case 19:
            SetMin(buf.ReadDouble());
            break;
        case 20:
            SetMax(buf.ReadDouble());
            break;
        case 21:
            SetMinFlag(buf.ReadBool());
            break;
        case 22:
            SetMaxFlag(buf.ReadBool());
            break;
        case 23:
            SetColorType(buf.ReadInt());
            break;
        case 24:
            singleColor.Read(buf);
            Select(24);
            break;
        case 25:
            SetColorTableName(buf.ReadString());
            break;
        case 26:
            SetDataValue(buf.ReadInt());
            break;
        case 27:
            SetShowOPoints(buf.ReadBool());
            break;
        case 28:
            SetOPointMaxInterations(buf.ReadInt());
            break;
        case 29:
            SetShowXPoints(buf.ReadBool());
            break;
        case 30:
            SetXPointMaxInterations(buf.ReadInt());
            break;
        case 31:
            SetShowChaotic(buf.ReadBool());
            break;
        case 32:
            SetShowIslands(buf.ReadBool());
            break;
        case 33:
            SetVerboseFlag(buf.ReadBool());
            break;
        case 34:
            SetShowRidgelines(buf.ReadBool());
            break;
        case 35:
            SetShowLines(buf.ReadBool());
            break;
        case 36:
            SetShowPoints(buf.ReadBool());
            break;
        case 37:
            SetLegendFlag(buf.ReadBool());
            break;
        case 38:
            SetLightingFlag(buf.ReadBool());
            break;
        case 39:
            SetStreamlineAlgorithmType(buf.ReadInt());
            break;
        case 40:
            SetMaxStreamlineProcessCount(buf.ReadInt());
            break;
        case 41:
            SetMaxDomainCacheSize(buf.ReadInt());
            break;
        case 42:
            SetWorkGroupSize(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("minPunctures", minPunctures, indent) + "\n";
        str = str + intToString("maxPunctures", maxPunctures, indent) + "\n";
        str = str + indent + "sourceType = ";
        if(sourceType == SOURCETYPE_SPECIFIEDPOINT)
            str = str + "SOURCETYPE_SPECIFIEDPOINT";
        if(sourceType == SOURCETYPE_SPECIFIEDLINE)
            str = str + "SOURCETYPE_SPECIFIEDLINE";
        str = str + "\n";
        str = str + doubleArrayToString("pointSource", pointSource, indent) + "\n";
        str = str + doubleArrayToString("lineStart", lineStart, indent) + "\n";
        str = str + doubleArrayToString("lineEnd", lineEnd, indent) + "\n";
        str = str + intToString("pointDensity", pointDensity, indent) + "\n";
        str = str + indent + "integrationType = ";
        if(integrationType == INTEGRATIONTYPE_DORMANDPRINCE)
            str = str + "INTEGRATIONTYPE_DORMANDPRINCE";
        if(integrationType == INTEGRATIONTYPE_ADAMSBASHFORTH)
            str = str + "INTEGRATIONTYPE_ADAMSBASHFORTH";
        if(integrationType == INTEGRATIONTYPE_M3DC1INTEGRATOR)
            str = str + "INTEGRATIONTYPE_M3DC1INTEGRATOR";
        str = str + "\n";
        str = str + doubleToString("maxStepLength", maxStepLength, indent) + "\n";
        str = str + doubleToString("relTol", relTol, indent) + "\n";
        str = str + doubleToString("absTol", absTol, indent) + "\n";
        str = str + intToString("maxToroidalWinding", maxToroidalWinding, indent) + "\n";
        str = str + intToString("overrideToroidalWinding", overrideToroidalWinding, indent) + "\n";
        str = str + doubleToString("hitRate", hitRate, indent) + "\n";
        str = str + intToString("adjustPlane", adjustPlane, indent) + "\n";
        str = str + indent + "overlaps = ";
        if(overlaps == OVERLAPTYPE_RAW)
            str = str + "OVERLAPTYPE_RAW";
        if(overlaps == OVERLAPTYPE_REMOVE)
            str = str + "OVERLAPTYPE_REMOVE";
        if(overlaps == OVERLAPTYPE_MERGE)
            str = str + "OVERLAPTYPE_MERGE";
        if(overlaps == OVERLAPTYPE_SMOOTH)
            str = str + "OVERLAPTYPE_SMOOTH";
        str = str + "\n";
        str = str + indent + "meshType = ";
        if(meshType == SHOWMESHTYPE_CURVES)
            str = str + "SHOWMESHTYPE_CURVES";
        if(meshType == SHOWMESHTYPE_SURFACES)
            str = str + "SHOWMESHTYPE_SURFACES";
        str = str + "\n";
        str = str + intToString("numberPlanes", numberPlanes, indent) + "\n";
        str = str + doubleToString("singlePlane", singlePlane, indent) + "\n";
        str = str + doubleToString("min", min, indent) + "\n";
        str = str + doubleToString("max", max, indent) + "\n";
        str = str + boolToString("minFlag", minFlag, indent) + "\n";
        str = str + boolToString("maxFlag", maxFlag, indent) + "\n";
        str = str + indent + "colorType = ";
        if(colorType == COLORINGMETHOD_COLORBYSINGLECOLOR)
            str = str + "COLORINGMETHOD_COLORBYSINGLECOLOR";
        if(colorType == COLORINGMETHOD_COLORBYCOLORTABLE)
            str = str + "COLORINGMETHOD_COLORBYCOLORTABLE";
        str = str + "\n";
        str = str + indent + "singleColor = {" + singleColor.Red() + ", " + singleColor.Green() + ", " + singleColor.Blue() + ", " + singleColor.Alpha() + "}\n";
        str = str + stringToString("colorTableName", colorTableName, indent) + "\n";
        str = str + indent + "dataValue = ";
        if(dataValue == DATAVALUE_ORIGINALVALUE)
            str = str + "DATAVALUE_ORIGINALVALUE";
        if(dataValue == DATAVALUE_INPUTORDER)
            str = str + "DATAVALUE_INPUTORDER";
        if(dataValue == DATAVALUE_POINTINDEX)
            str = str + "DATAVALUE_POINTINDEX";
        if(dataValue == DATAVALUE_PLANE)
            str = str + "DATAVALUE_PLANE";
        if(dataValue == DATAVALUE_WINDINGORDER)
            str = str + "DATAVALUE_WINDINGORDER";
        if(dataValue == DATAVALUE_WINDINGPOINTORDER)
            str = str + "DATAVALUE_WINDINGPOINTORDER";
        if(dataValue == DATAVALUE_WINDINGPOINTORDERMODULO)
            str = str + "DATAVALUE_WINDINGPOINTORDERMODULO";
        if(dataValue == DATAVALUE_TOROIDALWINDINGS)
            str = str + "DATAVALUE_TOROIDALWINDINGS";
        if(dataValue == DATAVALUE_POLOIDALWINDINGS)
            str = str + "DATAVALUE_POLOIDALWINDINGS";
        if(dataValue == DATAVALUE_SAFETYFACTOR)
            str = str + "DATAVALUE_SAFETYFACTOR";
        if(dataValue == DATAVALUE_CONFIDENCE)
            str = str + "DATAVALUE_CONFIDENCE";
        if(dataValue == DATAVALUE_RIDGELINEVARIANCE)
            str = str + "DATAVALUE_RIDGELINEVARIANCE";
        str = str + "\n";
        str = str + boolToString("showOPoints", showOPoints, indent) + "\n";
        str = str + intToString("OPointMaxInterations", OPointMaxInterations, indent) + "\n";
        str = str + boolToString("showXPoints", showXPoints, indent) + "\n";
        str = str + intToString("XPointMaxInterations", XPointMaxInterations, indent) + "\n";
        str = str + boolToString("showChaotic", showChaotic, indent) + "\n";
        str = str + boolToString("showIslands", showIslands, indent) + "\n";
        str = str + boolToString("verboseFlag", verboseFlag, indent) + "\n";
        str = str + boolToString("showRidgelines", showRidgelines, indent) + "\n";
        str = str + boolToString("showLines", showLines, indent) + "\n";
        str = str + boolToString("showPoints", showPoints, indent) + "\n";
        str = str + boolToString("legendFlag", legendFlag, indent) + "\n";
        str = str + boolToString("lightingFlag", lightingFlag, indent) + "\n";
        str = str + indent + "streamlineAlgorithmType = ";
        if(streamlineAlgorithmType == STREAMLINEALGORITHMTYPE_LOADONDEMAND)
            str = str + "STREAMLINEALGORITHMTYPE_LOADONDEMAND";
        if(streamlineAlgorithmType == STREAMLINEALGORITHMTYPE_PARALLELSTATICDOMAINS)
            str = str + "STREAMLINEALGORITHMTYPE_PARALLELSTATICDOMAINS";
        if(streamlineAlgorithmType == STREAMLINEALGORITHMTYPE_MASTERSLAVE)
            str = str + "STREAMLINEALGORITHMTYPE_MASTERSLAVE";
        str = str + "\n";
        str = str + intToString("maxStreamlineProcessCount", maxStreamlineProcessCount, indent) + "\n";
        str = str + intToString("maxDomainCacheSize", maxDomainCacheSize, indent) + "\n";
        str = str + intToString("workGroupSize", workGroupSize, indent) + "\n";
        return str;
    }


    // Attributes
    private int            minPunctures;
    private int            maxPunctures;
    private int            sourceType;
    private double[]       pointSource;
    private double[]       lineStart;
    private double[]       lineEnd;
    private int            pointDensity;
    private int            integrationType;
    private double         maxStepLength;
    private double         relTol;
    private double         absTol;
    private int            maxToroidalWinding;
    private int            overrideToroidalWinding;
    private double         hitRate;
    private int            adjustPlane;
    private int            overlaps;
    private int            meshType;
    private int            numberPlanes;
    private double         singlePlane;
    private double         min;
    private double         max;
    private boolean        minFlag;
    private boolean        maxFlag;
    private int            colorType;
    private ColorAttribute singleColor;
    private String         colorTableName;
    private int            dataValue;
    private boolean        showOPoints;
    private int            OPointMaxInterations;
    private boolean        showXPoints;
    private int            XPointMaxInterations;
    private boolean        showChaotic;
    private boolean        showIslands;
    private boolean        verboseFlag;
    private boolean        showRidgelines;
    private boolean        showLines;
    private boolean        showPoints;
    private boolean        legendFlag;
    private boolean        lightingFlag;
    private int            streamlineAlgorithmType;
    private int            maxStreamlineProcessCount;
    private int            maxDomainCacheSize;
    private int            workGroupSize;
}

