/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMultiCurveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPointList.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>

// ****************************************************************************
// Module: PyMultiCurveAttributes
//
// Purpose: 
//   This class contains the plot attributes for the MultiCurve plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Mar 6 08:12:10 PDT 2009
//
// ****************************************************************************

//
// This struct contains the Python type information and a MultiCurveAttributes.
//
struct MultiCurveAttributesObject
{
    PyObject_HEAD
    MultiCurveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMultiCurveAttributes(int);

std::string
PyMultiCurveAttributes_ToString(const MultiCurveAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "defaultPalette.";
        str += PyColorControlPointList_ToString(&atts->GetDefaultPalette(), objPrefix.c_str());
    }
    {   const unsignedCharVector &changedColors = atts->GetChangedColors();
        SNPRINTF(tmpStr, 1000, "%schangedColors = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < changedColors.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(changedColors[i]));
            str += tmpStr;
            if(i < changedColors.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors";
    switch (atts->GetColorType())
    {
      case MultiCurveAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case MultiCurveAttributes::ColorByMultipleColors:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syAxisTitleFormat = \"%s\"\n", prefix, atts->GetYAxisTitleFormat().c_str());
    str += tmpStr;
    if(atts->GetUseYAxisTickSpacing())
        SNPRINTF(tmpStr, 1000, "%suseYAxisTickSpacing = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseYAxisTickSpacing = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%syAxisTickSpacing = %g\n", prefix, atts->GetYAxisTickSpacing());
    str += tmpStr;
    if(atts->GetDisplayMarkers())
        SNPRINTF(tmpStr, 1000, "%sdisplayMarkers = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisplayMarkers = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smarkerVariable = \"%s\"\n", prefix, atts->GetMarkerVariable().c_str());
    str += tmpStr;
    if(atts->GetDisplayIds())
        SNPRINTF(tmpStr, 1000, "%sdisplayIds = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdisplayIds = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sidVariable = \"%s\"\n", prefix, atts->GetIdVariable().c_str());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
MultiCurveAttributes_Notify(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_SetDefaultPalette(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyColorControlPointList_Check(newValue))
    {
        fprintf(stderr, "The defaultPalette field can only be set with ColorControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetDefaultPalette(*PyColorControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetDefaultPalette(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPointList_Wrap(&obj->data->GetDefaultPalette());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetChangedColors(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    unsignedCharVector  &vec = obj->data->GetChangedColors();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the changedColors in the object as modified.
    obj->data->SelectChangedColors();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetChangedColors(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the changedColors.
    const unsignedCharVector &changedColors = obj->data->GetChangedColors();
    PyObject *retval = PyTuple_New(changedColors.size());
    for(size_t i = 0; i < changedColors.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(changedColors[i])));
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetColorType(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorType(MultiCurveAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetColorType(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetYAxisTitleFormat(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the yAxisTitleFormat in the object.
    obj->data->SetYAxisTitleFormat(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetYAxisTitleFormat(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetYAxisTitleFormat().c_str());
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetUseYAxisTickSpacing(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useYAxisTickSpacing in the object.
    obj->data->SetUseYAxisTickSpacing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetUseYAxisTickSpacing(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseYAxisTickSpacing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetYAxisTickSpacing(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the yAxisTickSpacing in the object.
    obj->data->SetYAxisTickSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetYAxisTickSpacing(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetYAxisTickSpacing());
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetDisplayMarkers(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayMarkers in the object.
    obj->data->SetDisplayMarkers(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetDisplayMarkers(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayMarkers()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetMarkerVariable(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the markerVariable in the object.
    obj->data->SetMarkerVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetMarkerVariable(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMarkerVariable().c_str());
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetDisplayIds(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayIds in the object.
    obj->data->SetDisplayIds(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetDisplayIds(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDisplayIds()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetIdVariable(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the idVariable in the object.
    obj->data->SetIdVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetIdVariable(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetIdVariable().c_str());
    return retval;
}

/*static*/ PyObject *
MultiCurveAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MultiCurveAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}



static struct PyMethodDef MultiCurveAttributes_methods[] = {
    {"Notify", MultiCurveAttributes_Notify, METH_VARARGS},
    {"SetDefaultPalette", MultiCurveAttributes_SetDefaultPalette, METH_VARARGS},
    {"GetDefaultPalette", MultiCurveAttributes_GetDefaultPalette, METH_VARARGS},
    {"SetChangedColors", MultiCurveAttributes_SetChangedColors, METH_VARARGS},
    {"GetChangedColors", MultiCurveAttributes_GetChangedColors, METH_VARARGS},
    {"SetColorType", MultiCurveAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", MultiCurveAttributes_GetColorType, METH_VARARGS},
    {"SetSingleColor", MultiCurveAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", MultiCurveAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", MultiCurveAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", MultiCurveAttributes_GetMultiColor, METH_VARARGS},
    {"SetLineStyle", MultiCurveAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", MultiCurveAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", MultiCurveAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", MultiCurveAttributes_GetLineWidth, METH_VARARGS},
    {"SetYAxisTitleFormat", MultiCurveAttributes_SetYAxisTitleFormat, METH_VARARGS},
    {"GetYAxisTitleFormat", MultiCurveAttributes_GetYAxisTitleFormat, METH_VARARGS},
    {"SetUseYAxisTickSpacing", MultiCurveAttributes_SetUseYAxisTickSpacing, METH_VARARGS},
    {"GetUseYAxisTickSpacing", MultiCurveAttributes_GetUseYAxisTickSpacing, METH_VARARGS},
    {"SetYAxisTickSpacing", MultiCurveAttributes_SetYAxisTickSpacing, METH_VARARGS},
    {"GetYAxisTickSpacing", MultiCurveAttributes_GetYAxisTickSpacing, METH_VARARGS},
    {"SetDisplayMarkers", MultiCurveAttributes_SetDisplayMarkers, METH_VARARGS},
    {"GetDisplayMarkers", MultiCurveAttributes_GetDisplayMarkers, METH_VARARGS},
    {"SetMarkerVariable", MultiCurveAttributes_SetMarkerVariable, METH_VARARGS},
    {"GetMarkerVariable", MultiCurveAttributes_GetMarkerVariable, METH_VARARGS},
    {"SetDisplayIds", MultiCurveAttributes_SetDisplayIds, METH_VARARGS},
    {"GetDisplayIds", MultiCurveAttributes_GetDisplayIds, METH_VARARGS},
    {"SetIdVariable", MultiCurveAttributes_SetIdVariable, METH_VARARGS},
    {"GetIdVariable", MultiCurveAttributes_GetIdVariable, METH_VARARGS},
    {"SetLegendFlag", MultiCurveAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", MultiCurveAttributes_GetLegendFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MultiCurveAttributes_dealloc(PyObject *v)
{
   MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MultiCurveAttributes_compare(PyObject *v, PyObject *w)
{
    MultiCurveAttributes *a = ((MultiCurveAttributesObject *)v)->data;
    MultiCurveAttributes *b = ((MultiCurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
MultiCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "defaultPalette") == 0)
        return MultiCurveAttributes_GetDefaultPalette(self, NULL);
    if(strcmp(name, "changedColors") == 0)
        return MultiCurveAttributes_GetChangedColors(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return MultiCurveAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(MultiCurveAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(MultiCurveAttributes::ColorByMultipleColors));

    if(strcmp(name, "singleColor") == 0)
        return MultiCurveAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return MultiCurveAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return MultiCurveAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return MultiCurveAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "yAxisTitleFormat") == 0)
        return MultiCurveAttributes_GetYAxisTitleFormat(self, NULL);
    if(strcmp(name, "useYAxisTickSpacing") == 0)
        return MultiCurveAttributes_GetUseYAxisTickSpacing(self, NULL);
    if(strcmp(name, "yAxisTickSpacing") == 0)
        return MultiCurveAttributes_GetYAxisTickSpacing(self, NULL);
    if(strcmp(name, "displayMarkers") == 0)
        return MultiCurveAttributes_GetDisplayMarkers(self, NULL);
    if(strcmp(name, "markerVariable") == 0)
        return MultiCurveAttributes_GetMarkerVariable(self, NULL);
    if(strcmp(name, "displayIds") == 0)
        return MultiCurveAttributes_GetDisplayIds(self, NULL);
    if(strcmp(name, "idVariable") == 0)
        return MultiCurveAttributes_GetIdVariable(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return MultiCurveAttributes_GetLegendFlag(self, NULL);

    return Py_FindMethod(MultiCurveAttributes_methods, self, name);
}

static int
MultiCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "defaultPalette") == 0)
        obj = MultiCurveAttributes_SetDefaultPalette(self, tuple);
    else if(strcmp(name, "changedColors") == 0)
        obj = MultiCurveAttributes_SetChangedColors(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = MultiCurveAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = MultiCurveAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = MultiCurveAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "lineStyle") == 0)
        obj = MultiCurveAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = MultiCurveAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "yAxisTitleFormat") == 0)
        obj = MultiCurveAttributes_SetYAxisTitleFormat(self, tuple);
    else if(strcmp(name, "useYAxisTickSpacing") == 0)
        obj = MultiCurveAttributes_SetUseYAxisTickSpacing(self, tuple);
    else if(strcmp(name, "yAxisTickSpacing") == 0)
        obj = MultiCurveAttributes_SetYAxisTickSpacing(self, tuple);
    else if(strcmp(name, "displayMarkers") == 0)
        obj = MultiCurveAttributes_SetDisplayMarkers(self, tuple);
    else if(strcmp(name, "markerVariable") == 0)
        obj = MultiCurveAttributes_SetMarkerVariable(self, tuple);
    else if(strcmp(name, "displayIds") == 0)
        obj = MultiCurveAttributes_SetDisplayIds(self, tuple);
    else if(strcmp(name, "idVariable") == 0)
        obj = MultiCurveAttributes_SetIdVariable(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = MultiCurveAttributes_SetLegendFlag(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
MultiCurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)v;
    fprintf(fp, "%s", PyMultiCurveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MultiCurveAttributes_str(PyObject *v)
{
    MultiCurveAttributesObject *obj = (MultiCurveAttributesObject *)v;
    return PyString_FromString(PyMultiCurveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MultiCurveAttributes_Purpose = "This class contains the plot attributes for the MultiCurve plot.";
#else
static char *MultiCurveAttributes_Purpose = "This class contains the plot attributes for the MultiCurve plot.";
#endif

//
// The type description structure
//
static PyTypeObject MultiCurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MultiCurveAttributes",                    // tp_name
    sizeof(MultiCurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MultiCurveAttributes_dealloc,  // tp_dealloc
    (printfunc)MultiCurveAttributes_print,     // tp_print
    (getattrfunc)MultiCurveAttributes_getattr, // tp_getattr
    (setattrfunc)MultiCurveAttributes_setattr, // tp_setattr
    (cmpfunc)MultiCurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MultiCurveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MultiCurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MultiCurveAttributes *defaultAtts = 0;
static MultiCurveAttributes *currentAtts = 0;

static PyObject *
NewMultiCurveAttributes(int useCurrent)
{
    MultiCurveAttributesObject *newObject;
    newObject = PyObject_NEW(MultiCurveAttributesObject, &MultiCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MultiCurveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MultiCurveAttributes(*defaultAtts);
    else
        newObject->data = new MultiCurveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMultiCurveAttributes(const MultiCurveAttributes *attr)
{
    MultiCurveAttributesObject *newObject;
    newObject = PyObject_NEW(MultiCurveAttributesObject, &MultiCurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MultiCurveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MultiCurveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMultiCurveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MultiCurveAttributesMethods[] = {
    {"MultiCurveAttributes", MultiCurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MultiCurveAttributesObserver = 0;

std::string
PyMultiCurveAttributes_GetLogString()
{
    std::string s("MultiCurveAtts = MultiCurveAttributes()\n");
    if(currentAtts != 0)
        s += PyMultiCurveAttributes_ToString(currentAtts, "MultiCurveAtts.");
    return s;
}

static void
PyMultiCurveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    MultiCurveAttributes *atts = (MultiCurveAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MultiCurveAtts = MultiCurveAttributes()\n");
        s += PyMultiCurveAttributes_ToString(currentAtts, "MultiCurveAtts.");
        cb(s);
    }
}

void
PyMultiCurveAttributes_StartUp(MultiCurveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMultiCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MultiCurveAttributesObserver == 0)
    {
        MultiCurveAttributesObserver = new ObserverToCallback(subj,
            PyMultiCurveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMultiCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MultiCurveAttributesObserver;
    MultiCurveAttributesObserver = 0;
}

PyMethodDef *
PyMultiCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MultiCurveAttributesMethods;
}

bool
PyMultiCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MultiCurveAttributesType);
}

MultiCurveAttributes *
PyMultiCurveAttributes_FromPyObject(PyObject *obj)
{
    MultiCurveAttributesObject *obj2 = (MultiCurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMultiCurveAttributes_New()
{
    return NewMultiCurveAttributes(0);
}

PyObject *
PyMultiCurveAttributes_Wrap(const MultiCurveAttributes *attr)
{
    return WrapMultiCurveAttributes(attr);
}

void
PyMultiCurveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MultiCurveAttributesObject *obj2 = (MultiCurveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMultiCurveAttributes_SetDefaults(const MultiCurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MultiCurveAttributes(*atts);
}

