/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: LabelViewerPluginInfo.C
// ************************************************************************* //

#include <LabelPluginInfo.h>
#include <QApplication>
#include <avtLabelPlot.h>

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Label plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
extern "C" PLOT_EXPORT ViewerPlotPluginInfo* Label_GetViewerInfo()
{
    LabelViewerPluginInfo::InitializeGlobalObjects();
    return new LabelViewerPluginInfo;
}

//
// Storage for static data elements.
//
LabelAttributes *LabelViewerPluginInfo::clientAtts = NULL;
LabelAttributes *LabelViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LabelViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LabelViewerPluginInfo::InitializeGlobalObjects()
{
    LabelViewerPluginInfo::clientAtts  = new LabelAttributes;
    LabelViewerPluginInfo::defaultAtts = new LabelAttributes;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LabelViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LabelViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LabelViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LabelAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LabelViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LabelAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
LabelViewerPluginInfo::AllocAvtPlot()
{
    return new avtLabelPlot;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 1 13:55:51 PST 2005
//
//  Modifications:
//    Brad Whitlock, Tue Aug 2 14:21:01 PST 2005
//    Added code to set the variableType in the plot attributes using the
//    metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
//
// ****************************************************************************

void
LabelViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)
{
    *(LabelAttributes*)atts = *defaultAtts;
    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Aug 2 14:23:05 PST 2005
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
//
// ****************************************************************************

void
LabelViewerPluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)
{
    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ResetPlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Aug 2 14:23:05 PST 2005
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
// ****************************************************************************

void
LabelViewerPluginInfo::ResetPlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)

{
    ReInitializePlotAtts(atts, plot);
}


// ****************************************************************************
// Method: LabelViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
LabelViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH | VAR_CATEGORY_SCALAR | VAR_CATEGORY_VECTOR | VAR_CATEGORY_MATERIAL | VAR_CATEGORY_SUBSET | VAR_CATEGORY_TENSOR | VAR_CATEGORY_SYMMETRIC_TENSOR | VAR_CATEGORY_LABEL | VAR_CATEGORY_ARRAY;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
LabelViewerPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Label"));
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Label.xpm>
const char **
LabelViewerPluginInfo::XPMIconData() const
{
    return Label_xpm;
}

// ****************************************************************************
// Method: LabelViewerPluginInfo::PrivateSetPlotAtts
//
// Purpose: 
//   Initializes the plot's varType attribute using the metadata.
//
// Arguments:
//   atts    : The attributes to initialize.
//   md      : The metadata object.
//   varName : The name of the plot's variable.
//
// Programmer: Brad Whitlock
// Creation:   Tue Aug 2 14:28:36 PST 2005
//
// Modifications:
//   Brad Whitlock, Tue Nov 15 09:49:41 PDT 2005
//   Added code to get the expression type if the DetermineVarType returns
//   a scalar. This allows us to get the right type for things made up of
//   scalars such as vectors.
//
//   Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//   Changed API.
//
// ****************************************************************************
#include <avtDatabaseMetaData.h>
#include <Expression.h>
#include <DebugStream.h>
#include <ViewerPlot.h>
void
LabelViewerPluginInfo::PrivateSetPlotAtts(AttributeSubject *atts, 
    ViewerPlot *plot)
{
    LabelAttributes *labelAtts = (LabelAttributes *)atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot->GetMetaData();
    if (md == NULL)
    {
        labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);
        return;
    }

    avtSubsetType st = md->DetermineSubsetType(plot->GetVariableName());
    if(st != AVT_UNKNOWN_SUBSET && st != AVT_MATERIAL_SUBSET)
    {
        labelAtts->SetVarType(LabelAttributes::LABEL_VT_SUBSET);
        debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SUBSET);" << endl;
    }
    else
    {
        avtVarType t = md->DetermineVarType(plot->GetVariableName());

        if(t == AVT_SCALAR_VAR)
        {
            // The final variable type is scalar but we should check if the
            // variable is an expression. If so then we should take the
            // expression's output type if it differs from scalar. This
            // allows us to get the right type for vector expressions, etc.
            for(int i = 0; i < md->GetNumberOfExpressions(); ++i)
            {
                const Expression *e = md->GetExpression(i);
                if(e->GetName() == plot->GetVariableName())
                {
                    if(e->GetType() == Expression::VectorMeshVar)
                        t = AVT_VECTOR_VAR;
                    else if(e->GetType() == Expression::TensorMeshVar)
                        t = AVT_TENSOR_VAR;
                    else if(e->GetType() == Expression::SymmetricTensorMeshVar)
                        t = AVT_SYMMETRIC_TENSOR_VAR;
                    else if(e->GetType() == Expression::ArrayMeshVar)
                        t = AVT_ARRAY_VAR;

                    break;
                }
            }
        }

        if(t == AVT_MESH)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_MESH);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_MESH);" << endl;
        }
        else if(t == AVT_SCALAR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_SCALAR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SCALAR_VAR);" << endl;
        }
        else if(t == AVT_VECTOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_VECTOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_VECTOR_VAR);" << endl;
        }
        else if(t == AVT_TENSOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_TENSOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_TENSOR_VAR);" << endl;
        }
        else if(t == AVT_SYMMETRIC_TENSOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_SYMMETRIC_TENSOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SYMMETRIC_TENSOR_VAR);" << endl;
        }
        else if(t == AVT_ARRAY_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_ARRAY_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_ARRAY_VAR);" << endl;
        }
        else if(t == AVT_LABEL_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_LABEL_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_LABEL_VAR);" << endl;
        }
        else if(t == AVT_MATERIAL)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_MATERIAL);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_MATERIAL);" << endl;
        }
        else if(t == AVT_UNKNOWN_TYPE)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);" << endl;
        }
    }
}

