/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: HistogramViewerPluginInfo.C
// ************************************************************************* //

#include <HistogramPluginInfo.h>
#include <QApplication>
#include <avtHistogramPlot.h>

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Histogram plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
extern "C" PLOT_EXPORT ViewerPlotPluginInfo* Histogram_GetViewerInfo()
{
    HistogramViewerPluginInfo::InitializeGlobalObjects();
    return new HistogramViewerPluginInfo;
}

//
// Storage for static data elements.
//
HistogramAttributes *HistogramViewerPluginInfo::clientAtts = NULL;
HistogramAttributes *HistogramViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  HistogramViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
HistogramViewerPluginInfo::InitializeGlobalObjects()
{
    HistogramViewerPluginInfo::clientAtts  = new HistogramAttributes;
    HistogramViewerPluginInfo::defaultAtts = new HistogramAttributes;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
HistogramViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
HistogramViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
HistogramViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(HistogramAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
HistogramViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(HistogramAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
HistogramViewerPluginInfo::AllocAvtPlot()
{
    return new avtHistogramPlot;
}

bool
HistogramViewerPluginInfo::ProvidesLegend() const
{
    return false;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed May 24 09:22:33 PDT 2006
//
//  Modifications:
//    Hank Childs, Wed May 24 08:45:06 PDT 2006
//    Populated with custom code.
//
//    Brad Whitlock, Wed Feb 21 14:26:13 PST 2007
//    Changed API.
//
// ****************************************************************************
#include <ViewerPlot.h>
#include <avtDatabaseMetaData.h>

void
HistogramViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)
{
    *(HistogramAttributes*)atts = *defaultAtts;
    HistogramAttributes *hatts = (HistogramAttributes *) atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot->GetMetaData();
    if (md == NULL)
    {
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
        return;
    }

    avtVarType t = md->DetermineVarType(plot->GetVariableName());
    if (t == AVT_SCALAR_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
    else if (t == AVT_ARRAY_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyVarsForSingleZone);
    else
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Hank Childs
//  Creation:   May 24, 2006
//
//  Modifications:
//    Brad Whitlock, Wed Feb 21 14:25:26 PST 2007
//    Changed API.
//
// ****************************************************************************

void
HistogramViewerPluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)
{
    HistogramAttributes *hatts = (HistogramAttributes *) atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot->GetMetaData();
    if (md == NULL)
    {
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
        return;
    }

    avtVarType t = md->DetermineVarType(plot->GetVariableName());
    if (t == AVT_SCALAR_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
    else if (t == AVT_ARRAY_VAR)
        hatts->SetBasedOn(HistogramAttributes::ManyVarsForSingleZone);
    else
        hatts->SetBasedOn(HistogramAttributes::ManyZonesForSingleVar);
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::ResetPlotAtts
//
//  Purpose:
//    Reset the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Hank Childs
//  Creation:   May 24, 2006
//
//  Modifications:
//    Brad Whitlock, Wed Feb 21 14:26:31 PST 2007
//    Changed API.
//
// ****************************************************************************
void
HistogramViewerPluginInfo::ResetPlotAtts(AttributeSubject *atts,
    ViewerPlot *plot)
{
    ReInitializePlotAtts(atts, plot);
}


// ****************************************************************************
// Method: HistogramViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
HistogramViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_ARRAY;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
HistogramViewerPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Histogram"));
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Histogram.xpm>
const char **
HistogramViewerPluginInfo::XPMIconData() const
{
    return Histogram_xpm;
}

