/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyFilledBoundaryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyFilledBoundaryAttributes
//
// Purpose: 
//   This class contains the plot attributes for the filled boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Aug 6 15:40:16 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a FilledBoundaryAttributes.
//
struct FilledBoundaryAttributesObject
{
    PyObject_HEAD
    FilledBoundaryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFilledBoundaryAttributes(int);

std::string
PyFilledBoundaryAttributes_ToString(const FilledBoundaryAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case FilledBoundaryAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::ColorByMultipleColors:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetFilledFlag())
        SNPRINTF(tmpStr, 1000, "%sfilledFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfilledFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        SNPRINTF(tmpStr, 1000, "%sboundaryNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < boundaryNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *boundaryType_names = "Domain, Group, Material, Unknown";
    switch (atts->GetBoundaryType())
    {
      case FilledBoundaryAttributes::Domain:
          SNPRINTF(tmpStr, 1000, "%sboundaryType = %sDomain  # %s\n", prefix, prefix, boundaryType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Group:
          SNPRINTF(tmpStr, 1000, "%sboundaryType = %sGroup  # %s\n", prefix, prefix, boundaryType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Material:
          SNPRINTF(tmpStr, 1000, "%sboundaryType = %sMaterial  # %s\n", prefix, prefix, boundaryType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Unknown:
          SNPRINTF(tmpStr, 1000, "%sboundaryType = %sUnknown  # %s\n", prefix, prefix, boundaryType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "%swireframe = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%swireframe = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDrawInternal())
        SNPRINTF(tmpStr, 1000, "%sdrawInternal = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdrawInternal = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetCleanZonesOnly())
        SNPRINTF(tmpStr, 1000, "%scleanZonesOnly = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scleanZonesOnly = 0\n", prefix);
    str += tmpStr;
    const unsigned char *mixedColor = atts->GetMixedColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%smixedColor = (%d, %d, %d, %d)\n", prefix, int(mixedColor[0]), int(mixedColor[1]), int(mixedColor[2]), int(mixedColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point, Sphere";
    switch (atts->GetPointType())
    {
      case FilledBoundaryAttributes::Box:
          SNPRINTF(tmpStr, 1000, "%spointType = %sBox  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Axis:
          SNPRINTF(tmpStr, 1000, "%spointType = %sAxis  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Icosahedron:
          SNPRINTF(tmpStr, 1000, "%spointType = %sIcosahedron  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%spointType = %sPoint  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      case FilledBoundaryAttributes::Sphere:
          SNPRINTF(tmpStr, 1000, "%spointType = %sSphere  # %s\n", prefix, prefix, pointType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%spointSizeVarEnabled = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizeVar = \"%s\"\n", prefix, atts->GetPointSizeVar().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSizePixels = %d\n", prefix, atts->GetPointSizePixels());
    str += tmpStr;
    return str;
}

static PyObject *
FilledBoundaryAttributes_Notify(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(FilledBoundaryAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetFilledFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the filledFlag in the object.
    obj->data->SetFilledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetFilledFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFilledFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(size_t i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetBoundaryType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundaryType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetBoundaryType(FilledBoundaryAttributes::Boundary_Type(ival));
    else
    {
        fprintf(stderr, "An invalid boundaryType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Domain, Group, Material, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetBoundaryType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundaryType()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawInternal in the object.
    obj->data->SetDrawInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawInternal()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanZonesOnly in the object.
    obj->data->SetCleanZonesOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCleanZonesOnly()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the mixedColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetMixedColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the mixedColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *mixedColor = obj->data->GetMixedColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(mixedColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(mixedColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(mixedColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(mixedColor[3])));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetPointType(FilledBoundaryAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point, Sphere"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

/*static*/ PyObject *
FilledBoundaryAttributes_SetPointSizePixels(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizePixels in the object.
    obj->data->SetPointSizePixels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FilledBoundaryAttributes_GetPointSizePixels(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointSizePixels()));
    return retval;
}



static struct PyMethodDef FilledBoundaryAttributes_methods[] = {
    {"Notify", FilledBoundaryAttributes_Notify, METH_VARARGS},
    {"SetColorType", FilledBoundaryAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", FilledBoundaryAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", FilledBoundaryAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", FilledBoundaryAttributes_GetColorTableName, METH_VARARGS},
    {"SetFilledFlag", FilledBoundaryAttributes_SetFilledFlag, METH_VARARGS},
    {"GetFilledFlag", FilledBoundaryAttributes_GetFilledFlag, METH_VARARGS},
    {"SetLegendFlag", FilledBoundaryAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", FilledBoundaryAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", FilledBoundaryAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", FilledBoundaryAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", FilledBoundaryAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", FilledBoundaryAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", FilledBoundaryAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", FilledBoundaryAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", FilledBoundaryAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", FilledBoundaryAttributes_GetMultiColor, METH_VARARGS},
    {"SetBoundaryNames", FilledBoundaryAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", FilledBoundaryAttributes_GetBoundaryNames, METH_VARARGS},
    {"SetBoundaryType", FilledBoundaryAttributes_SetBoundaryType, METH_VARARGS},
    {"GetBoundaryType", FilledBoundaryAttributes_GetBoundaryType, METH_VARARGS},
    {"SetOpacity", FilledBoundaryAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", FilledBoundaryAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", FilledBoundaryAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", FilledBoundaryAttributes_GetWireframe, METH_VARARGS},
    {"SetDrawInternal", FilledBoundaryAttributes_SetDrawInternal, METH_VARARGS},
    {"GetDrawInternal", FilledBoundaryAttributes_GetDrawInternal, METH_VARARGS},
    {"SetSmoothingLevel", FilledBoundaryAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", FilledBoundaryAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetCleanZonesOnly", FilledBoundaryAttributes_SetCleanZonesOnly, METH_VARARGS},
    {"GetCleanZonesOnly", FilledBoundaryAttributes_GetCleanZonesOnly, METH_VARARGS},
    {"SetMixedColor", FilledBoundaryAttributes_SetMixedColor, METH_VARARGS},
    {"GetMixedColor", FilledBoundaryAttributes_GetMixedColor, METH_VARARGS},
    {"SetPointSize", FilledBoundaryAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", FilledBoundaryAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", FilledBoundaryAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", FilledBoundaryAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", FilledBoundaryAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", FilledBoundaryAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", FilledBoundaryAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", FilledBoundaryAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointSizePixels", FilledBoundaryAttributes_SetPointSizePixels, METH_VARARGS},
    {"GetPointSizePixels", FilledBoundaryAttributes_GetPointSizePixels, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FilledBoundaryAttributes_dealloc(PyObject *v)
{
   FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FilledBoundaryAttributes_compare(PyObject *v, PyObject *w)
{
    FilledBoundaryAttributes *a = ((FilledBoundaryAttributesObject *)v)->data;
    FilledBoundaryAttributes *b = ((FilledBoundaryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
FilledBoundaryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return FilledBoundaryAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByMultipleColors));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return FilledBoundaryAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "filledFlag") == 0)
        return FilledBoundaryAttributes_GetFilledFlag(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return FilledBoundaryAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return FilledBoundaryAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return FilledBoundaryAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return FilledBoundaryAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return FilledBoundaryAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return FilledBoundaryAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "boundaryType") == 0)
        return FilledBoundaryAttributes_GetBoundaryType(self, NULL);
    if(strcmp(name, "Domain") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Domain));
    if(strcmp(name, "Group") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Group));
    if(strcmp(name, "Material") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Material));
    if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Unknown));

    if(strcmp(name, "opacity") == 0)
        return FilledBoundaryAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return FilledBoundaryAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "drawInternal") == 0)
        return FilledBoundaryAttributes_GetDrawInternal(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return FilledBoundaryAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "cleanZonesOnly") == 0)
        return FilledBoundaryAttributes_GetCleanZonesOnly(self, NULL);
    if(strcmp(name, "mixedColor") == 0)
        return FilledBoundaryAttributes_GetMixedColor(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return FilledBoundaryAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return FilledBoundaryAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Box));
    if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Axis));
    if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Icosahedron));
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Point));
    if(strcmp(name, "Sphere") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Sphere));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return FilledBoundaryAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return FilledBoundaryAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointSizePixels") == 0)
        return FilledBoundaryAttributes_GetPointSizePixels(self, NULL);

    return Py_FindMethod(FilledBoundaryAttributes_methods, self, name);
}

static int
FilledBoundaryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "colorType") == 0)
        obj = FilledBoundaryAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = FilledBoundaryAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "filledFlag") == 0)
        obj = FilledBoundaryAttributes_SetFilledFlag(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = FilledBoundaryAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lineStyle") == 0)
        obj = FilledBoundaryAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = FilledBoundaryAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = FilledBoundaryAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = FilledBoundaryAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "boundaryNames") == 0)
        obj = FilledBoundaryAttributes_SetBoundaryNames(self, tuple);
    else if(strcmp(name, "boundaryType") == 0)
        obj = FilledBoundaryAttributes_SetBoundaryType(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = FilledBoundaryAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "wireframe") == 0)
        obj = FilledBoundaryAttributes_SetWireframe(self, tuple);
    else if(strcmp(name, "drawInternal") == 0)
        obj = FilledBoundaryAttributes_SetDrawInternal(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = FilledBoundaryAttributes_SetSmoothingLevel(self, tuple);
    else if(strcmp(name, "cleanZonesOnly") == 0)
        obj = FilledBoundaryAttributes_SetCleanZonesOnly(self, tuple);
    else if(strcmp(name, "mixedColor") == 0)
        obj = FilledBoundaryAttributes_SetMixedColor(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = FilledBoundaryAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "pointType") == 0)
        obj = FilledBoundaryAttributes_SetPointType(self, tuple);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        obj = FilledBoundaryAttributes_SetPointSizeVarEnabled(self, tuple);
    else if(strcmp(name, "pointSizeVar") == 0)
        obj = FilledBoundaryAttributes_SetPointSizeVar(self, tuple);
    else if(strcmp(name, "pointSizePixels") == 0)
        obj = FilledBoundaryAttributes_SetPointSizePixels(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
FilledBoundaryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
    fprintf(fp, "%s", PyFilledBoundaryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FilledBoundaryAttributes_str(PyObject *v)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
    return PyString_FromString(PyFilledBoundaryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FilledBoundaryAttributes_Purpose = "This class contains the plot attributes for the filled boundary plot.";
#else
static char *FilledBoundaryAttributes_Purpose = "This class contains the plot attributes for the filled boundary plot.";
#endif

//
// The type description structure
//
static PyTypeObject FilledBoundaryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FilledBoundaryAttributes",                    // tp_name
    sizeof(FilledBoundaryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FilledBoundaryAttributes_dealloc,  // tp_dealloc
    (printfunc)FilledBoundaryAttributes_print,     // tp_print
    (getattrfunc)FilledBoundaryAttributes_getattr, // tp_getattr
    (setattrfunc)FilledBoundaryAttributes_setattr, // tp_setattr
    (cmpfunc)FilledBoundaryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FilledBoundaryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FilledBoundaryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FilledBoundaryAttributes *defaultAtts = 0;
static FilledBoundaryAttributes *currentAtts = 0;

static PyObject *
NewFilledBoundaryAttributes(int useCurrent)
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FilledBoundaryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FilledBoundaryAttributes(*defaultAtts);
    else
        newObject->data = new FilledBoundaryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFilledBoundaryAttributes(const FilledBoundaryAttributes *attr)
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FilledBoundaryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FilledBoundaryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFilledBoundaryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FilledBoundaryAttributesMethods[] = {
    {"FilledBoundaryAttributes", FilledBoundaryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FilledBoundaryAttributesObserver = 0;

std::string
PyFilledBoundaryAttributes_GetLogString()
{
    std::string s("FilledBoundaryAtts = FilledBoundaryAttributes()\n");
    if(currentAtts != 0)
        s += PyFilledBoundaryAttributes_ToString(currentAtts, "FilledBoundaryAtts.");
    return s;
}

static void
PyFilledBoundaryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    FilledBoundaryAttributes *atts = (FilledBoundaryAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FilledBoundaryAtts = FilledBoundaryAttributes()\n");
        s += PyFilledBoundaryAttributes_ToString(currentAtts, "FilledBoundaryAtts.");
        cb(s);
    }
}

void
PyFilledBoundaryAttributes_StartUp(FilledBoundaryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFilledBoundaryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FilledBoundaryAttributesObserver == 0)
    {
        FilledBoundaryAttributesObserver = new ObserverToCallback(subj,
            PyFilledBoundaryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyFilledBoundaryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FilledBoundaryAttributesObserver;
    FilledBoundaryAttributesObserver = 0;
}

PyMethodDef *
PyFilledBoundaryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FilledBoundaryAttributesMethods;
}

bool
PyFilledBoundaryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FilledBoundaryAttributesType);
}

FilledBoundaryAttributes *
PyFilledBoundaryAttributes_FromPyObject(PyObject *obj)
{
    FilledBoundaryAttributesObject *obj2 = (FilledBoundaryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFilledBoundaryAttributes_New()
{
    return NewFilledBoundaryAttributes(0);
}

PyObject *
PyFilledBoundaryAttributes_Wrap(const FilledBoundaryAttributes *attr)
{
    return WrapFilledBoundaryAttributes(attr);
}

void
PyFilledBoundaryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    FilledBoundaryAttributesObject *obj2 = (FilledBoundaryAttributesObject *)obj;
    obj2->parent = parent;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Jul 18 13:49:42 PDT 2003
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************

void
PyFilledBoundaryAttributes_SetDefaults(const FilledBoundaryAttributes *atts)
{
    defaultAtts = const_cast<FilledBoundaryAttributes*>(atts);
}

