/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCurveAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCurveAttributes
//
// Purpose: 
//   Attributes for the xy plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a CurveAttributes.
//
struct CurveAttributesObject
{
    PyObject_HEAD
    CurveAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCurveAttributes(int);

std::string
PyCurveAttributes_ToString(const CurveAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *curveColor = atts->GetCurveColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%scurveColor = (%d, %d, %d, %d)\n", prefix, int(curveColor[0]), int(curveColor[1]), int(curveColor[2]), int(curveColor[3]));
    str += tmpStr;
    if(atts->GetShowLabels())
        SNPRINTF(tmpStr, 1000, "%sshowLabels = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLabels = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdesignator = \"%s\"\n", prefix, atts->GetDesignator().c_str());
    str += tmpStr;
    if(atts->GetShowPoints())
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowPoints = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spointSize = %g\n", prefix, atts->GetPointSize());
    str += tmpStr;
    if(atts->GetShowLegend())
        SNPRINTF(tmpStr, 1000, "%sshowLegend = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sshowLegend = 0\n", prefix);
    str += tmpStr;
    const char *curveColorSource_names = "Cycle, Custom";
    switch (atts->GetCurveColorSource())
    {
      case CurveAttributes::Cycle:
          SNPRINTF(tmpStr, 1000, "%scurveColorSource = %sCycle  # %s\n", prefix, prefix, curveColorSource_names);
          str += tmpStr;
          break;
      case CurveAttributes::Custom:
          SNPRINTF(tmpStr, 1000, "%scurveColorSource = %sCustom  # %s\n", prefix, prefix, curveColorSource_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *renderMode_names = "RenderAsLines, RenderAsSymbols";
    switch (atts->GetRenderMode())
    {
      case CurveAttributes::RenderAsLines:
          SNPRINTF(tmpStr, 1000, "%srenderMode = %sRenderAsLines  # %s\n", prefix, prefix, renderMode_names);
          str += tmpStr;
          break;
      case CurveAttributes::RenderAsSymbols:
          SNPRINTF(tmpStr, 1000, "%srenderMode = %sRenderAsSymbols  # %s\n", prefix, prefix, renderMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *symbol_names = "TriangleUp, TriangleDown, Square, Circle, Plus, "
        "X";
    switch (atts->GetSymbol())
    {
      case CurveAttributes::TriangleUp:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sTriangleUp  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::TriangleDown:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sTriangleDown  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Square:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sSquare  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Circle:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sCircle  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::Plus:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sPlus  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      case CurveAttributes::X:
          SNPRINTF(tmpStr, 1000, "%ssymbol = %sX  # %s\n", prefix, prefix, symbol_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%ssymbolDensity = %d\n", prefix, atts->GetSymbolDensity());
    str += tmpStr;
    return str;
}

static PyObject *
CurveAttributes_Notify(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetCurveColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the curveColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetCurveColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetCurveColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the curveColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *curveColor = obj->data->GetCurveColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(curveColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(curveColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(curveColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(curveColor[3])));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLabels in the object.
    obj->data->SetShowLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLabels()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetDesignator(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the designator in the object.
    obj->data->SetDesignator(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetDesignator(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDesignator().c_str());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetShowLegend(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLegend in the object.
    obj->data->SetShowLegend(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetShowLegend(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLegend()?1L:0L);
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetCurveColorSource(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the curveColorSource in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCurveColorSource(CurveAttributes::CurveColor(ival));
    else
    {
        fprintf(stderr, "An invalid curveColorSource value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Cycle, Custom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetCurveColorSource(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCurveColorSource()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetRenderMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the renderMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetRenderMode(CurveAttributes::RenderMode(ival));
    else
    {
        fprintf(stderr, "An invalid renderMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "RenderAsLines, RenderAsSymbols.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetRenderMode(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRenderMode()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetSymbol(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the symbol in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetSymbol(CurveAttributes::SymbolTypes(ival));
    else
    {
        fprintf(stderr, "An invalid symbol value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "TriangleUp, TriangleDown, Square, Circle, Plus, "
                        "X.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetSymbol(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSymbol()));
    return retval;
}

/*static*/ PyObject *
CurveAttributes_SetSymbolDensity(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the symbolDensity in the object.
    obj->data->SetSymbolDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CurveAttributes_GetSymbolDensity(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSymbolDensity()));
    return retval;
}



PyMethodDef PyCurveAttributes_methods[CURVEATTRIBUTES_NMETH] = {
    {"Notify", CurveAttributes_Notify, METH_VARARGS},
    {"SetLineStyle", CurveAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", CurveAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", CurveAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", CurveAttributes_GetLineWidth, METH_VARARGS},
    {"SetCurveColor", CurveAttributes_SetCurveColor, METH_VARARGS},
    {"GetCurveColor", CurveAttributes_GetCurveColor, METH_VARARGS},
    {"SetShowLabels", CurveAttributes_SetShowLabels, METH_VARARGS},
    {"GetShowLabels", CurveAttributes_GetShowLabels, METH_VARARGS},
    {"SetDesignator", CurveAttributes_SetDesignator, METH_VARARGS},
    {"GetDesignator", CurveAttributes_GetDesignator, METH_VARARGS},
    {"SetShowPoints", CurveAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", CurveAttributes_GetShowPoints, METH_VARARGS},
    {"SetPointSize", CurveAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", CurveAttributes_GetPointSize, METH_VARARGS},
    {"SetShowLegend", CurveAttributes_SetShowLegend, METH_VARARGS},
    {"GetShowLegend", CurveAttributes_GetShowLegend, METH_VARARGS},
    {"SetCurveColorSource", CurveAttributes_SetCurveColorSource, METH_VARARGS},
    {"GetCurveColorSource", CurveAttributes_GetCurveColorSource, METH_VARARGS},
    {"SetRenderMode", CurveAttributes_SetRenderMode, METH_VARARGS},
    {"GetRenderMode", CurveAttributes_GetRenderMode, METH_VARARGS},
    {"SetSymbol", CurveAttributes_SetSymbol, METH_VARARGS},
    {"GetSymbol", CurveAttributes_GetSymbol, METH_VARARGS},
    {"SetSymbolDensity", CurveAttributes_SetSymbolDensity, METH_VARARGS},
    {"GetSymbolDensity", CurveAttributes_GetSymbolDensity, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CurveAttributes_dealloc(PyObject *v)
{
   CurveAttributesObject *obj = (CurveAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CurveAttributes_compare(PyObject *v, PyObject *w)
{
    CurveAttributes *a = ((CurveAttributesObject *)v)->data;
    CurveAttributes *b = ((CurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyCurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "lineStyle") == 0)
        return CurveAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return CurveAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "curveColor") == 0)
        return CurveAttributes_GetCurveColor(self, NULL);
    if(strcmp(name, "showLabels") == 0)
        return CurveAttributes_GetShowLabels(self, NULL);
    if(strcmp(name, "designator") == 0)
        return CurveAttributes_GetDesignator(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return CurveAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return CurveAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "showLegend") == 0)
        return CurveAttributes_GetShowLegend(self, NULL);
    if(strcmp(name, "curveColorSource") == 0)
        return CurveAttributes_GetCurveColorSource(self, NULL);
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(CurveAttributes::Cycle));
    if(strcmp(name, "Custom") == 0)
        return PyInt_FromLong(long(CurveAttributes::Custom));

    if(strcmp(name, "renderMode") == 0)
        return CurveAttributes_GetRenderMode(self, NULL);
    if(strcmp(name, "RenderAsLines") == 0)
        return PyInt_FromLong(long(CurveAttributes::RenderAsLines));
    if(strcmp(name, "RenderAsSymbols") == 0)
        return PyInt_FromLong(long(CurveAttributes::RenderAsSymbols));

    if(strcmp(name, "symbol") == 0)
        return CurveAttributes_GetSymbol(self, NULL);
    if(strcmp(name, "TriangleUp") == 0)
        return PyInt_FromLong(long(CurveAttributes::TriangleUp));
    if(strcmp(name, "TriangleDown") == 0)
        return PyInt_FromLong(long(CurveAttributes::TriangleDown));
    if(strcmp(name, "Square") == 0)
        return PyInt_FromLong(long(CurveAttributes::Square));
    if(strcmp(name, "Circle") == 0)
        return PyInt_FromLong(long(CurveAttributes::Circle));
    if(strcmp(name, "Plus") == 0)
        return PyInt_FromLong(long(CurveAttributes::Plus));
    if(strcmp(name, "X") == 0)
        return PyInt_FromLong(long(CurveAttributes::X));

    if(strcmp(name, "symbolDensity") == 0)
        return CurveAttributes_GetSymbolDensity(self, NULL);

    // Try and handle legacy fields in CurveAttributes
    if(strcmp(name, "cycleColors") == 0)
    {
        CurveAttributesObject *curveObj = (CurveAttributesObject *)self;
        bool cycleColors = curveObj->data->GetCurveColorSource() == CurveAttributes::Custom;
        return PyInt_FromLong(cycleColors?1L:0L);
    }
    // Try and handle legacy fields in CurveAttributes
    if(strcmp(name, "color") == 0)
    {
        return CurveAttributes_GetCurveColor(self, NULL);
    }
    return Py_FindMethod(PyCurveAttributes_methods, self, name);
}

int
PyCurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "lineStyle") == 0)
        obj = CurveAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = CurveAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "curveColor") == 0)
        obj = CurveAttributes_SetCurveColor(self, tuple);
    else if(strcmp(name, "showLabels") == 0)
        obj = CurveAttributes_SetShowLabels(self, tuple);
    else if(strcmp(name, "designator") == 0)
        obj = CurveAttributes_SetDesignator(self, tuple);
    else if(strcmp(name, "showPoints") == 0)
        obj = CurveAttributes_SetShowPoints(self, tuple);
    else if(strcmp(name, "pointSize") == 0)
        obj = CurveAttributes_SetPointSize(self, tuple);
    else if(strcmp(name, "showLegend") == 0)
        obj = CurveAttributes_SetShowLegend(self, tuple);
    else if(strcmp(name, "curveColorSource") == 0)
        obj = CurveAttributes_SetCurveColorSource(self, tuple);
    else if(strcmp(name, "renderMode") == 0)
        obj = CurveAttributes_SetRenderMode(self, tuple);
    else if(strcmp(name, "symbol") == 0)
        obj = CurveAttributes_SetSymbol(self, tuple);
    else if(strcmp(name, "symbolDensity") == 0)
        obj = CurveAttributes_SetSymbolDensity(self, tuple);

   // Try and handle legacy fields in CurveAttributes
    if(obj == NULL)
    {
        CurveAttributesObject *CurveObj = (CurveAttributesObject *)self;
        if(strcmp(name, "color") == 0)
        {
            obj = CurveAttributes_SetCurveColor(self, tuple);
        }
        if(strcmp(name, "cycleColors") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            if(ival == 0)
                CurveObj->data->SetCurveColorSource(CurveAttributes::Custom);
            else
                CurveObj->data->SetCurveColorSource(CurveAttributes::Cycle);
    
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
CurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)v;
    fprintf(fp, "%s", PyCurveAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CurveAttributes_str(PyObject *v)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)v;
    return PyString_FromString(PyCurveAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CurveAttributes_Purpose = "Attributes for the xy plot";
#else
static char *CurveAttributes_Purpose = "Attributes for the xy plot";
#endif

//
// The type description structure
//
static PyTypeObject CurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CurveAttributes",                    // tp_name
    sizeof(CurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CurveAttributes_dealloc,  // tp_dealloc
    (printfunc)CurveAttributes_print,     // tp_print
    (getattrfunc)PyCurveAttributes_getattr, // tp_getattr
    (setattrfunc)PyCurveAttributes_setattr, // tp_setattr
    (cmpfunc)CurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CurveAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CurveAttributes *defaultAtts = 0;
static CurveAttributes *currentAtts = 0;

static PyObject *
NewCurveAttributes(int useCurrent)
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CurveAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CurveAttributes(*defaultAtts);
    else
        newObject->data = new CurveAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCurveAttributes(const CurveAttributes *attr)
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CurveAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CurveAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCurveAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CurveAttributesMethods[] = {
    {"CurveAttributes", CurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CurveAttributesObserver = 0;

std::string
PyCurveAttributes_GetLogString()
{
    std::string s("CurveAtts = CurveAttributes()\n");
    if(currentAtts != 0)
        s += PyCurveAttributes_ToString(currentAtts, "CurveAtts.");
    return s;
}

static void
PyCurveAttributes_CallLogRoutine(Subject *subj, void *data)
{
    CurveAttributes *atts = (CurveAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CurveAtts = CurveAttributes()\n");
        s += PyCurveAttributes_ToString(currentAtts, "CurveAtts.");
        cb(s);
    }
}

void
PyCurveAttributes_StartUp(CurveAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CurveAttributesObserver == 0)
    {
        CurveAttributesObserver = new ObserverToCallback(subj,
            PyCurveAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CurveAttributesObserver;
    CurveAttributesObserver = 0;
}

PyMethodDef *
PyCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CurveAttributesMethods;
}

bool
PyCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CurveAttributesType);
}

CurveAttributes *
PyCurveAttributes_FromPyObject(PyObject *obj)
{
    CurveAttributesObject *obj2 = (CurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCurveAttributes_New()
{
    return NewCurveAttributes(0);
}

PyObject *
PyCurveAttributes_Wrap(const CurveAttributes *attr)
{
    return WrapCurveAttributes(attr);
}

void
PyCurveAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CurveAttributesObject *obj2 = (CurveAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCurveAttributes_SetDefaults(const CurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CurveAttributes(*atts);
}

