// ***************************************************************************
//
// Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-400124
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: CurveAttributes
//
// Purpose:
//    Attributes for the xy plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class CurveAttributes extends AttributeSubject implements Plugin
{
    private static int numAdditionalAttributes = 12;

    // Enum values
    public final static int RENDERMODE_RENDERASLINES = 0;
    public final static int RENDERMODE_RENDERASSYMBOLS = 1;

    public final static int CURVECOLOR_CYCLE = 0;
    public final static int CURVECOLOR_CUSTOM = 1;

    public final static int SYMBOLTYPES_TRIANGLEUP = 0;
    public final static int SYMBOLTYPES_TRIANGLEDOWN = 1;
    public final static int SYMBOLTYPES_SQUARE = 2;
    public final static int SYMBOLTYPES_CIRCLE = 3;
    public final static int SYMBOLTYPES_PLUS = 4;
    public final static int SYMBOLTYPES_X = 5;


    public CurveAttributes()
    {
        super(numAdditionalAttributes);

        lineStyle = 0;
        lineWidth = 0;
        curveColor = new ColorAttribute(0, 0, 0);
        showLabels = true;
        designator = new String("");
        showPoints = false;
        pointSize = 5;
        showLegend = true;
        curveColorSource = CURVECOLOR_CYCLE;
        renderMode = RENDERMODE_RENDERASLINES;
        symbol = SYMBOLTYPES_TRIANGLEUP;
        symbolDensity = 50;
    }

    public CurveAttributes(int nMoreFields)
    {
        super(numAdditionalAttributes + nMoreFields);

        lineStyle = 0;
        lineWidth = 0;
        curveColor = new ColorAttribute(0, 0, 0);
        showLabels = true;
        designator = new String("");
        showPoints = false;
        pointSize = 5;
        showLegend = true;
        curveColorSource = CURVECOLOR_CYCLE;
        renderMode = RENDERMODE_RENDERASLINES;
        symbol = SYMBOLTYPES_TRIANGLEUP;
        symbolDensity = 50;
    }

    public CurveAttributes(CurveAttributes obj)
    {
        super(numAdditionalAttributes);

        lineStyle = obj.lineStyle;
        lineWidth = obj.lineWidth;
        curveColor = new ColorAttribute(obj.curveColor);
        showLabels = obj.showLabels;
        designator = new String(obj.designator);
        showPoints = obj.showPoints;
        pointSize = obj.pointSize;
        showLegend = obj.showLegend;
        curveColorSource = obj.curveColorSource;
        renderMode = obj.renderMode;
        symbol = obj.symbol;
        symbolDensity = obj.symbolDensity;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return numAdditionalAttributes;
    }

    public boolean equals(CurveAttributes obj)
    {
        // Create the return value
        return ((lineStyle == obj.lineStyle) &&
                (lineWidth == obj.lineWidth) &&
                (curveColor == obj.curveColor) &&
                (showLabels == obj.showLabels) &&
                (designator.equals(obj.designator)) &&
                (showPoints == obj.showPoints) &&
                (pointSize == obj.pointSize) &&
                (showLegend == obj.showLegend) &&
                (curveColorSource == obj.curveColorSource) &&
                (renderMode == obj.renderMode) &&
                (symbol == obj.symbol) &&
                (symbolDensity == obj.symbolDensity));
    }

    public String GetName() { return "Curve"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLineStyle(int lineStyle_)
    {
        lineStyle = lineStyle_;
        Select(0);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(1);
    }

    public void SetCurveColor(ColorAttribute curveColor_)
    {
        curveColor = curveColor_;
        Select(2);
    }

    public void SetShowLabels(boolean showLabels_)
    {
        showLabels = showLabels_;
        Select(3);
    }

    public void SetDesignator(String designator_)
    {
        designator = designator_;
        Select(4);
    }

    public void SetShowPoints(boolean showPoints_)
    {
        showPoints = showPoints_;
        Select(5);
    }

    public void SetPointSize(double pointSize_)
    {
        pointSize = pointSize_;
        Select(6);
    }

    public void SetShowLegend(boolean showLegend_)
    {
        showLegend = showLegend_;
        Select(7);
    }

    public void SetCurveColorSource(int curveColorSource_)
    {
        curveColorSource = curveColorSource_;
        Select(8);
    }

    public void SetRenderMode(int renderMode_)
    {
        renderMode = renderMode_;
        Select(9);
    }

    public void SetSymbol(int symbol_)
    {
        symbol = symbol_;
        Select(10);
    }

    public void SetSymbolDensity(int symbolDensity_)
    {
        symbolDensity = symbolDensity_;
        Select(11);
    }

    // Property getting methods
    public int            GetLineStyle() { return lineStyle; }
    public int            GetLineWidth() { return lineWidth; }
    public ColorAttribute GetCurveColor() { return curveColor; }
    public boolean        GetShowLabels() { return showLabels; }
    public String         GetDesignator() { return designator; }
    public boolean        GetShowPoints() { return showPoints; }
    public double         GetPointSize() { return pointSize; }
    public boolean        GetShowLegend() { return showLegend; }
    public int            GetCurveColorSource() { return curveColorSource; }
    public int            GetRenderMode() { return renderMode; }
    public int            GetSymbol() { return symbol; }
    public int            GetSymbolDensity() { return symbolDensity; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(lineStyle);
        if(WriteSelect(1, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(2, buf))
            curveColor.Write(buf);
        if(WriteSelect(3, buf))
            buf.WriteBool(showLabels);
        if(WriteSelect(4, buf))
            buf.WriteString(designator);
        if(WriteSelect(5, buf))
            buf.WriteBool(showPoints);
        if(WriteSelect(6, buf))
            buf.WriteDouble(pointSize);
        if(WriteSelect(7, buf))
            buf.WriteBool(showLegend);
        if(WriteSelect(8, buf))
            buf.WriteInt(curveColorSource);
        if(WriteSelect(9, buf))
            buf.WriteInt(renderMode);
        if(WriteSelect(10, buf))
            buf.WriteInt(symbol);
        if(WriteSelect(11, buf))
            buf.WriteInt(symbolDensity);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetLineStyle(buf.ReadInt());
            break;
        case 1:
            SetLineWidth(buf.ReadInt());
            break;
        case 2:
            curveColor.Read(buf);
            Select(2);
            break;
        case 3:
            SetShowLabels(buf.ReadBool());
            break;
        case 4:
            SetDesignator(buf.ReadString());
            break;
        case 5:
            SetShowPoints(buf.ReadBool());
            break;
        case 6:
            SetPointSize(buf.ReadDouble());
            break;
        case 7:
            SetShowLegend(buf.ReadBool());
            break;
        case 8:
            SetCurveColorSource(buf.ReadInt());
            break;
        case 9:
            SetRenderMode(buf.ReadInt());
            break;
        case 10:
            SetSymbol(buf.ReadInt());
            break;
        case 11:
            SetSymbolDensity(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("lineStyle", lineStyle, indent) + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + indent + "curveColor = {" + curveColor.Red() + ", " + curveColor.Green() + ", " + curveColor.Blue() + ", " + curveColor.Alpha() + "}\n";
        str = str + boolToString("showLabels", showLabels, indent) + "\n";
        str = str + stringToString("designator", designator, indent) + "\n";
        str = str + boolToString("showPoints", showPoints, indent) + "\n";
        str = str + doubleToString("pointSize", pointSize, indent) + "\n";
        str = str + boolToString("showLegend", showLegend, indent) + "\n";
        str = str + indent + "curveColorSource = ";
        if(curveColorSource == CURVECOLOR_CYCLE)
            str = str + "CURVECOLOR_CYCLE";
        if(curveColorSource == CURVECOLOR_CUSTOM)
            str = str + "CURVECOLOR_CUSTOM";
        str = str + "\n";
        str = str + indent + "renderMode = ";
        if(renderMode == RENDERMODE_RENDERASLINES)
            str = str + "RENDERMODE_RENDERASLINES";
        if(renderMode == RENDERMODE_RENDERASSYMBOLS)
            str = str + "RENDERMODE_RENDERASSYMBOLS";
        str = str + "\n";
        str = str + indent + "symbol = ";
        if(symbol == SYMBOLTYPES_TRIANGLEUP)
            str = str + "SYMBOLTYPES_TRIANGLEUP";
        if(symbol == SYMBOLTYPES_TRIANGLEDOWN)
            str = str + "SYMBOLTYPES_TRIANGLEDOWN";
        if(symbol == SYMBOLTYPES_SQUARE)
            str = str + "SYMBOLTYPES_SQUARE";
        if(symbol == SYMBOLTYPES_CIRCLE)
            str = str + "SYMBOLTYPES_CIRCLE";
        if(symbol == SYMBOLTYPES_PLUS)
            str = str + "SYMBOLTYPES_PLUS";
        if(symbol == SYMBOLTYPES_X)
            str = str + "SYMBOLTYPES_X";
        str = str + "\n";
        str = str + intToString("symbolDensity", symbolDensity, indent) + "\n";
        return str;
    }


    // Attributes
    private int            lineStyle;
    private int            lineWidth;
    private ColorAttribute curveColor;
    private boolean        showLabels;
    private String         designator;
    private boolean        showPoints;
    private double         pointSize;
    private boolean        showLegend;
    private int            curveColorSource;
    private int            renderMode;
    private int            symbol;
    private int            symbolDensity;
}

