/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <CurveAttributes.h>
#include <DataNode.h>
#include <Line.h>

//
// Enum conversion methods for CurveAttributes::RenderMode
//

static const char *RenderMode_strings[] = {
"RenderAsLines", "RenderAsSymbols"};

std::string
CurveAttributes::RenderMode_ToString(CurveAttributes::RenderMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return RenderMode_strings[index];
}

std::string
CurveAttributes::RenderMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return RenderMode_strings[index];
}

bool
CurveAttributes::RenderMode_FromString(const std::string &s, CurveAttributes::RenderMode &val)
{
    val = CurveAttributes::RenderAsLines;
    for(int i = 0; i < 2; ++i)
    {
        if(s == RenderMode_strings[i])
        {
            val = (RenderMode)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for CurveAttributes::CurveColor
//

static const char *CurveColor_strings[] = {
"Cycle", "Custom"};

std::string
CurveAttributes::CurveColor_ToString(CurveAttributes::CurveColor t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return CurveColor_strings[index];
}

std::string
CurveAttributes::CurveColor_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return CurveColor_strings[index];
}

bool
CurveAttributes::CurveColor_FromString(const std::string &s, CurveAttributes::CurveColor &val)
{
    val = CurveAttributes::Cycle;
    for(int i = 0; i < 2; ++i)
    {
        if(s == CurveColor_strings[i])
        {
            val = (CurveColor)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for CurveAttributes::SymbolTypes
//

static const char *SymbolTypes_strings[] = {
"TriangleUp", "TriangleDown", "Square", 
"Circle", "Plus", "X"
};

std::string
CurveAttributes::SymbolTypes_ToString(CurveAttributes::SymbolTypes t)
{
    int index = int(t);
    if(index < 0 || index >= 6) index = 0;
    return SymbolTypes_strings[index];
}

std::string
CurveAttributes::SymbolTypes_ToString(int t)
{
    int index = (t < 0 || t >= 6) ? 0 : t;
    return SymbolTypes_strings[index];
}

bool
CurveAttributes::SymbolTypes_FromString(const std::string &s, CurveAttributes::SymbolTypes &val)
{
    val = CurveAttributes::TriangleUp;
    for(int i = 0; i < 6; ++i)
    {
        if(s == SymbolTypes_strings[i])
        {
            val = (SymbolTypes)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Init utility for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CurveAttributes::Init()
{
    lineStyle = 0;
    lineWidth = 0;
    showLabels = true;
    showPoints = false;
    pointSize = 5;
    showLegend = true;
    curveColorSource = Cycle;
    renderMode = RenderAsLines;
    symbol = TriangleUp;
    symbolDensity = 50;

    CurveAttributes::SelectAll();
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Copy utility for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CurveAttributes::Copy(const CurveAttributes &obj)
{
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    curveColor = obj.curveColor;
    showLabels = obj.showLabels;
    designator = obj.designator;
    showPoints = obj.showPoints;
    pointSize = obj.pointSize;
    showLegend = obj.showLegend;
    curveColorSource = obj.curveColorSource;
    renderMode = obj.renderMode;
    symbol = obj.symbol;
    symbolDensity = obj.symbolDensity;

    CurveAttributes::SelectAll();
}

// Type map format string
const char *CurveAttributes::TypeMapFormatString = CURVEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CurveAttributes::TmfsStruct = {CURVEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Default constructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes() : 
    AttributeSubject(CurveAttributes::TypeMapFormatString),
    curveColor(0, 0, 0)
{
    CurveAttributes::Init();
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Constructor for the derived classes of CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    curveColor(0, 0, 0)
{
    CurveAttributes::Init();
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Copy constructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes(const CurveAttributes &obj) : 
    AttributeSubject(CurveAttributes::TypeMapFormatString)
{
    CurveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CurveAttributes::CurveAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::CurveAttributes(const CurveAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CurveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CurveAttributes::~CurveAttributes
//
// Purpose: 
//   Destructor for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes::~CurveAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CurveAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CurveAttributes& 
CurveAttributes::operator = (const CurveAttributes &obj)
{
    if (this == &obj) return *this;

    CurveAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CurveAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::operator == (const CurveAttributes &obj) const
{
    // Create the return value
    return ((lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (curveColor == obj.curveColor) &&
            (showLabels == obj.showLabels) &&
            (designator == obj.designator) &&
            (showPoints == obj.showPoints) &&
            (pointSize == obj.pointSize) &&
            (showLegend == obj.showLegend) &&
            (curveColorSource == obj.curveColorSource) &&
            (renderMode == obj.renderMode) &&
            (symbol == obj.symbol) &&
            (symbolDensity == obj.symbolDensity));
}

// ****************************************************************************
// Method: CurveAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::operator != (const CurveAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CurveAttributes::TypeName
//
// Purpose: 
//   Type name method for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
CurveAttributes::TypeName() const
{
    return "CurveAttributes";
}

bool
CurveAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const CurveAttributes *tmp = (const CurveAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "Line")
    {
        const Line *tmp = (const Line*)atts;
        SetDesignator(tmp->GetDesignator());
        SetCurveColor(tmp->GetColor());
        retval = true;
    }

    return retval;
}

AttributeSubject *
CurveAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new CurveAttributes(*this);
    }
    else if(tname == "Line")
    {
        Line *line = new Line;
        line->SetDesignator(GetDesignator());
        line->SetColor(GetCurveColor());
        line->SetLineStyle(GetLineStyle());
        line->SetLineWidth(GetLineWidth());
        retval = line;
    }

    return retval;
}

// ****************************************************************************
// Method: CurveAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CurveAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CurveAttributes(*this);
    else
        retval = new CurveAttributes;

    return retval;
}

// ****************************************************************************
// Method: CurveAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CurveAttributes::SelectAll()
{
    Select(ID_lineStyle,        (void *)&lineStyle);
    Select(ID_lineWidth,        (void *)&lineWidth);
    Select(ID_curveColor,       (void *)&curveColor);
    Select(ID_showLabels,       (void *)&showLabels);
    Select(ID_designator,       (void *)&designator);
    Select(ID_showPoints,       (void *)&showPoints);
    Select(ID_pointSize,        (void *)&pointSize);
    Select(ID_showLegend,       (void *)&showLegend);
    Select(ID_curveColorSource, (void *)&curveColorSource);
    Select(ID_renderMode,       (void *)&renderMode);
    Select(ID_symbol,           (void *)&symbol);
    Select(ID_symbolDensity,    (void *)&symbolDensity);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CurveAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CurveAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CurveAttributes.
    DataNode *node = new DataNode("CurveAttributes");

    if(completeSave || !FieldsEqual(ID_lineStyle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *curveColorNode = new DataNode("curveColor");
        if(curveColor.CreateNode(curveColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(curveColorNode);
        }
        else
            delete curveColorNode;
    if(completeSave || !FieldsEqual(ID_showLabels, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showLabels", showLabels));
    }

    if(completeSave || !FieldsEqual(ID_designator, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("designator", designator));
    }

    if(completeSave || !FieldsEqual(ID_showPoints, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showPoints", showPoints));
    }

    if(completeSave || !FieldsEqual(ID_pointSize, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSize", pointSize));
    }

    if(completeSave || !FieldsEqual(ID_showLegend, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showLegend", showLegend));
    }

    if(completeSave || !FieldsEqual(ID_curveColorSource, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("curveColorSource", CurveColor_ToString(curveColorSource)));
    }

    if(completeSave || !FieldsEqual(ID_renderMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("renderMode", RenderMode_ToString(renderMode)));
    }

    if(completeSave || !FieldsEqual(ID_symbol, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("symbol", SymbolTypes_ToString(symbol)));
    }

    if(completeSave || !FieldsEqual(ID_symbolDensity, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("symbolDensity", symbolDensity));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CurveAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CurveAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CurveAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("curveColor")) != 0)
        curveColor.SetFromNode(node);
    if((node = searchNode->GetNode("showLabels")) != 0)
        SetShowLabels(node->AsBool());
    if((node = searchNode->GetNode("designator")) != 0)
        SetDesignator(node->AsString());
    if((node = searchNode->GetNode("showPoints")) != 0)
        SetShowPoints(node->AsBool());
    if((node = searchNode->GetNode("pointSize")) != 0)
        SetPointSize(node->AsDouble());
    if((node = searchNode->GetNode("showLegend")) != 0)
        SetShowLegend(node->AsBool());
    if((node = searchNode->GetNode("curveColorSource")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetCurveColorSource(CurveColor(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            CurveColor value;
            if(CurveColor_FromString(node->AsString(), value))
                SetCurveColorSource(value);
        }
    }
    if((node = searchNode->GetNode("renderMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetRenderMode(RenderMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            RenderMode value;
            if(RenderMode_FromString(node->AsString(), value))
                SetRenderMode(value);
        }
    }
    if((node = searchNode->GetNode("symbol")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 6)
                SetSymbol(SymbolTypes(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SymbolTypes value;
            if(SymbolTypes_FromString(node->AsString(), value))
                SetSymbol(value);
        }
    }
    if((node = searchNode->GetNode("symbolDensity")) != 0)
        SetSymbolDensity(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CurveAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(ID_lineStyle, (void *)&lineStyle);
}

void
CurveAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
CurveAttributes::SetCurveColor(const ColorAttribute &curveColor_)
{
    curveColor = curveColor_;
    Select(ID_curveColor, (void *)&curveColor);
}

void
CurveAttributes::SetShowLabels(bool showLabels_)
{
    showLabels = showLabels_;
    Select(ID_showLabels, (void *)&showLabels);
}

void
CurveAttributes::SetDesignator(const std::string &designator_)
{
    designator = designator_;
    Select(ID_designator, (void *)&designator);
}

void
CurveAttributes::SetShowPoints(bool showPoints_)
{
    showPoints = showPoints_;
    Select(ID_showPoints, (void *)&showPoints);
}

void
CurveAttributes::SetPointSize(double pointSize_)
{
    pointSize = pointSize_;
    Select(ID_pointSize, (void *)&pointSize);
}

void
CurveAttributes::SetShowLegend(bool showLegend_)
{
    showLegend = showLegend_;
    Select(ID_showLegend, (void *)&showLegend);
}

void
CurveAttributes::SetCurveColorSource(CurveAttributes::CurveColor curveColorSource_)
{
    curveColorSource = curveColorSource_;
    Select(ID_curveColorSource, (void *)&curveColorSource);
}

void
CurveAttributes::SetRenderMode(CurveAttributes::RenderMode renderMode_)
{
    renderMode = renderMode_;
    Select(ID_renderMode, (void *)&renderMode);
}

void
CurveAttributes::SetSymbol(CurveAttributes::SymbolTypes symbol_)
{
    symbol = symbol_;
    Select(ID_symbol, (void *)&symbol);
}

void
CurveAttributes::SetSymbolDensity(int symbolDensity_)
{
    symbolDensity = symbolDensity_;
    Select(ID_symbolDensity, (void *)&symbolDensity);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
CurveAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
CurveAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
CurveAttributes::GetCurveColor() const
{
    return curveColor;
}

ColorAttribute &
CurveAttributes::GetCurveColor()
{
    return curveColor;
}

bool
CurveAttributes::GetShowLabels() const
{
    return showLabels;
}

const std::string &
CurveAttributes::GetDesignator() const
{
    return designator;
}

std::string &
CurveAttributes::GetDesignator()
{
    return designator;
}

bool
CurveAttributes::GetShowPoints() const
{
    return showPoints;
}

double
CurveAttributes::GetPointSize() const
{
    return pointSize;
}

bool
CurveAttributes::GetShowLegend() const
{
    return showLegend;
}

CurveAttributes::CurveColor
CurveAttributes::GetCurveColorSource() const
{
    return CurveColor(curveColorSource);
}

CurveAttributes::RenderMode
CurveAttributes::GetRenderMode() const
{
    return RenderMode(renderMode);
}

CurveAttributes::SymbolTypes
CurveAttributes::GetSymbol() const
{
    return SymbolTypes(symbol);
}

int
CurveAttributes::GetSymbolDensity() const
{
    return symbolDensity;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CurveAttributes::SelectCurveColor()
{
    Select(ID_curveColor, (void *)&curveColor);
}

void
CurveAttributes::SelectDesignator()
{
    Select(ID_designator, (void *)&designator);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CurveAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CurveAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_lineStyle:        return "lineStyle";
    case ID_lineWidth:        return "lineWidth";
    case ID_curveColor:       return "curveColor";
    case ID_showLabels:       return "showLabels";
    case ID_designator:       return "designator";
    case ID_showPoints:       return "showPoints";
    case ID_pointSize:        return "pointSize";
    case ID_showLegend:       return "showLegend";
    case ID_curveColorSource: return "curveColorSource";
    case ID_renderMode:       return "renderMode";
    case ID_symbol:           return "symbol";
    case ID_symbolDensity:    return "symbolDensity";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CurveAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CurveAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_lineStyle:        return FieldType_linestyle;
    case ID_lineWidth:        return FieldType_linewidth;
    case ID_curveColor:       return FieldType_color;
    case ID_showLabels:       return FieldType_bool;
    case ID_designator:       return FieldType_string;
    case ID_showPoints:       return FieldType_bool;
    case ID_pointSize:        return FieldType_double;
    case ID_showLegend:       return FieldType_bool;
    case ID_curveColorSource: return FieldType_enum;
    case ID_renderMode:       return FieldType_enum;
    case ID_symbol:           return FieldType_enum;
    case ID_symbolDensity:    return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CurveAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CurveAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_lineStyle:        return "linestyle";
    case ID_lineWidth:        return "linewidth";
    case ID_curveColor:       return "color";
    case ID_showLabels:       return "bool";
    case ID_designator:       return "string";
    case ID_showPoints:       return "bool";
    case ID_pointSize:        return "double";
    case ID_showLegend:       return "bool";
    case ID_curveColorSource: return "enum";
    case ID_renderMode:       return "enum";
    case ID_symbol:           return "enum";
    case ID_symbolDensity:    return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CurveAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CurveAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CurveAttributes &obj = *((const CurveAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_lineStyle:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_curveColor:
        {  // new scope
        retval = (curveColor == obj.curveColor);
        }
        break;
    case ID_showLabels:
        {  // new scope
        retval = (showLabels == obj.showLabels);
        }
        break;
    case ID_designator:
        {  // new scope
        retval = (designator == obj.designator);
        }
        break;
    case ID_showPoints:
        {  // new scope
        retval = (showPoints == obj.showPoints);
        }
        break;
    case ID_pointSize:
        {  // new scope
        retval = (pointSize == obj.pointSize);
        }
        break;
    case ID_showLegend:
        {  // new scope
        retval = (showLegend == obj.showLegend);
        }
        break;
    case ID_curveColorSource:
        {  // new scope
        retval = (curveColorSource == obj.curveColorSource);
        }
        break;
    case ID_renderMode:
        {  // new scope
        retval = (renderMode == obj.renderMode);
        }
        break;
    case ID_symbol:
        {  // new scope
        retval = (symbol == obj.symbol);
        }
        break;
    case ID_symbolDensity:
        {  // new scope
        retval = (symbolDensity == obj.symbolDensity);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
CurveAttributes::ChangesRequireRecalculation(const CurveAttributes &obj) const
{
    return false;
}

void
CurveAttributes::Print(ostream &out, bool selected_only) const
{
    out << "CurveAttributes" << "\n";
    out << "{";
    for(int i = 0; i < NumAttributes(); ++i)
    {
        if(selected_only && !IsSelected(i))
            continue;

        switch(i)
        {
          case  0: out << "lineStyle=  " << GetLineStyle();      break;
          case  1: out << "lineWidth=  " << GetLineWidth();      break;
          case  2: double color[4];
                   GetCurveColor().GetRgba(color);
                   out << "color=      " 
                       << color[0] << " " << color[1] << " " 
                       << color[2] << " " << color[3];
                   GetDesignator();    break;
          case  3: out << "showLabels= " << GetShowLabels();    break;
          case  4: out << "designator= " << GetDesignator().c_str();    break;
          case  5: out << "showPoints= " << GetShowPoints();    break;
          case  6: out << "pointSize=  " << GetPointSize();    break;
          case  7: out << "legend=  " << (GetShowLegend()?"true":"false");    break;
//          case  8: out << "curveColor=" << (GetCurveColor()==CurveColor::Cycle?"cycle":"custom"); break;
          case  9: out << "renderMode=" << RenderMode_ToString(GetRenderMode()).c_str(); break;
          case  10: out << "symbol=" << SymbolTypes_ToString(GetSymbol()).c_str(); break;
          case  11: out << "symbolDensity=" << GetSymbolDensity(); break;
        }
        out << ",";
    }

    out << "}";
}

