/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyContourAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPointList.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>

// ****************************************************************************
// Module: PyContourAttributes
//
// Purpose: 
//   This class contains the plot attributes for the contour plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:32 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a ContourAttributes.
//
struct ContourAttributesObject
{
    PyObject_HEAD
    ContourAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewContourAttributes(int);

std::string
PyContourAttributes_ToString(const ContourAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "defaultPalette.";
        str += PyColorControlPointList_ToString(&atts->GetDefaultPalette(), objPrefix.c_str());
    }
    {   const unsignedCharVector &changedColors = atts->GetChangedColors();
        SNPRINTF(tmpStr, 1000, "%schangedColors = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < changedColors.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(changedColors[i]));
            str += tmpStr;
            if(i < changedColors.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case ContourAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case ContourAttributes::ColorByMultipleColors:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case ContourAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    const char *lineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%slineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, lineStyle_values[atts->GetLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    SNPRINTF(tmpStr, 1000, "%scontourNLevels = %d\n", prefix, atts->GetContourNLevels());
    str += tmpStr;
    {   const doubleVector &contourValue = atts->GetContourValue();
        SNPRINTF(tmpStr, 1000, "%scontourValue = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < contourValue.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", contourValue[i]);
            str += tmpStr;
            if(i < contourValue.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &contourPercent = atts->GetContourPercent();
        SNPRINTF(tmpStr, 1000, "%scontourPercent = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < contourPercent.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", contourPercent[i]);
            str += tmpStr;
            if(i < contourPercent.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *contourMethod_names = "Level, Value, Percent";
    switch (atts->GetContourMethod())
    {
      case ContourAttributes::Level:
          SNPRINTF(tmpStr, 1000, "%scontourMethod = %sLevel  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      case ContourAttributes::Value:
          SNPRINTF(tmpStr, 1000, "%scontourMethod = %sValue  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      case ContourAttributes::Percent:
          SNPRINTF(tmpStr, 1000, "%scontourMethod = %sPercent  # %s\n", prefix, prefix, contourMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    const char *scaling_names = "Linear, Log";
    switch (atts->GetScaling())
    {
      case ContourAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case ContourAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "%swireframe = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%swireframe = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ContourAttributes_Notify(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_SetDefaultPalette(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyColorControlPointList_Check(newValue))
    {
        fprintf(stderr, "The defaultPalette field can only be set with ColorControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetDefaultPalette(*PyColorControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetDefaultPalette(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPointList_Wrap(&obj->data->GetDefaultPalette());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetChangedColors(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    unsignedCharVector  &vec = obj->data->GetChangedColors();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the changedColors in the object as modified.
    obj->data->SelectChangedColors();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetChangedColors(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the changedColors.
    const unsignedCharVector &changedColors = obj->data->GetChangedColors();
    PyObject *retval = PyTuple_New(changedColors.size());
    for(size_t i = 0; i < changedColors.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(changedColors[i])));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetColorType(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(ContourAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetColorType(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4)
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetContourNLevels(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourNLevels in the object.
    obj->data->SetContourNLevels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetContourNLevels(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourNLevels()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetContourValue(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourValue();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourValue in the object as modified.
    obj->data->SelectContourValue();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetContourValue(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourValue.
    const doubleVector &contourValue = obj->data->GetContourValue();
    PyObject *retval = PyTuple_New(contourValue.size());
    for(size_t i = 0; i < contourValue.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourValue[i]));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetContourPercent(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    doubleVector  &vec = obj->data->GetContourPercent();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the contourPercent in the object as modified.
    obj->data->SelectContourPercent();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetContourPercent(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contourPercent.
    const doubleVector &contourPercent = obj->data->GetContourPercent();
    PyObject *retval = PyTuple_New(contourPercent.size());
    for(size_t i = 0; i < contourPercent.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(contourPercent[i]));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetContourMethod(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contourMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetContourMethod(ContourAttributes::Select_by(ival));
    else
    {
        fprintf(stderr, "An invalid contourMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Level, Value, Percent.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetContourMethod(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContourMethod()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetMin(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetMin(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetMax(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetMax(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetScaling(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetScaling(ContourAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Linear, Log.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetScaling(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
ContourAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContourAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}



static struct PyMethodDef ContourAttributes_methods[] = {
    {"Notify", ContourAttributes_Notify, METH_VARARGS},
    {"SetDefaultPalette", ContourAttributes_SetDefaultPalette, METH_VARARGS},
    {"GetDefaultPalette", ContourAttributes_GetDefaultPalette, METH_VARARGS},
    {"SetChangedColors", ContourAttributes_SetChangedColors, METH_VARARGS},
    {"GetChangedColors", ContourAttributes_GetChangedColors, METH_VARARGS},
    {"SetColorType", ContourAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", ContourAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", ContourAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", ContourAttributes_GetColorTableName, METH_VARARGS},
    {"SetLegendFlag", ContourAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", ContourAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", ContourAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", ContourAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", ContourAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", ContourAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", ContourAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", ContourAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", ContourAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", ContourAttributes_GetMultiColor, METH_VARARGS},
    {"SetContourNLevels", ContourAttributes_SetContourNLevels, METH_VARARGS},
    {"GetContourNLevels", ContourAttributes_GetContourNLevels, METH_VARARGS},
    {"SetContourValue", ContourAttributes_SetContourValue, METH_VARARGS},
    {"GetContourValue", ContourAttributes_GetContourValue, METH_VARARGS},
    {"SetContourPercent", ContourAttributes_SetContourPercent, METH_VARARGS},
    {"GetContourPercent", ContourAttributes_GetContourPercent, METH_VARARGS},
    {"SetContourMethod", ContourAttributes_SetContourMethod, METH_VARARGS},
    {"GetContourMethod", ContourAttributes_GetContourMethod, METH_VARARGS},
    {"SetMinFlag", ContourAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", ContourAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", ContourAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", ContourAttributes_GetMaxFlag, METH_VARARGS},
    {"SetMin", ContourAttributes_SetMin, METH_VARARGS},
    {"GetMin", ContourAttributes_GetMin, METH_VARARGS},
    {"SetMax", ContourAttributes_SetMax, METH_VARARGS},
    {"GetMax", ContourAttributes_GetMax, METH_VARARGS},
    {"SetScaling", ContourAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", ContourAttributes_GetScaling, METH_VARARGS},
    {"SetWireframe", ContourAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", ContourAttributes_GetWireframe, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ContourAttributes_dealloc(PyObject *v)
{
   ContourAttributesObject *obj = (ContourAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ContourAttributes_compare(PyObject *v, PyObject *w)
{
    ContourAttributes *a = ((ContourAttributesObject *)v)->data;
    ContourAttributes *b = ((ContourAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
ContourAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "defaultPalette") == 0)
        return ContourAttributes_GetDefaultPalette(self, NULL);
    if(strcmp(name, "changedColors") == 0)
        return ContourAttributes_GetChangedColors(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return ContourAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorByMultipleColors));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(ContourAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return ContourAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return ContourAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return ContourAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "lineWidth") == 0)
        return ContourAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return ContourAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return ContourAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "contourNLevels") == 0)
        return ContourAttributes_GetContourNLevels(self, NULL);
    if(strcmp(name, "contourValue") == 0)
        return ContourAttributes_GetContourValue(self, NULL);
    if(strcmp(name, "contourPercent") == 0)
        return ContourAttributes_GetContourPercent(self, NULL);
    if(strcmp(name, "contourMethod") == 0)
        return ContourAttributes_GetContourMethod(self, NULL);
    if(strcmp(name, "Level") == 0)
        return PyInt_FromLong(long(ContourAttributes::Level));
    if(strcmp(name, "Value") == 0)
        return PyInt_FromLong(long(ContourAttributes::Value));
    if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(ContourAttributes::Percent));

    if(strcmp(name, "minFlag") == 0)
        return ContourAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return ContourAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "min") == 0)
        return ContourAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return ContourAttributes_GetMax(self, NULL);
    if(strcmp(name, "scaling") == 0)
        return ContourAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ContourAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ContourAttributes::Log));

    if(strcmp(name, "wireframe") == 0)
        return ContourAttributes_GetWireframe(self, NULL);

    return Py_FindMethod(ContourAttributes_methods, self, name);
}

static int
ContourAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "defaultPalette") == 0)
        obj = ContourAttributes_SetDefaultPalette(self, tuple);
    else if(strcmp(name, "changedColors") == 0)
        obj = ContourAttributes_SetChangedColors(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = ContourAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = ContourAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = ContourAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lineStyle") == 0)
        obj = ContourAttributes_SetLineStyle(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = ContourAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = ContourAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = ContourAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "contourNLevels") == 0)
        obj = ContourAttributes_SetContourNLevels(self, tuple);
    else if(strcmp(name, "contourValue") == 0)
        obj = ContourAttributes_SetContourValue(self, tuple);
    else if(strcmp(name, "contourPercent") == 0)
        obj = ContourAttributes_SetContourPercent(self, tuple);
    else if(strcmp(name, "contourMethod") == 0)
        obj = ContourAttributes_SetContourMethod(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = ContourAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = ContourAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = ContourAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = ContourAttributes_SetMax(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = ContourAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "wireframe") == 0)
        obj = ContourAttributes_SetWireframe(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
ContourAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)v;
    fprintf(fp, "%s", PyContourAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ContourAttributes_str(PyObject *v)
{
    ContourAttributesObject *obj = (ContourAttributesObject *)v;
    return PyString_FromString(PyContourAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ContourAttributes_Purpose = "This class contains the plot attributes for the contour plot.";
#else
static char *ContourAttributes_Purpose = "This class contains the plot attributes for the contour plot.";
#endif

//
// The type description structure
//
static PyTypeObject ContourAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ContourAttributes",                    // tp_name
    sizeof(ContourAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ContourAttributes_dealloc,  // tp_dealloc
    (printfunc)ContourAttributes_print,     // tp_print
    (getattrfunc)ContourAttributes_getattr, // tp_getattr
    (setattrfunc)ContourAttributes_setattr, // tp_setattr
    (cmpfunc)ContourAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ContourAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ContourAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ContourAttributes *defaultAtts = 0;
static ContourAttributes *currentAtts = 0;

static PyObject *
NewContourAttributes(int useCurrent)
{
    ContourAttributesObject *newObject;
    newObject = PyObject_NEW(ContourAttributesObject, &ContourAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ContourAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ContourAttributes(*defaultAtts);
    else
        newObject->data = new ContourAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapContourAttributes(const ContourAttributes *attr)
{
    ContourAttributesObject *newObject;
    newObject = PyObject_NEW(ContourAttributesObject, &ContourAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ContourAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ContourAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewContourAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ContourAttributesMethods[] = {
    {"ContourAttributes", ContourAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ContourAttributesObserver = 0;

std::string
PyContourAttributes_GetLogString()
{
    std::string s("ContourAtts = ContourAttributes()\n");
    if(currentAtts != 0)
        s += PyContourAttributes_ToString(currentAtts, "ContourAtts.");
    return s;
}

static void
PyContourAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ContourAttributes *atts = (ContourAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ContourAtts = ContourAttributes()\n");
        s += PyContourAttributes_ToString(currentAtts, "ContourAtts.");
        cb(s);
    }
}

void
PyContourAttributes_StartUp(ContourAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyContourAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ContourAttributesObserver == 0)
    {
        ContourAttributesObserver = new ObserverToCallback(subj,
            PyContourAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyContourAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ContourAttributesObserver;
    ContourAttributesObserver = 0;
}

PyMethodDef *
PyContourAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ContourAttributesMethods;
}

bool
PyContourAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ContourAttributesType);
}

ContourAttributes *
PyContourAttributes_FromPyObject(PyObject *obj)
{
    ContourAttributesObject *obj2 = (ContourAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyContourAttributes_New()
{
    return NewContourAttributes(0);
}

PyObject *
PyContourAttributes_Wrap(const ContourAttributes *attr)
{
    return WrapContourAttributes(attr);
}

void
PyContourAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ContourAttributesObject *obj2 = (ContourAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyContourAttributes_SetDefaults(const ContourAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ContourAttributes(*atts);
}

