/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyZoneDumpAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyZoneDumpAttributes
//
// Purpose: 
//   Zone Dump Control
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:35 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a ZoneDumpAttributes.
//
struct ZoneDumpAttributesObject
{
    PyObject_HEAD
    ZoneDumpAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewZoneDumpAttributes(int);

std::string
PyZoneDumpAttributes_ToString(const ZoneDumpAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slowerBound = %g\n", prefix, atts->GetLowerBound());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%supperBound = %g\n", prefix, atts->GetUpperBound());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soutputFile = \"%s\"\n", prefix, atts->GetOutputFile().c_str());
    str += tmpStr;
    if(atts->GetEnabled())
        SNPRINTF(tmpStr, 1000, "%senabled = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%senabled = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ZoneDumpAttributes_Notify(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_SetVariable(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_GetVariable(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}

/*static*/ PyObject *
ZoneDumpAttributes_SetLowerBound(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lowerBound in the object.
    obj->data->SetLowerBound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_GetLowerBound(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLowerBound());
    return retval;
}

/*static*/ PyObject *
ZoneDumpAttributes_SetUpperBound(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the upperBound in the object.
    obj->data->SetUpperBound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_GetUpperBound(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUpperBound());
    return retval;
}

/*static*/ PyObject *
ZoneDumpAttributes_SetOutputFile(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the outputFile in the object.
    obj->data->SetOutputFile(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_GetOutputFile(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutputFile().c_str());
    return retval;
}

/*static*/ PyObject *
ZoneDumpAttributes_SetEnabled(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the enabled in the object.
    obj->data->SetEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ZoneDumpAttributes_GetEnabled(PyObject *self, PyObject *args)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEnabled()?1L:0L);
    return retval;
}



static struct PyMethodDef ZoneDumpAttributes_methods[] = {
    {"Notify", ZoneDumpAttributes_Notify, METH_VARARGS},
    {"SetVariable", ZoneDumpAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", ZoneDumpAttributes_GetVariable, METH_VARARGS},
    {"SetLowerBound", ZoneDumpAttributes_SetLowerBound, METH_VARARGS},
    {"GetLowerBound", ZoneDumpAttributes_GetLowerBound, METH_VARARGS},
    {"SetUpperBound", ZoneDumpAttributes_SetUpperBound, METH_VARARGS},
    {"GetUpperBound", ZoneDumpAttributes_GetUpperBound, METH_VARARGS},
    {"SetOutputFile", ZoneDumpAttributes_SetOutputFile, METH_VARARGS},
    {"GetOutputFile", ZoneDumpAttributes_GetOutputFile, METH_VARARGS},
    {"SetEnabled", ZoneDumpAttributes_SetEnabled, METH_VARARGS},
    {"GetEnabled", ZoneDumpAttributes_GetEnabled, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ZoneDumpAttributes_dealloc(PyObject *v)
{
   ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ZoneDumpAttributes_compare(PyObject *v, PyObject *w)
{
    ZoneDumpAttributes *a = ((ZoneDumpAttributesObject *)v)->data;
    ZoneDumpAttributes *b = ((ZoneDumpAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
ZoneDumpAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "variable") == 0)
        return ZoneDumpAttributes_GetVariable(self, NULL);
    if(strcmp(name, "lowerBound") == 0)
        return ZoneDumpAttributes_GetLowerBound(self, NULL);
    if(strcmp(name, "upperBound") == 0)
        return ZoneDumpAttributes_GetUpperBound(self, NULL);
    if(strcmp(name, "outputFile") == 0)
        return ZoneDumpAttributes_GetOutputFile(self, NULL);
    if(strcmp(name, "enabled") == 0)
        return ZoneDumpAttributes_GetEnabled(self, NULL);

    return Py_FindMethod(ZoneDumpAttributes_methods, self, name);
}

static int
ZoneDumpAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "variable") == 0)
        obj = ZoneDumpAttributes_SetVariable(self, tuple);
    else if(strcmp(name, "lowerBound") == 0)
        obj = ZoneDumpAttributes_SetLowerBound(self, tuple);
    else if(strcmp(name, "upperBound") == 0)
        obj = ZoneDumpAttributes_SetUpperBound(self, tuple);
    else if(strcmp(name, "outputFile") == 0)
        obj = ZoneDumpAttributes_SetOutputFile(self, tuple);
    else if(strcmp(name, "enabled") == 0)
        obj = ZoneDumpAttributes_SetEnabled(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
ZoneDumpAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)v;
    fprintf(fp, "%s", PyZoneDumpAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ZoneDumpAttributes_str(PyObject *v)
{
    ZoneDumpAttributesObject *obj = (ZoneDumpAttributesObject *)v;
    return PyString_FromString(PyZoneDumpAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ZoneDumpAttributes_Purpose = "Zone Dump Control";
#else
static char *ZoneDumpAttributes_Purpose = "Zone Dump Control";
#endif

//
// The type description structure
//
static PyTypeObject ZoneDumpAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ZoneDumpAttributes",                    // tp_name
    sizeof(ZoneDumpAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ZoneDumpAttributes_dealloc,  // tp_dealloc
    (printfunc)ZoneDumpAttributes_print,     // tp_print
    (getattrfunc)ZoneDumpAttributes_getattr, // tp_getattr
    (setattrfunc)ZoneDumpAttributes_setattr, // tp_setattr
    (cmpfunc)ZoneDumpAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ZoneDumpAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ZoneDumpAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ZoneDumpAttributes *defaultAtts = 0;
static ZoneDumpAttributes *currentAtts = 0;

static PyObject *
NewZoneDumpAttributes(int useCurrent)
{
    ZoneDumpAttributesObject *newObject;
    newObject = PyObject_NEW(ZoneDumpAttributesObject, &ZoneDumpAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ZoneDumpAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ZoneDumpAttributes(*defaultAtts);
    else
        newObject->data = new ZoneDumpAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapZoneDumpAttributes(const ZoneDumpAttributes *attr)
{
    ZoneDumpAttributesObject *newObject;
    newObject = PyObject_NEW(ZoneDumpAttributesObject, &ZoneDumpAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ZoneDumpAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ZoneDumpAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewZoneDumpAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ZoneDumpAttributesMethods[] = {
    {"ZoneDumpAttributes", ZoneDumpAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ZoneDumpAttributesObserver = 0;

std::string
PyZoneDumpAttributes_GetLogString()
{
    std::string s("ZoneDumpAtts = ZoneDumpAttributes()\n");
    if(currentAtts != 0)
        s += PyZoneDumpAttributes_ToString(currentAtts, "ZoneDumpAtts.");
    return s;
}

static void
PyZoneDumpAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ZoneDumpAttributes *atts = (ZoneDumpAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ZoneDumpAtts = ZoneDumpAttributes()\n");
        s += PyZoneDumpAttributes_ToString(currentAtts, "ZoneDumpAtts.");
        cb(s);
    }
}

void
PyZoneDumpAttributes_StartUp(ZoneDumpAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyZoneDumpAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ZoneDumpAttributesObserver == 0)
    {
        ZoneDumpAttributesObserver = new ObserverToCallback(subj,
            PyZoneDumpAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyZoneDumpAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ZoneDumpAttributesObserver;
    ZoneDumpAttributesObserver = 0;
}

PyMethodDef *
PyZoneDumpAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ZoneDumpAttributesMethods;
}

bool
PyZoneDumpAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ZoneDumpAttributesType);
}

ZoneDumpAttributes *
PyZoneDumpAttributes_FromPyObject(PyObject *obj)
{
    ZoneDumpAttributesObject *obj2 = (ZoneDumpAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyZoneDumpAttributes_New()
{
    return NewZoneDumpAttributes(0);
}

PyObject *
PyZoneDumpAttributes_Wrap(const ZoneDumpAttributes *attr)
{
    return WrapZoneDumpAttributes(attr);
}

void
PyZoneDumpAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ZoneDumpAttributesObject *obj2 = (ZoneDumpAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyZoneDumpAttributes_SetDefaults(const ZoneDumpAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ZoneDumpAttributes(*atts);
}

