/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisTubeWindow.h"

#include <TubeAttributes.h>
#include <ViewerProxy.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisColorTableButton.h>
#include <QvisOpacitySlider.h>
#include <QvisColorButton.h>
#include <QvisLineStyleWidget.h>
#include <QvisLineWidthWidget.h>
#include <QvisVariableButton.h>

#include <stdio.h>
#include <string>

using std::string;

// ****************************************************************************
// Method: QvisTubeWindow::QvisTubeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisTubeWindow::QvisTubeWindow(const int type,
                         TubeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisTubeWindow::~QvisTubeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisTubeWindow::~QvisTubeWindow()
{
}


// ****************************************************************************
// Method: QvisTubeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisTubeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    scaleByVarFlag = new QCheckBox(tr("Scale width by variable?  (Nodal)"), central);
    connect(scaleByVarFlag, SIGNAL(toggled(bool)),
            this, SLOT(scaleByVarFlagChanged(bool)));
    mainLayout->addWidget(scaleByVarFlag, 0,0);

    widthLabel = new QLabel(tr("Tube width (fixed)"), central);
    mainLayout->addWidget(widthLabel,1,0);
    width = new QLineEdit(central);
    connect(width, SIGNAL(returnPressed()),
            this, SLOT(widthProcessText()));
    mainLayout->addWidget(width, 1,1);

    scaleVariableLabel = new QLabel(tr("Tube width scaling variable"), central);
    mainLayout->addWidget(scaleVariableLabel,2,0);
    int scaleVariableMask = QvisVariableButton::Scalars;
    scaleVariable = new QvisVariableButton(true, true, true, scaleVariableMask, central);
    connect(scaleVariable, SIGNAL(activated(const QString&)),
            this, SLOT(scaleVariableChanged(const QString&)));
    mainLayout->addWidget(scaleVariable, 2,1);

    finenessLabel = new QLabel(tr("Fineness of tube"), central);
    mainLayout->addWidget(finenessLabel,3,0);
    fineness = new QLineEdit(central);
    connect(fineness, SIGNAL(returnPressed()),
            this, SLOT(finenessProcessText()));
    mainLayout->addWidget(fineness, 3,1);

    capping = new QCheckBox(tr("Cap ends of the tubes"), central);
    connect(capping, SIGNAL(toggled(bool)),
            this, SLOT(cappingChanged(bool)));
    mainLayout->addWidget(capping, 4,0);

}


// ****************************************************************************
// Method: QvisTubeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisTubeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case TubeAttributes::ID_scaleByVarFlag:
            if (atts->GetScaleByVarFlag() == false)
            {
                width->setEnabled(true);
                if(widthLabel)
                    widthLabel->setEnabled(true);
            }
            else
            {
                width->setEnabled(false);
                if(widthLabel)
                    widthLabel->setEnabled(false);
            }
            if (atts->GetScaleByVarFlag() == true)
            {
                scaleVariable->setEnabled(true);
                if(scaleVariableLabel)
                    scaleVariableLabel->setEnabled(true);
            }
            else
            {
                scaleVariable->setEnabled(false);
                if(scaleVariableLabel)
                    scaleVariableLabel->setEnabled(false);
            }
            scaleByVarFlag->blockSignals(true);
            scaleByVarFlag->setChecked(atts->GetScaleByVarFlag());
            scaleByVarFlag->blockSignals(false);
            break;
          case TubeAttributes::ID_width:
            width->setText(FloatToQString(atts->GetWidth()));
            break;
          case TubeAttributes::ID_scaleVariable:
            scaleVariable->blockSignals(true);
            scaleVariable->setText(QString(atts->GetScaleVariable().c_str()));
            scaleVariable->blockSignals(false);
            break;
          case TubeAttributes::ID_fineness:
            fineness->setText(IntToQString(atts->GetFineness()));
            break;
          case TubeAttributes::ID_capping:
            capping->blockSignals(true);
            capping->setChecked(atts->GetCapping());
            capping->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisTubeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisTubeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do width
    if(which_widget == TubeAttributes::ID_width || doAll)
    {
        float val;
        if(LineEditGetFloat(width, val))
            atts->SetWidth(val);
        else
        {
            ResettingError(tr("Tube width (fixed)"),
                FloatToQString(atts->GetWidth()));
            atts->SetWidth(atts->GetWidth());
        }
    }

    // Do fineness
    if(which_widget == TubeAttributes::ID_fineness || doAll)
    {
        int val;
        if(LineEditGetInt(fineness, val))
            atts->SetFineness(val);
        else
        {
            ResettingError(tr("Fineness of tube"),
                IntToQString(atts->GetFineness()));
            atts->SetFineness(atts->GetFineness());
        }
    }

}


//
// Qt Slot functions
//


void
QvisTubeWindow::scaleByVarFlagChanged(bool val)
{
    atts->SetScaleByVarFlag(val);
    Apply();
}


void
QvisTubeWindow::widthProcessText()
{
    GetCurrentValues(TubeAttributes::ID_width);
    Apply();
}


void
QvisTubeWindow::scaleVariableChanged(const QString &varName)
{
    atts->SetScaleVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisTubeWindow::finenessProcessText()
{
    GetCurrentValues(TubeAttributes::ID_fineness);
    Apply();
}


void
QvisTubeWindow::cappingChanged(bool val)
{
    atts->SetCapping(val);
    SetUpdate(false);
    Apply();
}


