/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtTransformFilter.C
// ************************************************************************* //

#include <avtTransformFilter.h>

#include <LinearTransformAttributes.h>
#include <SimilarityTransformAttributes.h>

#include <avtLinearTransformFilter.h>
#include <avtSimilarityTransformFilter.h>
#include <avtCoordSystemConvert.h>

// ****************************************************************************
//  Method: avtTransformFilter constructor
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Initialize invM.
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Reflect that this filter is now a facaded filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Added coord system convert.
//
//    Jeremy Meredith, Tue Apr 15 13:17:33 EDT 2008
//    Added linear transform.
//
// ****************************************************************************

avtTransformFilter::avtTransformFilter()
{
    ltf = new avtLinearTransformFilter();
    stf = new avtSimilarityTransformFilter();
    csc = new avtCoordSystemConvert();
}


// ****************************************************************************
//  Method: avtTransformFilter destructor
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Delete invM.
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Reflect that this filter is now a facaded filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Added coord system convert.
//
//    Jeremy Meredith, Tue Apr 15 13:17:33 EDT 2008
//    Added linear transform.
//
// ****************************************************************************

avtTransformFilter::~avtTransformFilter()
{
    if (ltf != NULL)
        delete ltf;
    if (stf != NULL)
        delete stf;
    if (csc != NULL)
        delete csc;
}


// ****************************************************************************
//  Method:  avtTransformFilter::Create
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
// ****************************************************************************

avtFilter *
avtTransformFilter::Create()
{
    return new avtTransformFilter();
}


// ****************************************************************************
//  Method:      avtTransformFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Apr 10 11:07:48 PDT 2003
//    Delete invM.
//
//    Kathleen Bonnell, Wed May 21 11:38:23 PDT 2003   
//    Check for bad axis of rotation. 
//
//    Hank Childs, Tue Jul  1 08:59:08 PDT 2003
//    Blew away any interpretation of atts and added code to make similarity
//    transform atts and pass it to that filter.
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Also add support for coordinate transformations.
//
//    Jeremy Meredith, Tue Apr 15 13:17:33 EDT 2008
//    Added linear transform.
//
//    Jeremy Meredith, Fri Aug  7 15:32:06 EDT 2009
//    Added selectable vector transform method.
//    Made coordinate system convert filter's coordinate type enum be
//    within the filter's namespace.
//
// ****************************************************************************

void
avtTransformFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const TransformAttributes*)a;

    if (atts.GetTransformType() == TransformAttributes::Similarity)
    {
        SimilarityTransformAttributes st_atts;
        st_atts.SetDoRotate(atts.GetDoRotate());
        st_atts.SetRotateOrigin(atts.GetRotateOrigin());
        st_atts.SetRotateAxis(atts.GetRotateAxis());
        st_atts.SetRotateAmount(atts.GetRotateAmount());
        switch (atts.GetRotateType())
        {
          case TransformAttributes::Deg:
            st_atts.SetRotateType(SimilarityTransformAttributes::Deg);
            break;
          case TransformAttributes::Rad:
            st_atts.SetRotateType(SimilarityTransformAttributes::Rad);
            break;
        }
        st_atts.SetDoScale(atts.GetDoScale());
        st_atts.SetScaleOrigin(atts.GetScaleOrigin());
        st_atts.SetScaleX(atts.GetScaleX());
        st_atts.SetScaleY(atts.GetScaleY());
        st_atts.SetScaleZ(atts.GetScaleZ());
        st_atts.SetDoTranslate(atts.GetDoTranslate());
        st_atts.SetTranslateX(atts.GetTranslateX());
        st_atts.SetTranslateY(atts.GetTranslateY());
        st_atts.SetTranslateZ(atts.GetTranslateZ());
    
        stf->SetAtts(&st_atts);
    }
    else if (atts.GetTransformType() == TransformAttributes::Coordinate)
    {
        switch (atts.GetInputCoordSys())
        {
           case TransformAttributes::Cartesian:
             csc->SetInputCoordSys(avtCoordSystemConvert::CARTESIAN);
             break;
           case TransformAttributes::Cylindrical:
             csc->SetInputCoordSys(avtCoordSystemConvert::CYLINDRICAL);
             break;
           case TransformAttributes::Spherical:
             csc->SetInputCoordSys(avtCoordSystemConvert::SPHERICAL);
             break;
        }
        switch (atts.GetOutputCoordSys())
        {
           case TransformAttributes::Cartesian:
             csc->SetOutputCoordSys(avtCoordSystemConvert::CARTESIAN);
             break;
           case TransformAttributes::Cylindrical:
             csc->SetOutputCoordSys(avtCoordSystemConvert::CYLINDRICAL);
             break;
           case TransformAttributes::Spherical:
             csc->SetOutputCoordSys(avtCoordSystemConvert::SPHERICAL);
             break;
        }
        switch (atts.GetVectorTransformMethod())
        {
          case TransformAttributes::None:
            csc->SetVectorTransformMethod(avtCoordSystemConvert::None);
            break;
          case TransformAttributes::AsPoint:
            csc->SetVectorTransformMethod(avtCoordSystemConvert::AsPoint);
            break;
          case TransformAttributes::AsDisplacement:
            csc->SetVectorTransformMethod(avtCoordSystemConvert::AsDisplacement);
            break;
          case TransformAttributes::AsDirection:
            csc->SetVectorTransformMethod(avtCoordSystemConvert::AsDirection);
            break;
        }
    }
    else
    {
        LinearTransformAttributes lt_atts;
        lt_atts.SetM00(atts.GetM00());
        lt_atts.SetM01(atts.GetM01());
        lt_atts.SetM02(atts.GetM02());

        lt_atts.SetM10(atts.GetM10());
        lt_atts.SetM11(atts.GetM11());
        lt_atts.SetM12(atts.GetM12());

        lt_atts.SetM20(atts.GetM20());
        lt_atts.SetM21(atts.GetM21());
        lt_atts.SetM22(atts.GetM22());

        lt_atts.SetInvertLinearTransform(atts.GetInvertLinearTransform());
        ltf->SetAtts(&lt_atts);
    }
}


// ****************************************************************************
//  Method: avtTransformFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtTransformFilter with the given
//      parameters would result in an equivalent avtTransformFilter.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Sep 24 13:29:16 PST 2001
//
// ****************************************************************************

bool
avtTransformFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(TransformAttributes*)a);
}


// ****************************************************************************
//  Method: avtTransformFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter we are facading (the similarity transform filter).
//
//  Programmer: Hank Childs
//  Creation:   July 1, 2003
//
//  Modifications:
//
//    Hank Childs, Tue Feb  1 16:37:56 PST 2005
//    Add support for coordinate systems.
//
//    Jeremy Meredith, Tue Apr 15 13:44:21 EDT 2008
//    Added support for linear transforms.
//
// ****************************************************************************

avtFilter *
avtTransformFilter::GetFacadedFilter(void)
{
    if (atts.GetTransformType() == TransformAttributes::Similarity)
        return stf;
    else if (atts.GetTransformType() == TransformAttributes::Coordinate)
        return csc;
    else
        return ltf;
}


// ****************************************************************************
//  Method: avtTransformFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter we are facading (the similarity transform filter).
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtTransformFilter::GetFacadedFilter(void) const
{
    if (atts.GetTransformType() == TransformAttributes::Similarity)
        return stf;
    else if (atts.GetTransformType() == TransformAttributes::Coordinate)
        return csc;
    else
        return ltf;
}
