/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTransformAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyTransformAttributes
//
// Purpose: 
//   This class contains attributes for the transform operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 7 14:14:33 PST 2009
//
// ****************************************************************************

//
// This struct contains the Python type information and a TransformAttributes.
//
struct TransformAttributesObject
{
    PyObject_HEAD
    TransformAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTransformAttributes(int);

std::string
PyTransformAttributes_ToString(const TransformAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetDoRotate())
        SNPRINTF(tmpStr, 1000, "%sdoRotate = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoRotate = 0\n", prefix);
    str += tmpStr;
    {   const float *rotateOrigin = atts->GetRotateOrigin();
        SNPRINTF(tmpStr, 1000, "%srotateOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const float *rotateAxis = atts->GetRotateAxis();
        SNPRINTF(tmpStr, 1000, "%srotateAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%srotateAmount = %g\n", prefix, atts->GetRotateAmount());
    str += tmpStr;
    const char *rotateType_names = "Deg, Rad";
    switch (atts->GetRotateType())
    {
      case TransformAttributes::Deg:
          SNPRINTF(tmpStr, 1000, "%srotateType = %sDeg  # %s\n", prefix, prefix, rotateType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Rad:
          SNPRINTF(tmpStr, 1000, "%srotateType = %sRad  # %s\n", prefix, prefix, rotateType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetDoScale())
        SNPRINTF(tmpStr, 1000, "%sdoScale = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoScale = 0\n", prefix);
    str += tmpStr;
    {   const float *scaleOrigin = atts->GetScaleOrigin();
        SNPRINTF(tmpStr, 1000, "%sscaleOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", scaleOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sscaleX = %g\n", prefix, atts->GetScaleX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscaleY = %g\n", prefix, atts->GetScaleY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscaleZ = %g\n", prefix, atts->GetScaleZ());
    str += tmpStr;
    if(atts->GetDoTranslate())
        SNPRINTF(tmpStr, 1000, "%sdoTranslate = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoTranslate = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateX = %g\n", prefix, atts->GetTranslateX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateY = %g\n", prefix, atts->GetTranslateY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateZ = %g\n", prefix, atts->GetTranslateZ());
    str += tmpStr;
    const char *transformType_names = "Similarity, Coordinate, Linear";
    switch (atts->GetTransformType())
    {
      case TransformAttributes::Similarity:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sSimilarity  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Coordinate:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sCoordinate  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sLinear  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *inputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    switch (atts->GetInputCoordSys())
    {
      case TransformAttributes::Cartesian:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sCartesian  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Cylindrical:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sCylindrical  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Spherical:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sSpherical  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *outputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    switch (atts->GetOutputCoordSys())
    {
      case TransformAttributes::Cartesian:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sCartesian  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Cylindrical:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sCylindrical  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Spherical:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sSpherical  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sm00 = %g\n", prefix, atts->GetM00());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm01 = %g\n", prefix, atts->GetM01());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm02 = %g\n", prefix, atts->GetM02());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm10 = %g\n", prefix, atts->GetM10());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm11 = %g\n", prefix, atts->GetM11());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm12 = %g\n", prefix, atts->GetM12());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm20 = %g\n", prefix, atts->GetM20());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm21 = %g\n", prefix, atts->GetM21());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm22 = %g\n", prefix, atts->GetM22());
    str += tmpStr;
    if(atts->GetInvertLinearTransform())
        SNPRINTF(tmpStr, 1000, "%sinvertLinearTransform = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertLinearTransform = 0\n", prefix);
    str += tmpStr;
    const char *vectorTransformMethod_names = "None, AsPoint, AsDisplacement, AsDirection";
    switch (atts->GetVectorTransformMethod())
    {
      case TransformAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sNone  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsPoint:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsPoint  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsDisplacement:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDisplacement  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsDirection:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDirection  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
TransformAttributes_Notify(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_SetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doRotate in the object.
    obj->data->SetDoRotate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoRotate()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetRotateOrigin();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateOrigin in the object as modified.
    obj->data->SelectRotateOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateOrigin.
    PyObject *retval = PyTuple_New(3);
    const float *rotateOrigin = obj->data->GetRotateOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(rotateOrigin[i])));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetRotateAxis();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateAxis in the object as modified.
    obj->data->SelectRotateAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateAxis.
    PyObject *retval = PyTuple_New(3);
    const float *rotateAxis = obj->data->GetRotateAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(rotateAxis[i])));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the rotateAmount in the object.
    obj->data->SetRotateAmount(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRotateAmount()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rotateType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetRotateType(TransformAttributes::AngleType(ival));
    else
    {
        fprintf(stderr, "An invalid rotateType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Deg, Rad.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRotateType()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doScale in the object.
    obj->data->SetDoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoScale()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float *fvals = obj->data->GetScaleOrigin();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the scaleOrigin in the object as modified.
    obj->data->SelectScaleOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the scaleOrigin.
    PyObject *retval = PyTuple_New(3);
    const float *scaleOrigin = obj->data->GetScaleOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(scaleOrigin[i])));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleX in the object.
    obj->data->SetScaleX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleX()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleY in the object.
    obj->data->SetScaleY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleY()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scaleZ in the object.
    obj->data->SetScaleZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScaleZ()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTranslate in the object.
    obj->data->SetDoTranslate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTranslate()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateX in the object.
    obj->data->SetTranslateX(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateX()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateY in the object.
    obj->data->SetTranslateY(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateY()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the translateZ in the object.
    obj->data->SetTranslateZ(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTranslateZ()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the transformType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTransformType(TransformAttributes::TransformType(ival));
    else
    {
        fprintf(stderr, "An invalid transformType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Similarity, Coordinate, Linear.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTransformType()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the inputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetInputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid inputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetInputCoordSys()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOutputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid outputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputCoordSys()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM00(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m00 in the object.
    obj->data->SetM00(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM00(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM00());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM01(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m01 in the object.
    obj->data->SetM01(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM01(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM01());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM02(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m02 in the object.
    obj->data->SetM02(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM02(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM02());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM10(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m10 in the object.
    obj->data->SetM10(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM10(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM10());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM11(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m11 in the object.
    obj->data->SetM11(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM11(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM11());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM12(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m12 in the object.
    obj->data->SetM12(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM12(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM12());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM20(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m20 in the object.
    obj->data->SetM20(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM20(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM20());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM21(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m21 in the object.
    obj->data->SetM21(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM21(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM21());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM22(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m22 in the object.
    obj->data->SetM22(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM22(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM22());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetInvertLinearTransform(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertLinearTransform in the object.
    obj->data->SetInvertLinearTransform(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetInvertLinearTransform(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertLinearTransform()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetVectorTransformMethod(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the vectorTransformMethod in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetVectorTransformMethod(TransformAttributes::VectorTransformMethod(ival));
    else
    {
        fprintf(stderr, "An invalid vectorTransformMethod value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, AsPoint, AsDisplacement, AsDirection.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetVectorTransformMethod(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVectorTransformMethod()));
    return retval;
}



static struct PyMethodDef TransformAttributes_methods[] = {
    {"Notify", TransformAttributes_Notify, METH_VARARGS},
    {"SetDoRotate", TransformAttributes_SetDoRotate, METH_VARARGS},
    {"GetDoRotate", TransformAttributes_GetDoRotate, METH_VARARGS},
    {"SetRotateOrigin", TransformAttributes_SetRotateOrigin, METH_VARARGS},
    {"GetRotateOrigin", TransformAttributes_GetRotateOrigin, METH_VARARGS},
    {"SetRotateAxis", TransformAttributes_SetRotateAxis, METH_VARARGS},
    {"GetRotateAxis", TransformAttributes_GetRotateAxis, METH_VARARGS},
    {"SetRotateAmount", TransformAttributes_SetRotateAmount, METH_VARARGS},
    {"GetRotateAmount", TransformAttributes_GetRotateAmount, METH_VARARGS},
    {"SetRotateType", TransformAttributes_SetRotateType, METH_VARARGS},
    {"GetRotateType", TransformAttributes_GetRotateType, METH_VARARGS},
    {"SetDoScale", TransformAttributes_SetDoScale, METH_VARARGS},
    {"GetDoScale", TransformAttributes_GetDoScale, METH_VARARGS},
    {"SetScaleOrigin", TransformAttributes_SetScaleOrigin, METH_VARARGS},
    {"GetScaleOrigin", TransformAttributes_GetScaleOrigin, METH_VARARGS},
    {"SetScaleX", TransformAttributes_SetScaleX, METH_VARARGS},
    {"GetScaleX", TransformAttributes_GetScaleX, METH_VARARGS},
    {"SetScaleY", TransformAttributes_SetScaleY, METH_VARARGS},
    {"GetScaleY", TransformAttributes_GetScaleY, METH_VARARGS},
    {"SetScaleZ", TransformAttributes_SetScaleZ, METH_VARARGS},
    {"GetScaleZ", TransformAttributes_GetScaleZ, METH_VARARGS},
    {"SetDoTranslate", TransformAttributes_SetDoTranslate, METH_VARARGS},
    {"GetDoTranslate", TransformAttributes_GetDoTranslate, METH_VARARGS},
    {"SetTranslateX", TransformAttributes_SetTranslateX, METH_VARARGS},
    {"GetTranslateX", TransformAttributes_GetTranslateX, METH_VARARGS},
    {"SetTranslateY", TransformAttributes_SetTranslateY, METH_VARARGS},
    {"GetTranslateY", TransformAttributes_GetTranslateY, METH_VARARGS},
    {"SetTranslateZ", TransformAttributes_SetTranslateZ, METH_VARARGS},
    {"GetTranslateZ", TransformAttributes_GetTranslateZ, METH_VARARGS},
    {"SetTransformType", TransformAttributes_SetTransformType, METH_VARARGS},
    {"GetTransformType", TransformAttributes_GetTransformType, METH_VARARGS},
    {"SetInputCoordSys", TransformAttributes_SetInputCoordSys, METH_VARARGS},
    {"GetInputCoordSys", TransformAttributes_GetInputCoordSys, METH_VARARGS},
    {"SetOutputCoordSys", TransformAttributes_SetOutputCoordSys, METH_VARARGS},
    {"GetOutputCoordSys", TransformAttributes_GetOutputCoordSys, METH_VARARGS},
    {"SetM00", TransformAttributes_SetM00, METH_VARARGS},
    {"GetM00", TransformAttributes_GetM00, METH_VARARGS},
    {"SetM01", TransformAttributes_SetM01, METH_VARARGS},
    {"GetM01", TransformAttributes_GetM01, METH_VARARGS},
    {"SetM02", TransformAttributes_SetM02, METH_VARARGS},
    {"GetM02", TransformAttributes_GetM02, METH_VARARGS},
    {"SetM10", TransformAttributes_SetM10, METH_VARARGS},
    {"GetM10", TransformAttributes_GetM10, METH_VARARGS},
    {"SetM11", TransformAttributes_SetM11, METH_VARARGS},
    {"GetM11", TransformAttributes_GetM11, METH_VARARGS},
    {"SetM12", TransformAttributes_SetM12, METH_VARARGS},
    {"GetM12", TransformAttributes_GetM12, METH_VARARGS},
    {"SetM20", TransformAttributes_SetM20, METH_VARARGS},
    {"GetM20", TransformAttributes_GetM20, METH_VARARGS},
    {"SetM21", TransformAttributes_SetM21, METH_VARARGS},
    {"GetM21", TransformAttributes_GetM21, METH_VARARGS},
    {"SetM22", TransformAttributes_SetM22, METH_VARARGS},
    {"GetM22", TransformAttributes_GetM22, METH_VARARGS},
    {"SetInvertLinearTransform", TransformAttributes_SetInvertLinearTransform, METH_VARARGS},
    {"GetInvertLinearTransform", TransformAttributes_GetInvertLinearTransform, METH_VARARGS},
    {"SetVectorTransformMethod", TransformAttributes_SetVectorTransformMethod, METH_VARARGS},
    {"GetVectorTransformMethod", TransformAttributes_GetVectorTransformMethod, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TransformAttributes_dealloc(PyObject *v)
{
   TransformAttributesObject *obj = (TransformAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TransformAttributes_compare(PyObject *v, PyObject *w)
{
    TransformAttributes *a = ((TransformAttributesObject *)v)->data;
    TransformAttributes *b = ((TransformAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
TransformAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "doRotate") == 0)
        return TransformAttributes_GetDoRotate(self, NULL);
    if(strcmp(name, "rotateOrigin") == 0)
        return TransformAttributes_GetRotateOrigin(self, NULL);
    if(strcmp(name, "rotateAxis") == 0)
        return TransformAttributes_GetRotateAxis(self, NULL);
    if(strcmp(name, "rotateAmount") == 0)
        return TransformAttributes_GetRotateAmount(self, NULL);
    if(strcmp(name, "rotateType") == 0)
        return TransformAttributes_GetRotateType(self, NULL);
    if(strcmp(name, "Deg") == 0)
        return PyInt_FromLong(long(TransformAttributes::Deg));
    if(strcmp(name, "Rad") == 0)
        return PyInt_FromLong(long(TransformAttributes::Rad));

    if(strcmp(name, "doScale") == 0)
        return TransformAttributes_GetDoScale(self, NULL);
    if(strcmp(name, "scaleOrigin") == 0)
        return TransformAttributes_GetScaleOrigin(self, NULL);
    if(strcmp(name, "scaleX") == 0)
        return TransformAttributes_GetScaleX(self, NULL);
    if(strcmp(name, "scaleY") == 0)
        return TransformAttributes_GetScaleY(self, NULL);
    if(strcmp(name, "scaleZ") == 0)
        return TransformAttributes_GetScaleZ(self, NULL);
    if(strcmp(name, "doTranslate") == 0)
        return TransformAttributes_GetDoTranslate(self, NULL);
    if(strcmp(name, "translateX") == 0)
        return TransformAttributes_GetTranslateX(self, NULL);
    if(strcmp(name, "translateY") == 0)
        return TransformAttributes_GetTranslateY(self, NULL);
    if(strcmp(name, "translateZ") == 0)
        return TransformAttributes_GetTranslateZ(self, NULL);
    if(strcmp(name, "transformType") == 0)
        return TransformAttributes_GetTransformType(self, NULL);
    if(strcmp(name, "Similarity") == 0)
        return PyInt_FromLong(long(TransformAttributes::Similarity));
    if(strcmp(name, "Coordinate") == 0)
        return PyInt_FromLong(long(TransformAttributes::Coordinate));
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(TransformAttributes::Linear));

    if(strcmp(name, "inputCoordSys") == 0)
        return TransformAttributes_GetInputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));

    if(strcmp(name, "outputCoordSys") == 0)
        return TransformAttributes_GetOutputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));

    if(strcmp(name, "m00") == 0)
        return TransformAttributes_GetM00(self, NULL);
    if(strcmp(name, "m01") == 0)
        return TransformAttributes_GetM01(self, NULL);
    if(strcmp(name, "m02") == 0)
        return TransformAttributes_GetM02(self, NULL);
    if(strcmp(name, "m10") == 0)
        return TransformAttributes_GetM10(self, NULL);
    if(strcmp(name, "m11") == 0)
        return TransformAttributes_GetM11(self, NULL);
    if(strcmp(name, "m12") == 0)
        return TransformAttributes_GetM12(self, NULL);
    if(strcmp(name, "m20") == 0)
        return TransformAttributes_GetM20(self, NULL);
    if(strcmp(name, "m21") == 0)
        return TransformAttributes_GetM21(self, NULL);
    if(strcmp(name, "m22") == 0)
        return TransformAttributes_GetM22(self, NULL);
    if(strcmp(name, "invertLinearTransform") == 0)
        return TransformAttributes_GetInvertLinearTransform(self, NULL);
    if(strcmp(name, "vectorTransformMethod") == 0)
        return TransformAttributes_GetVectorTransformMethod(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(TransformAttributes::None));
    if(strcmp(name, "AsPoint") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsPoint));
    if(strcmp(name, "AsDisplacement") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsDisplacement));
    if(strcmp(name, "AsDirection") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsDirection));


    return Py_FindMethod(TransformAttributes_methods, self, name);
}

static int
TransformAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "doRotate") == 0)
        obj = TransformAttributes_SetDoRotate(self, tuple);
    else if(strcmp(name, "rotateOrigin") == 0)
        obj = TransformAttributes_SetRotateOrigin(self, tuple);
    else if(strcmp(name, "rotateAxis") == 0)
        obj = TransformAttributes_SetRotateAxis(self, tuple);
    else if(strcmp(name, "rotateAmount") == 0)
        obj = TransformAttributes_SetRotateAmount(self, tuple);
    else if(strcmp(name, "rotateType") == 0)
        obj = TransformAttributes_SetRotateType(self, tuple);
    else if(strcmp(name, "doScale") == 0)
        obj = TransformAttributes_SetDoScale(self, tuple);
    else if(strcmp(name, "scaleOrigin") == 0)
        obj = TransformAttributes_SetScaleOrigin(self, tuple);
    else if(strcmp(name, "scaleX") == 0)
        obj = TransformAttributes_SetScaleX(self, tuple);
    else if(strcmp(name, "scaleY") == 0)
        obj = TransformAttributes_SetScaleY(self, tuple);
    else if(strcmp(name, "scaleZ") == 0)
        obj = TransformAttributes_SetScaleZ(self, tuple);
    else if(strcmp(name, "doTranslate") == 0)
        obj = TransformAttributes_SetDoTranslate(self, tuple);
    else if(strcmp(name, "translateX") == 0)
        obj = TransformAttributes_SetTranslateX(self, tuple);
    else if(strcmp(name, "translateY") == 0)
        obj = TransformAttributes_SetTranslateY(self, tuple);
    else if(strcmp(name, "translateZ") == 0)
        obj = TransformAttributes_SetTranslateZ(self, tuple);
    else if(strcmp(name, "transformType") == 0)
        obj = TransformAttributes_SetTransformType(self, tuple);
    else if(strcmp(name, "inputCoordSys") == 0)
        obj = TransformAttributes_SetInputCoordSys(self, tuple);
    else if(strcmp(name, "outputCoordSys") == 0)
        obj = TransformAttributes_SetOutputCoordSys(self, tuple);
    else if(strcmp(name, "m00") == 0)
        obj = TransformAttributes_SetM00(self, tuple);
    else if(strcmp(name, "m01") == 0)
        obj = TransformAttributes_SetM01(self, tuple);
    else if(strcmp(name, "m02") == 0)
        obj = TransformAttributes_SetM02(self, tuple);
    else if(strcmp(name, "m10") == 0)
        obj = TransformAttributes_SetM10(self, tuple);
    else if(strcmp(name, "m11") == 0)
        obj = TransformAttributes_SetM11(self, tuple);
    else if(strcmp(name, "m12") == 0)
        obj = TransformAttributes_SetM12(self, tuple);
    else if(strcmp(name, "m20") == 0)
        obj = TransformAttributes_SetM20(self, tuple);
    else if(strcmp(name, "m21") == 0)
        obj = TransformAttributes_SetM21(self, tuple);
    else if(strcmp(name, "m22") == 0)
        obj = TransformAttributes_SetM22(self, tuple);
    else if(strcmp(name, "invertLinearTransform") == 0)
        obj = TransformAttributes_SetInvertLinearTransform(self, tuple);
    else if(strcmp(name, "vectorTransformMethod") == 0)
        obj = TransformAttributes_SetVectorTransformMethod(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
TransformAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;
    fprintf(fp, "%s", PyTransformAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TransformAttributes_str(PyObject *v)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;
    return PyString_FromString(PyTransformAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TransformAttributes_Purpose = "This class contains attributes for the transform operator.";
#else
static char *TransformAttributes_Purpose = "This class contains attributes for the transform operator.";
#endif

//
// The type description structure
//
static PyTypeObject TransformAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TransformAttributes",                    // tp_name
    sizeof(TransformAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TransformAttributes_dealloc,  // tp_dealloc
    (printfunc)TransformAttributes_print,     // tp_print
    (getattrfunc)TransformAttributes_getattr, // tp_getattr
    (setattrfunc)TransformAttributes_setattr, // tp_setattr
    (cmpfunc)TransformAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TransformAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TransformAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TransformAttributes *defaultAtts = 0;
static TransformAttributes *currentAtts = 0;

static PyObject *
NewTransformAttributes(int useCurrent)
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TransformAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TransformAttributes(*defaultAtts);
    else
        newObject->data = new TransformAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTransformAttributes(const TransformAttributes *attr)
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TransformAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TransformAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTransformAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TransformAttributesMethods[] = {
    {"TransformAttributes", TransformAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TransformAttributesObserver = 0;

std::string
PyTransformAttributes_GetLogString()
{
    std::string s("TransformAtts = TransformAttributes()\n");
    if(currentAtts != 0)
        s += PyTransformAttributes_ToString(currentAtts, "TransformAtts.");
    return s;
}

static void
PyTransformAttributes_CallLogRoutine(Subject *subj, void *data)
{
    TransformAttributes *atts = (TransformAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TransformAtts = TransformAttributes()\n");
        s += PyTransformAttributes_ToString(currentAtts, "TransformAtts.");
        cb(s);
    }
}

void
PyTransformAttributes_StartUp(TransformAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTransformAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TransformAttributesObserver == 0)
    {
        TransformAttributesObserver = new ObserverToCallback(subj,
            PyTransformAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTransformAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TransformAttributesObserver;
    TransformAttributesObserver = 0;
}

PyMethodDef *
PyTransformAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TransformAttributesMethods;
}

bool
PyTransformAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TransformAttributesType);
}

TransformAttributes *
PyTransformAttributes_FromPyObject(PyObject *obj)
{
    TransformAttributesObject *obj2 = (TransformAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTransformAttributes_New()
{
    return NewTransformAttributes(0);
}

PyObject *
PyTransformAttributes_Wrap(const TransformAttributes *attr)
{
    return WrapTransformAttributes(attr);
}

void
PyTransformAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TransformAttributesObject *obj2 = (TransformAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTransformAttributes_SetDefaults(const TransformAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TransformAttributes(*atts);
}

