/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TraceHistoryAttributes.h>
#include <DataNode.h>

// Type map format string
const char *TraceHistoryAttributes::TypeMapFormatString = "s*sis";

// ****************************************************************************
// Method: TraceHistoryAttributes::TraceHistoryAttributes
//
// Purpose: 
//   Constructor for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TraceHistoryAttributes::TraceHistoryAttributes() : 
    AttributeSubject(TraceHistoryAttributes::TypeMapFormatString),
    displacement("default")
{
    numiter = 5;
    output = "dump";
}

// ****************************************************************************
// Method: TraceHistoryAttributes::TraceHistoryAttributes
//
// Purpose: 
//   Copy constructor for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TraceHistoryAttributes::TraceHistoryAttributes(const TraceHistoryAttributes &obj) : 
    AttributeSubject(TraceHistoryAttributes::TypeMapFormatString)
{
    vars = obj.vars;
    displacement = obj.displacement;
    numiter = obj.numiter;
    output = obj.output;

    SelectAll();
}

// ****************************************************************************
// Method: TraceHistoryAttributes::~TraceHistoryAttributes
//
// Purpose: 
//   Destructor for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TraceHistoryAttributes::~TraceHistoryAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TraceHistoryAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TraceHistoryAttributes& 
TraceHistoryAttributes::operator = (const TraceHistoryAttributes &obj)
{
    if (this == &obj) return *this;
    vars = obj.vars;
    displacement = obj.displacement;
    numiter = obj.numiter;
    output = obj.output;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: TraceHistoryAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TraceHistoryAttributes::operator == (const TraceHistoryAttributes &obj) const
{
    // Create the return value
    return ((vars == obj.vars) &&
            (displacement == obj.displacement) &&
            (numiter == obj.numiter) &&
            (output == obj.output));
}

// ****************************************************************************
// Method: TraceHistoryAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TraceHistoryAttributes::operator != (const TraceHistoryAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TraceHistoryAttributes::TypeName
//
// Purpose: 
//   Type name method for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TraceHistoryAttributes::TypeName() const
{
    return "TraceHistoryAttributes";
}

// ****************************************************************************
// Method: TraceHistoryAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TraceHistoryAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TraceHistoryAttributes *tmp = (const TraceHistoryAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TraceHistoryAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TraceHistoryAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TraceHistoryAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TraceHistoryAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TraceHistoryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TraceHistoryAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TraceHistoryAttributes(*this);
    else
        retval = new TraceHistoryAttributes;

    return retval;
}

// ****************************************************************************
// Method: TraceHistoryAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TraceHistoryAttributes::SelectAll()
{
    Select(ID_vars,         (void *)&vars);
    Select(ID_displacement, (void *)&displacement);
    Select(ID_numiter,      (void *)&numiter);
    Select(ID_output,       (void *)&output);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TraceHistoryAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TraceHistoryAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TraceHistoryAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TraceHistoryAttributes.
    DataNode *node = new DataNode("TraceHistoryAttributes");

    if(completeSave || !FieldsEqual(ID_vars, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("vars", vars));
    }

    if(completeSave || !FieldsEqual(ID_displacement, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displacement", displacement));
    }

    if(completeSave || !FieldsEqual(ID_numiter, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numiter", numiter));
    }

    if(completeSave || !FieldsEqual(ID_output, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("output", output));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TraceHistoryAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TraceHistoryAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TraceHistoryAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("vars")) != 0)
        SetVars(node->AsStringVector());
    if((node = searchNode->GetNode("displacement")) != 0)
        SetDisplacement(node->AsString());
    if((node = searchNode->GetNode("numiter")) != 0)
        SetNumiter(node->AsInt());
    if((node = searchNode->GetNode("output")) != 0)
        SetOutput(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TraceHistoryAttributes::SetVars(const stringVector &vars_)
{
    vars = vars_;
    Select(ID_vars, (void *)&vars);
}

void
TraceHistoryAttributes::SetDisplacement(const std::string &displacement_)
{
    displacement = displacement_;
    Select(ID_displacement, (void *)&displacement);
}

void
TraceHistoryAttributes::SetNumiter(int numiter_)
{
    numiter = numiter_;
    Select(ID_numiter, (void *)&numiter);
}

void
TraceHistoryAttributes::SetOutput(const std::string &output_)
{
    output = output_;
    Select(ID_output, (void *)&output);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const stringVector &
TraceHistoryAttributes::GetVars() const
{
    return vars;
}

stringVector &
TraceHistoryAttributes::GetVars()
{
    return vars;
}

const std::string &
TraceHistoryAttributes::GetDisplacement() const
{
    return displacement;
}

std::string &
TraceHistoryAttributes::GetDisplacement()
{
    return displacement;
}

int
TraceHistoryAttributes::GetNumiter() const
{
    return numiter;
}

const std::string &
TraceHistoryAttributes::GetOutput() const
{
    return output;
}

std::string &
TraceHistoryAttributes::GetOutput()
{
    return output;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TraceHistoryAttributes::SelectVars()
{
    Select(ID_vars, (void *)&vars);
}

void
TraceHistoryAttributes::SelectDisplacement()
{
    Select(ID_displacement, (void *)&displacement);
}

void
TraceHistoryAttributes::SelectOutput()
{
    Select(ID_output, (void *)&output);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TraceHistoryAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TraceHistoryAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_vars:         return "vars";
    case ID_displacement: return "displacement";
    case ID_numiter:      return "numiter";
    case ID_output:       return "output";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TraceHistoryAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TraceHistoryAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_vars:         return FieldType_stringVector;
    case ID_displacement: return FieldType_variablename;
    case ID_numiter:      return FieldType_int;
    case ID_output:       return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TraceHistoryAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TraceHistoryAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_vars:         return "stringVector";
    case ID_displacement: return "variablename";
    case ID_numiter:      return "int";
    case ID_output:       return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TraceHistoryAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TraceHistoryAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TraceHistoryAttributes &obj = *((const TraceHistoryAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_vars:
        {  // new scope
        retval = (vars == obj.vars);
        }
        break;
    case ID_displacement:
        {  // new scope
        retval = (displacement == obj.displacement);
        }
        break;
    case ID_numiter:
        {  // new scope
        retval = (numiter == obj.numiter);
        }
        break;
    case ID_output:
        {  // new scope
        retval = (output == obj.output);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

