/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyThresholdAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyThresholdAttributes
//
// Purpose: 
//   This class contains attributes for the threshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 12:03:42 PDT 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThresholdAttributes.
//
struct ThresholdAttributesObject
{
    PyObject_HEAD
    ThresholdAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewThresholdAttributes(int);

std::string
PyThresholdAttributes_ToString(const ThresholdAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%soutputMeshType = %d\n", prefix, atts->GetOutputMeshType());
    str += tmpStr;
    {   const stringVector &listedVarNames = atts->GetListedVarNames();
        SNPRINTF(tmpStr, 1000, "%slistedVarNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < listedVarNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", listedVarNames[i].c_str());
            str += tmpStr;
            if(i < listedVarNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &zonePortions = atts->GetZonePortions();
        SNPRINTF(tmpStr, 1000, "%szonePortions = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < zonePortions.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", zonePortions[i]);
            str += tmpStr;
            if(i < zonePortions.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &lowerBounds = atts->GetLowerBounds();
        SNPRINTF(tmpStr, 1000, "%slowerBounds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < lowerBounds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lowerBounds[i]);
            str += tmpStr;
            if(i < lowerBounds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &upperBounds = atts->GetUpperBounds();
        SNPRINTF(tmpStr, 1000, "%supperBounds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < upperBounds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", upperBounds[i]);
            str += tmpStr;
            if(i < upperBounds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sdefaultVarName = \"%s\"\n", prefix, atts->GetDefaultVarName().c_str());
    str += tmpStr;
    if(atts->GetDefaultVarIsScalar())
        SNPRINTF(tmpStr, 1000, "%sdefaultVarIsScalar = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdefaultVarIsScalar = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
ThresholdAttributes_Notify(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_SetOutputMeshType(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputMeshType in the object.
    obj->data->SetOutputMeshType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetOutputMeshType(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputMeshType()));
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetListedVarNames(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    stringVector  &vec = obj->data->GetListedVarNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the listedVarNames in the object as modified.
    obj->data->SelectListedVarNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetListedVarNames(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the listedVarNames.
    const stringVector &listedVarNames = obj->data->GetListedVarNames();
    PyObject *retval = PyTuple_New(listedVarNames.size());
    for(size_t i = 0; i < listedVarNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(listedVarNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetZonePortions(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    intVector  &vec = obj->data->GetZonePortions();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the zonePortions in the object as modified.
    obj->data->SelectZonePortions();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetZonePortions(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the zonePortions.
    const intVector &zonePortions = obj->data->GetZonePortions();
    PyObject *retval = PyTuple_New(zonePortions.size());
    for(size_t i = 0; i < zonePortions.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(zonePortions[i])));
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetLowerBounds(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    doubleVector  &vec = obj->data->GetLowerBounds();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the lowerBounds in the object as modified.
    obj->data->SelectLowerBounds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetLowerBounds(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lowerBounds.
    const doubleVector &lowerBounds = obj->data->GetLowerBounds();
    PyObject *retval = PyTuple_New(lowerBounds.size());
    for(size_t i = 0; i < lowerBounds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lowerBounds[i]));
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetUpperBounds(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    doubleVector  &vec = obj->data->GetUpperBounds();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the upperBounds in the object as modified.
    obj->data->SelectUpperBounds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetUpperBounds(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upperBounds.
    const doubleVector &upperBounds = obj->data->GetUpperBounds();
    PyObject *retval = PyTuple_New(upperBounds.size());
    for(size_t i = 0; i < upperBounds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upperBounds[i]));
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetDefaultVarName(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the defaultVarName in the object.
    obj->data->SetDefaultVarName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetDefaultVarName(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDefaultVarName().c_str());
    return retval;
}

/*static*/ PyObject *
ThresholdAttributes_SetDefaultVarIsScalar(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the defaultVarIsScalar in the object.
    obj->data->SetDefaultVarIsScalar(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdAttributes_GetDefaultVarIsScalar(PyObject *self, PyObject *args)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDefaultVarIsScalar()?1L:0L);
    return retval;
}



static struct PyMethodDef ThresholdAttributes_methods[] = {
    {"Notify", ThresholdAttributes_Notify, METH_VARARGS},
    {"SetOutputMeshType", ThresholdAttributes_SetOutputMeshType, METH_VARARGS},
    {"GetOutputMeshType", ThresholdAttributes_GetOutputMeshType, METH_VARARGS},
    {"SetListedVarNames", ThresholdAttributes_SetListedVarNames, METH_VARARGS},
    {"GetListedVarNames", ThresholdAttributes_GetListedVarNames, METH_VARARGS},
    {"SetZonePortions", ThresholdAttributes_SetZonePortions, METH_VARARGS},
    {"GetZonePortions", ThresholdAttributes_GetZonePortions, METH_VARARGS},
    {"SetLowerBounds", ThresholdAttributes_SetLowerBounds, METH_VARARGS},
    {"GetLowerBounds", ThresholdAttributes_GetLowerBounds, METH_VARARGS},
    {"SetUpperBounds", ThresholdAttributes_SetUpperBounds, METH_VARARGS},
    {"GetUpperBounds", ThresholdAttributes_GetUpperBounds, METH_VARARGS},
    {"SetDefaultVarName", ThresholdAttributes_SetDefaultVarName, METH_VARARGS},
    {"GetDefaultVarName", ThresholdAttributes_GetDefaultVarName, METH_VARARGS},
    {"SetDefaultVarIsScalar", ThresholdAttributes_SetDefaultVarIsScalar, METH_VARARGS},
    {"GetDefaultVarIsScalar", ThresholdAttributes_GetDefaultVarIsScalar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ThresholdAttributes_dealloc(PyObject *v)
{
   ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ThresholdAttributes_compare(PyObject *v, PyObject *w)
{
    ThresholdAttributes *a = ((ThresholdAttributesObject *)v)->data;
    ThresholdAttributes *b = ((ThresholdAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
ThresholdAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "outputMeshType") == 0)
        return ThresholdAttributes_GetOutputMeshType(self, NULL);
    if(strcmp(name, "listedVarNames") == 0)
        return ThresholdAttributes_GetListedVarNames(self, NULL);
    if(strcmp(name, "zonePortions") == 0)
        return ThresholdAttributes_GetZonePortions(self, NULL);
    if(strcmp(name, "lowerBounds") == 0)
        return ThresholdAttributes_GetLowerBounds(self, NULL);
    if(strcmp(name, "upperBounds") == 0)
        return ThresholdAttributes_GetUpperBounds(self, NULL);
    if(strcmp(name, "defaultVarName") == 0)
        return ThresholdAttributes_GetDefaultVarName(self, NULL);
    if(strcmp(name, "defaultVarIsScalar") == 0)
        return ThresholdAttributes_GetDefaultVarIsScalar(self, NULL);

    return Py_FindMethod(ThresholdAttributes_methods, self, name);
}

static int
ThresholdAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "outputMeshType") == 0)
        obj = ThresholdAttributes_SetOutputMeshType(self, tuple);
    else if(strcmp(name, "listedVarNames") == 0)
        obj = ThresholdAttributes_SetListedVarNames(self, tuple);
    else if(strcmp(name, "zonePortions") == 0)
        obj = ThresholdAttributes_SetZonePortions(self, tuple);
    else if(strcmp(name, "lowerBounds") == 0)
        obj = ThresholdAttributes_SetLowerBounds(self, tuple);
    else if(strcmp(name, "upperBounds") == 0)
        obj = ThresholdAttributes_SetUpperBounds(self, tuple);
    else if(strcmp(name, "defaultVarName") == 0)
        obj = ThresholdAttributes_SetDefaultVarName(self, tuple);
    else if(strcmp(name, "defaultVarIsScalar") == 0)
        obj = ThresholdAttributes_SetDefaultVarIsScalar(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
ThresholdAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
    fprintf(fp, "%s", PyThresholdAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ThresholdAttributes_str(PyObject *v)
{
    ThresholdAttributesObject *obj = (ThresholdAttributesObject *)v;
    return PyString_FromString(PyThresholdAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ThresholdAttributes_Purpose = "This class contains attributes for the threshold operator.";
#else
static char *ThresholdAttributes_Purpose = "This class contains attributes for the threshold operator.";
#endif

//
// The type description structure
//
static PyTypeObject ThresholdAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThresholdAttributes",                    // tp_name
    sizeof(ThresholdAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThresholdAttributes_dealloc,  // tp_dealloc
    (printfunc)ThresholdAttributes_print,     // tp_print
    (getattrfunc)ThresholdAttributes_getattr, // tp_getattr
    (setattrfunc)ThresholdAttributes_setattr, // tp_setattr
    (cmpfunc)ThresholdAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ThresholdAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThresholdAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThresholdAttributes *defaultAtts = 0;
static ThresholdAttributes *currentAtts = 0;

static PyObject *
NewThresholdAttributes(int useCurrent)
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ThresholdAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ThresholdAttributes(*defaultAtts);
    else
        newObject->data = new ThresholdAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapThresholdAttributes(const ThresholdAttributes *attr)
{
    ThresholdAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdAttributesObject, &ThresholdAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThresholdAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThresholdAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewThresholdAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThresholdAttributesMethods[] = {
    {"ThresholdAttributes", ThresholdAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThresholdAttributesObserver = 0;

std::string
PyThresholdAttributes_GetLogString()
{
    std::string s("ThresholdAtts = ThresholdAttributes()\n");
    if(currentAtts != 0)
        s += PyThresholdAttributes_ToString(currentAtts, "ThresholdAtts.");
    return s;
}

static void
PyThresholdAttributes_CallLogRoutine(Subject *subj, void *data)
{
    ThresholdAttributes *atts = (ThresholdAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ThresholdAtts = ThresholdAttributes()\n");
        s += PyThresholdAttributes_ToString(currentAtts, "ThresholdAtts.");
        cb(s);
    }
}

void
PyThresholdAttributes_StartUp(ThresholdAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyThresholdAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThresholdAttributesObserver == 0)
    {
        ThresholdAttributesObserver = new ObserverToCallback(subj,
            PyThresholdAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyThresholdAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThresholdAttributesObserver;
    ThresholdAttributesObserver = 0;
}

PyMethodDef *
PyThresholdAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThresholdAttributesMethods;
}

bool
PyThresholdAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThresholdAttributesType);
}

ThresholdAttributes *
PyThresholdAttributes_FromPyObject(PyObject *obj)
{
    ThresholdAttributesObject *obj2 = (ThresholdAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThresholdAttributes_New()
{
    return NewThresholdAttributes(0);
}

PyObject *
PyThresholdAttributes_Wrap(const ThresholdAttributes *attr)
{
    return WrapThresholdAttributes(attr);
}

void
PyThresholdAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ThresholdAttributesObject *obj2 = (ThresholdAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyThresholdAttributes_SetDefaults(const ThresholdAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThresholdAttributes(*atts);
}

