/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ThreeSliceAttributes.h>
#include <DataNode.h>

// Type map format string
const char *ThreeSliceAttributes::TypeMapFormatString = "fffb";

// ****************************************************************************
// Method: ThreeSliceAttributes::ThreeSliceAttributes
//
// Purpose: 
//   Constructor for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ThreeSliceAttributes::ThreeSliceAttributes() : 
    AttributeSubject(ThreeSliceAttributes::TypeMapFormatString)
{
    x = 0;
    y = 0;
    z = 0;
    interactive = true;
}

// ****************************************************************************
// Method: ThreeSliceAttributes::ThreeSliceAttributes
//
// Purpose: 
//   Copy constructor for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ThreeSliceAttributes::ThreeSliceAttributes(const ThreeSliceAttributes &obj) : 
    AttributeSubject(ThreeSliceAttributes::TypeMapFormatString)
{
    x = obj.x;
    y = obj.y;
    z = obj.z;
    interactive = obj.interactive;

    SelectAll();
}

// ****************************************************************************
// Method: ThreeSliceAttributes::~ThreeSliceAttributes
//
// Purpose: 
//   Destructor for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ThreeSliceAttributes::~ThreeSliceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ThreeSliceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ThreeSliceAttributes& 
ThreeSliceAttributes::operator = (const ThreeSliceAttributes &obj)
{
    if (this == &obj) return *this;
    x = obj.x;
    y = obj.y;
    z = obj.z;
    interactive = obj.interactive;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ThreeSliceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceAttributes::operator == (const ThreeSliceAttributes &obj) const
{
    // Create the return value
    return ((x == obj.x) &&
            (y == obj.y) &&
            (z == obj.z) &&
            (interactive == obj.interactive));
}

// ****************************************************************************
// Method: ThreeSliceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceAttributes::operator != (const ThreeSliceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ThreeSliceAttributes::TypeName
//
// Purpose: 
//   Type name method for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ThreeSliceAttributes::TypeName() const
{
    return "ThreeSliceAttributes";
}

// ****************************************************************************
// Method: ThreeSliceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ThreeSliceAttributes class.
//
// Programmer: Akira Haddox
// Creation:   Mon Jun 9 13:18:30 PST 2003
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(atts->TypeName() == "PointAttributes")
    {
        if (interactive)
        {
            const PointAttributes *tmp = (const PointAttributes *)atts;
            const double *xyz = tmp->GetPoint();
            SetX(xyz[0]);
            SetY(xyz[1]);
            SetZ(xyz[2]);
            return true;
        }
    }

    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ThreeSliceAttributes *tmp = (const ThreeSliceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ThreeSliceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: Akira Haddox
// Creation:   Mon Jun 9 13:18:30 PST 2003
//
// Modifications:
//   Akira Haddox, Wed Jul  2 11:11:26 PDT 2003
//   Added PointAttributes.
//
// ****************************************************************************

AttributeSubject *
ThreeSliceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ThreeSliceAttributes(*this);
    if(tname == "PointAttributes" && interactive)
    {
        PointAttributes *p = new PointAttributes;
        double pt[3];
        pt[0] = GetX();
        pt[1] = GetY();
        pt[2] = GetZ();
        p->SetPoint(pt);    
        retval = p;
    }

    return retval;
}

// ****************************************************************************
// Method: ThreeSliceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ThreeSliceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ThreeSliceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ThreeSliceAttributes(*this);
    else
        retval = new ThreeSliceAttributes;

    return retval;
}

// ****************************************************************************
// Method: ThreeSliceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ThreeSliceAttributes::SelectAll()
{
    Select(ID_x,           (void *)&x);
    Select(ID_y,           (void *)&y);
    Select(ID_z,           (void *)&z);
    Select(ID_interactive, (void *)&interactive);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ThreeSliceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ThreeSliceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ThreeSliceAttributes.
    DataNode *node = new DataNode("ThreeSliceAttributes");

    if(completeSave || !FieldsEqual(ID_x, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("x", x));
    }

    if(completeSave || !FieldsEqual(ID_y, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("y", y));
    }

    if(completeSave || !FieldsEqual(ID_z, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("z", z));
    }

    if(completeSave || !FieldsEqual(ID_interactive, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("interactive", interactive));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ThreeSliceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ThreeSliceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ThreeSliceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("x")) != 0)
        SetX(node->AsFloat());
    if((node = searchNode->GetNode("y")) != 0)
        SetY(node->AsFloat());
    if((node = searchNode->GetNode("z")) != 0)
        SetZ(node->AsFloat());
    if((node = searchNode->GetNode("interactive")) != 0)
        SetInteractive(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ThreeSliceAttributes::SetX(float x_)
{
    x = x_;
    Select(ID_x, (void *)&x);
}

void
ThreeSliceAttributes::SetY(float y_)
{
    y = y_;
    Select(ID_y, (void *)&y);
}

void
ThreeSliceAttributes::SetZ(float z_)
{
    z = z_;
    Select(ID_z, (void *)&z);
}

void
ThreeSliceAttributes::SetInteractive(bool interactive_)
{
    interactive = interactive_;
    Select(ID_interactive, (void *)&interactive);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

float
ThreeSliceAttributes::GetX() const
{
    return x;
}

float
ThreeSliceAttributes::GetY() const
{
    return y;
}

float
ThreeSliceAttributes::GetZ() const
{
    return z;
}

bool
ThreeSliceAttributes::GetInteractive() const
{
    return interactive;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ThreeSliceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ThreeSliceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_x:           return "x";
    case ID_y:           return "y";
    case ID_z:           return "z";
    case ID_interactive: return "interactive";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ThreeSliceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ThreeSliceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_x:           return FieldType_float;
    case ID_y:           return FieldType_float;
    case ID_z:           return FieldType_float;
    case ID_interactive: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ThreeSliceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ThreeSliceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_x:           return "float";
    case ID_y:           return "float";
    case ID_z:           return "float";
    case ID_interactive: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ThreeSliceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ThreeSliceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ThreeSliceAttributes &obj = *((const ThreeSliceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_x:
        {  // new scope
        retval = (x == obj.x);
        }
        break;
    case ID_y:
        {  // new scope
        retval = (y == obj.y);
        }
        break;
    case ID_z:
        {  // new scope
        retval = (z == obj.z);
        }
        break;
    case ID_interactive:
        {  // new scope
        retval = (interactive == obj.interactive);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

