/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SurfCompPrepAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SurfCompPrepAttributes::CoordinateSystem
//

static const char *CoordinateSystem_strings[] = {
"Cartesian", "Cylindrical", "Spherical"
};

std::string
SurfCompPrepAttributes::CoordinateSystem_ToString(SurfCompPrepAttributes::CoordinateSystem t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return CoordinateSystem_strings[index];
}

std::string
SurfCompPrepAttributes::CoordinateSystem_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return CoordinateSystem_strings[index];
}

bool
SurfCompPrepAttributes::CoordinateSystem_FromString(const std::string &s, SurfCompPrepAttributes::CoordinateSystem &val)
{
    val = SurfCompPrepAttributes::Cartesian;
    for(int i = 0; i < 3; ++i)
    {
        if(s == CoordinateSystem_strings[i])
        {
            val = (CoordinateSystem)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SurfCompPrepAttributes::SurfaceType
//

static const char *SurfaceType_strings[] = {
"Closest", "Farthest", "Average"
};

std::string
SurfCompPrepAttributes::SurfaceType_ToString(SurfCompPrepAttributes::SurfaceType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return SurfaceType_strings[index];
}

std::string
SurfCompPrepAttributes::SurfaceType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return SurfaceType_strings[index];
}

bool
SurfCompPrepAttributes::SurfaceType_FromString(const std::string &s, SurfCompPrepAttributes::SurfaceType &val)
{
    val = SurfCompPrepAttributes::Closest;
    for(int i = 0; i < 3; ++i)
    {
        if(s == SurfaceType_strings[i])
        {
            val = (SurfaceType)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *SurfCompPrepAttributes::TypeMapFormatString = "iiddiddiddiddiddiddi";

// ****************************************************************************
// Method: SurfCompPrepAttributes::SurfCompPrepAttributes
//
// Purpose: 
//   Constructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::SurfCompPrepAttributes() : 
    AttributeSubject(SurfCompPrepAttributes::TypeMapFormatString)
{
    surfaceType = Average;
    coordSystem = Cartesian;
    thetaStart = 0;
    thetaStop = 360;
    thetaSteps = 90;
    phiStart = 0;
    phiStop = 180;
    phiSteps = 45;
    startRadius = 0;
    endRadius = 1;
    radiusSteps = 100;
    xStart = 0;
    xStop = 1;
    xSteps = 100;
    yStart = 0;
    yStop = 1;
    ySteps = 100;
    zStart = 0;
    zStop = 1;
    zSteps = 100;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SurfCompPrepAttributes
//
// Purpose: 
//   Copy constructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::SurfCompPrepAttributes(const SurfCompPrepAttributes &obj) : 
    AttributeSubject(SurfCompPrepAttributes::TypeMapFormatString)
{
    surfaceType = obj.surfaceType;
    coordSystem = obj.coordSystem;
    thetaStart = obj.thetaStart;
    thetaStop = obj.thetaStop;
    thetaSteps = obj.thetaSteps;
    phiStart = obj.phiStart;
    phiStop = obj.phiStop;
    phiSteps = obj.phiSteps;
    startRadius = obj.startRadius;
    endRadius = obj.endRadius;
    radiusSteps = obj.radiusSteps;
    xStart = obj.xStart;
    xStop = obj.xStop;
    xSteps = obj.xSteps;
    yStart = obj.yStart;
    yStop = obj.yStop;
    ySteps = obj.ySteps;
    zStart = obj.zStart;
    zStop = obj.zStop;
    zSteps = obj.zSteps;

    SelectAll();
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::~SurfCompPrepAttributes
//
// Purpose: 
//   Destructor for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes::~SurfCompPrepAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SurfCompPrepAttributes& 
SurfCompPrepAttributes::operator = (const SurfCompPrepAttributes &obj)
{
    if (this == &obj) return *this;
    surfaceType = obj.surfaceType;
    coordSystem = obj.coordSystem;
    thetaStart = obj.thetaStart;
    thetaStop = obj.thetaStop;
    thetaSteps = obj.thetaSteps;
    phiStart = obj.phiStart;
    phiStop = obj.phiStop;
    phiSteps = obj.phiSteps;
    startRadius = obj.startRadius;
    endRadius = obj.endRadius;
    radiusSteps = obj.radiusSteps;
    xStart = obj.xStart;
    xStop = obj.xStop;
    xSteps = obj.xSteps;
    yStart = obj.yStart;
    yStop = obj.yStop;
    ySteps = obj.ySteps;
    zStart = obj.zStart;
    zStop = obj.zStop;
    zSteps = obj.zSteps;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::operator == (const SurfCompPrepAttributes &obj) const
{
    // Create the return value
    return ((surfaceType == obj.surfaceType) &&
            (coordSystem == obj.coordSystem) &&
            (thetaStart == obj.thetaStart) &&
            (thetaStop == obj.thetaStop) &&
            (thetaSteps == obj.thetaSteps) &&
            (phiStart == obj.phiStart) &&
            (phiStop == obj.phiStop) &&
            (phiSteps == obj.phiSteps) &&
            (startRadius == obj.startRadius) &&
            (endRadius == obj.endRadius) &&
            (radiusSteps == obj.radiusSteps) &&
            (xStart == obj.xStart) &&
            (xStop == obj.xStop) &&
            (xSteps == obj.xSteps) &&
            (yStart == obj.yStart) &&
            (yStop == obj.yStop) &&
            (ySteps == obj.ySteps) &&
            (zStart == obj.zStart) &&
            (zStop == obj.zStop) &&
            (zSteps == obj.zSteps));
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::operator != (const SurfCompPrepAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::TypeName
//
// Purpose: 
//   Type name method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SurfCompPrepAttributes::TypeName() const
{
    return "SurfCompPrepAttributes";
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SurfCompPrepAttributes *tmp = (const SurfCompPrepAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfCompPrepAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SurfCompPrepAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SurfCompPrepAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SurfCompPrepAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SurfCompPrepAttributes(*this);
    else
        retval = new SurfCompPrepAttributes;

    return retval;
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepAttributes::SelectAll()
{
    Select(ID_surfaceType, (void *)&surfaceType);
    Select(ID_coordSystem, (void *)&coordSystem);
    Select(ID_thetaStart,  (void *)&thetaStart);
    Select(ID_thetaStop,   (void *)&thetaStop);
    Select(ID_thetaSteps,  (void *)&thetaSteps);
    Select(ID_phiStart,    (void *)&phiStart);
    Select(ID_phiStop,     (void *)&phiStop);
    Select(ID_phiSteps,    (void *)&phiSteps);
    Select(ID_startRadius, (void *)&startRadius);
    Select(ID_endRadius,   (void *)&endRadius);
    Select(ID_radiusSteps, (void *)&radiusSteps);
    Select(ID_xStart,      (void *)&xStart);
    Select(ID_xStop,       (void *)&xStop);
    Select(ID_xSteps,      (void *)&xSteps);
    Select(ID_yStart,      (void *)&yStart);
    Select(ID_yStop,       (void *)&yStop);
    Select(ID_ySteps,      (void *)&ySteps);
    Select(ID_zStart,      (void *)&zStart);
    Select(ID_zStop,       (void *)&zStop);
    Select(ID_zSteps,      (void *)&zSteps);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfCompPrepAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SurfCompPrepAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SurfCompPrepAttributes.
    DataNode *node = new DataNode("SurfCompPrepAttributes");

    if(completeSave || !FieldsEqual(ID_surfaceType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("surfaceType", SurfaceType_ToString(surfaceType)));
    }

    if(completeSave || !FieldsEqual(ID_coordSystem, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("coordSystem", CoordinateSystem_ToString(coordSystem)));
    }

    if(completeSave || !FieldsEqual(ID_thetaStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaStart", thetaStart));
    }

    if(completeSave || !FieldsEqual(ID_thetaStop, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaStop", thetaStop));
    }

    if(completeSave || !FieldsEqual(ID_thetaSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("thetaSteps", thetaSteps));
    }

    if(completeSave || !FieldsEqual(ID_phiStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiStart", phiStart));
    }

    if(completeSave || !FieldsEqual(ID_phiStop, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiStop", phiStop));
    }

    if(completeSave || !FieldsEqual(ID_phiSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phiSteps", phiSteps));
    }

    if(completeSave || !FieldsEqual(ID_startRadius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startRadius", startRadius));
    }

    if(completeSave || !FieldsEqual(ID_endRadius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endRadius", endRadius));
    }

    if(completeSave || !FieldsEqual(ID_radiusSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radiusSteps", radiusSteps));
    }

    if(completeSave || !FieldsEqual(ID_xStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xStart", xStart));
    }

    if(completeSave || !FieldsEqual(ID_xStop, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xStop", xStop));
    }

    if(completeSave || !FieldsEqual(ID_xSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xSteps", xSteps));
    }

    if(completeSave || !FieldsEqual(ID_yStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yStart", yStart));
    }

    if(completeSave || !FieldsEqual(ID_yStop, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yStop", yStop));
    }

    if(completeSave || !FieldsEqual(ID_ySteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ySteps", ySteps));
    }

    if(completeSave || !FieldsEqual(ID_zStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zStart", zStart));
    }

    if(completeSave || !FieldsEqual(ID_zStop, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zStop", zStop));
    }

    if(completeSave || !FieldsEqual(ID_zSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zSteps", zSteps));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SurfCompPrepAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SurfCompPrepAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("surfaceType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetSurfaceType(SurfaceType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SurfaceType value;
            if(SurfaceType_FromString(node->AsString(), value))
                SetSurfaceType(value);
        }
    }
    if((node = searchNode->GetNode("coordSystem")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetCoordSystem(CoordinateSystem(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            CoordinateSystem value;
            if(CoordinateSystem_FromString(node->AsString(), value))
                SetCoordSystem(value);
        }
    }
    if((node = searchNode->GetNode("thetaStart")) != 0)
        SetThetaStart(node->AsDouble());
    if((node = searchNode->GetNode("thetaStop")) != 0)
        SetThetaStop(node->AsDouble());
    if((node = searchNode->GetNode("thetaSteps")) != 0)
        SetThetaSteps(node->AsInt());
    if((node = searchNode->GetNode("phiStart")) != 0)
        SetPhiStart(node->AsDouble());
    if((node = searchNode->GetNode("phiStop")) != 0)
        SetPhiStop(node->AsDouble());
    if((node = searchNode->GetNode("phiSteps")) != 0)
        SetPhiSteps(node->AsInt());
    if((node = searchNode->GetNode("startRadius")) != 0)
        SetStartRadius(node->AsDouble());
    if((node = searchNode->GetNode("endRadius")) != 0)
        SetEndRadius(node->AsDouble());
    if((node = searchNode->GetNode("radiusSteps")) != 0)
        SetRadiusSteps(node->AsInt());
    if((node = searchNode->GetNode("xStart")) != 0)
        SetXStart(node->AsDouble());
    if((node = searchNode->GetNode("xStop")) != 0)
        SetXStop(node->AsDouble());
    if((node = searchNode->GetNode("xSteps")) != 0)
        SetXSteps(node->AsInt());
    if((node = searchNode->GetNode("yStart")) != 0)
        SetYStart(node->AsDouble());
    if((node = searchNode->GetNode("yStop")) != 0)
        SetYStop(node->AsDouble());
    if((node = searchNode->GetNode("ySteps")) != 0)
        SetYSteps(node->AsInt());
    if((node = searchNode->GetNode("zStart")) != 0)
        SetZStart(node->AsDouble());
    if((node = searchNode->GetNode("zStop")) != 0)
        SetZStop(node->AsDouble());
    if((node = searchNode->GetNode("zSteps")) != 0)
        SetZSteps(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SurfCompPrepAttributes::SetSurfaceType(SurfCompPrepAttributes::SurfaceType surfaceType_)
{
    surfaceType = surfaceType_;
    Select(ID_surfaceType, (void *)&surfaceType);
}

void
SurfCompPrepAttributes::SetCoordSystem(SurfCompPrepAttributes::CoordinateSystem coordSystem_)
{
    coordSystem = coordSystem_;
    Select(ID_coordSystem, (void *)&coordSystem);
}

void
SurfCompPrepAttributes::SetThetaStart(double thetaStart_)
{
    thetaStart = thetaStart_;
    Select(ID_thetaStart, (void *)&thetaStart);
}

void
SurfCompPrepAttributes::SetThetaStop(double thetaStop_)
{
    thetaStop = thetaStop_;
    Select(ID_thetaStop, (void *)&thetaStop);
}

void
SurfCompPrepAttributes::SetThetaSteps(int thetaSteps_)
{
    thetaSteps = thetaSteps_;
    Select(ID_thetaSteps, (void *)&thetaSteps);
}

void
SurfCompPrepAttributes::SetPhiStart(double phiStart_)
{
    phiStart = phiStart_;
    Select(ID_phiStart, (void *)&phiStart);
}

void
SurfCompPrepAttributes::SetPhiStop(double phiStop_)
{
    phiStop = phiStop_;
    Select(ID_phiStop, (void *)&phiStop);
}

void
SurfCompPrepAttributes::SetPhiSteps(int phiSteps_)
{
    phiSteps = phiSteps_;
    Select(ID_phiSteps, (void *)&phiSteps);
}

void
SurfCompPrepAttributes::SetStartRadius(double startRadius_)
{
    startRadius = startRadius_;
    Select(ID_startRadius, (void *)&startRadius);
}

void
SurfCompPrepAttributes::SetEndRadius(double endRadius_)
{
    endRadius = endRadius_;
    Select(ID_endRadius, (void *)&endRadius);
}

void
SurfCompPrepAttributes::SetRadiusSteps(int radiusSteps_)
{
    radiusSteps = radiusSteps_;
    Select(ID_radiusSteps, (void *)&radiusSteps);
}

void
SurfCompPrepAttributes::SetXStart(double xStart_)
{
    xStart = xStart_;
    Select(ID_xStart, (void *)&xStart);
}

void
SurfCompPrepAttributes::SetXStop(double xStop_)
{
    xStop = xStop_;
    Select(ID_xStop, (void *)&xStop);
}

void
SurfCompPrepAttributes::SetXSteps(int xSteps_)
{
    xSteps = xSteps_;
    Select(ID_xSteps, (void *)&xSteps);
}

void
SurfCompPrepAttributes::SetYStart(double yStart_)
{
    yStart = yStart_;
    Select(ID_yStart, (void *)&yStart);
}

void
SurfCompPrepAttributes::SetYStop(double yStop_)
{
    yStop = yStop_;
    Select(ID_yStop, (void *)&yStop);
}

void
SurfCompPrepAttributes::SetYSteps(int ySteps_)
{
    ySteps = ySteps_;
    Select(ID_ySteps, (void *)&ySteps);
}

void
SurfCompPrepAttributes::SetZStart(double zStart_)
{
    zStart = zStart_;
    Select(ID_zStart, (void *)&zStart);
}

void
SurfCompPrepAttributes::SetZStop(double zStop_)
{
    zStop = zStop_;
    Select(ID_zStop, (void *)&zStop);
}

void
SurfCompPrepAttributes::SetZSteps(int zSteps_)
{
    zSteps = zSteps_;
    Select(ID_zSteps, (void *)&zSteps);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SurfCompPrepAttributes::SurfaceType
SurfCompPrepAttributes::GetSurfaceType() const
{
    return SurfaceType(surfaceType);
}

SurfCompPrepAttributes::CoordinateSystem
SurfCompPrepAttributes::GetCoordSystem() const
{
    return CoordinateSystem(coordSystem);
}

double
SurfCompPrepAttributes::GetThetaStart() const
{
    return thetaStart;
}

double
SurfCompPrepAttributes::GetThetaStop() const
{
    return thetaStop;
}

int
SurfCompPrepAttributes::GetThetaSteps() const
{
    return thetaSteps;
}

double
SurfCompPrepAttributes::GetPhiStart() const
{
    return phiStart;
}

double
SurfCompPrepAttributes::GetPhiStop() const
{
    return phiStop;
}

int
SurfCompPrepAttributes::GetPhiSteps() const
{
    return phiSteps;
}

double
SurfCompPrepAttributes::GetStartRadius() const
{
    return startRadius;
}

double
SurfCompPrepAttributes::GetEndRadius() const
{
    return endRadius;
}

int
SurfCompPrepAttributes::GetRadiusSteps() const
{
    return radiusSteps;
}

double
SurfCompPrepAttributes::GetXStart() const
{
    return xStart;
}

double
SurfCompPrepAttributes::GetXStop() const
{
    return xStop;
}

int
SurfCompPrepAttributes::GetXSteps() const
{
    return xSteps;
}

double
SurfCompPrepAttributes::GetYStart() const
{
    return yStart;
}

double
SurfCompPrepAttributes::GetYStop() const
{
    return yStop;
}

int
SurfCompPrepAttributes::GetYSteps() const
{
    return ySteps;
}

double
SurfCompPrepAttributes::GetZStart() const
{
    return zStart;
}

double
SurfCompPrepAttributes::GetZStop() const
{
    return zStop;
}

int
SurfCompPrepAttributes::GetZSteps() const
{
    return zSteps;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfCompPrepAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_surfaceType: return "surfaceType";
    case ID_coordSystem: return "coordSystem";
    case ID_thetaStart:  return "thetaStart";
    case ID_thetaStop:   return "thetaStop";
    case ID_thetaSteps:  return "thetaSteps";
    case ID_phiStart:    return "phiStart";
    case ID_phiStop:     return "phiStop";
    case ID_phiSteps:    return "phiSteps";
    case ID_startRadius: return "startRadius";
    case ID_endRadius:   return "endRadius";
    case ID_radiusSteps: return "radiusSteps";
    case ID_xStart:      return "xStart";
    case ID_xStop:       return "xStop";
    case ID_xSteps:      return "xSteps";
    case ID_yStart:      return "yStart";
    case ID_yStop:       return "yStop";
    case ID_ySteps:      return "ySteps";
    case ID_zStart:      return "zStart";
    case ID_zStop:       return "zStop";
    case ID_zSteps:      return "zSteps";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SurfCompPrepAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_surfaceType: return FieldType_enum;
    case ID_coordSystem: return FieldType_enum;
    case ID_thetaStart:  return FieldType_double;
    case ID_thetaStop:   return FieldType_double;
    case ID_thetaSteps:  return FieldType_int;
    case ID_phiStart:    return FieldType_double;
    case ID_phiStop:     return FieldType_double;
    case ID_phiSteps:    return FieldType_int;
    case ID_startRadius: return FieldType_double;
    case ID_endRadius:   return FieldType_double;
    case ID_radiusSteps: return FieldType_int;
    case ID_xStart:      return FieldType_double;
    case ID_xStop:       return FieldType_double;
    case ID_xSteps:      return FieldType_int;
    case ID_yStart:      return FieldType_double;
    case ID_yStop:       return FieldType_double;
    case ID_ySteps:      return FieldType_int;
    case ID_zStart:      return FieldType_double;
    case ID_zStop:       return FieldType_double;
    case ID_zSteps:      return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SurfCompPrepAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_surfaceType: return "enum";
    case ID_coordSystem: return "enum";
    case ID_thetaStart:  return "double";
    case ID_thetaStop:   return "double";
    case ID_thetaSteps:  return "int";
    case ID_phiStart:    return "double";
    case ID_phiStop:     return "double";
    case ID_phiSteps:    return "int";
    case ID_startRadius: return "double";
    case ID_endRadius:   return "double";
    case ID_radiusSteps: return "int";
    case ID_xStart:      return "double";
    case ID_xStop:       return "double";
    case ID_xSteps:      return "int";
    case ID_yStart:      return "double";
    case ID_yStop:       return "double";
    case ID_ySteps:      return "int";
    case ID_zStart:      return "double";
    case ID_zStop:       return "double";
    case ID_zSteps:      return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SurfCompPrepAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SurfCompPrepAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SurfCompPrepAttributes &obj = *((const SurfCompPrepAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_surfaceType:
        {  // new scope
        retval = (surfaceType == obj.surfaceType);
        }
        break;
    case ID_coordSystem:
        {  // new scope
        retval = (coordSystem == obj.coordSystem);
        }
        break;
    case ID_thetaStart:
        {  // new scope
        retval = (thetaStart == obj.thetaStart);
        }
        break;
    case ID_thetaStop:
        {  // new scope
        retval = (thetaStop == obj.thetaStop);
        }
        break;
    case ID_thetaSteps:
        {  // new scope
        retval = (thetaSteps == obj.thetaSteps);
        }
        break;
    case ID_phiStart:
        {  // new scope
        retval = (phiStart == obj.phiStart);
        }
        break;
    case ID_phiStop:
        {  // new scope
        retval = (phiStop == obj.phiStop);
        }
        break;
    case ID_phiSteps:
        {  // new scope
        retval = (phiSteps == obj.phiSteps);
        }
        break;
    case ID_startRadius:
        {  // new scope
        retval = (startRadius == obj.startRadius);
        }
        break;
    case ID_endRadius:
        {  // new scope
        retval = (endRadius == obj.endRadius);
        }
        break;
    case ID_radiusSteps:
        {  // new scope
        retval = (radiusSteps == obj.radiusSteps);
        }
        break;
    case ID_xStart:
        {  // new scope
        retval = (xStart == obj.xStart);
        }
        break;
    case ID_xStop:
        {  // new scope
        retval = (xStop == obj.xStop);
        }
        break;
    case ID_xSteps:
        {  // new scope
        retval = (xSteps == obj.xSteps);
        }
        break;
    case ID_yStart:
        {  // new scope
        retval = (yStart == obj.yStart);
        }
        break;
    case ID_yStop:
        {  // new scope
        retval = (yStop == obj.yStop);
        }
        break;
    case ID_ySteps:
        {  // new scope
        retval = (ySteps == obj.ySteps);
        }
        break;
    case ID_zStart:
        {  // new scope
        retval = (zStart == obj.zStart);
        }
        break;
    case ID_zStop:
        {  // new scope
        retval = (zStop == obj.zStop);
        }
        break;
    case ID_zSteps:
        {  // new scope
        retval = (zSteps == obj.zSteps);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

