/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySubdivideQuadsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySubdivideQuadsAttributes
//
// Purpose: 
//   Attributes for SubdivideQuads operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Aug 8 13:23:38 PST 2008
//
// ****************************************************************************

//
// This struct contains the Python type information and a SubdivideQuadsAttributes.
//
struct SubdivideQuadsAttributesObject
{
    PyObject_HEAD
    SubdivideQuadsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSubdivideQuadsAttributes(int);

std::string
PySubdivideQuadsAttributes_ToString(const SubdivideQuadsAttributes *atts, const char *prefix)
{
    std::string str; 
    char tmpStr[1000]; 

    SNPRINTF(tmpStr, 1000, "%sthreshold = %g\n", prefix, atts->GetThreshold());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxSubdivs = %d\n", prefix, atts->GetMaxSubdivs());
    str += tmpStr;
    if(atts->GetFanOutPoints())
        SNPRINTF(tmpStr, 1000, "%sfanOutPoints = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sfanOutPoints = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDoTriangles())
        SNPRINTF(tmpStr, 1000, "%sdoTriangles = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoTriangles = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
SubdivideQuadsAttributes_Notify(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_SetThreshold(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the threshold in the object.
    obj->data->SetThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_GetThreshold(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetThreshold());
    return retval;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_SetMaxSubdivs(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSubdivs in the object.
    obj->data->SetMaxSubdivs((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_GetMaxSubdivs(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSubdivs()));
    return retval;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_SetFanOutPoints(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fanOutPoints in the object.
    obj->data->SetFanOutPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_GetFanOutPoints(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFanOutPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_SetDoTriangles(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTriangles in the object.
    obj->data->SetDoTriangles(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_GetDoTriangles(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTriangles()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_SetVariable(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SubdivideQuadsAttributes_GetVariable(PyObject *self, PyObject *args)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



static struct PyMethodDef SubdivideQuadsAttributes_methods[] = {
    {"Notify", SubdivideQuadsAttributes_Notify, METH_VARARGS},
    {"SetThreshold", SubdivideQuadsAttributes_SetThreshold, METH_VARARGS},
    {"GetThreshold", SubdivideQuadsAttributes_GetThreshold, METH_VARARGS},
    {"SetMaxSubdivs", SubdivideQuadsAttributes_SetMaxSubdivs, METH_VARARGS},
    {"GetMaxSubdivs", SubdivideQuadsAttributes_GetMaxSubdivs, METH_VARARGS},
    {"SetFanOutPoints", SubdivideQuadsAttributes_SetFanOutPoints, METH_VARARGS},
    {"GetFanOutPoints", SubdivideQuadsAttributes_GetFanOutPoints, METH_VARARGS},
    {"SetDoTriangles", SubdivideQuadsAttributes_SetDoTriangles, METH_VARARGS},
    {"GetDoTriangles", SubdivideQuadsAttributes_GetDoTriangles, METH_VARARGS},
    {"SetVariable", SubdivideQuadsAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", SubdivideQuadsAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SubdivideQuadsAttributes_dealloc(PyObject *v)
{
   SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SubdivideQuadsAttributes_compare(PyObject *v, PyObject *w)
{
    SubdivideQuadsAttributes *a = ((SubdivideQuadsAttributesObject *)v)->data;
    SubdivideQuadsAttributes *b = ((SubdivideQuadsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
SubdivideQuadsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "threshold") == 0)
        return SubdivideQuadsAttributes_GetThreshold(self, NULL);
    if(strcmp(name, "maxSubdivs") == 0)
        return SubdivideQuadsAttributes_GetMaxSubdivs(self, NULL);
    if(strcmp(name, "fanOutPoints") == 0)
        return SubdivideQuadsAttributes_GetFanOutPoints(self, NULL);
    if(strcmp(name, "doTriangles") == 0)
        return SubdivideQuadsAttributes_GetDoTriangles(self, NULL);
    if(strcmp(name, "variable") == 0)
        return SubdivideQuadsAttributes_GetVariable(self, NULL);

    return Py_FindMethod(SubdivideQuadsAttributes_methods, self, name);
}

static int
SubdivideQuadsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "threshold") == 0)
        obj = SubdivideQuadsAttributes_SetThreshold(self, tuple);
    else if(strcmp(name, "maxSubdivs") == 0)
        obj = SubdivideQuadsAttributes_SetMaxSubdivs(self, tuple);
    else if(strcmp(name, "fanOutPoints") == 0)
        obj = SubdivideQuadsAttributes_SetFanOutPoints(self, tuple);
    else if(strcmp(name, "doTriangles") == 0)
        obj = SubdivideQuadsAttributes_SetDoTriangles(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = SubdivideQuadsAttributes_SetVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    return (obj != NULL) ? 0 : -1;
}

static int
SubdivideQuadsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;
    fprintf(fp, "%s", PySubdivideQuadsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SubdivideQuadsAttributes_str(PyObject *v)
{
    SubdivideQuadsAttributesObject *obj = (SubdivideQuadsAttributesObject *)v;
    return PyString_FromString(PySubdivideQuadsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SubdivideQuadsAttributes_Purpose = "Attributes for SubdivideQuads operator";
#else
static char *SubdivideQuadsAttributes_Purpose = "Attributes for SubdivideQuads operator";
#endif

//
// The type description structure
//
static PyTypeObject SubdivideQuadsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SubdivideQuadsAttributes",                    // tp_name
    sizeof(SubdivideQuadsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SubdivideQuadsAttributes_dealloc,  // tp_dealloc
    (printfunc)SubdivideQuadsAttributes_print,     // tp_print
    (getattrfunc)SubdivideQuadsAttributes_getattr, // tp_getattr
    (setattrfunc)SubdivideQuadsAttributes_setattr, // tp_setattr
    (cmpfunc)SubdivideQuadsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SubdivideQuadsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SubdivideQuadsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SubdivideQuadsAttributes *defaultAtts = 0;
static SubdivideQuadsAttributes *currentAtts = 0;

static PyObject *
NewSubdivideQuadsAttributes(int useCurrent)
{
    SubdivideQuadsAttributesObject *newObject;
    newObject = PyObject_NEW(SubdivideQuadsAttributesObject, &SubdivideQuadsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SubdivideQuadsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SubdivideQuadsAttributes(*defaultAtts);
    else
        newObject->data = new SubdivideQuadsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSubdivideQuadsAttributes(const SubdivideQuadsAttributes *attr)
{
    SubdivideQuadsAttributesObject *newObject;
    newObject = PyObject_NEW(SubdivideQuadsAttributesObject, &SubdivideQuadsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SubdivideQuadsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SubdivideQuadsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSubdivideQuadsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SubdivideQuadsAttributesMethods[] = {
    {"SubdivideQuadsAttributes", SubdivideQuadsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SubdivideQuadsAttributesObserver = 0;

std::string
PySubdivideQuadsAttributes_GetLogString()
{
    std::string s("SubdivideQuadsAtts = SubdivideQuadsAttributes()\n");
    if(currentAtts != 0)
        s += PySubdivideQuadsAttributes_ToString(currentAtts, "SubdivideQuadsAtts.");
    return s;
}

static void
PySubdivideQuadsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    SubdivideQuadsAttributes *atts = (SubdivideQuadsAttributes *)subj;
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SubdivideQuadsAtts = SubdivideQuadsAttributes()\n");
        s += PySubdivideQuadsAttributes_ToString(currentAtts, "SubdivideQuadsAtts.");
        cb(s);
    }
}

void
PySubdivideQuadsAttributes_StartUp(SubdivideQuadsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySubdivideQuadsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SubdivideQuadsAttributesObserver == 0)
    {
        SubdivideQuadsAttributesObserver = new ObserverToCallback(subj,
            PySubdivideQuadsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySubdivideQuadsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SubdivideQuadsAttributesObserver;
    SubdivideQuadsAttributesObserver = 0;
}

PyMethodDef *
PySubdivideQuadsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SubdivideQuadsAttributesMethods;
}

bool
PySubdivideQuadsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SubdivideQuadsAttributesType);
}

SubdivideQuadsAttributes *
PySubdivideQuadsAttributes_FromPyObject(PyObject *obj)
{
    SubdivideQuadsAttributesObject *obj2 = (SubdivideQuadsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySubdivideQuadsAttributes_New()
{
    return NewSubdivideQuadsAttributes(0);
}

PyObject *
PySubdivideQuadsAttributes_Wrap(const SubdivideQuadsAttributes *attr)
{
    return WrapSubdivideQuadsAttributes(attr);
}

void
PySubdivideQuadsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SubdivideQuadsAttributesObject *obj2 = (SubdivideQuadsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySubdivideQuadsAttributes_SetDefaults(const SubdivideQuadsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SubdivideQuadsAttributes(*atts);
}

