/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtSphereSliceFilter.C
// ************************************************************************* //

#include <avtSphereSliceFilter.h>

#include <vtkVisItCutter.h>
#include <vtkPolyData.h>
#include <vtkQuadric.h>


// ****************************************************************************
//  Method: avtSphereSliceFilter constructor
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

avtSphereSliceFilter::avtSphereSliceFilter()
{
    quadric = vtkQuadric::New();
}


// ****************************************************************************
//  Method: avtSphereSliceFilter destructor
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//
// ****************************************************************************

avtSphereSliceFilter::~avtSphereSliceFilter()
{
    if (quadric != NULL)
    {
        quadric->Delete();
        quadric = NULL;
    }
}


// ****************************************************************************
//  Method:  avtSphereSliceFilter::Create
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

avtFilter *
avtSphereSliceFilter::Create()
{
    return new avtSphereSliceFilter();
}


// ****************************************************************************
//  Method:      avtSphereSliceFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

void
avtSphereSliceFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const SphereSliceAttributes*)a;
    origin[0] = atts.GetOrigin()[0];
    origin[1] = atts.GetOrigin()[1];
    origin[2] = atts.GetOrigin()[2];
    radius    = atts.GetRadius();

    double coeffs[10];

    coeffs[0] = 1.;
    coeffs[1] = 1.;
    coeffs[2] = 1.;
    coeffs[3] = 0.;
    coeffs[4] = 0.;
    coeffs[5] = 0.;
    coeffs[6] = -2. * origin[0];
    coeffs[7] = -2. * origin[1];
    coeffs[8] = -2. * origin[2];
    coeffs[9] = origin[0] * origin[0] + origin[1] * origin[1] +
                origin[2] * origin[2] - radius * radius;
    quadric->SetCoefficients(coeffs);
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtSphereSliceFilter with the given
//      parameters would result in an equivalent avtSphereSliceFilter.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
// ****************************************************************************

bool
avtSphereSliceFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(SphereSliceAttributes*)a);
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the SphereSlice filter.
//
//  Arguments:
//      in_ds      The input dataset.
//      <unused>   The domain number.
//      <unused>   The label.
//
//  Returns:       The output dataset.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//
//    Hank Childs, Tue Sep 10 18:25:27 PDT 2002
//    Made all memory management internal to this routine.
//
//    Kathleen Bonnell, Thu Apr 28 10:28:22 PDT 2005
//    Use vtkVisItCutter instead of vtkCutter since it has logic to handle
//    CellData correctly. 
//
// ****************************************************************************

vtkDataSet *
avtSphereSliceFilter::ExecuteData(vtkDataSet *in_ds, int, std::string)
{
    vtkVisItCutter *cutter = vtkVisItCutter::New();
    cutter->SetCutFunction(quadric);
    cutter->SetInput(in_ds);
    cutter->Update();

    vtkDataSet *out_ds = cutter->GetOutput();
    if (out_ds->GetNumberOfCells() == 0)
    {
        out_ds = NULL;
    }

    ManageMemory(out_ds);
    cutter->Delete();
    return out_ds;
}


// ****************************************************************************
//  Method: avtSphereSliceFilter::UpdateDataObjectInfo
//
//  Purpose:
//      Changes to topological dimension of the output to be one less that the
//      input.
//
//  Programmer: brugger -- generated by xml2info
//  Creation:   Thu Mar 21 14:45:33 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Thu Mar  2 14:26:06 PST 2006 
//    Set ZonesSplit.
//
// ****************************************************************************

void
avtSphereSliceFilter::UpdateDataObjectInfo(void)
{
    avtDataAttributes &inAtts      = GetInput()->GetInfo().GetAttributes();
    avtDataAttributes &outAtts     = GetOutput()->GetInfo().GetAttributes();
    avtDataValidity   &outValidity = GetOutput()->GetInfo().GetValidity();

    outAtts.SetTopologicalDimension(inAtts.GetTopologicalDimension()-1);
    outValidity.InvalidateZones();
    outValidity.ZonesSplit();
}
